/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.importer;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.pentaho.metadata.repository.DomainAlreadyExistsException;
import org.pentaho.metadata.repository.DomainIdNullException;
import org.pentaho.metadata.repository.DomainStorageException;
import org.pentaho.platform.api.mimetype.IMimeType;
import org.pentaho.platform.api.repository2.unified.Converter;
import org.pentaho.platform.api.repository2.unified.IPlatformImportBundle;
import org.pentaho.platform.api.repository2.unified.IRepositoryDefaultAclHandler;
import org.pentaho.platform.api.repository2.unified.IRepositoryFileData;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.api.repository2.unified.RepositoryFileExtraMetaData;
import org.pentaho.platform.api.repository2.unified.RepositoryFileSid;
import org.pentaho.platform.plugin.services.importer.IPlatformImportHandler;
import org.pentaho.platform.plugin.services.importer.PlatformImportException;
import org.pentaho.platform.plugin.services.importer.RepositoryFileImportBundle;
import org.pentaho.platform.plugin.services.importer.SolutionFileImportHelper;
import org.pentaho.platform.plugin.services.importexport.ImportSession;
import org.pentaho.platform.plugin.services.importexport.exportManifest.ExportManifestFormatException;
import org.pentaho.platform.plugin.services.messages.Messages;
import org.pentaho.platform.repository.RepositoryFilenameUtils;
import org.pentaho.platform.web.http.api.resources.services.FileService;
import org.springframework.util.Assert;

public class RepositoryFileImportFileHandler
implements IPlatformImportHandler {
    private static final Messages messages = Messages.getInstance();
    private IUnifiedRepository repository;
    private SolutionFileImportHelper solutionHelper = new SolutionFileImportHelper();
    private HashMap<String, IMimeType> mimeTypeMap = new HashMap();
    private List<String> knownExtensions;
    IRepositoryDefaultAclHandler defaultAclHandler;

    public RepositoryFileImportFileHandler(List<IMimeType> mimeTypes) {
        for (IMimeType mimeType : mimeTypes) {
            this.mimeTypeMap.put(mimeType.getName(), mimeType);
        }
    }

    public Log getLogger() {
        return this.getImportSession().getLogger();
    }

    public ImportSession getImportSession() {
        return ImportSession.getSession();
    }

    @Override
    public void importFile(IPlatformImportBundle bnd) throws PlatformImportException {
        if (!(bnd instanceof RepositoryFileImportBundle)) {
            throw new PlatformImportException("Error importing bundle. RepositoryFileImportBundle expected");
        }
        RepositoryFileImportBundle bundle = (RepositoryFileImportBundle)bnd;
        if (bundle.isSchedulable() == null) {
            bundle.setSchedulable(true);
        }
        String repositoryFilePath = RepositoryFilenameUtils.concat((String)bundle.getPath(), (String)bundle.getName());
        this.getLogger().trace((Object)messages.getString("RepositoryFileImportFileHandler.ProcessingFile", new Object[]{repositoryFilePath}));
        this.validateName(bundle);
        RepositoryFile file = this.repository.getFile(repositoryFilePath);
        if (file != null) {
            if (file.isFolder() && this.getImportSession().getFoldersCreatedImplicitly().contains(repositoryFilePath)) {
                this.getLogger().trace((Object)messages.getString("RepositoryFileImportFileHandler.SkippingImplicitlyCreatedFolder", new Object[]{repositoryFilePath}));
            } else if (bundle.overwriteInRepossitory()) {
                if (!file.isFolder()) {
                    file = this.finalAdjustFile(bundle, file);
                    this.copyFileToRepository(bundle, repositoryFilePath, file);
                } else {
                    this.getLogger().trace((Object)messages.getString("RepositoryFileImportFileHandler.ExistingFolder", new Object[]{repositoryFilePath}));
                    file = this.finalAdjustFolder(bundle, file.getId());
                    this.repository.updateFolder(file, null);
                    if (bundle.getAcl() != null) {
                        this.updateAclFromBundle(false, bundle, file);
                    }
                    if (bundle.getExtraMetaData() != null && bundle.getExtraMetaData().getExtraMetaData().size() > 0) {
                        this.updateExtraMetaDataFromBundle(false, bundle, file);
                    }
                }
            } else {
                if (this.getImportSession().getIsNotRunningImport().booleanValue()) {
                    throw new PlatformImportException(messages.getString("DefaultImportHandler.ERROR_0009_OVERWRITE_CONTENT", new Object[]{repositoryFilePath}), 9);
                }
                this.getLogger().trace((Object)messages.getString("RepositoryFileImportFileHandler.SkippingExistingFile", new Object[]{repositoryFilePath}));
                ImportSession importSession = ImportSession.getSession();
                importSession.getSkippedFiles().add(repositoryFilePath);
            }
        } else if (bundle.isFolder()) {
            this.getLogger().trace((Object)messages.getString("RepositoryFileImportFileHandler.CreatingFolder", new Object[]{repositoryFilePath}));
            Serializable parentId = this.getParentId(repositoryFilePath);
            bundle.setFile(bundle.getFile());
            RepositoryFile repoFile = this.finalAdjustFolder(bundle, null);
            if (bundle.getAcl() != null) {
                repoFile = this.repository.createFolder(parentId, repoFile, bundle.getAcl(), null);
                this.updateAclFromBundle(true, bundle, repoFile);
                if (bundle.getExtraMetaData() != null && bundle.getExtraMetaData().getExtraMetaData().size() > 0) {
                    this.updateExtraMetaDataFromBundle(true, bundle, file);
                }
            } else {
                this.repository.createFolder(parentId, repoFile, null);
            }
        } else {
            this.getLogger().trace((Object)messages.getString("RepositoryFileImportFileHandler.CreatingFile", new Object[]{repositoryFilePath}));
            this.copyFileToRepository(bundle, repositoryFilePath, null);
        }
    }

    private void validateName(RepositoryFileImportBundle bundle) throws PlatformImportException {
        if (null != bundle) {
            FileService fileService = new FileService();
            String name = bundle.getName();
            if (bundle.isFolder()) {
                if (!fileService.isValidFolderName(name)) {
                    throw new PlatformImportException(messages.getString("DefaultImportHandler.ERROR_0012_INVALID_FOLDER_NAME", new Object[]{name}), 10);
                }
            } else if (!fileService.isValidFileName(name)) {
                throw new PlatformImportException(messages.getString("DefaultImportHandler.ERROR_0011_INVALID_FILE_NAME", new Object[]{name}), 10);
            }
        }
    }

    private RepositoryFile finalAdjustFolder(RepositoryFileImportBundle bundle, Serializable id) {
        RepositoryFile.Builder builder = new RepositoryFile.Builder(bundle.getFile()).hidden(bundle.isHidden().booleanValue());
        if (id != null) {
            builder.id(id);
        }
        return builder.build();
    }

    private RepositoryFile finalAdjustFile(RepositoryFileImportBundle bundle, RepositoryFile file) {
        return new RepositoryFile.Builder(file).hidden(this.isHiddenBundle(bundle)).schedulable(bundle.isSchedulable().booleanValue()).build();
    }

    private boolean isHiddenBundle(RepositoryFileImportBundle bundle) {
        if (bundle.isHidden() != null) {
            return bundle.isHidden();
        }
        return this.solutionHelper.isInHiddenList(bundle.getName());
    }

    protected boolean copyFileToRepository(RepositoryFileImportBundle bundle, String repositoryPath, RepositoryFile file) throws PlatformImportException {
        String name = bundle.getName();
        String ext = RepositoryFilenameUtils.getExtension((String)name);
        if (StringUtils.isEmpty((String)ext)) {
            this.getLogger().debug((Object)messages.getString("RepositoryFileImportFileHandler.SkippingFileWithoutExtension", new Object[]{name}));
            return false;
        }
        String mimeType = bundle.getMimeType();
        if (mimeType == null) {
            this.getLogger().debug((Object)messages.getString("RepositoryFileImportFileHandler.SkippingFileWithoutMimeType", new Object[]{name}));
            return false;
        }
        try {
            RepositoryFile repositoryFile;
            Converter converter;
            this.getLogger().trace((Object)messages.getString("RepositoryFileImportFileHandler.CopyingFile", new Object[]{name}));
            if (this.getMimeTypeMap().get(mimeType) == null) {
                this.getLogger().debug((Object)messages.getString("RepositoryFileImportFileHandler.SkippingFileWithUnknownMimeType", new Object[]{name, mimeType}));
            }
            if ((converter = this.getMimeTypeMap().get(mimeType).getConverter()) == null) {
                this.getLogger().debug((Object)messages.getString("RepositoryFileImportFileHandler.SkippingFileWithoutConverter", new Object[]{name}));
                return false;
            }
            IRepositoryFileData data = null;
            data = converter.convert(bundle.getInputStream(), bundle.getCharSet(), mimeType);
            if (null == file) {
                repositoryFile = this.createFile(bundle, repositoryPath, data);
                if (repositoryFile != null) {
                    this.updateAclFromBundle(true, bundle, repositoryFile);
                    this.updateExtraMetaDataFromBundleHelper(bundle, repositoryFile, true);
                }
            } else {
                repositoryFile = this.updateFile(bundle, file, data);
                this.updateAclFromBundle(false, bundle, repositoryFile);
                this.updateExtraMetaDataFromBundleHelper(bundle, repositoryFile, false);
            }
            converter.convertPostRepoSave(repositoryFile);
            if (repositoryFile != null) {
                this.getImportSession().addImportedRepositoryFile(repositoryFile);
            }
            return true;
        }
        catch (IOException e) {
            this.getLogger().warn((Object)messages.getString("DefaultImportHandler.WARN_0003_IOEXCEPTION", new Object[]{name}), (Throwable)e);
            return false;
        }
    }

    private void updateExtraMetaDataFromBundleHelper(RepositoryFileImportBundle bundle, RepositoryFile file, boolean isNew) {
        if (bundle.getExtraMetaData() != null && bundle.getExtraMetaData().getExtraMetaData().size() > 0) {
            this.updateExtraMetaDataFromBundle(isNew, bundle, file);
        }
    }

    private void updateAclFromBundle(boolean newFile, RepositoryFileImportBundle bundle, RepositoryFile repositoryFile) {
        this.updateAcl(newFile, repositoryFile, bundle.getAcl());
    }

    private void updateAcl(boolean newFile, RepositoryFile repositoryFile, RepositoryFileAcl repositoryFileAcl) {
        if (newFile) {
            this.getLogger().debug((Object)messages.getString("RepositoryFileImportFileHandler.FileIsNew"));
        } else {
            this.getLogger().debug((Object)messages.getString("RepositoryFileImportFileHandler.FileExists"));
        }
        if (repositoryFileAcl != null && (this.getImportSession().isApplyAclSettings() || !this.getImportSession().isRetainOwnership())) {
            RepositoryFileAcl useAclForPermissions;
            RepositoryFileSid newOwner;
            RepositoryFileAcl manifestAcl = repositoryFileAcl;
            RepositoryFileAcl originalAcl = this.repository.getAcl(repositoryFile.getId());
            if (this.getImportSession().isRetainOwnership()) {
                if (newFile) {
                    this.getLogger().debug((Object)messages.getString("RepositoryFileImportFileHandler.OwnerFromSession"));
                    newOwner = this.getDefaultAcl(repositoryFile).getOwner();
                } else {
                    this.getLogger().debug((Object)messages.getString("RepositoryFileImportFileHandler.OwnerFromExistingFile"));
                    newOwner = originalAcl.getOwner();
                }
            } else {
                this.getLogger().debug((Object)messages.getString("RepositoryFileImportFileHandler.OwnerFromManifest"));
                newOwner = manifestAcl.getOwner();
            }
            if (this.getImportSession().isApplyAclSettings() && (this.getImportSession().isOverwriteAclSettings() || newFile)) {
                this.getLogger().debug((Object)messages.getString("RepositoryFileImportFileHandler.PermissionsFromManifest"));
                useAclForPermissions = manifestAcl;
            } else if (newFile) {
                this.getLogger().debug((Object)messages.getString("RepositoryFileImportFileHandler.PermissionsFromSettings"));
                useAclForPermissions = this.getDefaultAcl(repositoryFile);
            } else {
                this.getLogger().debug((Object)messages.getString("RepositoryFileImportFileHandler.PermissionsFromExistingFile"));
                useAclForPermissions = originalAcl;
            }
            if (!newOwner.equals((Object)originalAcl.getOwner()) || !useAclForPermissions.equals((Object)originalAcl)) {
                RepositoryFileAcl updatedAcl = new RepositoryFileAcl(repositoryFile.getId(), newOwner, useAclForPermissions.isEntriesInheriting(), useAclForPermissions.getAces());
                this.repository.updateAcl(updatedAcl);
            }
        }
    }

    private RepositoryFileAcl getDefaultAcl(RepositoryFile repositoryFile) {
        return this.defaultAclHandler.createDefaultAcl(repositoryFile.clone());
    }

    private void updateExtraMetaDataFromBundle(boolean newFile, RepositoryFileImportBundle bundle, RepositoryFile repositoryFile) {
        this.updateExtraMetaData(newFile, repositoryFile, bundle.getExtraMetaData());
    }

    private void updateExtraMetaData(boolean newFile, RepositoryFile repositoryFile, RepositoryFileExtraMetaData repositoryFileExtraMetaData) {
        if (repositoryFileExtraMetaData != null && !repositoryFileExtraMetaData.getExtraMetaData().isEmpty()) {
            if (newFile) {
                this.getLogger().debug((Object)messages.getString("RepositoryFileImportFileHandler.ExtraMetaDataToNewFile"));
            } else {
                this.getLogger().debug((Object)messages.getString("RepositoryFileImportFileHandler.ExtraMetaDataToExistingFile"));
            }
            RepositoryFileExtraMetaData manifestExtraMetaData = repositoryFileExtraMetaData;
            this.repository.setFileMetadata(repositoryFile.getId(), manifestExtraMetaData.getExtraMetaData());
        }
    }

    protected RepositoryFile createFile(RepositoryFileImportBundle bundle, String repositoryPath, IRepositoryFileData data) throws PlatformImportException {
        if (this.solutionHelper.isInApprovedExtensionList(repositoryPath)) {
            RepositoryFile file = new RepositoryFile.Builder(bundle.getName()).hidden(this.isHiddenBundle(bundle)).schedulable(bundle.isSchedulable().booleanValue()).title("default", this.getTitle(bundle.getTitle() != null ? bundle.getTitle() : bundle.getName())).versioned(true).build();
            Serializable parentId = this.checkAndCreatePath(repositoryPath, this.getImportSession().getCurrentManifestKey());
            RepositoryFileAcl acl = bundle.getAcl();
            if (null == acl) {
                return this.repository.createFile(parentId, file, data, bundle.getComment());
            }
            return this.repository.createFile(parentId, file, data, acl, bundle.getComment());
        }
        this.getLogger().trace((Object)messages.getString("RepositoryFileImportFileHandler.ExtensionNotApproved", new Object[]{repositoryPath}));
        return null;
    }

    protected RepositoryFile updateFile(RepositoryFileImportBundle bundle, RepositoryFile file, IRepositoryFileData data) throws PlatformImportException {
        return this.repository.updateFile(file, data, bundle.getComment());
    }

    private Serializable checkAndCreatePath(String repositoryPath, String manifestKey) throws PlatformImportException {
        if (this.getParentId(repositoryPath) == null) {
            String parentPath = RepositoryFilenameUtils.getFullPathNoEndSeparator((String)repositoryPath);
            String parentManifestKey = RepositoryFilenameUtils.getFullPathNoEndSeparator((String)manifestKey);
            if (!this.getImportSession().getFoldersCreatedImplicitly().contains(parentPath)) {
                RepositoryFile parentFile = this.repository.getFile(parentPath);
                if (parentFile == null) {
                    this.checkAndCreatePath(parentPath, parentManifestKey);
                    try {
                        parentFile = this.createFolderJustInTime(parentPath, parentManifestKey);
                    }
                    catch (Exception e) {
                        throw new PlatformImportException(messages.getString("DefaultImportHandler.ERROR_0010_JUST_IN_TIME_FOLDER_CREATION", new Object[]{repositoryPath}));
                    }
                }
                Serializable parentFileId = parentFile.getId();
                Assert.notNull((Object)parentFileId);
            }
        }
        return this.getParentId(repositoryPath);
    }

    protected String getTitle(String name) {
        int dotIndex;
        if (!StringUtils.isEmpty((String)name) && (dotIndex = name.lastIndexOf(46)) != -1) {
            String extension = name.substring(dotIndex + 1);
            if (this.knownExtensions != null && this.knownExtensions.contains(extension)) {
                return name.substring(0, dotIndex);
            }
        }
        return name;
    }

    protected Serializable getParentId(String repositoryPath) {
        Assert.notNull((Object)repositoryPath);
        String parentPath = RepositoryFilenameUtils.getFullPathNoEndSeparator((String)repositoryPath);
        RepositoryFile parentFile = this.repository.getFile(parentPath);
        if (parentFile == null) {
            return null;
        }
        Serializable parentFileId = parentFile.getId();
        Assert.notNull((Object)parentFileId);
        return parentFileId;
    }

    public IUnifiedRepository getRepository() {
        return this.repository;
    }

    public void setRepository(IUnifiedRepository repository) {
        this.repository = repository;
    }

    public void setDefaultAclHandler(IRepositoryDefaultAclHandler defaultAclHandler) {
        this.defaultAclHandler = defaultAclHandler;
    }

    public RepositoryFile createFolderJustInTime(String folderPath, String manifestKey) throws PlatformImportException, DomainIdNullException, DomainAlreadyExistsException, DomainStorageException, IOException {
        this.getLogger().trace((Object)messages.getString("RepositoryFileImportFileHandler.CreatingImpliedFolder", new Object[]{folderPath}));
        Serializable parentId = this.getParentId(folderPath);
        Assert.notNull((Object)parentId);
        boolean isHidden = this.getImportSession().isFileHidden(manifestKey) == null ? false : this.getImportSession().isFileHidden(manifestKey);
        RepositoryFile.Builder builder = new RepositoryFile.Builder(RepositoryFilenameUtils.getName((String)folderPath)).path(RepositoryFilenameUtils.getPath((String)folderPath)).folder(true).hidden(isHidden);
        RepositoryFile repoFile = builder.build();
        RepositoryFileAcl repoAcl = this.getImportSession().processAclForFile(manifestKey);
        if (repoAcl != null) {
            repoFile = this.repository.createFolder(parentId, repoFile, repoAcl, null);
            RepositoryFileAcl repositoryFileAcl = null;
            try {
                repositoryFileAcl = this.getImportSession().getManifest().getExportManifestEntity(manifestKey).getRepositoryFileAcl();
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (ExportManifestFormatException exportManifestFormatException) {
                // empty catch block
            }
            this.updateAcl(true, repoFile, repositoryFileAcl);
        } else {
            repoFile = this.repository.createFolder(parentId, repoFile, null);
        }
        this.getImportSession().getFoldersCreatedImplicitly().add(folderPath);
        return repoFile;
    }

    @Override
    public List<IMimeType> getMimeTypes() {
        return new ArrayList<IMimeType>(this.mimeTypeMap.values());
    }

    public Map<String, IMimeType> getMimeTypeMap() {
        return this.mimeTypeMap;
    }

    public void setKnownExtensions(List<String> knownExtensions) {
        this.knownExtensions = knownExtensions;
    }

    public List<String> getKnownExtensions() {
        return this.knownExtensions;
    }
}

