/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.importer;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.platform.api.repository2.unified.IPlatformImportBundle;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.api.repository2.unified.RepositoryFileExtraMetaData;

public class RepositoryFileImportBundle
implements IPlatformImportBundle {
    private InputStream inputStream;
    private String path = "/";
    private String name;
    private String title;
    private String charSet;
    private String mimeType;
    private String comment;
    private boolean overwriteInRepository;
    private Boolean hidden;
    private Boolean schedulable;
    private RepositoryFile file;
    private RepositoryFileAcl acl;
    private RepositoryFileExtraMetaData extraMetaData;
    private boolean applyAclSettings;
    private boolean overwriteAclSettings;
    private boolean retainOwnership;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private List<IPlatformImportBundle> children = new ArrayList<IPlatformImportBundle>();
    private boolean preserveDsw;

    protected RepositoryFileImportBundle() {
    }

    public RepositoryFileAcl getAcl() {
        return this.acl;
    }

    public void setAcl(RepositoryFileAcl acl) {
        this.acl = acl;
    }

    public RepositoryFileExtraMetaData getExtraMetaData() {
        return this.extraMetaData;
    }

    public void setExtraMetaData(RepositoryFileExtraMetaData extraMetaData) {
        this.extraMetaData = extraMetaData;
    }

    public List<IPlatformImportBundle> getChildBundles() {
        return this.children;
    }

    public InputStream getInputStream() throws IOException {
        return this.inputStream;
    }

    public void setInputStream(InputStream inStr) {
        this.inputStream = inStr;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getCharSet() {
        return this.charSet;
    }

    public void setCharSet(String charSet) {
        this.charSet = charSet;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean overwriteInRepossitory() {
        return this.overwriteInRepository;
    }

    public void setOverwriteInRepository(boolean overwrite) {
        this.overwriteInRepository = overwrite;
    }

    public Boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public Boolean isSchedulable() {
        return this.schedulable;
    }

    public void setSchedulable(Boolean schedulable) {
        this.schedulable = schedulable;
    }

    public boolean isFolder() {
        return this.mimeType != null && this.mimeType.equals("text/directory");
    }

    public RepositoryFile getFile() {
        return this.file;
    }

    public void setFile(RepositoryFile file) {
        this.file = file;
    }

    public boolean isOverwriteInRepository() {
        return this.overwriteInRepository;
    }

    public boolean isApplyAclSettings() {
        return this.applyAclSettings;
    }

    public void setApplyAclSettings(boolean applyAclSettings) {
        this.applyAclSettings = applyAclSettings;
    }

    public boolean isOverwriteAclSettings() {
        return this.overwriteAclSettings;
    }

    public void setOverwriteAclSettings(boolean overwriteAclSettings) {
        this.overwriteAclSettings = overwriteAclSettings;
    }

    public boolean isRetainOwnership() {
        return this.retainOwnership;
    }

    public void setRetainOwnership(boolean retainOwnership) {
        this.retainOwnership = retainOwnership;
    }

    private boolean validate() {
        if (this.mimeType != null && this.mimeType.equals("text/directory")) {
            return this.inputStream == null;
        }
        return this.inputStream != null;
    }

    private void addProperty(String prop, Object val) {
        this.properties.put(prop, val);
    }

    public Object getProperty(String prop) {
        return this.properties.get(prop);
    }

    public boolean overwriteInRepository() {
        return this.overwriteInRepository;
    }

    public boolean isPreserveDsw() {
        return this.preserveDsw;
    }

    public void setPreserveDsw(boolean preserveDsw) {
        this.preserveDsw = preserveDsw;
    }

    public static class Builder {
        protected RepositoryFileImportBundle bundle = new RepositoryFileImportBundle();

        public RepositoryFileImportBundle build() {
            if (this.bundle.validate()) {
                return this.bundle;
            }
            throw new IllegalStateException("Bundle is not valid, check your inputs");
        }

        public Builder overwriteFile(boolean overwrite) {
            this.bundle.setOverwriteInRepository(overwrite);
            return this;
        }

        public Builder comment(String comment) {
            this.bundle.setComment(comment);
            return this;
        }

        public Builder acl(RepositoryFileAcl acl) {
            this.bundle.setAcl(acl);
            return this;
        }

        public Builder extraMetaData(RepositoryFileExtraMetaData extraMetaData) {
            this.bundle.setExtraMetaData(extraMetaData);
            return this;
        }

        public Builder input(InputStream in) {
            this.bundle.setInputStream(in);
            return this;
        }

        public Builder file(RepositoryFile file) {
            this.bundle.setFile(file);
            return this;
        }

        public Builder hidden(Boolean hidden) {
            this.bundle.setHidden(hidden);
            return this;
        }

        public Builder schedulable(Boolean schedulable) {
            this.bundle.setSchedulable(schedulable);
            return this;
        }

        public Builder charSet(String charset) {
            this.bundle.setCharSet(charset);
            return this;
        }

        public Builder name(String name) {
            this.bundle.setName(name);
            return this;
        }

        public Builder title(String title) {
            this.bundle.setTitle(title);
            return this;
        }

        public Builder path(String path) {
            this.bundle.setPath(path);
            return this;
        }

        public Builder withParam(String param, String value) {
            this.bundle.addProperty(param, value);
            return this;
        }

        public Builder mime(String mime) {
            this.bundle.setMimeType(mime);
            return this;
        }

        public void applyAclSettings(boolean applyAclSettings) {
            this.bundle.setApplyAclSettings(applyAclSettings);
        }

        public void overwriteAclSettings(boolean overwriteAclSettings) {
            this.bundle.setOverwriteAclSettings(overwriteAclSettings);
        }

        public void retainOwnership(boolean retainOwnership) {
            this.bundle.setRetainOwnership(retainOwnership);
        }

        public Builder addChildBundle(IPlatformImportBundle childBundle) {
            this.bundle.children.add(childBundle);
            return this;
        }

        public Builder preserveDsw(boolean preserveDsw) {
            this.bundle.setPreserveDsw(preserveDsw);
            return this;
        }
    }
}

