/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.importer;

import java.util.HashMap;
import java.util.Map;
import org.pentaho.platform.api.mimetype.IMimeType;
import org.pentaho.platform.api.mimetype.IPlatformMimeResolver;
import org.pentaho.platform.api.repository2.unified.IPlatformImportBundle;

public class NameBaseMimeResolver
implements IPlatformMimeResolver {
    private Map<String, IMimeType> extensionToMimeMap = new HashMap<String, IMimeType>();

    public String resolveMimeForFileName(String fileName) {
        IMimeType mimeType = this.extensionToMimeMap.get(this.extractExtension(fileName));
        if (mimeType == null) {
            return null;
        }
        return mimeType.getName();
    }

    public String resolveMimeForBundle(IPlatformImportBundle bundle) {
        if (bundle.getMimeType() != null) {
            return bundle.getMimeType();
        }
        IMimeType mimeType = this.extensionToMimeMap.get(this.extractExtension(bundle.getName()));
        if (mimeType == null) {
            return null;
        }
        return mimeType.getName();
    }

    public IMimeType resolveMimeTypeForFileName(String fileName) {
        return this.extensionToMimeMap.get(this.extractExtension(fileName));
    }

    private String extractExtension(String name) {
        if (name == null) {
            return null;
        }
        int idx = name.lastIndexOf(".");
        if (idx == -1 || idx == name.length()) {
            return name;
        }
        return name.substring(idx + 1);
    }

    public void addMimeType(IMimeType mimeType) {
        for (String extension : mimeType.getExtensions()) {
            this.extensionToMimeMap.put(extension, mimeType);
        }
    }
}

