/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.importer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.metadata.repository.DomainAlreadyExistsException;
import org.pentaho.metadata.repository.DomainIdNullException;
import org.pentaho.metadata.repository.DomainStorageException;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.stores.xml.XmlMetaStore;
import org.pentaho.metastore.util.MetaStoreUtil;
import org.pentaho.platform.api.mimetype.IMimeType;
import org.pentaho.platform.api.repository2.unified.IPlatformImportBundle;
import org.pentaho.platform.plugin.services.exporter.MetaStoreExportUtil;
import org.pentaho.platform.plugin.services.importer.IPlatformImportHandler;
import org.pentaho.platform.plugin.services.importer.PlatformImportException;

public class MetaStoreImportHandler
implements IPlatformImportHandler {
    private static final Log log = LogFactory.getLog(MetaStoreImportHandler.class);
    private static final String METASTORE = "metastore";
    private List<IMimeType> mimeTypes;
    private IMetaStore metastore;
    protected XmlMetaStore tmpXmlMetaStore;

    public MetaStoreImportHandler() {
    }

    public MetaStoreImportHandler(List<IMimeType> mimeTypes) {
        this.mimeTypes = mimeTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importFile(IPlatformImportBundle bundle) throws PlatformImportException, DomainIdNullException, DomainAlreadyExistsException, DomainStorageException, IOException {
        ZipEntry entry;
        InputStream inputStream = bundle.getInputStream();
        Path path = Files.createTempDirectory(METASTORE, new FileAttribute[0]);
        path.toFile().deleteOnExit();
        ZipInputStream zis = new ZipInputStream(inputStream);
        while ((entry = zis.getNextEntry()) != null) {
            try {
                String filePath = path.toString() + File.separator + entry.getName();
                if (entry.isDirectory()) {
                    File dir = new File(filePath);
                    dir.mkdir();
                    continue;
                }
                File file = new File(filePath);
                file.getParentFile().mkdirs();
                FileOutputStream fos = new FileOutputStream(filePath);
                IOUtils.copy((InputStream)zis, (OutputStream)fos);
                IOUtils.closeQuietly((OutputStream)fos);
            }
            finally {
                zis.closeEntry();
            }
        }
        IOUtils.closeQuietly((InputStream)zis);
        IMetaStore metastore = this.getRepoMetaStore();
        if (metastore != null) {
            try {
                if (this.tmpXmlMetaStore == null) {
                    this.tmpXmlMetaStore = new XmlMetaStore(path.toString());
                } else {
                    this.tmpXmlMetaStore.setRootFolder(path.toString() + File.separator + METASTORE);
                }
                this.tmpXmlMetaStore.setName(bundle.getName());
                String desc = bundle.getProperty("description") == null ? null : bundle.getProperty("description").toString();
                this.tmpXmlMetaStore.setDescription(desc);
                MetaStoreUtil.copy((IMetaStore)this.tmpXmlMetaStore, (IMetaStore)metastore, (boolean)bundle.overwriteInRepository());
            }
            catch (MetaStoreException e) {
                log.error((Object)"Could not restore the MetaStore");
                log.debug((Object)"Error restoring the MetaStore", (Throwable)e);
            }
        }
    }

    public void setMimeTypes(List<IMimeType> mimeTypes) {
        this.mimeTypes = mimeTypes;
    }

    @Override
    public List<IMimeType> getMimeTypes() {
        return this.mimeTypes;
    }

    protected IMetaStore getRepoMetaStore() {
        if (this.metastore == null) {
            try {
                this.metastore = MetaStoreExportUtil.connectToRepository(null).getMetaStore();
            }
            catch (KettleException e) {
                log.debug((Object)"Can't get the metastore to import into");
            }
        }
        return this.metastore;
    }

    protected void setRepoMetaStore(IMetaStore metastore) {
        this.metastore = metastore;
    }
}

