/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.openflashchart.factory;

import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import ofc4j.model.elements.ScatterChart;
import org.dom4j.Node;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.plugin.action.openflashchart.factory.AbstractChartFactory;

public class BubbleChartFactory
extends AbstractChartFactory {
    private static final String MAX_BUBBLE_SIZE_NODE_LOC = "max-bubble-size";
    private static final String BUBBLE_LABEL_Z_FORMAT_NODE_LOC = "bubble-label-z-format";
    private static final String BUBBLE_LABEL_CONTENT_NODE_LOC = "bubble-label-content";
    private Number bubbleMaxX;
    private int maxBubbleSize = 100;

    @Override
    public void validateData() {
        super.validateData();
        if (this.getColumnCount() < 3) {
            throw new RuntimeException(Messages.getInstance().getErrorString("BubbleChartFactory.ERROR_0001_XYZ_COLUMN_COUNT"));
        }
    }

    @Override
    protected void createElements() {
        Node contentNode = this.chartNode.selectSingleNode(BUBBLE_LABEL_CONTENT_NODE_LOC);
        String content = BubbleChartFactory.getValue(contentNode);
        Node zFormatNode = this.chartNode.selectSingleNode(BUBBLE_LABEL_Z_FORMAT_NODE_LOC);
        String zFormat = BubbleChartFactory.getValue(zFormatNode);
        DecimalFormat df = null;
        if (zFormat != null) {
            df = new DecimalFormat(zFormat);
        }
        for (int row = 0; row < this.getRowCount(); ++row) {
            ScatterChart e = null;
            String text = this.getRowHeader(row);
            ScatterChart sc = new ScatterChart("");
            sc.setColour(this.getColor(row));
            Number x = (Number)this.getValueAt(row, 0);
            Number y = (Number)this.getValueAt(row, 1);
            Number z = (Number)this.getValueAt(row, 2);
            this.setupDotSize(sc, z);
            sc.addPoint((Number)x.doubleValue(), (Number)y.doubleValue());
            if (content != null) {
                String zstr = null;
                if (df != null) {
                    zstr = df.format(z);
                } else if (z != null) {
                    zstr = z.toString();
                }
                sc.setTooltip(MessageFormat.format(content, text, NumberFormat.getInstance().format(x), NumberFormat.getInstance().format(y), zstr));
            }
            if (this.alpha != null) {
                sc.setAlpha(this.alpha);
            }
            e = sc;
            e.setText(text);
            this.elements.add(e);
        }
    }

    @Override
    protected void setupStyles() {
        super.setupStyles();
        Number maxX = 0;
        int rowCount = this.getRowCount();
        for (int row = 0; row < rowCount; ++row) {
            Number currx = (Number)this.getValueAt(row, 2);
            if (!(((Number)maxX).doubleValue() < currx.doubleValue())) continue;
            maxX = currx;
        }
        this.bubbleMaxX = maxX;
        Node bubbleSizeNode = this.chartNode.selectSingleNode(MAX_BUBBLE_SIZE_NODE_LOC);
        if (BubbleChartFactory.getValue(bubbleSizeNode) != null) {
            this.maxBubbleSize = Integer.parseInt(BubbleChartFactory.getValue(bubbleSizeNode));
        }
    }

    public void setupDotSize(ScatterChart se, Number x) {
        se.setDotSize(Integer.valueOf(Math.round((float)this.maxBubbleSize * (x.floatValue() / this.bubbleMaxX.floatValue()))));
    }
}

