/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.kettle;

import javax.sql.DataSource;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.service.IDatabaseDialectService;
import org.pentaho.di.core.database.DataSourceNamingException;
import org.pentaho.di.core.database.DataSourceProviderFactory;
import org.pentaho.di.core.database.DataSourceProviderInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.platform.api.data.DBDatasourceServiceException;
import org.pentaho.platform.api.data.IDBDatasourceService;
import org.pentaho.platform.api.data.IJndiDatasourceService;
import org.pentaho.platform.api.data.IPooledDatasourceService;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository.DatabaseHelper;

public class PlatformKettleDataSourceProvider
implements DataSourceProviderInterface {
    protected static final PlatformKettleDataSourceProvider instance = new PlatformKettleDataSourceProvider();
    private static DatabaseHelper dbHelper;

    private PlatformKettleDataSourceProvider() {
        dbHelper = new DatabaseHelper((IDatabaseDialectService)PentahoSystem.get(IDatabaseDialectService.class));
    }

    public DataSourceProviderInterface getInstance() {
        return instance;
    }

    protected static void hookupProvider() {
        DataSourceProviderFactory.setDataSourceProviderInterface((DataSourceProviderInterface)instance);
    }

    private <T extends IDBDatasourceService> IDBDatasourceService getService(Class<T> dataSourceServiceInterface) {
        IDBDatasourceService datasourceService = (IDBDatasourceService)PentahoSystem.get(dataSourceServiceInterface, null);
        IDBDatasourceService service = datasourceService == null ? (IDBDatasourceService)PentahoSystem.get(IDBDatasourceService.class, null) : datasourceService;
        return service;
    }

    protected <T extends IDBDatasourceService> DataSource getNamedDataSourceFromService(Class<T> dataSourceServiceInterface, String dataSourceName) throws DataSourceNamingException {
        IDBDatasourceService service = this.getService(dataSourceServiceInterface);
        if (service != null) {
            try {
                return service.getDataSource(dataSourceName);
            }
            catch (DBDatasourceServiceException ex) {
                throw new DataSourceNamingException((Throwable)ex);
            }
        }
        return null;
    }

    public DataSource getNamedDataSource(String dataSourceName) throws DataSourceNamingException {
        return this.getNamedDataSourceFromService(IDBDatasourceService.class, dataSourceName);
    }

    public DataSource getNamedDataSource(String dataSourceName, DataSourceProviderInterface.DatasourceType type) throws DataSourceNamingException {
        if (type != null) {
            switch (type) {
                case JNDI: {
                    return this.getNamedDataSourceFromService(IJndiDatasourceService.class, dataSourceName);
                }
                case POOLED: {
                    return this.getNamedDataSourceFromService(IPooledDatasourceService.class, dataSourceName);
                }
            }
        }
        throw new DataSourceNamingException(String.format("Unknown data source type [%s] for named data source [%s]", type, dataSourceName));
    }

    public DataSource getPooledDataSourceFromMeta(DatabaseMeta dbMeta, DataSourceProviderInterface.DatasourceType type) throws DataSourceNamingException {
        if (type != DataSourceProviderInterface.DatasourceType.POOLED) {
            throw new DataSourceNamingException(String.format("Attempted to get non-pooled DB connection via meta [%s]", dbMeta.getName()));
        }
        IDatabaseConnection connection = dbHelper.databaseMetaToDatabaseConnection(dbMeta);
        IDBDatasourceService service = this.getService(IPooledDatasourceService.class);
        if (null == service) {
            return null;
        }
        DataSource dataSource = null;
        try {
            dataSource = service.resolveDatabaseConnection(connection);
        }
        catch (DBDatasourceServiceException e) {
            throw new DataSourceNamingException((Throwable)e);
        }
        return dataSource;
    }

    public DataSource invalidateNamedDataSource(String datasourceName, DataSourceProviderInterface.DatasourceType type) throws DataSourceNamingException {
        IDBDatasourceService service;
        switch (type) {
            case JNDI: {
                service = this.getService(IJndiDatasourceService.class);
                break;
            }
            case POOLED: {
                service = this.getService(IPooledDatasourceService.class);
                break;
            }
            default: {
                service = this.getService(IDBDatasourceService.class);
            }
        }
        if (service != null) {
            try {
                DataSource dataSource = service.getDataSource(datasourceName);
                if (dataSource == null) {
                    return null;
                }
                service.clearDataSource(datasourceName);
                return dataSource;
            }
            catch (DBDatasourceServiceException ex) {
                throw new DataSourceNamingException((Throwable)ex);
            }
        }
        return null;
    }
}

