/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.jfreereport.outputs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.pentaho.platform.plugin.action.jfreereport.outputs.AbstractGenerateStreamContentComponent;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressListener;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessor;
import org.pentaho.reporting.engine.classic.core.layout.output.YieldReportListener;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.FlowReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.FlowExcelOutputProcessor;

public class JFreeReportExcelComponent
extends AbstractGenerateStreamContentComponent {
    private static final long serialVersionUID = -2130145967763406737L;

    @Override
    protected String getMimeType() {
        return "application/vnd.ms-excel";
    }

    @Override
    protected String getExtension() {
        return ".xls";
    }

    @Override
    protected boolean performExport(MasterReport report, OutputStream outputStream) {
        try {
            int yieldRate;
            FlowExcelOutputProcessor target = new FlowExcelOutputProcessor(report.getConfiguration(), outputStream, report.getResourceManager());
            FlowReportProcessor reportProcessor = new FlowReportProcessor(report, (OutputProcessor)target);
            if (this.isDefinedInput("workbook")) {
                try {
                    InputStream inputStream = this.getInputStream("workbook");
                    target.setTemplateInputStream(inputStream);
                }
                catch (Exception e) {
                    this.error(Messages.getInstance().getString("JFreeReportExcelComponent.ERROR_0037_ERROR_READING_REPORT_INPUT"), e);
                    return false;
                }
            }
            if ((yieldRate = this.getYieldRate()) > 0) {
                reportProcessor.addReportProgressListener((ReportProgressListener)new YieldReportListener(yieldRate));
            }
            reportProcessor.processReport();
            reportProcessor.close();
            outputStream.flush();
            this.close();
            return true;
        }
        catch (ReportProcessingException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }
}

