/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.jfreereport.outputs;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.io.IOUtils;
import org.pentaho.platform.plugin.action.jfreereport.AbstractJFreeReportComponent;
import org.pentaho.platform.plugin.action.jfreereport.helper.PentahoResourceBundleFactory;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;

public abstract class AbstractGenerateContentComponent
extends AbstractJFreeReportComponent {
    private static final long serialVersionUID = -5240026550908859563L;

    protected AbstractGenerateContentComponent() {
    }

    protected boolean validateAction() {
        Object inputValue;
        if (!this.isDefinedInput("_REPORT.OBJECT")) {
            this.warn(Messages.getInstance().getString("AbstractGenerateContentComponent.JFreeReport.ERROR_0038_NO_REPORT_OBJECT_INPUT"));
            return false;
        }
        if (this.isDefinedInput("yield-rate")) {
            inputValue = this.getInputValue("yield-rate");
            if (inputValue instanceof Number) {
                Number n = (Number)inputValue;
                if (n.intValue() < 0) {
                    this.warn(Messages.getInstance().getString("AbstractGenerateContentComponent.JFreeReport.ERROR_0040_YIELD_RATE_POSITIVE"));
                }
            } else {
                this.warn(Messages.getInstance().getString("AbstractGenerateContentComponent.JFreeReport.ERROR_0041_YIELD_RATE_NUMERIC"));
                return false;
            }
        }
        if (this.isDefinedInput("report-priority") && !"normal".equals(inputValue = this.getInputStringValue("report-priority")) && !"lower".equals(inputValue) && !"lowest".equals(inputValue)) {
            this.warn(Messages.getInstance().getString("AbstractGenerateContentComponent.JFreeReport.ERROR_0042_PRIORITY_MUST_BE"));
        }
        return true;
    }

    protected MasterReport getReport() {
        Object maybeJFreeReport = this.getInputValue("_REPORT.OBJECT");
        if (maybeJFreeReport instanceof MasterReport) {
            return (MasterReport)maybeJFreeReport;
        }
        return null;
    }

    protected boolean validateSystemSettings() {
        return true;
    }

    protected boolean executeAction() throws Throwable {
        MasterReport report = this.getReport();
        if (report == null) {
            this.warn(Messages.getInstance().getString("AbstractGenerateContentComponent.JFreeReport.ERROR_0043_NO_REPORT_FOR_ACTION"));
            return false;
        }
        this.applyThreadPriority();
        boolean privateCopy = this.getInputBooleanValue("create_private_report", false);
        if (privateCopy && this.isDefinedOutput("_REPORT.OBJECT")) {
            report = report.clone();
        }
        String baseName = IOUtils.getInstance().stripFileExtension(this.getActionName());
        String path = this.getSolutionName() + File.separator + this.getSolutionPath();
        PentahoResourceBundleFactory bundleFactory = new PentahoResourceBundleFactory(path, baseName, this.getSession());
        report.setResourceBundleFactory((ResourceBundleFactory)bundleFactory);
        report.getReportConfiguration().setConfigProperty("org.pentaho.reporting.engine.classic.core.ResourceBundle", baseName);
        return this.performExport(report);
    }

    private void applyThreadPriority() {
        if (this.isDefinedInput("report-priority")) {
            try {
                String inputValue = this.getInputStringValue("report-priority");
                if ("lower".equals(inputValue)) {
                    int priority = Math.max(Thread.currentThread().getPriority() - 1, 1);
                    Thread.currentThread().setPriority(priority);
                } else if ("lowest".equals(inputValue)) {
                    Thread.currentThread().setPriority(1);
                }
            }
            catch (Exception e) {
                this.warn(Messages.getInstance().getString("AbstractGenerateContentComponent.JFreeReport.ERROR_0044_UNABLE_T0_SET_THREAD_PRIORITY"));
            }
        }
    }

    protected abstract boolean performExport(MasterReport var1) throws IOException;

    public void done() {
    }

    public boolean init() {
        return true;
    }

    public Log getLogger() {
        return LogFactory.getLog(((Object)((Object)this)).getClass());
    }

    protected int getYieldRate() {
        Object inputValue;
        if (this.isDefinedInput("yield-rate") && (inputValue = this.getInputValue("yield-rate")) instanceof Number) {
            Number n = (Number)inputValue;
            if (n.intValue() < 1) {
                return 0;
            }
            return n.intValue();
        }
        return 0;
    }
}

