/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.chartbeans;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.pentaho.chart.AbstractChartThemeFactory;
import org.pentaho.chart.ChartBeanFactory;
import org.pentaho.chart.ChartBoot;
import org.pentaho.chart.IChartLinkGenerator;
import org.pentaho.chart.InvalidChartDefinition;
import org.pentaho.chart.data.IChartDataModel;
import org.pentaho.chart.model.ChartModel;
import org.pentaho.chart.model.DialPlot;
import org.pentaho.chart.model.PiePlot;
import org.pentaho.chart.model.Theme;
import org.pentaho.chart.model.util.ChartSerializer;
import org.pentaho.chart.plugin.ChartDataOverflowException;
import org.pentaho.chart.plugin.ChartProcessingException;
import org.pentaho.chart.plugin.NoChartDataException;
import org.pentaho.chart.plugin.api.IOutput;
import org.pentaho.chart.plugin.api.PersistenceException;
import org.pentaho.chart.plugin.jfreechart.outputs.JFreeChartOutput;
import org.pentaho.commons.connection.IPentahoMetaData;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.api.engine.IPentahoRequestContext;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.action.chartbeans.ChartBeansGeneratorUtil;
import org.pentaho.platform.plugin.action.chartbeans.ChartBootException;
import org.pentaho.platform.plugin.action.chartbeans.ChartLinkGenerator;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;

public class ChartComponent {
    protected static final int DEFAULT_CHART_WIDTH = 400;
    protected static final int DEFAULT_CHART_HEIGHT = 300;
    protected boolean convertNullsToZero = false;
    protected String seriesColumnName = null;
    protected int seriesColumn = -1;
    protected String categoryColumnName = null;
    protected int categoryColumn = -1;
    protected String valueColumnName = null;
    protected int valueColumn = -1;
    protected IPentahoResultSet resultSet = null;
    protected String chartEngine;
    protected Exception bootException = null;
    protected String outputType = "";
    protected int chartWidth = -1;
    protected int chartHeight = -1;
    protected Number scalingFactor = new Double(1.0);
    protected OutputStream outputStream = null;
    protected String chartModelJson = null;
    protected String chartModelXml = null;
    protected ChartModel chartModel = null;
    protected String contentLinkingTemplate;
    protected String title = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChartComponent() {
        ChartBoot chartBoot = ChartBoot.getInstance();
        synchronized (chartBoot) {
            while (!ChartBoot.getInstance().isBootDone()) {
                if (ChartBoot.getInstance().isBootInProgress()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                if (ChartBoot.getInstance().isBootFailed()) continue;
                ChartBoot.getInstance().start();
            }
            if (ChartBoot.getInstance().isBootFailed()) {
                this.bootException = ChartBoot.getInstance().getBootFailureReason();
            }
        }
    }

    public boolean execute() throws ChartBootException, ChartProcessingException, ResourceException, InvalidChartDefinition, IOException, PersistenceException {
        if (this.bootException != null) {
            throw new ChartBootException(this.bootException);
        }
        if (this.chartModel.getTheme() != null) {
            Theme chartTheme;
            AbstractChartThemeFactory chartThemeFactory = new AbstractChartThemeFactory(){

                protected List<File> getThemeFiles() {
                    ArrayList<File> themeFiles = new ArrayList<File>();
                    themeFiles.add(new File(PentahoSystem.getApplicationContext().getSolutionPath("system/chartbeans/themes/Theme1.xml")));
                    themeFiles.add(new File(PentahoSystem.getApplicationContext().getSolutionPath("system/chartbeans/themes/Theme2.xml")));
                    themeFiles.add(new File(PentahoSystem.getApplicationContext().getSolutionPath("system/chartbeans/themes/Theme3.xml")));
                    themeFiles.add(new File(PentahoSystem.getApplicationContext().getSolutionPath("system/chartbeans/themes/Theme4.xml")));
                    themeFiles.add(new File(PentahoSystem.getApplicationContext().getSolutionPath("system/chartbeans/themes/Theme5.xml")));
                    themeFiles.add(new File(PentahoSystem.getApplicationContext().getSolutionPath("system/chartbeans/themes/Theme6.xml")));
                    themeFiles.add(new File(PentahoSystem.getApplicationContext().getSolutionPath("system/chartbeans/themes/Theme7.xml")));
                    themeFiles.add(new File(PentahoSystem.getApplicationContext().getSolutionPath("system/chartbeans/themes/Theme8.xml")));
                    return themeFiles;
                }
            };
            if (!(this.chartModel.getPlot() instanceof DialPlot) && (chartTheme = chartThemeFactory.getTheme(this.chartModel.getTheme())) != null) {
                chartTheme.applyTo(this.chartModel);
            }
        }
        this.loadChartEngine();
        this.chartModel.setChartEngineId(this.chartEngine);
        ByteArrayInputStream is = null;
        Object[][] data = this.processChartData(this.resultSet, this.valueColumn);
        try {
            ByteArrayOutputStream outputStream;
            ChartLinkGenerator chartLinkGenerator = this.contentLinkingTemplate == null ? null : new ChartLinkGenerator(this.contentLinkingTemplate);
            IChartDataModel chartDataModel = ChartBeanFactory.createChartDataModel((Object[][])data, (Number)this.scalingFactor, (boolean)this.convertNullsToZero, (int)this.valueColumn, (int)this.seriesColumn, (int)this.categoryColumn, (ChartModel)this.chartModel, (IPentahoMetaData)this.resultSet.getMetaData());
            IOutput output = ChartBeanFactory.createChart((ChartModel)this.chartModel, (IChartDataModel)chartDataModel, (IChartLinkGenerator)chartLinkGenerator);
            if ("OpenFlashChart".equals(this.chartEngine)) {
                outputStream = new ByteArrayOutputStream();
                output.persistChart((OutputStream)outputStream, this.getOutputType(), this.chartWidth, this.chartHeight);
                String persistedChart = new String(outputStream.toByteArray(), "utf-8");
                IPentahoRequestContext requestContext = PentahoRequestContextHolder.getRequestContext();
                String flashContent = ChartBeansGeneratorUtil.mergeOpenFlashChartHtmlTemplate(persistedChart.replaceAll("\"", "\\\\\""), requestContext.getContextPath() + this.getSwfPath() + "/" + this.getSwfName());
                is = new ByteArrayInputStream(flashContent.getBytes("utf-8"));
            } else if ("JFreeChart".equals(this.chartEngine)) {
                if ("html".equals(this.outputType) || chartLinkGenerator != null) {
                    File imageFile = PentahoSystem.getApplicationContext().createTempFile(PentahoSessionHolder.getSession(), "tmp_chart_", ".png", false);
                    FileOutputStream outputStream2 = new FileOutputStream(imageFile);
                    output.persistChart((OutputStream)outputStream2, IOutput.OutputTypes.FILE_TYPE_PNG, this.chartWidth, this.chartHeight);
                    String imageMapName = null;
                    String imageMap = null;
                    if (chartLinkGenerator != null) {
                        imageMapName = imageFile.getName().substring(0, imageFile.getName().indexOf(46));
                        imageMap = ((JFreeChartOutput)output).getMap(imageMapName);
                    }
                    String jFreeChartHtml = ChartBeansGeneratorUtil.mergeJFreeChartHtmlTemplate(imageFile, imageMap, imageMapName, this.chartWidth, this.chartHeight, PentahoRequestContextHolder.getRequestContext().getContextPath());
                    is = new ByteArrayInputStream(jFreeChartHtml.getBytes("utf-8"));
                } else {
                    outputStream = new ByteArrayOutputStream();
                    output.persistChart((OutputStream)outputStream, this.getOutputType(), this.chartWidth, this.chartHeight);
                    is = new ByteArrayInputStream(outputStream.toByteArray());
                }
            }
            int val = 0;
            while ((val = ((InputStream)is).read()) != -1) {
                this.outputStream.write(val);
            }
        }
        catch (NoChartDataException ex) {
            if ("JFreeChart".equals(this.chartEngine)) {
                BufferedImage image = new BufferedImage(this.chartWidth, this.chartHeight, 2);
                Graphics2D graphics = image.createGraphics();
                graphics.setFont(new Font("serif", 1, 14));
                graphics.setColor(Color.BLACK);
                graphics.drawString("The chart data query returned no data.", 40, 40);
                String outputType = "png";
                File imageFile = PentahoSystem.getApplicationContext().createTempFile(PentahoSessionHolder.getSession(), "tmp_chart_", ".png", false);
                FileOutputStream fo = new FileOutputStream(imageFile);
                ImageIO.write((RenderedImage)image, "png", fo);
                String jFreeChartHtml = ChartBeansGeneratorUtil.mergeJFreeChartHtmlTemplate(imageFile, null, null, this.chartWidth, this.chartHeight, PentahoRequestContextHolder.getRequestContext().getContextPath());
                is = new ByteArrayInputStream(jFreeChartHtml.getBytes("utf-8"));
                int val = 0;
                while ((val = ((InputStream)is).read()) != -1) {
                    this.outputStream.write(val);
                }
            } else {
                String flashContent = ChartBeansGeneratorUtil.buildEmptyOpenFlashChartHtmlFragment("The chart data query returned no data.");
                is = new ByteArrayInputStream(flashContent.getBytes("utf-8"));
                int val = 0;
                while ((val = ((InputStream)is).read()) != -1) {
                    this.outputStream.write(val);
                }
            }
        }
        catch (ChartDataOverflowException ex) {
            if ("JFreeChart".equals(this.chartEngine)) {
                BufferedImage image = new BufferedImage(this.chartWidth, this.chartHeight, 2);
                Graphics2D graphics = image.createGraphics();
                graphics.setFont(new Font("serif", 1, 14));
                graphics.setColor(Color.BLACK);
                graphics.drawString(Messages.getInstance().getErrorString("ChartComponent.TOO_MANY_DATA_POINTS"), 5, 5);
                graphics.drawString(Messages.getInstance().getErrorString("ChartComponent.MAX_ALLOWED_DATA_POINTS", new Object[]{Integer.toString(ex.getMaxAllowedDataPoints())}), 5, 25);
                String outputType = this.getMimeType().equals("image/jpg") ? "jpeg" : "png";
                ImageIO.write((RenderedImage)image, outputType, this.outputStream);
            }
            String flashContent = ChartBeansGeneratorUtil.buildEmptyOpenFlashChartHtmlFragment(Messages.getInstance().getErrorString("ChartComponent.TOO_MANY_DATA_POINTS_HTML", new Object[]{Integer.toString(ex.getMaxAllowedDataPoints())}));
            is = new ByteArrayInputStream(flashContent.getBytes("utf-8"));
            int val = 0;
            while ((val = ((InputStream)is).read()) != -1) {
                this.outputStream.write(val);
            }
        }
        return true;
    }

    protected Object[][] processChartData(IPentahoResultSet resultSet, int valueColumnIndex) {
        if (resultSet == null) {
            return null;
        }
        Object[][] result = null;
        result = new Object[resultSet.getRowCount()][resultSet.getMetaData().getColumnCount()];
        for (int r = 0; r < resultSet.getRowCount(); ++r) {
            for (int c = 0; c < resultSet.getMetaData().getColumnCount(); ++c) {
                result[r][c] = resultSet.getValueAt(r, c);
            }
        }
        return result;
    }

    public void setOutputStream(OutputStream outStream) {
        this.outputStream = outStream;
    }

    public void setChartData(IPentahoResultSet chartDataSet) {
        this.resultSet = chartDataSet.memoryCopy();
    }

    public boolean validate() throws Exception {
        if (this.resultSet == null) {
            return false;
        }
        if (this.seriesColumnName != null) {
            if (!this.seriesColumnName.equals("")) {
                this.seriesColumn = this.resultSet.getMetaData().getColumnIndex(this.seriesColumnName);
            }
        } else if (this.seriesColumn < 0) {
            this.seriesColumn = 0;
        }
        if (this.categoryColumnName != null) {
            if ("None".equals(this.categoryColumnName)) {
                this.categoryColumn = -1;
            } else if (!this.categoryColumnName.equals("")) {
                this.categoryColumn = this.resultSet.getMetaData().getColumnIndex(this.categoryColumnName);
            }
        } else if (this.categoryColumn < 0) {
            this.categoryColumn = 1;
        }
        if (this.valueColumnName != null) {
            if (!this.valueColumnName.equals("")) {
                this.valueColumn = this.resultSet.getMetaData().getColumnIndex(this.valueColumnName);
            }
        } else if (this.valueColumn < 0) {
            this.valueColumn = 2;
        }
        this.loadChartEngine();
        if (this.chartModel == null) {
            return false;
        }
        if (this.chartModel.getPlot() instanceof DialPlot ? this.valueColumn < 0 : (this.chartModel.getPlot() instanceof PiePlot ? this.seriesColumn < 0 || this.valueColumn < 0 : this.seriesColumn < 0 || this.valueColumn < 0)) {
            return false;
        }
        if (this.chartWidth <= 0) {
            this.chartWidth = 400;
        }
        if (this.chartHeight <= 0) {
            this.chartHeight = 300;
        }
        return true;
    }

    public void setSeriesColumn(String seriesCol) {
        this.seriesColumnName = seriesCol;
    }

    public void setConvertNullsToZero(boolean convert) {
        this.convertNullsToZero = convert;
    }

    public boolean getConvertNullsToZero() {
        return this.convertNullsToZero;
    }

    public void setCategoryColumn(String categoryCol) {
        this.categoryColumnName = categoryCol;
    }

    public void setValueColumn(String valueCol) {
        this.valueColumnName = valueCol;
    }

    protected IOutput.OutputTypes getOutputType() {
        if (this.outputType.equals("jpg")) {
            return IOutput.OutputTypes.FILE_TYPE_JPEG;
        }
        if (this.outputType.equals("png")) {
            return IOutput.OutputTypes.FILE_TYPE_PNG;
        }
        if (this.outputType.equals("html")) {
            return IOutput.OutputTypes.FILE_TYPE_HTML;
        }
        return null;
    }

    public String getMimeType() {
        this.loadChartEngine();
        if ("JFreeChart".equals(this.chartEngine)) {
            if (this.outputType.equalsIgnoreCase("jpg")) {
                return "image/jpg";
            }
            if (this.outputType.equalsIgnoreCase("png")) {
                return "image/png";
            }
            if (this.outputType.equalsIgnoreCase("html")) {
                return "text/html";
            }
            this.outputType = "png";
            return "image/png";
        }
        if ("OpenFlashChart".equals(this.chartEngine)) {
            this.outputType = "html";
            return "text/html";
        }
        return "text/html";
    }

    protected void loadChartEngine() {
        this.loadChartModel();
        if (this.chartModel != null && this.chartModel.getChartEngineId() != null) {
            this.chartEngine = this.chartModel.getChartEngineId();
            return;
        }
        if (this.chartEngine != null) {
            return;
        }
        String defaultChartEngine = PentahoSystem.getSystemSetting((String)"chartbeans/chartbeans_config.xml", (String)"default-chart-engine", (String)"OpenFlashChart");
        if (defaultChartEngine == null) {
            defaultChartEngine = "OpenFlashChart";
        }
        this.chartEngine = defaultChartEngine;
    }

    protected void loadChartModel() {
        if (this.chartModel == null) {
            if (this.chartModelJson != null) {
                this.chartModel = ChartSerializer.deSerialize((String)this.chartModelJson, (ChartSerializer.ChartSerializationFormat)ChartSerializer.ChartSerializationFormat.JSON);
            } else if (this.chartModelXml != null) {
                this.chartModel = ChartSerializer.deSerialize((String)this.chartModelXml, (ChartSerializer.ChartSerializationFormat)ChartSerializer.ChartSerializationFormat.XML);
            }
        }
    }

    public void setChartModelJson(String chartModelJson) {
        this.chartModelJson = chartModelJson;
    }

    public void setChartModelXml(String chartModelXml) {
        this.chartModelXml = chartModelXml;
    }

    public void setChartModel(ChartModel chartModel) {
        this.chartModel = chartModel;
    }

    public void setChartWidth(int chartWidth) {
        this.chartWidth = chartWidth;
    }

    public void setChartHeight(int chartHeight) {
        this.chartHeight = chartHeight;
    }

    public void setChartWidth(String chartWidth) {
        this.chartWidth = Integer.valueOf(chartWidth);
    }

    public void setChartHeight(String chartHeight) {
        this.chartHeight = Integer.valueOf(chartHeight);
    }

    public String getChartEngine() {
        this.loadChartEngine();
        return this.chartEngine;
    }

    public void setChartEngine(String chartEngine) {
        this.chartEngine = chartEngine;
    }

    public void setOutputType(String outputType) {
        this.outputType = outputType;
    }

    public void setScalingFactor(Double scalingFactor) {
        this.scalingFactor = scalingFactor;
    }

    public String getSwfPath() {
        return "openflashchart";
    }

    public String getSwfName() {
        return "open-flash-chart-full-embedded-font.swf";
    }

    public void setContentLinkingTemplate(String template) {
        this.contentLinkingTemplate = template;
    }
}

