/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftp;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileNotFolderException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.ftp.FtpClient;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystem;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.ftp.FtpRandomAccessContent;
import org.apache.commons.vfs2.util.FileObjectUtils;
import org.apache.commons.vfs2.util.Messages;
import org.apache.commons.vfs2.util.MonitorInputStream;
import org.apache.commons.vfs2.util.MonitorOutputStream;
import org.apache.commons.vfs2.util.RandomAccessMode;

public class FtpFileObject
extends AbstractFileObject<FtpFileSystem> {
    private static final long DEFAULT_TIMESTAMP = 0L;
    private static final Map<String, FTPFile> EMPTY_FTP_FILE_MAP = Collections.unmodifiableMap(new TreeMap());
    private static final FTPFile UNKNOWN = new FTPFile();
    private static final Log log = LogFactory.getLog(FtpFileObject.class);
    private final String relPath;
    private volatile FTPFile fileInfo;
    private volatile Map<String, FTPFile> children;
    private volatile FileObject linkDestination;
    private final AtomicBoolean inRefresh = new AtomicBoolean();

    protected FtpFileObject(AbstractFileName name, FtpFileSystem fileSystem, FileName rootName) throws FileSystemException {
        super(name, fileSystem);
        String relPath = UriParser.decode(rootName.getRelativeName(name));
        this.relPath = ".".equals(relPath) ? null : relPath;
    }

    private FTPFile getChildFile(String name, boolean flush) throws IOException {
        if (flush && !this.inRefresh.get()) {
            this.children = null;
        }
        this.doGetChildren();
        return this.children != null ? this.children.get(name) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGetChildren() throws IOException {
        if (this.children != null) {
            return;
        }
        FtpClient client = ((FtpFileSystem)this.getAbstractFileSystem()).getClient();
        try {
            String path = this.fileInfo != null && this.fileInfo.isSymbolicLink() ? this.getFileSystem().getFileSystemManager().resolveName(this.getParent().getName(), this.fileInfo.getLink()).getPath() : this.relPath;
            FTPFile[] tmpChildren = client.listFiles(path);
            if (tmpChildren == null || tmpChildren.length == 0) {
                this.children = EMPTY_FTP_FILE_MAP;
            } else {
                this.children = new TreeMap<String, FTPFile>();
                for (int i = 0; i < tmpChildren.length; ++i) {
                    FTPFile child = tmpChildren[i];
                    if (child == null) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)Messages.getString("vfs.provider.ftp/invalid-directory-entry.debug", i, this.relPath));
                        continue;
                    }
                    if (".".equals(child.getName()) || "..".equals(child.getName())) continue;
                    this.children.put(child.getName(), child);
                }
            }
        }
        finally {
            ((FtpFileSystem)this.getAbstractFileSystem()).putClient(client);
        }
    }

    @Override
    protected void doAttach() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getInfo(boolean flush) throws IOException {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            FTPFile newFileInfo;
            FtpFileObject parent = (FtpFileObject)FileObjectUtils.getAbstractFileObject(this.getParent());
            if (parent != null) {
                newFileInfo = parent.getChildFile(UriParser.decode(this.getName().getBaseName()), flush);
            } else {
                newFileInfo = new FTPFile();
                newFileInfo.setType(1);
            }
            this.fileInfo = newFileInfo == null ? UNKNOWN : newFileInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() throws FileSystemException {
        if (this.inRefresh.compareAndSet(false, true)) {
            try {
                super.refresh();
                FileSystem fileSystem = this.getFileSystem();
                synchronized (fileSystem) {
                    this.fileInfo = null;
                }
            }
            finally {
                this.inRefresh.set(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDetach() {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            this.fileInfo = null;
            this.children = null;
        }
    }

    @Override
    protected void onChildrenChanged(FileName child, FileType newType) {
        if (this.children != null && newType.equals((Object)FileType.IMAGINARY)) {
            try {
                this.children.remove(UriParser.decode(child.getBaseName()));
            }
            catch (FileSystemException e) {
                throw new RuntimeException(e.getMessage());
            }
        } else {
            this.children = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onChange() throws IOException {
        this.children = null;
        if (this.getType().equals((Object)FileType.IMAGINARY)) {
            FileSystem fileSystem = this.getFileSystem();
            synchronized (fileSystem) {
                this.fileInfo = UNKNOWN;
            }
            return;
        }
        this.getInfo(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FileType doGetType() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            if (this.fileInfo == null) {
                this.getInfo(false);
            }
            if (this.fileInfo == UNKNOWN) {
                return FileType.IMAGINARY;
            }
            if (this.fileInfo.isDirectory()) {
                return FileType.FOLDER;
            }
            if (this.fileInfo.isFile()) {
                return FileType.FILE;
            }
            if (this.fileInfo.isSymbolicLink()) {
                FileObject linkDest = this.getLinkDestination();
                if (this.isCircular(linkDest)) {
                    return FileType.IMAGINARY;
                }
                return linkDest.getType();
            }
        }
        throw new FileSystemException("vfs.provider.ftp/get-type.error", (Object)this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject getLinkDestination() throws FileSystemException {
        if (this.linkDestination == null) {
            String path;
            FileSystem fileSystem = this.getFileSystem();
            synchronized (fileSystem) {
                path = this.fileInfo == null ? null : this.fileInfo.getLink();
            }
            FileName parent = this.getName().getParent();
            FileName relativeTo = parent == null ? this.getName() : parent;
            FileName linkDestinationName = this.getFileSystem().getFileSystemManager().resolveName(relativeTo, path);
            this.linkDestination = this.getFileSystem().resolveFile(linkDestinationName);
        }
        return this.linkDestination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FileObject[] doListChildrenResolved() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            if (this.fileInfo != null && this.fileInfo.isSymbolicLink()) {
                FileObject linkDest = this.getLinkDestination();
                if (this.isCircular(linkDest)) {
                    return null;
                }
                return linkDest.getChildren();
            }
        }
        return null;
    }

    @Override
    public FileObject[] getChildren() throws FileSystemException {
        try {
            if (this.doGetType() != FileType.FOLDER) {
                throw new FileNotFolderException(this.getName());
            }
        }
        catch (Exception ex) {
            throw new FileNotFolderException(this.getName(), (Throwable)ex);
        }
        try {
            this.inRefresh.set(true);
            FileObject[] fileObjectArray = super.getChildren();
            return fileObjectArray;
        }
        finally {
            this.inRefresh.set(false);
        }
    }

    @Override
    protected String[] doListChildren() throws Exception {
        this.doGetChildren();
        if (this.children == null) {
            return null;
        }
        String[] childNames = new String[this.children.size()];
        int childNum = -1;
        for (FTPFile child : this.children.values()) {
            childNames[++childNum] = child.getName();
        }
        return UriParser.encode(childNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDelete() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            if (this.fileInfo != null) {
                boolean ok;
                FtpClient ftpClient = ((FtpFileSystem)this.getAbstractFileSystem()).getClient();
                try {
                    ok = this.fileInfo.isDirectory() ? ftpClient.removeDirectory(this.relPath) : ftpClient.deleteFile(this.relPath);
                }
                finally {
                    ((FtpFileSystem)this.getAbstractFileSystem()).putClient(ftpClient);
                }
                if (!ok) {
                    throw new FileSystemException("vfs.provider.ftp/delete-file.error", (Object)this.getName());
                }
                this.fileInfo = null;
            }
            this.children = EMPTY_FTP_FILE_MAP;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRename(FileObject newFile) throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            boolean ok;
            FtpClient ftpClient = ((FtpFileSystem)this.getAbstractFileSystem()).getClient();
            try {
                String oldName = this.relPath;
                String newName = ((FtpFileObject)FileObjectUtils.getAbstractFileObject(newFile)).getRelPath();
                ok = ftpClient.rename(oldName, newName);
            }
            finally {
                ((FtpFileSystem)this.getAbstractFileSystem()).putClient(ftpClient);
            }
            if (!ok) {
                throw new FileSystemException("vfs.provider.ftp/rename-file.error", this.getName().toString(), newFile);
            }
            this.fileInfo = null;
            this.children = EMPTY_FTP_FILE_MAP;
        }
    }

    @Override
    protected void doCreateFolder() throws Exception {
        boolean ok;
        FtpClient client = ((FtpFileSystem)this.getAbstractFileSystem()).getClient();
        try {
            ok = client.makeDirectory(this.relPath);
        }
        finally {
            ((FtpFileSystem)this.getAbstractFileSystem()).putClient(client);
        }
        if (!ok) {
            throw new FileSystemException("vfs.provider.ftp/create-folder.error", (Object)this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long doGetContentSize() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            if (this.fileInfo == null) {
                return 0L;
            }
            if (this.fileInfo.isSymbolicLink()) {
                FileObject linkDest = this.getLinkDestination();
                if (this.isCircular(linkDest)) {
                    return this.fileInfo.getSize();
                }
                return linkDest.getContent().getSize();
            }
            return this.fileInfo.getSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long doGetLastModifiedTime() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            if (this.fileInfo == null) {
                return 0L;
            }
            if (this.fileInfo.isSymbolicLink()) {
                FileObject linkDest = this.getLinkDestination();
                if (this.isCircular(linkDest)) {
                    return this.getTimestamp();
                }
                return linkDest.getContent().getLastModifiedTime();
            }
            return this.getTimestamp();
        }
    }

    @Override
    protected InputStream doGetInputStream(int bufferSize) throws Exception {
        FtpClient client = ((FtpFileSystem)this.getAbstractFileSystem()).getClient();
        try {
            InputStream inputStream = client.retrieveFileStream(this.relPath, 0);
            if (inputStream == null) {
                throw new FileNotFoundException(this.getName().toString());
            }
            return new FtpInputStream(client, inputStream, bufferSize);
        }
        catch (Exception e) {
            ((FtpFileSystem)this.getAbstractFileSystem()).putClient(client);
            throw e;
        }
    }

    @Override
    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode mode) throws Exception {
        return new FtpRandomAccessContent(this, mode);
    }

    @Override
    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        FtpClient client = ((FtpFileSystem)this.getAbstractFileSystem()).getClient();
        try {
            OutputStream out = null;
            out = bAppend ? client.appendFileStream(this.relPath) : client.storeFileStream(this.relPath);
            FileSystemException.requireNonNull(out, "vfs.provider.ftp/output-error.debug", this.getName(), client.getReplyString());
            return new FtpOutputStream(client, out);
        }
        catch (Exception e) {
            ((FtpFileSystem)this.getAbstractFileSystem()).putClient(client);
            throw e;
        }
    }

    String getRelPath() {
        return this.relPath;
    }

    private long getTimestamp() {
        Calendar timestamp = this.fileInfo != null ? this.fileInfo.getTimestamp() : null;
        return timestamp == null ? 0L : timestamp.getTime().getTime();
    }

    private boolean isCircular(FileObject linkDest) throws FileSystemException {
        return linkDest.getName().getPathDecoded().equals(this.getName().getPathDecoded());
    }

    FtpInputStream getInputStream(long filePointer) throws IOException {
        FtpClient client = ((FtpFileSystem)this.getAbstractFileSystem()).getClient();
        try {
            InputStream instr = client.retrieveFileStream(this.relPath, filePointer);
            FileSystemException.requireNonNull(instr, "vfs.provider.ftp/input-error.debug", this.getName(), client.getReplyString());
            return new FtpInputStream(client, instr);
        }
        catch (IOException e) {
            ((FtpFileSystem)this.getAbstractFileSystem()).putClient(client);
            throw e;
        }
    }

    private class FtpOutputStream
    extends MonitorOutputStream {
        private final FtpClient client;

        public FtpOutputStream(FtpClient client, OutputStream outstr) {
            super(outstr);
            this.client = client;
        }

        @Override
        protected void onClose() throws IOException {
            boolean ok;
            try {
                ok = this.client.completePendingCommand();
            }
            finally {
                ((FtpFileSystem)FtpFileObject.this.getAbstractFileSystem()).putClient(this.client);
            }
            if (!ok) {
                throw new FileSystemException("vfs.provider.ftp/finish-put.error", (Object)FtpFileObject.this.getName());
            }
        }
    }

    class FtpInputStream
    extends MonitorInputStream {
        private final FtpClient client;

        public FtpInputStream(FtpClient client, InputStream in) {
            super(in);
            this.client = client;
        }

        public FtpInputStream(FtpClient client, InputStream in, int bufferSize) {
            super(in, bufferSize);
            this.client = client;
        }

        void abort() throws IOException {
            this.client.abort();
            this.close();
        }

        @Override
        protected void onClose() throws IOException {
            boolean ok;
            try {
                ok = this.client.completePendingCommand() || this.isTransferAbortedOkReplyCode();
            }
            finally {
                ((FtpFileSystem)FtpFileObject.this.getAbstractFileSystem()).putClient(this.client);
            }
            if (!ok) {
                throw new FileSystemException("vfs.provider.ftp/finish-get.error", (Object)FtpFileObject.this.getName());
            }
        }

        private boolean isTransferAbortedOkReplyCode() throws IOException {
            List<Integer> transferAbortedOkReplyCodes = FtpFileSystemConfigBuilder.getInstance().getTransferAbortedOkReplyCodes(((FtpFileSystem)FtpFileObject.this.getAbstractFileSystem()).getFileSystemOptions());
            return transferAbortedOkReplyCodes != null && transferAbortedOkReplyCodes.contains(this.client.getReplyCode());
        }
    }
}

