/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.api.repository2.unified.data.simple;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.pentaho.platform.api.repository2.unified.IRepositoryFileData;

public class SimpleRepositoryFileData
implements IRepositoryFileData {
    private static final long serialVersionUID = -1571991472814251230L;
    private InputStream stream;
    private String encoding;
    private String mimeType;

    public SimpleRepositoryFileData(InputStream stream, String encoding, String mimeType) {
        this.stream = stream;
        this.encoding = encoding;
        this.mimeType = mimeType;
    }

    @Deprecated
    public InputStream getStream() {
        return this.stream;
    }

    public InputStream getInputStream() {
        return this.stream;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public long getDataSize() {
        try {
            return this.stream.available();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public String toString() {
        int MAX_EXCERPT_LENGTH = 20;
        StringBuilder buf = new StringBuilder();
        buf.append("SimpleRepositoryFileData[");
        if (this.stream.markSupported()) {
            this.stream.mark(Integer.MAX_VALUE);
            buf.append("stream excerpt=");
            if (StringUtils.isNotBlank((String)this.encoding)) {
                String text = null;
                try {
                    text = SimpleRepositoryFileData.toString(this.stream, this.encoding);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                buf.append(this.head(text, 20));
                buf.append(",");
                buf.append("encoding=");
                buf.append(this.encoding);
            } else {
                byte[] bytes = null;
                try {
                    bytes = SimpleRepositoryFileData.toByteArray(this.stream);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                buf.append(this.head(bytes, 20));
            }
            try {
                this.stream.reset();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        buf.append("stream=<unable to show>");
        buf.append(",");
        buf.append("mimeType=");
        buf.append(this.mimeType);
        buf.append("]");
        return buf.toString();
    }

    private String head(String str, int count) {
        if (str.length() > count) {
            return str.substring(0, count) + "...";
        }
        return str;
    }

    private String head(byte[] bytes, int count) {
        if (bytes.length > count) {
            StringBuilder buf = new StringBuilder();
            buf.append("[");
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(bytes[i]);
            }
            buf.append("...");
            buf.append("]");
            return buf.toString();
        }
        return Arrays.toString(bytes);
    }

    private static String toString(InputStream input, String encoding) throws IOException {
        int DEFAULT_BUFFER_SIZE = 4096;
        StringWriter sw = new StringWriter();
        InputStreamReader in = new InputStreamReader(input, encoding);
        char[] buffer = new char[4096];
        int n = 0;
        while (-1 != (n = in.read(buffer))) {
            sw.write(buffer, 0, n);
        }
        return sw.toString();
    }

    private static byte[] toByteArray(InputStream input) throws IOException {
        int DEFAULT_BUFFER_SIZE = 4096;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toByteArray();
    }
}

