/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.enc;

import com.sun.xml.security.core.xenc.ReferenceList;
import com.sun.xml.security.core.xenc.ReferenceType;
import com.sun.xml.ws.security.opt.api.EncryptedKey;
import com.sun.xml.ws.security.opt.api.SecurityElement;
import com.sun.xml.ws.security.opt.api.keyinfo.BuilderResult;
import com.sun.xml.ws.security.opt.crypto.dsig.keyinfo.KeyInfo;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.enc.TokenProcessor;
import com.sun.xml.ws.security.opt.impl.message.ETHandler;
import com.sun.xml.ws.security.opt.impl.util.NamespaceContextEx;
import com.sun.xml.ws.security.opt.impl.util.WSSElementFactory;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.DerivedTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.EncryptionPolicy;
import com.sun.xml.wss.impl.policy.mls.EncryptionTarget;
import com.sun.xml.wss.impl.policy.mls.SymmetricKeyBinding;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import com.sun.xml.wss.logging.impl.opt.crypto.LogStringsMessages;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;

public class EncryptionProcessor {
    private static byte[] crlf = null;
    private static final Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.opt.crypto", "com.sun.xml.wss.logging.impl.opt.crypto.LogStrings");

    public void process(JAXBFilterProcessingContext context) throws XWSSecurityException {
        DerivedTokenKeyBinding dtk;
        WSSPolicy originalKeyBinding;
        boolean ekRefList = false;
        Object referenceType = null;
        Object x509TokenId = null;
        WSSElementFactory elementFactory = new WSSElementFactory(context.getSOAPVersion());
        Object _x509Cert = null;
        Object keyInfoStrategy = null;
        Object symmetricKeyName = null;
        Object certificateBinding = null;
        ((NamespaceContextEx)context.getNamespaceContext()).addEncryptionNS();
        ((NamespaceContextEx)context.getNamespaceContext()).addSignatureNS();
        ReferenceList dataRefList = null;
        Object ekt = null;
        WSSPolicy wssPolicy = (WSSPolicy)context.getSecurityPolicy();
        EncryptionPolicy.FeatureBinding featureBinding = (EncryptionPolicy.FeatureBinding)wssPolicy.getFeatureBinding();
        WSSPolicy keyBinding = (WSSPolicy)wssPolicy.getKeyBinding();
        EncryptedKey ek = null;
        KeyInfo edKeyInfo = null;
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, LogStringsMessages.WSS_1952_ENCRYPTION_KEYBINDING_VALUE(keyBinding));
        }
        if (PolicyTypeUtil.derivedTokenKeyBinding(keyBinding) && PolicyTypeUtil.x509CertificateBinding(originalKeyBinding = (dtk = (DerivedTokenKeyBinding)keyBinding.clone()).getOriginalKeyBinding())) {
            AuthenticationTokenPolicy.X509CertificateBinding ckBindingClone = (AuthenticationTokenPolicy.X509CertificateBinding)originalKeyBinding.clone();
            SymmetricKeyBinding skb = new SymmetricKeyBinding();
            skb.setKeyBinding(ckBindingClone);
            dtk.setOriginalKeyBinding(skb);
            EncryptionPolicy ep = (EncryptionPolicy)wssPolicy.clone();
            ep.setKeyBinding(dtk);
            context.setSecurityPolicy(ep);
            wssPolicy = ep;
        }
        TokenProcessor tp = new TokenProcessor((EncryptionPolicy)wssPolicy, context);
        BuilderResult tokenInfo = tp.process();
        Key dataEncKey = null;
        Object dkEncKey = null;
        dataEncKey = tokenInfo.getDataProtectionKey();
        ek = tokenInfo.getEncryptedKey();
        ArrayList targets = featureBinding.getTargetBindings();
        Iterator targetItr = targets.iterator();
        ETHandler edBuilder = new ETHandler(context.getSOAPVersion());
        EncryptionPolicy.FeatureBinding binding = (EncryptionPolicy.FeatureBinding)wssPolicy.getFeatureBinding();
        dataRefList = new ReferenceList();
        if (ek == null || binding.getUseStandAloneRefList()) {
            edKeyInfo = tokenInfo.getKeyInfo();
        }
        boolean refAdded = false;
        while (targetItr.hasNext()) {
            EncryptionTarget target = (EncryptionTarget)targetItr.next();
            boolean contentOnly = target.getContentOnly();
            List edList = edBuilder.buildEDList((EncryptionPolicy)wssPolicy, target, context, dataEncKey, edKeyInfo);
            for (int i = 0; i < edList.size(); ++i) {
                JAXBElement<ReferenceType> rt = elementFactory.createDataReference((SecurityElement)edList.get(i));
                dataRefList.getDataReferenceOrKeyReference().add(rt);
                refAdded = true;
            }
        }
        if (refAdded) {
            if (ek == null || binding.getUseStandAloneRefList()) {
                context.getSecurityHeader().add(elementFactory.createGSHeaderElement(dataRefList));
            } else {
                ek.setReferenceList(dataRefList);
            }
        }
    }

    private void checkBSP5607(String elemName, String uri, boolean contentOnly) throws XWSSecurityException {
        if (!contentOnly && ("http://schemas.xmlsoap.org/soap/envelope/".equalsIgnoreCase(uri) || "http://www.w3.org/2003/05/soap-envelope".equalsIgnoreCase(uri)) && ("Header".equalsIgnoreCase(elemName) || "Envelope".equalsIgnoreCase(elemName) || "Body".equalsIgnoreCase(elemName))) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1918_ILLEGAL_ENCRYPTION_TARGET(uri, elemName));
            throw new XWSSecurityException("Encryption of SOAP " + elemName + " is not allowed");
        }
    }

    static {
        try {
            crlf = "\r\n".getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException ue) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1917_CRLF_INIT_FAILED(), ue);
        }
    }
}

