/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.validation.client.impl;

import java.io.Serializable;
import javax.validation.Path;

final class NodeImpl
implements Path.Node,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final Path.Node ROOT_NODE = new NodeImpl(null, null, null, false);
    private final boolean isInIterable;
    private final String name;
    private final Integer index;
    private final Object key;

    static Path.Node createIndexedNode(String name, Integer index) {
        return new NodeImpl(name, null, index, true);
    }

    static Path.Node createIterableNode(String name) {
        return new NodeImpl(name, null, null, true);
    }

    static Path.Node createKeyedNode(String name, Object key) {
        return new NodeImpl(name, key, null, true);
    }

    static Path.Node createNode(String name) {
        return new NodeImpl(name, null, null, false);
    }

    private NodeImpl(String name, Object key, Integer index, boolean iterable) {
        this.name = name;
        this.key = key;
        this.index = index;
        this.isInIterable = iterable;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NodeImpl)) {
            return false;
        }
        NodeImpl that = (NodeImpl)obj;
        return (this.name == null ? that.name == null : this.name.equals(that.name)) && (this.index == null ? that.index == null : this.index.equals(that.index)) && (this.key == null ? that.key == null : this.key.equals(that.key)) && this.isInIterable == that.isInIterable;
    }

    public Integer getIndex() {
        return this.index;
    }

    public Object getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.index == null ? 0 : this.index.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.isInIterable ? 0 : 1);
        return result;
    }

    public boolean isInIterable() {
        return this.isInIterable;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.name != null) {
            sb.append(this.name);
        }
        if (this.isInIterable()) {
            sb.append('[');
            if (this.key != null) {
                sb.append(this.key);
            } else if (this.index != null) {
                sb.append(this.index);
            }
            sb.append(']');
        }
        return sb.toString();
    }
}

