/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.attributeparsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.uibinder.attributeparsers.AttributeParser;
import com.google.gwt.uibinder.attributeparsers.FieldReferenceConverter;
import com.google.gwt.uibinder.rebind.FieldReference;
import com.google.gwt.uibinder.rebind.MortalLogger;
import com.google.gwt.uibinder.rebind.XMLElement;

class StrictAttributeParser
implements AttributeParser {
    private final FieldReferenceConverter converter;
    protected final MortalLogger logger;
    private final JType[] types;

    StrictAttributeParser(FieldReferenceConverter converter, MortalLogger logger, JType ... types) {
        this.converter = converter;
        this.logger = logger;
        this.types = types;
    }

    @Override
    public String parse(XMLElement source, String value) throws UnableToCompleteException {
        if ("".equals(value.trim())) {
            this.logger.die(source, "Cannot use empty value as type %s", new Object[]{FieldReference.renderTypesList((JType[])this.types)});
        }
        try {
            return this.converter.convert(source, value, new FieldReferenceDelegate(this.types));
        }
        catch (FieldReferenceConverter.IllegalFieldReferenceException e) {
            this.logger.die(source, "Cannot parse value: \"%s\" as type %s", new Object[]{value, FieldReference.renderTypesList((JType[])this.types)});
            return null;
        }
    }

    static class FieldReferenceDelegate
    implements FieldReferenceConverter.Delegate {
        private boolean sawReference = false;
        private final JType[] types;

        FieldReferenceDelegate(JType ... types) {
            this.types = types;
        }

        @Override
        public JType[] getTypes() {
            return this.types;
        }

        @Override
        public String handleFragment(String fragment) throws FieldReferenceConverter.IllegalFieldReferenceException {
            if (fragment.length() > 0) {
                throw new FieldReferenceConverter.IllegalFieldReferenceException();
            }
            return fragment;
        }

        @Override
        public String handleReference(String reference) throws FieldReferenceConverter.IllegalFieldReferenceException {
            this.assertOnly();
            this.sawReference = true;
            return reference;
        }

        private void assertOnly() {
            if (this.sawReference) {
                throw new FieldReferenceConverter.IllegalFieldReferenceException();
            }
        }
    }
}

