/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.client.testing;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import java.util.ArrayList;
import java.util.List;

public class StubScheduler
extends Scheduler {
    private final List<Scheduler.RepeatingCommand> repeatingCommands = new ArrayList<Scheduler.RepeatingCommand>();
    private final List<Scheduler.ScheduledCommand> scheduledCommands = new ArrayList<Scheduler.ScheduledCommand>();

    public List<Scheduler.RepeatingCommand> getRepeatingCommands() {
        return this.repeatingCommands;
    }

    public boolean executeCommands() {
        boolean repeatingRemaining = this.executeRepeatingCommands();
        boolean scheduledRemaining = this.executeScheduledCommands();
        return repeatingRemaining || scheduledRemaining;
    }

    public boolean executeRepeatingCommands() {
        ArrayList<Scheduler.RepeatingCommand> commands = new ArrayList<Scheduler.RepeatingCommand>(this.repeatingCommands);
        this.repeatingCommands.clear();
        for (Scheduler.RepeatingCommand command : commands) {
            boolean reschedule;
            try {
                reschedule = command.execute();
            }
            catch (Throwable e) {
                reschedule = false;
                GWT.reportUncaughtException(e);
            }
            if (!reschedule) continue;
            this.repeatingCommands.add(command);
        }
        return !this.repeatingCommands.isEmpty();
    }

    public List<Scheduler.ScheduledCommand> getScheduledCommands() {
        return this.scheduledCommands;
    }

    public boolean executeScheduledCommands() {
        ArrayList<Scheduler.ScheduledCommand> commands = new ArrayList<Scheduler.ScheduledCommand>(this.scheduledCommands);
        this.scheduledCommands.clear();
        for (Scheduler.ScheduledCommand command : commands) {
            try {
                command.execute();
            }
            catch (Throwable e) {
                GWT.reportUncaughtException(e);
            }
        }
        return !this.scheduledCommands.isEmpty();
    }

    @Override
    public void scheduleDeferred(Scheduler.ScheduledCommand cmd) {
        this.scheduledCommands.add(cmd);
    }

    @Override
    public void scheduleEntry(Scheduler.RepeatingCommand cmd) {
        this.repeatingCommands.add(cmd);
    }

    @Override
    public void scheduleEntry(Scheduler.ScheduledCommand cmd) {
        this.scheduledCommands.add(cmd);
    }

    @Override
    public void scheduleFinally(Scheduler.RepeatingCommand cmd) {
        this.repeatingCommands.add(cmd);
    }

    @Override
    public void scheduleFinally(Scheduler.ScheduledCommand cmd) {
        this.scheduledCommands.add(cmd);
    }

    @Override
    public void scheduleFixedDelay(Scheduler.RepeatingCommand cmd, int delayMs) {
        this.repeatingCommands.add(cmd);
    }

    @Override
    public void scheduleFixedPeriod(Scheduler.RepeatingCommand cmd, int delayMs) {
        this.repeatingCommands.add(cmd);
    }

    @Override
    public void scheduleIncremental(Scheduler.RepeatingCommand cmd) {
        this.repeatingCommands.add(cmd);
    }
}

