/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.legacy.charts.propertyeditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pentaho.plugin.jfreereport.reportcharts.ColorHelper;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.colorchooser.ColorChooserPane;

public class ColorPropertyEditor
implements PropertyEditor {
    private ColorChooserPane colorChooser;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Color value;

    @Override
    public void setValue(Object value) {
        Color oldValue = this.value;
        if (value instanceof Color) {
            if (this.colorChooser != null) {
                this.colorChooser.setColor((Color)value);
            }
            this.value = (Color)value;
        } else if (value instanceof String) {
            if (!StringUtils.isEmpty((String)((String)value))) {
                this.setAsText(value.toString());
            } else {
                this.value = null;
            }
        } else {
            if (this.colorChooser != null) {
                this.colorChooser.setColor(null);
            }
            this.value = null;
        }
        this.propertyChangeSupport.firePropertyChange(null, oldValue, this.value);
    }

    @Override
    public Object getValue() {
        return this.getAsText();
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        if (this.value == null) {
            return;
        }
        Graphics graphics = gfx.create();
        graphics.setColor(this.value);
        graphics.fillRect(box.x, box.y, box.width, box.height);
        graphics.setColor(Color.BLACK);
        graphics.drawRect(box.x, box.y, box.width, box.height);
        graphics.dispose();
    }

    @Override
    public String getJavaInitializationString() {
        return null;
    }

    @Override
    public String getAsText() {
        return ColorHelper.lookupName(this.value);
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (text == null) {
            this.setValue(null);
        } else {
            try {
                this.setValue(Color.decode(text));
            }
            catch (NumberFormatException ex) {
                this.setValue(ColorHelper.lookupColor(text));
            }
        }
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public Component getCustomEditor() {
        if (this.colorChooser == null) {
            this.colorChooser = new ColorChooserPane();
            this.colorChooser.setColor(this.value);
            this.colorChooser.getModel().addChangeListener((ChangeListener)new ColorSelectionChangeListener());
        }
        return this.colorChooser;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    private class ColorSelectionChangeListener
    implements ChangeListener {
        private ColorSelectionChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ColorPropertyEditor.this.setValue(ColorPropertyEditor.this.colorChooser.getModel().getSelectedColor());
        }
    }
}

