/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.plugin.jfreereport.reportcharts;

import java.awt.Color;
import java.awt.Paint;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.ThermometerPlot;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.ValueDataset;
import org.pentaho.plugin.jfreereport.reportcharts.AbstractChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.ThermometerUnit;

public class ThermometerChartExpression
extends AbstractChartExpression {
    private int bulbRadius = ThermometerPlotDefaults.getDefaultBulbRadius();
    private int columnRadius = ThermometerPlotDefaults.getDefaultColumnRadius();
    private ThermometerUnit thermometerUnits = null;
    private int criticalRangeHigh = 100;
    private int criticalRangeLow = 75;
    private int warningRangeHigh = 75;
    private int warningRangeLow = 30;
    private int normalRangeHigh = 30;
    private int normalRangeLow = 0;
    private Color mercuryPaint;
    private Color thermometerPaint;
    private Color warningRangeColor;
    private Color criticalRangeColor;
    private Color normalRangeColor;

    public Color getWarningRangeColor() {
        return this.warningRangeColor;
    }

    public void setWarningRangeColor(Color warningRangeColor) {
        this.warningRangeColor = warningRangeColor;
    }

    public Color getCriticalRangeColor() {
        return this.criticalRangeColor;
    }

    public void setCriticalRangeColor(Color criticalRangeColor) {
        this.criticalRangeColor = criticalRangeColor;
    }

    public Color getNormalRangeColor() {
        return this.normalRangeColor;
    }

    public void setNormalRangeColor(Color normalRangeColor) {
        this.normalRangeColor = normalRangeColor;
    }

    public int getBulbRadius() {
        return this.bulbRadius;
    }

    public void setBulbRadius(int bulbRadius) {
        this.bulbRadius = bulbRadius;
    }

    public int getColumnRadius() {
        return this.columnRadius;
    }

    public void setColumnRadius(int columnRadius) {
        this.columnRadius = columnRadius;
    }

    public ThermometerUnit getThermometerUnits() {
        return this.thermometerUnits;
    }

    public void setThermometerUnits(ThermometerUnit thermometerUnits) {
        this.thermometerUnits = thermometerUnits;
    }

    public int getCriticalRangeHigh() {
        return this.criticalRangeHigh;
    }

    public void setCriticalRangeHigh(int criticalRangeHigh) {
        this.criticalRangeHigh = criticalRangeHigh;
    }

    public int getCriticalRangeLow() {
        return this.criticalRangeLow;
    }

    public void setCriticalRangeLow(int criticalRangeLow) {
        this.criticalRangeLow = criticalRangeLow;
    }

    public int getWarningRangeHigh() {
        return this.warningRangeHigh;
    }

    public void setWarningRangeHigh(int warningRangeHigh) {
        this.warningRangeHigh = warningRangeHigh;
    }

    public int getWarningRangeLow() {
        return this.warningRangeLow;
    }

    public void setWarningRangeLow(int warningRangeLow) {
        this.warningRangeLow = warningRangeLow;
    }

    public int getNormalRangeHigh() {
        return this.normalRangeHigh;
    }

    public void setNormalRangeHigh(int normalRangeHigh) {
        this.normalRangeHigh = normalRangeHigh;
    }

    public int getNormalRangeLow() {
        return this.normalRangeLow;
    }

    public void setNormalRangeLow(int normalRangeLow) {
        this.normalRangeLow = normalRangeLow;
    }

    public Color getMercuryPaint() {
        return this.mercuryPaint;
    }

    public void setMercuryPaint(Color mercuryPaint) {
        this.mercuryPaint = mercuryPaint;
    }

    public Color getThermometerPaint() {
        return this.thermometerPaint;
    }

    public void setThermometerPaint(Color thermometerPaint) {
        this.thermometerPaint = thermometerPaint;
    }

    @Override
    protected JFreeChart computeChart(Dataset dataset) {
        ValueDataset thermometerDataset = null;
        if (dataset instanceof ValueDataset) {
            thermometerDataset = (ValueDataset)dataset;
        }
        ThermometerPlot plot = new ThermometerPlot(thermometerDataset);
        return new JFreeChart(this.computeTitle(), JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
    }

    @Override
    protected void configureChart(JFreeChart chart) {
        super.configureChart(chart);
        Plot plot = chart.getPlot();
        ThermometerPlot thermometerPlot = (ThermometerPlot)plot;
        if (!this.isShowBorder() || !this.isChartSectionOutline()) {
            chart.setBorderVisible(false);
            thermometerPlot.setOutlineVisible(false);
        }
        if (this.getThermometerUnits() != null) {
            thermometerPlot.setUnits(this.getThermometerUnits().getUnitConstant());
        }
        thermometerPlot.setLowerBound((double)Math.min(this.getCriticalRangeLow(), Math.min(this.getNormalRangeLow(), this.getWarningRangeLow())));
        thermometerPlot.setUpperBound((double)Math.max(this.getCriticalRangeHigh(), Math.max(this.getNormalRangeHigh(), this.getWarningRangeHigh())));
        thermometerPlot.setBulbRadius(this.getBulbRadius());
        thermometerPlot.setColumnRadius(this.getColumnRadius());
        thermometerPlot.setSubrange(2, (double)this.getCriticalRangeLow(), (double)this.getCriticalRangeHigh());
        thermometerPlot.setSubrange(1, (double)this.getWarningRangeLow(), (double)this.getWarningRangeHigh());
        thermometerPlot.setSubrange(0, (double)this.getNormalRangeLow(), (double)this.getNormalRangeHigh());
        if (this.getMercuryPaint() != null) {
            thermometerPlot.setMercuryPaint((Paint)this.getMercuryPaint());
        }
        if (this.getThermometerPaint() != null) {
            thermometerPlot.setThermometerPaint((Paint)this.getThermometerPaint());
        }
        if (this.getCriticalRangeColor() != null) {
            thermometerPlot.setSubrangePaint(2, (Paint)this.getCriticalRangeColor());
        }
        if (this.getWarningRangeColor() != null) {
            thermometerPlot.setSubrangePaint(1, (Paint)this.getWarningRangeColor());
        }
        if (this.getNormalRangeColor() != null) {
            thermometerPlot.setSubrangePaint(0, (Paint)this.getNormalRangeColor());
        }
    }

    private static class ThermometerPlotDefaults
    extends ThermometerPlot {
        private ThermometerPlotDefaults() {
        }

        public static int getDefaultBulbRadius() {
            return 40;
        }

        public static int getDefaultColumnRadius() {
            return 20;
        }
    }
}

