/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.impl;

import ca.uhn.hl7v2.validation.PrimitiveTypeRule;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexPrimitiveRule
implements PrimitiveTypeRule {
    private final Pattern myPattern;
    private final String mySectionReference;

    public RegexPrimitiveRule(String theRegex, String theSectionReference) {
        this.myPattern = Pattern.compile(theRegex);
        this.mySectionReference = theSectionReference;
    }

    public boolean test(String value) {
        if (value == null || value.equals("\"\"") || value.equals("")) {
            return true;
        }
        Matcher matcher = this.myPattern.matcher(value);
        return matcher.matches();
    }

    public String getDescription() {
        return "Matches the regular expression " + this.myPattern.pattern();
    }

    public String getSectionReference() {
        return this.mySectionReference;
    }

    public String correct(String value) {
        return value;
    }
}

