/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.util;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.GenericComposite;
import ca.uhn.hl7v2.model.GenericPrimitive;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.Varies;
import ca.uhn.hl7v2.util.SegmentFinder;
import ca.uhn.log.HapiLog;
import ca.uhn.log.HapiLogFactory;
import java.util.StringTokenizer;

public class Terser {
    private SegmentFinder finder;
    private static HapiLog log = HapiLogFactory.getHapiLog(Terser.class);

    public Terser(Message message) {
        this.finder = new SegmentFinder(message);
    }

    public static String get(Segment segment, int field, int rep, int component, int subcomponent) throws HL7Exception {
        Primitive prim = Terser.getPrimitive(segment, field, rep, component, subcomponent);
        return prim.getValue();
    }

    public static void set(Segment segment, int field, int rep, int component, int subcomponent, String value) throws HL7Exception {
        Primitive prim = Terser.getPrimitive(segment, field, rep, component, subcomponent);
        prim.setValue(value);
    }

    private static Primitive getPrimitive(Segment segment, int field, int rep, int component, int subcomponent) throws HL7Exception {
        Type type = segment.getField(field, rep);
        return Terser.getPrimitive(type, component, subcomponent);
    }

    public static Primitive getPrimitive(Type type, int component, int subcomponent) {
        Type comp = Terser.getComponent(type, component);
        Type sub = Terser.getComponent(comp, subcomponent);
        return Terser.getPrimitive(sub);
    }

    private static Primitive getPrimitive(Type type) {
        Primitive p = null;
        if (Varies.class.isAssignableFrom(type.getClass())) {
            p = Terser.getPrimitive(((Varies)type).getData());
        } else if (Composite.class.isAssignableFrom(type.getClass())) {
            try {
                p = Terser.getPrimitive(((Composite)type).getComponent(0));
            }
            catch (HL7Exception e) {
                throw new Error("Internal error: HL7Exception thrown on Composite.getComponent(0).");
            }
        } else if (type instanceof Primitive) {
            p = (Primitive)type;
        }
        return p;
    }

    private static Type getComponent(Type type, int comp) {
        Type ret = null;
        if (Varies.class.isAssignableFrom(type.getClass())) {
            Varies v = (Varies)type;
            try {
                if (comp > 1 && GenericPrimitive.class.isAssignableFrom(v.getData().getClass())) {
                    v.setData(new GenericComposite(v.getMessage()));
                }
            }
            catch (DataTypeException de) {
                String message = "Unexpected exception copying data to generic composite: " + de.getMessage();
                log.error(message, de);
                throw new Error(message);
            }
            ret = Terser.getComponent(v.getData(), comp);
        } else if (Primitive.class.isAssignableFrom(type.getClass()) && comp == 1) {
            ret = type;
        } else if (GenericComposite.class.isAssignableFrom(type.getClass()) || Composite.class.isAssignableFrom(type.getClass()) && comp <= Terser.numStandardComponents(type)) {
            try {
                ret = ((Composite)type).getComponent(comp - 1);
            }
            catch (Exception e) {
                throw new Error("Internal error: HL7Exception thrown on getComponent(x) where x < # standard components.", e);
            }
        } else {
            ret = type.getExtraComponents().getComponent(comp - Terser.numStandardComponents(type) - 1);
        }
        return ret;
    }

    public String get(String spec) throws HL7Exception {
        StringTokenizer tok = new StringTokenizer(spec, "-", false);
        Segment segment = this.getSegment(tok.nextToken());
        int[] ind = Terser.getIndices(spec);
        return Terser.get(segment, ind[0], ind[1], ind[2], ind[3]);
    }

    public Segment getSegment(String segSpec) throws HL7Exception {
        Segment seg = null;
        if (segSpec.substring(0, 1).equals("/")) {
            this.getFinder().reset();
        }
        StringTokenizer tok = new StringTokenizer(segSpec, "/", false);
        SegmentFinder finder = this.getFinder();
        while (tok.hasMoreTokens()) {
            String pathSpec = tok.nextToken();
            PathSpec ps = this.parsePathSpec(pathSpec);
            ps.isGroup = tok.hasMoreTokens();
            if (ps.isGroup) {
                Group g = null;
                g = ps.find ? finder.findGroup(ps.pattern, ps.rep) : finder.getGroup(ps.pattern, ps.rep);
                finder = new SegmentFinder(g);
                continue;
            }
            seg = ps.find ? finder.findSegment(ps.pattern, ps.rep) : finder.getSegment(ps.pattern, ps.rep);
        }
        return seg;
    }

    private PathSpec parsePathSpec(String spec) throws HL7Exception {
        PathSpec ps = new PathSpec();
        if (spec.startsWith(".")) {
            ps.find = true;
            spec = spec.substring(1);
        } else {
            ps.find = false;
        }
        if (spec.length() == 0) {
            throw new HL7Exception("Invalid path (some path element is either empty or contains only a dot)");
        }
        StringTokenizer tok = new StringTokenizer(spec, "()", false);
        ps.pattern = tok.nextToken();
        if (tok.hasMoreTokens()) {
            String repString = tok.nextToken();
            try {
                ps.rep = Integer.parseInt(repString);
            }
            catch (NumberFormatException e) {
                throw new HL7Exception(String.valueOf(repString) + " is not a valid rep #", 207);
            }
        } else {
            ps.rep = 0;
        }
        return ps;
    }

    public static int[] getIndices(String spec) throws HL7Exception {
        StringTokenizer tok = new StringTokenizer(spec, "-", false);
        tok.nextToken();
        if (!tok.hasMoreTokens()) {
            throw new HL7Exception("Must specify field in spec " + spec, 207);
        }
        int[] ret = null;
        try {
            StringTokenizer fieldSpec = new StringTokenizer(tok.nextToken(), "()", false);
            int fieldNum = Integer.parseInt(fieldSpec.nextToken());
            int fieldRep = 0;
            if (fieldSpec.hasMoreTokens()) {
                fieldRep = Integer.parseInt(fieldSpec.nextToken());
            }
            int component = 1;
            if (tok.hasMoreTokens()) {
                component = Integer.parseInt(tok.nextToken());
            }
            int subcomponent = 1;
            if (tok.hasMoreTokens()) {
                subcomponent = Integer.parseInt(tok.nextToken());
            }
            int[] result = new int[]{fieldNum, fieldRep, component, subcomponent};
            ret = result;
        }
        catch (NumberFormatException e) {
            throw new HL7Exception("Invalid integer in spec " + spec, 207);
        }
        return ret;
    }

    public void set(String spec, String value) throws HL7Exception {
        StringTokenizer tok = new StringTokenizer(spec, "-", false);
        Segment segment = this.getSegment(tok.nextToken());
        int[] ind = Terser.getIndices(spec);
        if (log.isDebugEnabled()) {
            log.debug("Setting " + spec + " seg: " + segment.getName() + " ind: " + ind[0] + " " + ind[1] + " " + ind[2] + " " + ind[3]);
        }
        Terser.set(segment, ind[0], ind[1], ind[2], ind[3], value);
    }

    public static int numSubComponents(Type type, int component) {
        int n = -1;
        if (component == 1 && Primitive.class.isAssignableFrom(type.getClass())) {
            n = 1;
        } else {
            Type comp = Terser.getComponent(type, component);
            n = Terser.numComponents(comp);
        }
        return n;
    }

    public static int numComponents(Type type) {
        if (Varies.class.isAssignableFrom(type.getClass())) {
            return Terser.numComponents(((Varies)type).getData());
        }
        return Terser.numStandardComponents(type) + type.getExtraComponents().numComponents();
    }

    private static int numStandardComponents(Type t) {
        int n = 0;
        n = Varies.class.isAssignableFrom(t.getClass()) ? Terser.numStandardComponents(((Varies)t).getData()) : (Composite.class.isAssignableFrom(t.getClass()) ? ((Composite)t).getComponents().length : 1);
        return n;
    }

    public SegmentFinder getFinder() {
        return this.finder;
    }

    private class PathSpec {
        public String pattern;
        public boolean isGroup;
        public boolean find;
        public int rep;

        private PathSpec() {
        }
    }
}

