/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.primitive;

import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.DataTypeUtil;
import ca.uhn.log.HapiLog;
import ca.uhn.log.HapiLogFactory;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class CommonDT {
    private static final HapiLog log = HapiLogFactory.getHapiLog(CommonDT.class);
    private String value;
    private int year;
    private int month;
    private int day;

    public CommonDT() {
        this.value = null;
        this.year = 0;
        this.month = 0;
        this.day = 0;
    }

    public CommonDT(String val) throws DataTypeException {
        this.setValue(val);
    }

    public void setValue(Calendar theCalendar) throws DataTypeException {
        int yr = theCalendar.get(1);
        int mnth = theCalendar.get(2) + 1;
        int dy = theCalendar.get(5);
        this.setYearMonthDayPrecision(yr, mnth, dy);
    }

    public void setValue(Date theDate) throws DataTypeException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(theDate);
        this.setValue(calendar);
    }

    public Calendar getValueAsCalendar() {
        Calendar retVal = Calendar.getInstance();
        retVal.set(5, this.getDay());
        retVal.set(2, this.getMonth() - 1);
        retVal.set(1, this.getYear());
        retVal.set(11, 0);
        retVal.set(12, 0);
        retVal.set(13, 0);
        retVal.set(14, 0);
        return retVal;
    }

    public Date getValueAsDate() {
        return this.getValueAsCalendar().getTime();
    }

    public void setValue(String val) throws DataTypeException {
        if (val != null && !val.equals("") && !val.equals("\"\"")) {
            try {
                GregorianCalendar cal = new GregorianCalendar();
                cal.clear();
                cal.setLenient(false);
                if (val.length() != 4 && val.length() != 6 && val.length() != 8) {
                    String msg = "The length of the DT datatype value does not conform to an allowable format. Format should conform to YYYY[MM[DD]]";
                    DataTypeException e = new DataTypeException(msg);
                    throw e;
                }
                if (val.length() >= 4) {
                    int yrInt = Integer.parseInt(val.substring(0, 4));
                    cal.set(yrInt, 0, 1);
                    cal.getTime();
                    this.year = yrInt;
                }
                if (val.length() >= 6) {
                    int mnthInt = Integer.parseInt(val.substring(4, 6));
                    cal.set(this.year, mnthInt - 1, 1);
                    cal.getTime();
                    this.month = mnthInt;
                }
                if (val.length() == 8) {
                    int dayInt = Integer.parseInt(val.substring(6, 8));
                    cal.set(this.year, this.month - 1, dayInt);
                    cal.getTime();
                    this.day = dayInt;
                }
                this.value = val;
            }
            catch (DataTypeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DataTypeException(e);
            }
        } else {
            this.value = val;
        }
    }

    public void setYearPrecision(int yr) throws DataTypeException {
        try {
            GregorianCalendar cal = new GregorianCalendar();
            cal.clear();
            cal.setLenient(false);
            if (Integer.toString(yr).length() != 4) {
                String msg = "The input year value must be four digits long";
                DataTypeException e = new DataTypeException(msg);
                throw e;
            }
            cal.set(yr, 0, 1);
            cal.getTime();
            this.year = yr;
            this.month = 0;
            this.day = 0;
            this.value = Integer.toString(yr);
        }
        catch (DataTypeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataTypeException(e);
        }
    }

    public void setYearMonthPrecision(int yr, int mnth) throws DataTypeException {
        try {
            GregorianCalendar cal = new GregorianCalendar();
            cal.clear();
            cal.setLenient(false);
            if (Integer.toString(yr).length() != 4) {
                String msg = "The input year value must be four digits long";
                DataTypeException e = new DataTypeException(msg);
                throw e;
            }
            cal.set(yr, mnth - 1, 1);
            cal.getTime();
            this.year = yr;
            this.month = mnth;
            this.day = 0;
            this.value = String.valueOf(Integer.toString(yr)) + DataTypeUtil.preAppendZeroes(mnth, 2);
        }
        catch (DataTypeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataTypeException(e);
        }
    }

    public void setYearMonthDayPrecision(int yr, int mnth, int dy) throws DataTypeException {
        try {
            GregorianCalendar cal = new GregorianCalendar();
            cal.clear();
            cal.setLenient(false);
            if (Integer.toString(yr).length() != 4) {
                String msg = "The input year value must be four digits long";
                DataTypeException e = new DataTypeException(msg);
                throw e;
            }
            cal.set(yr, mnth - 1, dy);
            cal.getTime();
            this.year = yr;
            this.month = mnth;
            this.day = dy;
            this.value = String.valueOf(Integer.toString(yr)) + DataTypeUtil.preAppendZeroes(mnth, 2) + DataTypeUtil.preAppendZeroes(dy, 2);
        }
        catch (DataTypeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataTypeException(e);
        }
    }

    public String getValue() {
        return this.value;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public static String toHl7DTFormat(GregorianCalendar cal) throws DataTypeException {
        String val = "";
        try {
            cal.setLenient(false);
            int calYear = cal.get(1);
            int calMonth = cal.get(2) + 1;
            int calDay = cal.get(5);
            CommonDT dt = new CommonDT();
            dt.setYearMonthDayPrecision(calYear, calMonth, calDay);
            val = dt.getValue();
        }
        catch (DataTypeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataTypeException(e);
        }
        return val;
    }
}

