/*
 * Decompiled with CFR 0.152.
 */
package com.totvscrm.pentaho.step.buildjsonresponse;

import com.totvscrm.pentaho.step.buildjsonresponse.BuildResponseJson;
import com.totvscrm.pentaho.step.buildjsonresponse.BuildResponseJsonData;
import com.totvscrm.pentaho.step.buildjsonresponse.BuildResponseJsonDialog;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="[WS] Build Response JSON - EAI TOTVs", name="BuildReponseJson.Meta.Name", description="BuildReponseJson.Meta.TooltipDesc", image="BuildResponseJSON.png", categoryDescription="BuildReponseJson.Meta.CategoryDescription", i18nPackageName="com.totvscrm.pentaho.step.buildjsonresponse", documentationUrl="https://wsintegracoes.webnode.com/buildresponsejson/", casesUrl="https://wsintegracoes.webnode.com/buildresponsejson/", forumUrl="https://wsintegracoes.webnode.com/buildresponsejson/")
public class BuildResponseJsonMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static final Class<?> PKG = BuildResponseJsonMeta.class;
    private String currentTimestampIndex;
    private String currentTimestamp;
    private String outputFieldIndex;
    private String environmentCurrentTimestamp;
    private String environmentOutputField;
    private String[] fieldStreamHeader;
    private String[] fieldValueHeader;
    private String[] fieldStreamReceivedMessage;
    private String[] fieldValueReceivedMessage;
    private String[] fieldStreamProcessingInformation;
    private String[] fieldValueProcessingInformation;
    private String[] fieldStreamReturnContent;
    private String[] fieldValueReturnContent;

    public BuildResponseJsonMeta() {
        this.setDefault();
    }

    public void setDefault() {
        this.setCurrentTimestamp(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss-03:00").format(new Date()));
        this.setCurrentTimeStampIndex("");
        this.setOutputFieldIndex("");
        this.setFieldStreamHeader(new String[0]);
        this.setFieldValueHeader(new String[0]);
        this.setFieldStreamReceivedMessage(new String[0]);
        this.setFieldValueReceivedMessage(new String[0]);
        this.setFieldStreamProcessingInformation(new String[0]);
        this.setFieldValueProcessingInformation(new String[0]);
        this.setFieldStreamReturnContent(new String[0]);
        this.setFieldValueReturnContent(new String[0]);
    }

    public void allocateHeader(int nrRows) {
        this.setFieldStreamHeader(new String[nrRows]);
        this.setFieldValueHeader(new String[nrRows]);
    }

    public void allocateReceivedMessage(int nrRows) {
        this.setFieldStreamReceivedMessage(new String[nrRows]);
        this.setFieldValueReceivedMessage(new String[nrRows]);
    }

    public void allocateProcessingInformation(int nrRows) {
        this.setFieldStreamProcessingInformation(new String[nrRows]);
        this.setFieldValueProcessingInformation(new String[nrRows]);
    }

    public void allocateReturnContent(int nrRows) {
        this.setFieldStreamReturnContent(new String[nrRows]);
        this.setFieldValueReturnContent(new String[nrRows]);
    }

    public StepDialogInterface getDialog(Shell shell, StepMetaInterface meta, TransMeta transMeta, String name) {
        return new BuildResponseJsonDialog(shell, meta, transMeta, name);
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans disp) {
        return new BuildResponseJson(stepMeta, stepDataInterface, cnr, transMeta, disp);
    }

    public StepDataInterface getStepData() {
        return new BuildResponseJsonData();
    }

    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    public String getXML() throws KettleValueException {
        int i;
        StringBuilder xml = new StringBuilder();
        xml.append(XMLHandler.addTagValue((String)"currentTimestampIndex", (String)this.currentTimestampIndex));
        xml.append(XMLHandler.addTagValue((String)"outputFieldIndex", (String)this.outputFieldIndex));
        xml.append("    <header>").append(Const.CR);
        for (i = 0; i < this.fieldValueHeader.length; ++i) {
            xml.append("        <field>").append(Const.CR);
            xml.append("          ").append(XMLHandler.addTagValue((String)"value_header", (String)this.fieldValueHeader[i]));
            xml.append("          ").append(XMLHandler.addTagValue((String)"stream_header", (String)this.fieldStreamHeader[i]));
            xml.append("        </field>").append(Const.CR);
        }
        xml.append("    </header>").append(Const.CR);
        xml.append("    <received_message>").append(Const.CR);
        for (i = 0; i < this.fieldValueReceivedMessage.length; ++i) {
            xml.append("        <field>").append(Const.CR);
            xml.append("          ").append(XMLHandler.addTagValue((String)"value_received_message", (String)this.fieldValueReceivedMessage[i]));
            xml.append("          ").append(XMLHandler.addTagValue((String)"stream_received_message", (String)this.fieldStreamReceivedMessage[i]));
            xml.append("        </field>").append(Const.CR);
        }
        xml.append("    </received_message>").append(Const.CR);
        xml.append("    <processing_information>").append(Const.CR);
        for (i = 0; i < this.fieldValueProcessingInformation.length; ++i) {
            xml.append("        <field>").append(Const.CR);
            xml.append("          ").append(XMLHandler.addTagValue((String)"value_processing_information", (String)this.fieldValueProcessingInformation[i]));
            xml.append("          ").append(XMLHandler.addTagValue((String)"stream_processing_information", (String)this.fieldStreamProcessingInformation[i]));
            xml.append("        </field>").append(Const.CR);
        }
        xml.append("    </processing_information>").append(Const.CR);
        xml.append("    <return_content>").append(Const.CR);
        for (i = 0; i < this.fieldValueReturnContent.length; ++i) {
            xml.append("        <field>").append(Const.CR);
            xml.append("          ").append(XMLHandler.addTagValue((String)"value_return_content", (String)this.fieldValueReturnContent[i]));
            xml.append("          ").append(XMLHandler.addTagValue((String)"stream_return_content", (String)this.fieldStreamReturnContent[i]));
            xml.append("        </field>").append(Const.CR);
        }
        xml.append("    </return_content>").append(Const.CR);
        return xml.toString();
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        try {
            Node knode;
            int i;
            this.setCurrentTimeStampIndex(XMLHandler.getTagValue((Node)stepnode, (String)"currentTimestampIndex"));
            this.setOutputFieldIndex(XMLHandler.getTagValue((Node)stepnode, (String)"outputFieldIndex"));
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"header");
            int nrRows = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocateHeader(nrRows);
            for (i = 0; i < nrRows; ++i) {
                knode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldValueHeader[i] = XMLHandler.getTagValue((Node)knode, (String)"value_header");
                this.fieldStreamHeader[i] = XMLHandler.getTagValue((Node)knode, (String)"stream_header");
            }
            fields = XMLHandler.getSubNode((Node)stepnode, (String)"received_message");
            nrRows = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocateReceivedMessage(nrRows);
            for (i = 0; i < nrRows; ++i) {
                knode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldValueReceivedMessage[i] = XMLHandler.getTagValue((Node)knode, (String)"value_received_message");
                this.fieldStreamReceivedMessage[i] = XMLHandler.getTagValue((Node)knode, (String)"stream_received_message");
            }
            fields = XMLHandler.getSubNode((Node)stepnode, (String)"processing_information");
            nrRows = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocateProcessingInformation(nrRows);
            for (i = 0; i < nrRows; ++i) {
                knode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldValueProcessingInformation[i] = XMLHandler.getTagValue((Node)knode, (String)"value_processing_information");
                this.fieldStreamProcessingInformation[i] = XMLHandler.getTagValue((Node)knode, (String)"stream_processing_information");
            }
            fields = XMLHandler.getSubNode((Node)stepnode, (String)"return_content");
            nrRows = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocateReturnContent(nrRows);
            for (i = 0; i < nrRows; ++i) {
                knode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldValueReturnContent[i] = XMLHandler.getTagValue((Node)knode, (String)"value_return_content");
                this.fieldStreamReturnContent[i] = XMLHandler.getTagValue((Node)knode, (String)"stream_return_content");
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Plugin unable to read step info from XML node", (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            String streamField;
            String valueField;
            int idx;
            rep.saveStepAttribute(id_transformation, id_step, "currentTimestampIndex", this.currentTimestampIndex);
            rep.saveStepAttribute(id_transformation, id_step, "outputFieldIndex", this.outputFieldIndex);
            int nrRows = this.fieldValueHeader.length < this.fieldStreamHeader.length ? this.fieldStreamHeader.length : this.fieldValueHeader.length;
            for (idx = 0; idx < nrRows; ++idx) {
                valueField = idx < this.fieldValueHeader.length ? this.fieldValueHeader[idx] : "";
                streamField = idx < this.fieldStreamHeader.length ? this.fieldStreamHeader[idx] : "";
                rep.saveStepAttribute(id_transformation, id_step, idx, "value_header", valueField);
                rep.saveStepAttribute(id_transformation, id_step, idx, "stream_header", streamField);
            }
            nrRows = this.fieldValueReceivedMessage.length < this.fieldStreamReceivedMessage.length ? this.fieldStreamReceivedMessage.length : this.fieldValueReceivedMessage.length;
            for (idx = 0; idx < nrRows; ++idx) {
                valueField = idx < this.fieldValueReceivedMessage.length ? this.fieldValueReceivedMessage[idx] : "";
                streamField = idx < this.fieldStreamReceivedMessage.length ? this.fieldStreamReceivedMessage[idx] : "";
                rep.saveStepAttribute(id_transformation, id_step, idx, "value_received_message", valueField);
                rep.saveStepAttribute(id_transformation, id_step, idx, "stream_received_message", streamField);
            }
            nrRows = this.fieldValueProcessingInformation.length < this.fieldStreamProcessingInformation.length ? this.fieldStreamProcessingInformation.length : this.fieldValueProcessingInformation.length;
            for (idx = 0; idx < nrRows; ++idx) {
                valueField = idx < this.fieldValueProcessingInformation.length ? this.fieldValueProcessingInformation[idx] : "";
                streamField = idx < this.fieldStreamProcessingInformation.length ? this.fieldStreamProcessingInformation[idx] : "";
                rep.saveStepAttribute(id_transformation, id_step, idx, "value_processing_information", valueField);
                rep.saveStepAttribute(id_transformation, id_step, idx, "stream_processing_information", streamField);
            }
            nrRows = this.fieldValueReturnContent.length < this.fieldStreamReturnContent.length ? this.fieldStreamReturnContent.length : this.fieldValueReturnContent.length;
            for (idx = 0; idx < nrRows; ++idx) {
                valueField = idx < this.fieldValueReturnContent.length ? this.fieldValueReturnContent[idx] : "";
                streamField = idx < this.fieldStreamReturnContent.length ? this.fieldStreamReturnContent[idx] : "";
                rep.saveStepAttribute(id_transformation, id_step, idx, "value_return_content", valueField);
                rep.saveStepAttribute(id_transformation, id_step, idx, "stream_return_content", streamField);
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step into repository: " + String.valueOf(id_step), (Throwable)e);
        }
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int idx;
            this.currentTimestampIndex = rep.getStepAttributeString(id_step, "currentTimestampIndex");
            this.outputFieldIndex = rep.getStepAttributeString(id_step, "outputFieldIndex");
            int nrValues = rep.countNrStepAttributes(id_step, "value_header");
            int nrStreams = rep.countNrStepAttributes(id_step, "stream_header");
            int nrRows = nrValues < nrStreams ? nrStreams : nrValues;
            this.allocateHeader(nrRows);
            for (idx = 0; idx < nrRows; ++idx) {
                this.fieldValueHeader[idx] = Const.NVL((String)rep.getStepAttributeString(id_step, idx, "value_header"), (String)"");
                this.fieldStreamHeader[idx] = Const.NVL((String)rep.getStepAttributeString(id_step, idx, "stream_header"), (String)"");
            }
            nrValues = rep.countNrStepAttributes(id_step, "value_received_message");
            nrRows = nrValues < (nrStreams = rep.countNrStepAttributes(id_step, "stream_received_message")) ? nrStreams : nrValues;
            this.allocateReceivedMessage(nrRows);
            for (idx = 0; idx < nrRows; ++idx) {
                this.fieldValueReceivedMessage[idx] = Const.NVL((String)rep.getStepAttributeString(id_step, idx, "value_received_message"), (String)"");
                this.fieldStreamReceivedMessage[idx] = Const.NVL((String)rep.getStepAttributeString(id_step, idx, "stream_received_message"), (String)"");
            }
            nrValues = rep.countNrStepAttributes(id_step, "value_processing_information");
            nrRows = nrValues < (nrStreams = rep.countNrStepAttributes(id_step, "stream_processing_information")) ? nrStreams : nrValues;
            this.allocateProcessingInformation(nrRows);
            for (idx = 0; idx < nrRows; ++idx) {
                this.fieldValueProcessingInformation[idx] = Const.NVL((String)rep.getStepAttributeString(id_step, idx, "value_processing_information"), (String)"");
                this.fieldStreamProcessingInformation[idx] = Const.NVL((String)rep.getStepAttributeString(id_step, idx, "stream_processing_information"), (String)"");
            }
            nrValues = rep.countNrStepAttributes(id_step, "value_return_content");
            nrRows = nrValues < (nrStreams = rep.countNrStepAttributes(id_step, "stream_return_content")) ? nrStreams : nrValues;
            this.allocateReturnContent(nrRows);
            for (idx = 0; idx < nrRows; ++idx) {
                this.fieldValueReturnContent[idx] = Const.NVL((String)rep.getStepAttributeString(id_step, idx, "value_return_content"), (String)"");
                this.fieldStreamReturnContent[idx] = Const.NVL((String)rep.getStepAttributeString(id_step, idx, "stream_return_content"), (String)"");
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to load step from repository", (Throwable)e);
        }
    }

    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        ValueMetaString vCurrentTimestamp = new ValueMetaString(space.environmentSubstitute(this.currentTimestampIndex));
        vCurrentTimestamp.setTrimType(3);
        vCurrentTimestamp.setOrigin(name);
        if (inputRowMeta.indexOfValue(space.environmentSubstitute(this.currentTimestampIndex)) < 0) {
            inputRowMeta.addValueMeta((ValueMetaInterface)vCurrentTimestamp);
        }
        this.setEnvironmentCurrentTimestamp(space.environmentSubstitute(this.currentTimestampIndex));
        ValueMetaString vOutputField = new ValueMetaString(space.environmentSubstitute(this.outputFieldIndex));
        vOutputField.setTrimType(3);
        vOutputField.setOrigin(name);
        if (inputRowMeta.indexOfValue(space.environmentSubstitute(this.outputFieldIndex)) < 0) {
            inputRowMeta.addValueMeta((ValueMetaInterface)vOutputField);
        }
        this.setEnvironmentOutputField(space.environmentSubstitute(this.outputFieldIndex));
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] current_timestamp, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        if (input != null && input.length > 0) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"BuildReponseJson.Meta.CheckResult.ReceivingRows.OK", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"BuildReponseJson.Meta.CheckResult.ReceivingRows.ERROR", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    public String getCurrentTimeStampIndex() {
        return this.currentTimestampIndex;
    }

    public void setCurrentTimeStampIndex(String currentTimestampIndex) {
        this.currentTimestampIndex = currentTimestampIndex;
    }

    public String getCurrentTimestamp() {
        return this.currentTimestamp;
    }

    public void setCurrentTimestamp(String currentTimestamp) {
        this.currentTimestamp = currentTimestamp;
    }

    public String getOutputFieldIndex() {
        return this.outputFieldIndex;
    }

    public void setOutputFieldIndex(String outputFieldIndex) {
        this.outputFieldIndex = outputFieldIndex;
    }

    public String[] getFieldStreamHeader() {
        return this.fieldStreamHeader;
    }

    public void setFieldStreamHeader(String[] fieldStreamHeader) {
        this.fieldStreamHeader = fieldStreamHeader;
    }

    public String[] getFieldValueHeader() {
        return this.fieldValueHeader;
    }

    public void setFieldValueHeader(String[] fieldValueHeader) {
        this.fieldValueHeader = fieldValueHeader;
    }

    public String[] getFieldStreamReceivedMessage() {
        return this.fieldStreamReceivedMessage;
    }

    public void setFieldStreamReceivedMessage(String[] fieldStreamReceivedMessage) {
        this.fieldStreamReceivedMessage = fieldStreamReceivedMessage;
    }

    public String[] getFieldValueReceivedMessage() {
        return this.fieldValueReceivedMessage;
    }

    public void setFieldValueReceivedMessage(String[] fieldValueReceivedMessage) {
        this.fieldValueReceivedMessage = fieldValueReceivedMessage;
    }

    public String[] getFieldStreamProcessingInformation() {
        return this.fieldStreamProcessingInformation;
    }

    public void setFieldStreamProcessingInformation(String[] fieldStreamProcessingInformation) {
        this.fieldStreamProcessingInformation = fieldStreamProcessingInformation;
    }

    public String[] getFieldValueProcessingInformation() {
        return this.fieldValueProcessingInformation;
    }

    public void setFieldValueProcessingInformation(String[] fieldValueProcessingInformation) {
        this.fieldValueProcessingInformation = fieldValueProcessingInformation;
    }

    public String[] getFieldStreamReturnContent() {
        return this.fieldStreamReturnContent;
    }

    public void setFieldStreamReturnContent(String[] fieldStreamReturnContent) {
        this.fieldStreamReturnContent = fieldStreamReturnContent;
    }

    public String[] getFieldValueReturnContent() {
        return this.fieldValueReturnContent;
    }

    public void setFieldValueReturnContent(String[] fieldValueReturnContent) {
        this.fieldValueReturnContent = fieldValueReturnContent;
    }

    public String getEnvironmentCurrentTimestamp() {
        return this.environmentCurrentTimestamp;
    }

    public void setEnvironmentCurrentTimestamp(String environmentCurrentTimestamp) {
        this.environmentCurrentTimestamp = environmentCurrentTimestamp;
    }

    public String getEnvironmentOutputField() {
        return this.environmentOutputField;
    }

    public void setEnvironmentOutputField(String environmentOutputField) {
        this.environmentOutputField = environmentOutputField;
    }
}

