/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ConfirmedAction;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VActionContext;
import com.ibm.as400.vaccess.VObject;
import java.io.IOException;

class IFSDeleteAction
extends ConfirmedAction {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String confirmTitleText_ = ResourceLoader.getText("DLG_CONFIRM_DELETION_TITLE");
    private static final String confirmMessageText_ = ResourceLoader.getText("DLG_CONFIRM_DELETION");
    private static final String text_ = ResourceLoader.getText("ACTION_DELETE");
    private IFSFile file_ = null;

    public IFSDeleteAction(VObject vObject, IFSFile iFSFile) {
        super(vObject, confirmTitleText_, confirmMessageText_);
        this.file_ = iFSFile;
    }

    public String getText() {
        return text_;
    }

    public void perform2(VActionContext vActionContext) {
        if (Trace.isTraceOn()) {
            Trace.log(3, "Deleting file or directory [" + this.file_.getPath() + "].");
        }
        this.fireStartWorking();
        boolean bl = false;
        try {
            if (!this.file_.exists()) {
                this.fireError(new IOException(ResourceLoader.getText("EXC_FILE_NOT_FOUND")));
                bl = true;
            } else if (this.file_.delete()) {
                bl = true;
            } else {
                this.fireError(new IOException(ResourceLoader.getText("EXC_FILE_NOT_DELETED")));
            }
        }
        catch (IOException iOException) {
            this.fireError(iOException);
        }
        this.fireStopWorking();
        if (bl) {
            this.fireObjectDeleted();
        }
    }
}

