/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.commtrace;

import java.io.StringWriter;

class BitBuf {
    private byte[] data;
    private int bitlen;
    private static StringBuffer binbyte = new StringBuffer("01234567");
    private static StringBuffer hexbyte = new StringBuffer("FF");
    private final int[] masks = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
    private final char[] hexchars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public BitBuf(byte[] byArray) {
        this.data = (byte[])byArray.clone();
        this.bitlen = this.data.length * 8;
    }

    public BitBuf(int[] nArray) {
        this.data = new byte[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.data[i] = (byte)nArray[i];
        }
        this.bitlen = this.data.length * 8;
    }

    public BitBuf(byte by) {
        this.data = new byte[1];
        this.data[0] = by;
        this.bitlen = this.data.length * 8;
    }

    public BitBuf(int n) {
        this.data = new byte[n];
        this.bitlen = this.data.length * 8;
    }

    public BitBuf(BitBuf bitBuf, int n, int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        this.bitlen = n2;
        int n3 = (n2 + 7) / 8;
        this.data = new byte[n3];
        for (int i = 0; i < n3; ++i) {
            this.data[i] = bitBuf.getOctet(n + 8 * i);
        }
        this.truncate();
    }

    public String byteAsBin(int n) {
        for (int i = 7; i >= 0; --i) {
            binbyte.setCharAt(i, (this.data[n] & 0xFF & this.masks[i]) > 0 ? (char)'1' : '0');
        }
        return binbyte.toString();
    }

    public String byteAsHex(int n) {
        hexbyte.setCharAt(0, this.hexchars[this.data[n] >>> 4 & 0xF]);
        hexbyte.setCharAt(1, this.hexchars[this.data[n] & 0xF]);
        return hexbyte.toString();
    }

    public Object clone() {
        BitBuf bitBuf = new BitBuf(this.data);
        return bitBuf;
    }

    public boolean getBitAsBool(int n) {
        int n2 = n / 8;
        int n3 = n % 8;
        return (this.data[n2] & 0xFF & this.masks[n3]) > 0;
    }

    public byte getBitAsByte(int n) {
        int n2 = n / 8;
        int n3 = n % 8;
        if ((this.data[n2] & 0xFF & this.masks[n3]) > 0) {
            return 1;
        }
        return 0;
    }

    public int getBitSize() {
        return this.bitlen;
    }

    public byte[] getBytes() {
        return (byte[])this.data.clone();
    }

    public int getByteSize() {
        return this.data.length;
    }

    public byte getOctet(int n) {
        byte by;
        if (n >= this.bitlen || n < -8) {
            by = 0;
        } else if (n < 0) {
            by = (byte)((this.data[0] & 0xFF) >>> 0 - n);
        } else {
            int n2 = n / 8;
            int n3 = n % 8;
            by = this.data[n2];
            by = (byte)(by << n3);
            if (n3 > 0 && n + 8 < this.bitlen) {
                by = (byte)(by | (this.data[n2 + 1] & 0xFF) >>> 8 - n3);
            }
        }
        return by;
    }

    public void shiftLeft(int n) {
        this.shiftBufferLeft(n);
    }

    public void shiftRight(int n) {
        this.shiftBufferRight(n);
        this.truncate();
    }

    public void shiftBufferLeft(int n) {
        int n2;
        int n3 = n / 8;
        int n4 = n % 8;
        if (n3 > 0) {
            for (n2 = 0; n2 < this.data.length; ++n2) {
                this.data[n2] = n2 < this.data.length - n3 ? this.data[n2 + n3] : (byte)0;
            }
        }
        if (n4 > 0) {
            for (n2 = 0; n2 < this.data.length; ++n2) {
                if (n2 < this.data.length - 1) {
                    this.data[n2] = (byte)(this.data[n2] << n4 | (this.data[n2 + 1] & 0xFF) >>> 8 - n4);
                    continue;
                }
                int n5 = n2;
                this.data[n5] = (byte)(this.data[n5] << n4);
            }
        }
    }

    public void shiftBufferRight(int n) {
        int n2;
        int n3 = n / 8;
        int n4 = n % 8;
        if (n3 > 0) {
            n2 = this.data.length;
            while (n2-- > 0) {
                if (n2 >= n3) {
                    this.data[n2] = this.data[n2 - n3];
                    continue;
                }
                this.data[n2] = 0;
            }
        }
        if (n4 > 0) {
            n2 = this.data.length;
            while (n2-- > 0) {
                if (n2 > 0) {
                    this.data[n2] = (byte)((this.data[n2] & 0xFF) >>> n4 | this.data[n2 - 1] << 8 - n4);
                    continue;
                }
                this.data[n2] = (byte)((this.data[n2] & 0xFF) >>> n4);
            }
        }
    }

    public BitBuf slice(int n) {
        return new BitBuf(this, n, this.bitlen - n);
    }

    public BitBuf slice(int n, int n2) {
        return new BitBuf(this, n, n2);
    }

    public String toBinString() {
        return this.toBinString(0, "");
    }

    public String toBinString(int n, String string) {
        StringWriter stringWriter = new StringWriter();
        for (int i = 0; i < this.data.length; ++i) {
            stringWriter.write(this.byteAsBin(i));
            if (n == 0 || i % n != 0) continue;
            stringWriter.write(string);
        }
        return stringWriter.toString();
    }

    public String toBinString(String string) {
        return this.toBinString(1, string);
    }

    public byte toByte() {
        return this.getOctet(this.bitlen - 8);
    }

    public String toHexString() {
        return this.toHexString(0, "");
    }

    public String toHexString(int n, String string) {
        StringWriter stringWriter = new StringWriter();
        for (int i = 0; i < this.data.length; ++i) {
            if (i != 0 && n > 0 && i % n == 0) {
                stringWriter.write(string);
            }
            stringWriter.write(this.byteAsHex(i));
        }
        return stringWriter.toString();
    }

    public String toHexString(String string) {
        return this.toHexString(1, string);
    }

    public String toHexStringJustified(int n, String string) {
        BitBuf bitBuf = (BitBuf)this.clone();
        int n2 = bitBuf.bitlen % 8;
        if (n2 > 0) {
            bitBuf.shiftBufferRight(8 - n2);
        }
        return bitBuf.toHexString(n, string);
    }

    public int toInt() {
        long l = 0L;
        for (int i = 0; i < 4; ++i) {
            l |= (long)((this.getOctet(this.bitlen - 8 * (i + 1)) & 0xFF) << i * 8);
        }
        return (int)l;
    }

    public long toLong() {
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            l |= (long)(this.getOctet(this.bitlen - 8 * (i + 1)) & 0xFF) << i * 8;
        }
        return l;
    }

    public short toShort() {
        long l = 0L;
        for (int i = 0; i < 2; ++i) {
            l |= (long)((this.getOctet(this.bitlen - 8 * (i + 1)) & 0xFF) << i * 8);
        }
        return (short)l;
    }

    private void truncate() {
        int n = this.bitlen % 8;
        if (n > 0) {
            int n2 = this.data.length - 1;
            this.data[n2] = (byte)(this.data[n2] & ~((1 << 8 - n) - 1));
        }
    }
}

