/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.ConverterImpl;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExecutionEnvironment;
import com.ibm.as400.access.NPCPAttribute;
import com.ibm.as400.access.NPCPAttributeIDList;
import com.ibm.as400.access.NPDataStream;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.Trace;
import java.io.IOException;

class NPConversation {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private ConverterImplRemote converter_ = null;
    private AS400ImplRemote system_ = null;
    private AS400Server server_;
    private NPCPAttribute serverAttributes_ = new NPCPAttribute();

    NPConversation(AS400ImplRemote aS400ImplRemote, AS400Server aS400Server) throws AS400Exception, ErrorCompletingRequestException, IOException, InterruptedException {
        this.system_ = aS400ImplRemote;
        this.server_ = aS400Server;
        try {
            this.retrieveServerAttributes();
        }
        catch (RequestNotSupportedException requestNotSupportedException) {
            throw new ErrorCompletingRequestException(1);
        }
    }

    AS400Server getServer() {
        return this.server_;
    }

    String getAttribute(int n) {
        return this.serverAttributes_.getStringValue(n);
    }

    ConverterImpl getConverter() {
        return this.converter_;
    }

    int makeRequest(NPDataStream nPDataStream, NPDataStream nPDataStream2) throws AS400Exception, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        int n = 0;
        int n2 = this.server_.newCorrelationId();
        nPDataStream.setConverter(this.converter_);
        nPDataStream2.setConverter(this.converter_);
        nPDataStream.setCorrelation(n2);
        this.server_.clearInstanceReplyStreams();
        this.server_.addInstanceReplyStream(nPDataStream2);
        this.server_.send(nPDataStream, n2);
        nPDataStream2 = (NPDataStream)this.server_.receive(n2);
        if (nPDataStream2 == null) {
            Trace.log(2, "Didn't get me datastream back!");
            throw new NullPointerException();
        }
        n = nPDataStream2.getReturnCode();
        if (n != 0) {
            switch (n) {
                case 9: {
                    NPCPAttribute nPCPAttribute = (NPCPAttribute)nPDataStream2.getCodePoint(8);
                    if (nPCPAttribute != null) {
                        AS400Message aS400Message;
                        String string = new String();
                        String string2 = new String();
                        String string3 = nPCPAttribute.getStringValue(34);
                        String string4 = nPCPAttribute.getStringValue(110);
                        String string5 = nPCPAttribute.getStringValue(147);
                        String string6 = nPCPAttribute.getStringValue(128);
                        String string7 = nPCPAttribute.getStringValue(129);
                        String string8 = nPCPAttribute.getStringValue(130);
                        Integer n3 = nPCPAttribute.getIntValue(159);
                        String string9 = nPCPAttribute.getStringValue(142);
                        byte[] byArray = new byte[nPCPAttribute.getLength()];
                        Integer n4 = new Integer(string9);
                        Trace.log(2, "CPF Message(" + string5 + ") = " + string6 + ", HelpText= " + string7);
                        if (n3 != null && n4 != null) {
                            aS400Message = new AS400Message(string5, string6, string, string2, n3, n4, byArray, string7, string3, string4, string8);
                        } else {
                            aS400Message = new AS400Message(string5, string6);
                            aS400Message.setHelp(string7);
                        }
                        throw new AS400Exception(aS400Message);
                    }
                }
                case 4: 
                case 14: 
                case 19: 
                case 20: 
                case 21: 
                case 32: 
                case 33: {
                    break;
                }
                case 28: {
                    Trace.log(4, "NetPrint DataStream host cannot change to our NLV.  RC = " + n);
                    break;
                }
                case 3: {
                    Trace.log(2, "NetPrint DataStream RC = " + n);
                    throw new RequestNotSupportedException(this.getAttribute(141), 1);
                }
                default: {
                    Trace.log(2, "NetPrint DataStream RC = " + n);
                    throw new ErrorCompletingRequestException(1);
                }
            }
        }
        return n;
    }

    private void retrieveServerAttributes() throws AS400Exception, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        NPDataStream nPDataStream = new NPDataStream(8);
        NPDataStream nPDataStream2 = new NPDataStream(8);
        NPCPAttributeIDList nPCPAttributeIDList = new NPCPAttributeIDList();
        NPCPAttribute nPCPAttribute = new NPCPAttribute();
        NPCPAttribute nPCPAttribute2 = new NPCPAttribute();
        nPCPAttribute.setAttrValue(138, ExecutionEnvironment.getCcsid());
        nPCPAttributeIDList.addAttrID(138);
        nPDataStream.setAction(15);
        nPDataStream.addCodePoint(nPCPAttribute);
        nPDataStream.addCodePoint(nPCPAttributeIDList);
        nPDataStream2.addCodePoint(nPCPAttribute2);
        int n = this.makeRequest(nPDataStream, nPDataStream2);
        if (n == 0) {
            Integer n2 = nPCPAttribute2.getIntValue(138);
            if (n2 != null) {
                int n3 = n2;
                this.serverAttributes_.setAttrValue(138, n3);
                this.converter_ = ConverterImplRemote.getConverter(n3, this.system_);
            }
            nPCPAttribute.reset();
            nPCPAttributeIDList.reset();
            nPCPAttribute.setAttrValue(180, this.system_.getNLV());
            nPCPAttributeIDList.addAttrID(180);
            nPDataStream.setAction(14);
            nPDataStream.resetCodePoints();
            nPDataStream.addCodePoint(nPCPAttribute);
            nPDataStream.addCodePoint(nPCPAttributeIDList);
            nPCPAttribute2.reset();
            nPDataStream2.resetCodePoints();
            nPDataStream2.addCodePoint(nPCPAttribute2);
            this.makeRequest(nPDataStream, nPDataStream2);
            this.serverAttributes_.addUpdateAttributes(nPCPAttribute2);
            nPCPAttributeIDList.reset();
            nPCPAttributeIDList.addAttrID(141);
            nPCPAttributeIDList.addAttrID(59);
            nPCPAttributeIDList.addAttrID(62);
            nPCPAttributeIDList.addAttrID(60);
            nPDataStream.setAction(15);
            nPDataStream.resetCodePoints();
            nPDataStream.addCodePoint(nPCPAttributeIDList);
            nPCPAttribute2.reset();
            nPDataStream2.resetCodePoints();
            nPDataStream2.addCodePoint(nPCPAttribute2);
            n = this.makeRequest(nPDataStream, nPDataStream2);
            if (n == 0) {
                this.serverAttributes_.addUpdateAttributes(nPCPAttribute2);
                if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                    Trace.log(3, " Network Print Server started ");
                    Trace.log(3, "   NetPrint Server info (System/Job#/JobUser/JobName): " + this.serverAttributes_.getStringValue(60) + "/" + this.serverAttributes_.getStringValue(62) + "/" + this.serverAttributes_.getStringValue(59));
                    Trace.log(3, "   NetPrint Server VRM = " + this.serverAttributes_.getStringValue(141));
                }
            }
        }
    }
}

