/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.IFSCachedAttributes;
import com.ibm.as400.access.IFSChangeAttrsReq;
import com.ibm.as400.access.IFSCreateDirHandleRep;
import com.ibm.as400.access.IFSCreateDirHandleReq;
import com.ibm.as400.access.IFSCreateDirReq;
import com.ibm.as400.access.IFSDataStreamReq;
import com.ibm.as400.access.IFSDeleteDirReq;
import com.ibm.as400.access.IFSDeleteFileReq;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileDescriptorImplRemote;
import com.ibm.as400.access.IFSFileImpl;
import com.ibm.as400.access.IFSListAttrsRep;
import com.ibm.as400.access.IFSListAttrsReq;
import com.ibm.as400.access.IFSObjAttrs2;
import com.ibm.as400.access.IFSOpenRep;
import com.ibm.as400.access.IFSQuerySpaceRep;
import com.ibm.as400.access.IFSQuerySpaceReq;
import com.ibm.as400.access.IFSRenameReq;
import com.ibm.as400.access.IFSReturnCodeRep;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectAlreadyExistsException;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Vector;

class IFSFileImplRemote
implements IFSFileImpl {
    private static final boolean DEBUG = false;
    private static final boolean IS_RESTART_NAME = true;
    private static final boolean NO_RESTART_NAME = true;
    private static final boolean SORT_LIST = true;
    private static final int NO_MAX_GET_COUNT = -1;
    private static final int UNINITIALIZED = -1;
    private transient IFSListAttrsRep attributesReply_;
    private IFSFileDescriptorImplRemote fd_ = new IFSFileDescriptorImplRemote();
    private boolean isSymbolicLink_;
    private boolean determinedIsSymbolicLink_;
    private boolean sortLists_;

    IFSFileImplRemote() {
    }

    public int canRead() throws IOException, AS400SecurityException {
        this.fd_.connect();
        return this.fd_.checkAccess(1, 8);
    }

    public int canWrite() throws IOException, AS400SecurityException {
        this.fd_.connect();
        return this.fd_.checkAccess(2, 8);
    }

    public boolean copyTo(String string, boolean bl) throws IOException, AS400SecurityException, ObjectAlreadyExistsException {
        this.fd_.connect();
        if (Trace.traceOn_ && !bl && this.fd_.getSystemVRM() < 328448) {
            Trace.log(4, "Server is V5R2 or lower, so the 'Do not replace' argument will be ignored.");
        }
        if (this.isDirectory() == 0 && this.exists(string) == 0) {
            throw new ObjectAlreadyExistsException(string, 1);
        }
        return this.fd_.copyTo(string, bl);
    }

    public long created() throws IOException, AS400SecurityException {
        this.fd_.connect();
        long l = 0L;
        IFSListAttrsRep iFSListAttrsRep = this.getAttributeSetFromServer(this.fd_.path_);
        if (iFSListAttrsRep != null) {
            this.attributesReply_ = iFSListAttrsRep;
            l = iFSListAttrsRep.getCreationDate();
        }
        return l;
    }

    public int createNewFile() throws IOException, AS400SecurityException {
        this.fd_.connect();
        return this.fd_.checkAccess(2, 4);
    }

    public int delete() throws IOException, AS400SecurityException {
        IFSDataStreamReq iFSDataStreamReq;
        block9: {
            this.fd_.connect();
            byte[] byArray = this.fd_.converter_.stringToByteArray(this.fd_.path_);
            iFSDataStreamReq = new IFSDeleteFileReq(byArray, this.fd_.preferredServerCCSID_);
            try {
                if (this.isDirectory() == 0) {
                    iFSDataStreamReq = new IFSDeleteDirReq(byArray, this.fd_.preferredServerCCSID_);
                }
            }
            catch (Exception exception) {
                if (!Trace.traceOn_) break block9;
                Trace.log(4, "Unable to determine if file or directory.\n" + exception.toString());
            }
        }
        ClientAccessDataStream clientAccessDataStream = null;
        try {
            clientAccessDataStream = (ClientAccessDataStream)this.fd_.server_.sendAndReceive(iFSDataStreamReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "Byte stream server connection lost.");
            this.fd_.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted");
            throw new InterruptedIOException(interruptedException.getMessage());
        }
        int n = 0;
        if (clientAccessDataStream instanceof IFSReturnCodeRep) {
            n = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
            if (n != 0 && Trace.traceOn_) {
                Trace.log(2, "IFSReturnCodeRep return code = ", n);
            }
        } else {
            Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.data_);
            throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
        }
        this.attributesReply_ = null;
        return n;
    }

    private boolean determineIsDirectory(IFSListAttrsRep iFSListAttrsRep) {
        boolean bl = false;
        String string = this.fd_.converter_.byteArrayToString(iFSListAttrsRep.getName());
        switch (iFSListAttrsRep.getObjectType()) {
            case 1: 
            case 2: {
                bl = (iFSListAttrsRep.getFixedAttributes() & 0x10) != 0;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private boolean determineIsFile(IFSListAttrsRep iFSListAttrsRep) {
        boolean bl = false;
        String string = this.fd_.converter_.byteArrayToString(iFSListAttrsRep.getName());
        switch (iFSListAttrsRep.getObjectType()) {
            case 1: 
            case 2: {
                bl = (iFSListAttrsRep.getFixedAttributes() & 0x10) == 0;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public int exists() throws IOException, AS400SecurityException {
        return this.exists(this.fd_.path_);
    }

    private int exists(String string) throws IOException, AS400SecurityException {
        int n = 0;
        this.fd_.connect();
        n = 2;
        try {
            IFSListAttrsRep iFSListAttrsRep = this.getAttributeSetFromServer(string);
            if (iFSListAttrsRep != null) {
                n = 0;
                this.attributesReply_ = iFSListAttrsRep;
            }
        }
        catch (AS400SecurityException aS400SecurityException) {
            n = 5;
        }
        return n;
    }

    String getAbsolutePath() {
        return this.fd_.path_;
    }

    private IFSListAttrsRep getAttributeSetFromServer(String string) throws IOException, AS400SecurityException {
        IFSListAttrsRep iFSListAttrsRep = null;
        Vector vector = this.listAttributes(string, -1, null, true, false);
        if (vector != null && vector.size() == 1) {
            iFSListAttrsRep = (IFSListAttrsRep)vector.elementAt(0);
        }
        return iFSListAttrsRep;
    }

    public int getCCSID() throws IOException, AS400SecurityException {
        this.fd_.connect();
        return this.fd_.getCCSID();
    }

    public long getFreeSpace() throws IOException, AS400SecurityException {
        try {
            this.fd_.connect();
        }
        catch (AS400SecurityException aS400SecurityException) {
            throw new ExtendedIOException(this.fd_.path_, 5);
        }
        long l = 0L;
        long l2 = 0L;
        ClientAccessDataStream clientAccessDataStream = null;
        try {
            IFSQuerySpaceReq iFSQuerySpaceReq = new IFSQuerySpaceReq(0);
            clientAccessDataStream = (ClientAccessDataStream)this.fd_.server_.sendAndReceive(iFSQuerySpaceReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "Byte stream server connection lost.");
            this.fd_.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted");
            throw new InterruptedIOException(interruptedException.getMessage());
        }
        int n = 0;
        if (!(clientAccessDataStream instanceof IFSQuerySpaceRep)) {
            if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                n = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                if (n != 0) {
                    Trace.log(2, "IFSReturnCodeRep return code = ", n);
                }
                throw new ExtendedIOException(this.fd_.path_, n);
            }
            Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.getReqRepID());
            throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
        }
        l = ((IFSQuerySpaceRep)clientAccessDataStream).getFreeSpace();
        if (Trace.traceOn_) {
            if (l == Long.MAX_VALUE) {
                Trace.log(1, "MaxStorage appears to be set to *NOMAX");
            } else {
                Trace.log(1, "MaxStorage does not appear to be set to *NOMAX");
            }
        }
        String string = this.fd_.path_;
        if (this.isDirectory() != 0) {
            string = IFSFile.getParent(this.fd_.path_);
        }
        byte[] byArray = this.fd_.getConverter().stringToByteArray(string);
        clientAccessDataStream = null;
        try {
            IFSCreateDirHandleReq iFSCreateDirHandleReq = new IFSCreateDirHandleReq(byArray, this.fd_.preferredServerCCSID_);
            clientAccessDataStream = (ClientAccessDataStream)this.fd_.server_.sendAndReceive(iFSCreateDirHandleReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "Byte stream server connection lost.");
            this.fd_.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted");
            throw new InterruptedIOException(interruptedException.getMessage());
        }
        n = 0;
        int n2 = 0;
        if (!(clientAccessDataStream instanceof IFSCreateDirHandleRep)) {
            if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                n = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                if (n != 0) {
                    Trace.log(2, "IFSReturnCodeRep return code = ", n);
                }
                throw new ExtendedIOException(this.fd_.path_, n);
            }
            Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.getReqRepID());
            throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
        }
        n2 = ((IFSCreateDirHandleRep)clientAccessDataStream).getHandle();
        clientAccessDataStream = null;
        try {
            IFSQuerySpaceReq iFSQuerySpaceReq = new IFSQuerySpaceReq(n2);
            clientAccessDataStream = (ClientAccessDataStream)this.fd_.server_.sendAndReceive(iFSQuerySpaceReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "Byte stream server connection lost.");
            this.fd_.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted");
            throw new InterruptedIOException(interruptedException.getMessage());
        }
        n = 0;
        if (!(clientAccessDataStream instanceof IFSQuerySpaceRep)) {
            if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                n = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                if (n != 0) {
                    Trace.log(2, "IFSReturnCodeRep return code = ", n);
                }
                throw new ExtendedIOException(this.fd_.path_, n);
            }
            Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.getReqRepID());
            throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
        }
        l2 = ((IFSQuerySpaceRep)clientAccessDataStream).getFreeSpace();
        return Math.min(l, l2);
    }

    public String getOwnerName() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        String string = null;
        this.fd_.connect();
        try {
            IFSListAttrsRep iFSListAttrsRep = this.fd_.listObjAttrs1(2048, 0);
            if (iFSListAttrsRep != null) {
                string = iFSListAttrsRep.getOwnerName(this.fd_.system_.getCcsid());
            } else {
                if (Trace.traceOn_) {
                    Trace.log(4, "Return code from getOwnerName: " + this.fd_.errorRC_);
                }
                if (this.fd_.errorRC_ == 2 || this.fd_.errorRC_ == 3) {
                    throw new ExtendedIOException(this.fd_.path_, 3);
                }
            }
        }
        catch (ExtendedIOException extendedIOException) {
            if (extendedIOException.getReturnCode() == 4) {
                if (Trace.traceOn_) {
                    Trace.log(4, "Unable to determine owner of directory.", (Throwable)extendedIOException);
                }
            }
            throw extendedIOException;
        }
        return string == null ? "" : string;
    }

    public long getOwnerUID() throws IOException, AS400SecurityException {
        this.fd_.connect();
        IFSListAttrsRep iFSListAttrsRep = this.fd_.listObjAttrs2();
        if (iFSListAttrsRep != null) {
            return iFSListAttrsRep.getOwnerUID();
        }
        return -1L;
    }

    public String getSubtype() throws IOException, AS400SecurityException {
        String string = "";
        this.fd_.connect();
        byte[] byArray = this.fd_.converter_.stringToByteArray(this.fd_.path_);
        byte[] byArray2 = this.fd_.converter_.stringToByteArray(".TYPE");
        IFSListAttrsReq iFSListAttrsReq = new IFSListAttrsReq(byArray, this.fd_.preferredServerCCSID_, 0, -1, null, false, byArray2, false, this.fd_.patternMatching_);
        Vector vector = this.fd_.listAttributes(iFSListAttrsReq);
        if (vector == null) {
            if (Trace.traceOn_) {
                Trace.log(4, "Received null from listAttributes(req).");
            }
        } else if (vector.size() == 0) {
            if (Trace.traceOn_) {
                Trace.log(4, "Received no replies from listAttributes(req).");
            }
        } else {
            IFSListAttrsRep iFSListAttrsRep;
            byte[] byArray3;
            if (vector.size() > 1 && Trace.traceOn_) {
                Trace.log(4, "Received multiple replies from listAttributes(req) (" + vector.size() + ")");
            }
            if ((byArray3 = (iFSListAttrsRep = (IFSListAttrsRep)vector.elementAt(0)).getExtendedAttributeValue()) != null) {
                string = new CharConverter(37).byteArrayToString(byArray3).trim();
            }
        }
        return string;
    }

    public int isDirectory() throws IOException, AS400SecurityException {
        this.fd_.connect();
        int n = 2;
        if (this.attributesReply_ == null) {
            try {
                this.attributesReply_ = this.getAttributeSetFromServer(this.fd_.path_);
            }
            catch (AS400SecurityException aS400SecurityException) {
                n = 5;
            }
        }
        if (this.attributesReply_ != null && this.determineIsDirectory(this.attributesReply_)) {
            n = 0;
        }
        return n;
    }

    public int isFile() throws IOException, AS400SecurityException {
        this.fd_.connect();
        int n = 2;
        if (this.attributesReply_ == null) {
            try {
                this.attributesReply_ = this.getAttributeSetFromServer(this.fd_.path_);
            }
            catch (AS400SecurityException aS400SecurityException) {
                n = 5;
            }
        }
        if (this.attributesReply_ != null && this.determineIsFile(this.attributesReply_)) {
            n = 0;
        }
        return n;
    }

    public boolean isHidden() throws IOException, AS400SecurityException {
        this.fd_.connect();
        boolean bl = false;
        if (this.attributesReply_ == null) {
            this.attributesReply_ = this.getAttributeSetFromServer(this.fd_.path_);
        }
        if (this.attributesReply_ != null) {
            bl = (this.attributesReply_.getFixedAttributes() & 2) != 0;
        }
        return bl;
    }

    public boolean isReadOnly() throws IOException, AS400SecurityException {
        this.fd_.connect();
        boolean bl = false;
        if (this.attributesReply_ == null) {
            this.attributesReply_ = this.getAttributeSetFromServer(this.fd_.path_);
        }
        if (this.attributesReply_ != null) {
            bl = (this.attributesReply_.getFixedAttributes() & 1) != 0;
        }
        return bl;
    }

    public boolean isSymbolicLink() throws IOException, AS400SecurityException {
        this.fd_.connect();
        if (Trace.traceOn_ && this.fd_.getSystemVRM() < 328448) {
            Trace.log(4, "Server is V5R2 or lower, so isSymbolicLink() will always report false.");
            return false;
        }
        if (!this.determinedIsSymbolicLink_) {
            int n = this.fd_.path_.length();
            if (n <= 1) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Path length is less than 2, so assuming not a symbolic link: " + this.fd_.path_);
                }
                this.isSymbolicLink_ = false;
                this.determinedIsSymbolicLink_ = true;
            } else {
                StringBuffer stringBuffer = new StringBuffer(this.fd_.path_);
                stringBuffer.setCharAt(n - 1, '*');
                String string = stringBuffer.toString();
                String string2 = string.substring(0, 1 + string.lastIndexOf(47));
                byte[] byArray = this.fd_.converter_.stringToByteArray(string);
                IFSCachedAttributes[] iFSCachedAttributesArray = this.listDirectoryDetails(string, string2, -1, byArray, true, false);
                IFSCachedAttributes iFSCachedAttributes = null;
                String string3 = this.fd_.path_.substring(1 + this.fd_.path_.lastIndexOf(47));
                for (int i = 0; iFSCachedAttributes == null && i < iFSCachedAttributesArray.length; ++i) {
                    if (!iFSCachedAttributesArray[i].name_.equals(string3)) continue;
                    iFSCachedAttributes = iFSCachedAttributesArray[i];
                }
                if (iFSCachedAttributes != null) {
                    this.isSymbolicLink_ = iFSCachedAttributes.isSymbolicLink_;
                    this.determinedIsSymbolicLink_ = true;
                } else {
                    if (Trace.traceOn_) {
                        Trace.log(2, "Received zero matches from listDirectoryDetails() against parent of " + string.toString());
                    }
                    this.isSymbolicLink_ = false;
                    this.determinedIsSymbolicLink_ = true;
                }
            }
        }
        return this.isSymbolicLink_;
    }

    public long lastAccessed() throws IOException, AS400SecurityException {
        this.fd_.connect();
        long l = 0L;
        IFSListAttrsRep iFSListAttrsRep = this.getAttributeSetFromServer(this.fd_.path_);
        if (iFSListAttrsRep != null) {
            this.attributesReply_ = iFSListAttrsRep;
            l = iFSListAttrsRep.getAccessDate();
        }
        return l;
    }

    public long lastModified() throws IOException, AS400SecurityException {
        this.fd_.connect();
        long l = 0L;
        IFSListAttrsRep iFSListAttrsRep = this.getAttributeSetFromServer(this.fd_.path_);
        if (iFSListAttrsRep != null) {
            this.attributesReply_ = iFSListAttrsRep;
            l = iFSListAttrsRep.getModificationDate();
        }
        return l;
    }

    public long length() throws IOException, AS400SecurityException {
        this.fd_.connect();
        long l = 0L;
        if (this.fd_.getSystemVRM() >> 8 != 1282) {
            IFSListAttrsRep iFSListAttrsRep = this.getAttributeSetFromServer(this.fd_.path_);
            if (iFSListAttrsRep != null) {
                this.attributesReply_ = iFSListAttrsRep;
                l = iFSListAttrsRep.getSize(this.fd_.serverDatastreamLevel_);
            }
        } else {
            byte[] byArray = this.fd_.converter_.stringToByteArray(this.fd_.path_);
            IFSListAttrsReq iFSListAttrsReq = new IFSListAttrsReq(byArray, this.fd_.preferredServerCCSID_, 0, -1, null, true, null, true, this.fd_.patternMatching_);
            Vector vector = this.fd_.listAttributes(iFSListAttrsReq);
            if (vector == null) {
                if (this.fd_.errorRC_ != 0) {
                    throw new ExtendedIOException(this.fd_.path_, this.fd_.errorRC_);
                }
                throw new InternalErrorException(6);
            }
            if (vector.size() == 0) {
                if (Trace.traceOn_) {
                    Trace.log(4, "Received no replies from listAttributes(req).");
                }
            } else {
                if (vector.size() > 1 && Trace.traceOn_) {
                    Trace.log(4, "Received multiple replies from listAttributes(req) (" + vector.size() + ")");
                }
                IFSListAttrsRep iFSListAttrsRep = (IFSListAttrsRep)vector.elementAt(0);
                l = iFSListAttrsRep.getSize8Bytes();
            }
        }
        return l;
    }

    private Vector listAttributes(String string, int n, byte[] byArray, boolean bl, boolean bl2) throws IOException, AS400SecurityException {
        byte[] byArray2 = this.fd_.converter_.stringToByteArray(string);
        IFSListAttrsReq iFSListAttrsReq = new IFSListAttrsReq(byArray2, this.fd_.preferredServerCCSID_, 0, n, byArray, bl, null, false, this.fd_.patternMatching_);
        if (bl2) {
            iFSListAttrsReq.setSorted(true);
        }
        return this.fd_.listAttributes(iFSListAttrsReq);
    }

    public String[] listDirectoryContents(String string) throws IOException, AS400SecurityException {
        this.fd_.connect();
        Vector vector = this.listAttributes(string, -1, null, true, this.sortLists_);
        String[] stringArray = null;
        if (vector != null) {
            stringArray = new String[vector.size()];
            int n = 0;
            for (int i = 0; i < vector.size(); ++i) {
                IFSListAttrsRep iFSListAttrsRep = (IFSListAttrsRep)vector.elementAt(i);
                String string2 = this.fd_.converter_.byteArrayToString(iFSListAttrsRep.getName());
                if (string2.equals(".") || string2.equals("..")) continue;
                stringArray[n++] = string2;
            }
            if (n == 0) {
                stringArray = new String[]{};
            } else if (stringArray.length != n) {
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                stringArray = stringArray2;
            }
        }
        return stringArray;
    }

    private IFSCachedAttributes[] listDirectoryDetails(String string, String string2, int n, byte[] byArray, boolean bl, boolean bl2) throws IOException, AS400SecurityException {
        this.fd_.connect();
        IFSCachedAttributes[] iFSCachedAttributesArray = null;
        try {
            Vector vector = this.listAttributes(string, n, byArray, bl, bl2);
            int n2 = 0;
            if (vector != null) {
                iFSCachedAttributesArray = new IFSCachedAttributes[vector.size()];
                int n3 = this.fd_.serverDatastreamLevel_;
                for (int i = 0; i < vector.size(); ++i) {
                    IFSListAttrsRep iFSListAttrsRep = (IFSListAttrsRep)vector.elementAt(i);
                    String string3 = this.fd_.converter_.byteArrayToString(iFSListAttrsRep.getName());
                    if (string3.equals(".") || string3.equals("..")) continue;
                    boolean bl3 = this.determineIsDirectory(iFSListAttrsRep);
                    boolean bl4 = this.determineIsFile(iFSListAttrsRep);
                    IFSCachedAttributes iFSCachedAttributes = new IFSCachedAttributes(iFSListAttrsRep.getAccessDate(), iFSListAttrsRep.getCreationDate(), iFSListAttrsRep.getFixedAttributes(), iFSListAttrsRep.getModificationDate(), iFSListAttrsRep.getObjectType(), iFSListAttrsRep.getSize(n3), string3, string2, bl3, bl4, iFSListAttrsRep.getRestartID(), iFSListAttrsRep.isSymbolicLink(n3));
                    iFSCachedAttributesArray[n2++] = iFSCachedAttributes;
                }
            }
            if (n2 == 0) {
                iFSCachedAttributesArray = new IFSCachedAttributes[]{};
            } else if (iFSCachedAttributesArray.length != n2) {
                IFSCachedAttributes[] iFSCachedAttributesArray2 = new IFSCachedAttributes[n2];
                System.arraycopy(iFSCachedAttributesArray, 0, iFSCachedAttributesArray2, 0, n2);
                iFSCachedAttributesArray = iFSCachedAttributesArray2;
            }
        }
        catch (AS400SecurityException aS400SecurityException) {
            iFSCachedAttributesArray = null;
            throw aS400SecurityException;
        }
        return iFSCachedAttributesArray;
    }

    public IFSCachedAttributes[] listDirectoryDetails(String string, String string2, int n, String string3) throws IOException, AS400SecurityException {
        byte[] byArray = this.fd_.converter_.stringToByteArray(string3);
        return this.listDirectoryDetails(string, string2, n, byArray, true, this.sortLists_);
    }

    public IFSCachedAttributes[] listDirectoryDetails(String string, String string2, int n, byte[] byArray, boolean bl) throws IOException, AS400SecurityException {
        boolean bl2 = bl ? this.sortLists_ : false;
        return this.listDirectoryDetails(string, string2, n, byArray, false, bl2);
    }

    public int mkdir(String string) throws IOException, AS400SecurityException {
        int n;
        block5: {
            this.fd_.connect();
            n = 2;
            try {
                byte[] byArray = this.fd_.converter_.stringToByteArray(string);
                IFSCreateDirReq iFSCreateDirReq = new IFSCreateDirReq(byArray, this.fd_.preferredServerCCSID_);
                ClientAccessDataStream clientAccessDataStream = (ClientAccessDataStream)this.fd_.server_.sendAndReceive(iFSCreateDirReq);
                if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                    n = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                    if (n == 5 || n == 13) {
                        throw new AS400SecurityException(1);
                    }
                    break block5;
                }
                Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.data_);
                throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
            }
            catch (ConnectionDroppedException connectionDroppedException) {
                Trace.log(2, "Byte stream server connection lost.");
                this.fd_.connectionDropped(connectionDroppedException);
            }
            catch (InterruptedException interruptedException) {
                Trace.log(2, "Interrupted");
                throw new InterruptedIOException(interruptedException.getMessage());
            }
        }
        return n;
    }

    public int mkdirs() throws IOException, AS400SecurityException {
        this.fd_.connect();
        boolean bl = false;
        Vector<String> vector = new Vector<String>();
        String string = this.fd_.path_;
        int n = 2;
        n = this.exists(string);
        if (n != 0) {
            do {
                vector.addElement(string);
            } while ((string = IFSFile.getParent(string)) != null && this.exists(string) != 0);
        } else {
            n = 4;
        }
        for (int i = vector.size(); i > 0 && (n = this.mkdir(string = (String)vector.elementAt(i - 1))) == 0; --i) {
        }
        return n;
    }

    public int renameTo(IFSFileImpl iFSFileImpl) throws IOException, AS400SecurityException {
        this.fd_.connect();
        boolean bl = false;
        ClientAccessDataStream clientAccessDataStream = null;
        IFSFileImplRemote iFSFileImplRemote = (IFSFileImplRemote)iFSFileImpl;
        try {
            byte[] byArray = this.fd_.converter_.stringToByteArray(this.fd_.path_);
            byte[] byArray2 = this.fd_.converter_.stringToByteArray(iFSFileImplRemote.getAbsolutePath());
            IFSRenameReq iFSRenameReq = new IFSRenameReq(byArray, byArray2, this.fd_.preferredServerCCSID_, false);
            clientAccessDataStream = (ClientAccessDataStream)this.fd_.server_.sendAndReceive(iFSRenameReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "Byte stream server connection lost.");
            this.fd_.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted");
            throw new InterruptedIOException(interruptedException.getMessage());
        }
        int n = 2;
        if (clientAccessDataStream instanceof IFSReturnCodeRep) {
            n = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
            if (n == 0) {
                bl = true;
            } else if (Trace.traceOn_) {
                Trace.log(2, "Error renaming file: IFSReturnCodeRep return code = ", n);
            }
        } else {
            Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.data_);
            throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
        }
        if (bl) {
            this.fd_.path_ = iFSFileImplRemote.getAbsolutePath();
            this.attributesReply_ = null;
        }
        return n;
    }

    public boolean setCCSID(int n) throws IOException, AS400SecurityException {
        this.fd_.connect();
        IFSListAttrsRep iFSListAttrsRep = this.fd_.listObjAttrs2();
        if (iFSListAttrsRep == null) {
            if (this.fd_.errorRC_ != 0) {
                throw new ExtendedIOException(this.fd_.path_, this.fd_.errorRC_);
            }
            throw new InternalErrorException(6);
        }
        boolean bl = false;
        IFSObjAttrs2 iFSObjAttrs2 = iFSListAttrsRep.getObjAttrs2();
        if (Trace.traceOn_) {
            Trace.log(1, "Length of returned OA2* structure (should be 144 or 160): " + iFSObjAttrs2.length());
        }
        iFSObjAttrs2.setCCSID(n, this.fd_.serverDatastreamLevel_);
        ClientAccessDataStream clientAccessDataStream = null;
        try {
            byte[] byArray = this.fd_.converter_.stringToByteArray(this.fd_.path_);
            IFSChangeAttrsReq iFSChangeAttrsReq = new IFSChangeAttrsReq(byArray, this.fd_.preferredServerCCSID_, iFSObjAttrs2, this.fd_.serverDatastreamLevel_);
            clientAccessDataStream = (ClientAccessDataStream)this.fd_.server_.sendAndReceive(iFSChangeAttrsReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "Byte stream server connection lost.");
            this.fd_.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted");
            throw new InterruptedIOException(interruptedException.getMessage());
        }
        if (clientAccessDataStream instanceof IFSReturnCodeRep) {
            int n2 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
            if (n2 == 0) {
                bl = true;
                this.fd_.setCCSID(n);
            } else if (Trace.traceOn_) {
                Trace.log(2, "Error setting file data CCSID: IFSReturnCodeRep return code = ", n2);
            }
        } else {
            Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.data_);
            throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
        }
        return bl;
    }

    public boolean setFixedAttributes(int n) throws IOException {
        try {
            this.fd_.connect();
        }
        catch (AS400SecurityException aS400SecurityException) {
            throw new ExtendedIOException(this.fd_.path_, 5);
        }
        ClientAccessDataStream clientAccessDataStream = null;
        try {
            byte[] byArray = this.fd_.converter_.stringToByteArray(this.fd_.path_);
            IFSChangeAttrsReq iFSChangeAttrsReq = new IFSChangeAttrsReq(byArray, this.fd_.preferredServerCCSID_, n, true, this.fd_.serverDatastreamLevel_);
            clientAccessDataStream = (ClientAccessDataStream)this.fd_.server_.sendAndReceive(iFSChangeAttrsReq);
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "Byte stream server connection lost.");
            this.fd_.connectionDropped(connectionDroppedException);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Interrupted");
            throw new InterruptedIOException(interruptedException.getMessage());
        }
        boolean bl = false;
        if (clientAccessDataStream instanceof IFSReturnCodeRep) {
            int n2 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
            if (n2 == 0) {
                bl = true;
            } else if (Trace.traceOn_) {
                Trace.log(2, "Error setting file attributes: IFSReturnCodeRep return code = ", n2);
            }
        } else {
            Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.data_);
            throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
        }
        this.attributesReply_ = null;
        return bl;
    }

    public boolean setHidden(boolean bl) throws IOException {
        try {
            this.fd_.connect();
        }
        catch (AS400SecurityException aS400SecurityException) {
            throw new ExtendedIOException(this.fd_.path_, 5);
        }
        boolean bl2 = false;
        IFSListAttrsRep iFSListAttrsRep = null;
        try {
            iFSListAttrsRep = this.getAttributeSetFromServer(this.fd_.path_);
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, "Failed to get attribute set", (Throwable)aS400SecurityException);
            throw new ExtendedIOException(this.fd_.path_, 5);
        }
        if (iFSListAttrsRep != null) {
            boolean bl3;
            int n = iFSListAttrsRep.getFixedAttributes();
            boolean bl4 = bl3 = (n & 2) != 0;
            if (bl3 != bl) {
                int n2 = bl ? n + 2 : n & 0x7FFFFFFD;
                ClientAccessDataStream clientAccessDataStream = null;
                try {
                    byte[] byArray = this.fd_.converter_.stringToByteArray(this.fd_.path_);
                    IFSChangeAttrsReq iFSChangeAttrsReq = new IFSChangeAttrsReq(byArray, this.fd_.preferredServerCCSID_, n2, true, this.fd_.serverDatastreamLevel_);
                    clientAccessDataStream = (ClientAccessDataStream)this.fd_.server_.sendAndReceive(iFSChangeAttrsReq);
                }
                catch (ConnectionDroppedException connectionDroppedException) {
                    Trace.log(2, "Byte stream server connection lost.");
                    this.fd_.connectionDropped(connectionDroppedException);
                }
                catch (InterruptedException interruptedException) {
                    Trace.log(2, "Interrupted");
                    throw new InterruptedIOException(interruptedException.getMessage());
                }
                if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                    int n3 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                    if (n3 == 0) {
                        bl2 = true;
                    } else if (Trace.traceOn_) {
                        Trace.log(2, "Error setting hidden attribute: IFSReturnCodeRep return code = ", n3);
                    }
                } else {
                    Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.data_);
                    throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
                }
                this.attributesReply_ = null;
            } else {
                bl2 = true;
            }
        }
        return bl2;
    }

    public boolean setLastModified(long l) throws IOException {
        int n = -1;
        boolean bl = false;
        try {
            this.fd_.connect();
            if (l == -1L) {
                n = this.fd_.createFileHandle(2, 8);
                if (n == -1) {
                    boolean bl2 = false;
                    return bl2;
                }
                this.fd_.setOpen(true, n);
                byte[] byArray = new byte[1];
                boolean bl3 = false;
                if (l == -1L) {
                    boolean bl4 = bl3 = this.length() == 0L;
                }
                if (bl3) {
                    this.fd_.writeBytes(byArray, 0, 1, true);
                    bl = this.fd_.setLength(0L);
                } else if (1 == this.fd_.read(byArray, 0, 1)) {
                    this.fd_.setFileOffset(0L);
                    this.fd_.writeBytes(byArray, 0, 1, true);
                    bl = true;
                } else {
                    if (Trace.traceOn_) {
                        Trace.log(2, "Failed to read first byte of file.");
                    }
                    bl = false;
                }
            } else {
                ClientAccessDataStream clientAccessDataStream = null;
                try {
                    byte[] byArray = this.fd_.converter_.stringToByteArray(this.fd_.path_);
                    IFSChangeAttrsReq iFSChangeAttrsReq = new IFSChangeAttrsReq(byArray, this.fd_.preferredServerCCSID_, 0L, l, 0L, this.fd_.serverDatastreamLevel_);
                    clientAccessDataStream = (ClientAccessDataStream)this.fd_.server_.sendAndReceive(iFSChangeAttrsReq);
                }
                catch (ConnectionDroppedException connectionDroppedException) {
                    Trace.log(2, "Byte stream server connection lost.");
                    this.fd_.connectionDropped(connectionDroppedException);
                }
                catch (InterruptedException interruptedException) {
                    Trace.log(2, "Interrupted");
                    throw new InterruptedIOException(interruptedException.getMessage());
                }
                if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                    int n2 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                    if (n2 == 0) {
                        bl = true;
                    } else if (Trace.traceOn_) {
                        Trace.log(2, "Error setting last-modified date: IFSReturnCodeRep return code = ", n2);
                    }
                } else {
                    Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.data_);
                    throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
                }
            }
            this.attributesReply_ = null;
        }
        catch (AS400SecurityException aS400SecurityException) {
            throw new ExtendedIOException(this.fd_.path_, 5);
        }
        finally {
            if (n != -1) {
                this.fd_.close(n);
            }
        }
        return bl;
    }

    public boolean setLength(int n) throws IOException, AS400SecurityException {
        try {
            this.fd_.connect();
        }
        catch (AS400SecurityException aS400SecurityException) {
            throw new ExtendedIOException(this.fd_.path_, 5);
        }
        this.attributesReply_ = null;
        return this.fd_.setLength(n);
    }

    public void setPath(String string) {
        if (this.fd_.server_ != null) {
            throw new ExtendedIllegalStateException("path", 5);
        }
        String string2 = string.length() == 0 || string.charAt(0) != '/' ? "/" + string : string;
        this.fd_.path_ = string2;
    }

    private static final void setPassByReference(ProgramParameter programParameter) {
        try {
            programParameter.setParameterType(2);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void setPatternMatching(int n) {
        this.fd_.patternMatching_ = n;
    }

    public boolean setReadOnly(boolean bl) throws IOException {
        try {
            this.fd_.connect();
        }
        catch (AS400SecurityException aS400SecurityException) {
            throw new ExtendedIOException(this.fd_.path_, 5);
        }
        boolean bl2 = false;
        IFSListAttrsRep iFSListAttrsRep = null;
        try {
            iFSListAttrsRep = this.getAttributeSetFromServer(this.fd_.path_);
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, "Failed to get attribute set", (Throwable)aS400SecurityException);
            throw new ExtendedIOException(this.fd_.path_, 5);
        }
        if (iFSListAttrsRep != null) {
            boolean bl3;
            int n = iFSListAttrsRep.getFixedAttributes();
            boolean bl4 = bl3 = (n & 1) != 0;
            if (bl3 != bl) {
                int n2 = bl ? n + 1 : n & 0x7FFFFFFE;
                ClientAccessDataStream clientAccessDataStream = null;
                try {
                    byte[] byArray = this.fd_.converter_.stringToByteArray(this.fd_.path_);
                    IFSChangeAttrsReq iFSChangeAttrsReq = new IFSChangeAttrsReq(byArray, this.fd_.preferredServerCCSID_, n2, true, this.fd_.serverDatastreamLevel_);
                    clientAccessDataStream = (ClientAccessDataStream)this.fd_.server_.sendAndReceive(iFSChangeAttrsReq);
                }
                catch (ConnectionDroppedException connectionDroppedException) {
                    Trace.log(2, "Byte stream server connection lost.");
                    this.fd_.connectionDropped(connectionDroppedException);
                }
                catch (InterruptedException interruptedException) {
                    Trace.log(2, "Interrupted");
                    throw new InterruptedIOException(interruptedException.getMessage());
                }
                if (clientAccessDataStream instanceof IFSReturnCodeRep) {
                    int n3 = ((IFSReturnCodeRep)clientAccessDataStream).getReturnCode();
                    if (n3 == 0) {
                        bl2 = true;
                    } else if (Trace.traceOn_) {
                        Trace.log(2, "Error setting read-only attribute: IFSReturnCodeRep return code = ", n3);
                    }
                } else {
                    Trace.log(2, "Unknown reply data stream ", clientAccessDataStream.data_);
                    throw new InternalErrorException(Integer.toHexString(clientAccessDataStream.getReqRepID()), 2);
                }
                this.attributesReply_ = null;
            } else {
                bl2 = true;
            }
        }
        return bl2;
    }

    public void setSorted(boolean bl) {
        this.sortLists_ = bl;
    }

    public void setSystem(AS400Impl aS400Impl) {
        this.fd_.system_ = (AS400ImplRemote)aS400Impl;
    }

    static {
        AS400Server.addReplyStream((DataStream)new IFSListAttrsRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSOpenRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSCreateDirHandleRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSQuerySpaceRep(), 0);
        AS400Server.addReplyStream((DataStream)new IFSReturnCodeRep(), 0);
    }
}

