/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.DBStorage;
import com.ibm.as400.access.JDTrace;

class DBStoragePool {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private DBStorage[] pool_ = new DBStorage[16];

    DBStoragePool() {
    }

    final synchronized DBStorage getUnusedStorage() {
        int n = this.pool_.length;
        for (int i = 0; i < n; ++i) {
            DBStorage dBStorage = this.pool_[i];
            if (dBStorage == null) {
                dBStorage = new DBStorage();
                dBStorage.inUse_ = true;
                this.pool_[i] = dBStorage;
                return dBStorage;
            }
            if (dBStorage.inUse_) continue;
            dBStorage.inUse_ = true;
            return dBStorage;
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "Creating new DBStoragePool of size " + n * 2);
        }
        DBStorage[] dBStorageArray = new DBStorage[n * 2];
        for (int i = 0; i < n; ++i) {
            dBStorageArray[i] = this.pool_[i];
        }
        DBStorage dBStorage = new DBStorage();
        dBStorage.inUse_ = true;
        dBStorageArray[n] = dBStorage;
        this.pool_ = dBStorageArray;
        return dBStorage;
    }
}

