/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.CADSPool;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

class ClientAccessDataStream
extends DataStream {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    protected static final int HEADER_LENGTH = 20;
    private static final CADSPool basePool_ = new CADSPool();
    boolean inUse_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final ClientAccessDataStream construct(InputStream inputStream, Hashtable hashtable, Hashtable hashtable2, AS400ImplRemote aS400ImplRemote) throws IOException {
        ClientAccessDataStream clientAccessDataStream = basePool_.getUnusedStream();
        try {
            ClientAccessDataStream clientAccessDataStream2;
            if (DataStream.readFromStream(inputStream, clientAccessDataStream.data_, 0, 20) < 20) {
                if (Trace.traceOn_) {
                    Trace.log(2, "Failed to read all of the data stream header.");
                }
                clientAccessDataStream.inUse_ = false;
                throw new ConnectionDroppedException(2);
            }
            if (clientAccessDataStream.data_[6] != -32) {
                if (Trace.traceOn_) {
                    Trace.log(2, "Incorrect data stream header detected.");
                }
                clientAccessDataStream.inUse_ = false;
                throw new InternalErrorException(2);
            }
            ClientAccessDataStream clientAccessDataStream3 = (ClientAccessDataStream)hashtable.remove(clientAccessDataStream);
            if (clientAccessDataStream3 == null) {
                clientAccessDataStream2 = (ClientAccessDataStream)hashtable2.get(clientAccessDataStream);
                if (clientAccessDataStream2 == null) {
                    clientAccessDataStream3 = new ClientAccessDataStream();
                } else {
                    clientAccessDataStream3 = (ClientAccessDataStream)clientAccessDataStream2.getNewDataStream();
                    if (clientAccessDataStream3 == null) {
                        clientAccessDataStream3 = new ClientAccessDataStream();
                    }
                }
            }
            clientAccessDataStream3.system_ = aS400ImplRemote;
            clientAccessDataStream3.data_ = new byte[clientAccessDataStream.getLength()];
            System.arraycopy(clientAccessDataStream.data_, 0, clientAccessDataStream3.data_, 0, 20);
            if (clientAccessDataStream3.data_.length - 20 > 0) {
                clientAccessDataStream3.readAfterHeader(inputStream);
            }
            clientAccessDataStream2 = clientAccessDataStream3;
            return clientAccessDataStream2;
        }
        finally {
            clientAccessDataStream.inUse_ = false;
        }
    }

    ClientAccessDataStream() {
        super(20);
    }

    ClientAccessDataStream(byte[] byArray) {
        super(20, byArray);
    }

    int getCorrelation() {
        return this.get32bit(12);
    }

    int getCSInstance() {
        return this.get32bit(8);
    }

    int getHeaderID() {
        return this.get16bit(4);
    }

    int getLength() {
        return this.get32bit(0);
    }

    int getReqRepID() {
        return ((this.data_[18] & 0xFF) << 8) + (this.data_[19] & 0xFF);
    }

    int getServerID() {
        return this.get16bit(6);
    }

    int getTemplateLen() {
        return this.get16bit(16);
    }

    public int hashCode() {
        return ((this.data_[18] & 0xFF) << 8) + (this.data_[19] & 0xFF);
    }

    void setCorrelation(int n) {
        this.set32bit(n, 12);
    }

    void setCSInstance(int n) {
        this.set32bit(n, 8);
    }

    void setHeaderID(int n) {
        this.set16bit(n, 4);
    }

    void setLength(int n) {
        this.data_[0] = (byte)(n >>> 24);
        this.data_[1] = (byte)(n >>> 16);
        this.data_[2] = (byte)(n >>> 8);
        this.data_[3] = (byte)n;
    }

    void setReqRepID(int n) {
        this.set16bit(n, 18);
    }

    void setServerID(int n) {
        this.set16bit(n, 6);
    }

    void setTemplateLen(int n) {
        this.set16bit(n, 16);
    }
}

