/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.teradatabulkloader;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.ui.core.PropsUI;

class RadioComposite
extends Composite {
    private final PropsUI props;
    private final BaseStepMeta baseStepMeta;
    private Listener lsActionType;
    private final List<Listener> listeners = new ArrayList<Listener>();

    RadioComposite(PropsUI props, BaseStepMeta baseStepMeta, Composite parent, int opts) {
        super(parent, opts);
        this.props = props;
        this.baseStepMeta = baseStepMeta;
        this.lsActionType = new Listener(){

            public void handleEvent(Event event) {
                Control[] children = RadioComposite.this.getChildren();
                for (int j = 0; j < children.length; ++j) {
                    Control child = children[j];
                    if (!(child instanceof Button)) continue;
                    Button bc = (Button)child;
                    bc.setSelection(false);
                }
                Button button = (Button)event.widget;
                button.setSelection(true);
                RadioComposite.this.baseStepMeta.setChanged();
            }
        };
    }

    public void addListener(Listener ls) {
        this.listeners.add(ls);
    }

    public void addButtons(String[] labels) {
        for (int i = 0; i < labels.length; ++i) {
            this.addButton(labels[i]);
        }
    }

    public void addButton(String label) {
        Button button = new Button((Composite)this, 131088);
        button.setText(label);
        this.props.setLook((Control)button);
        button.addListener(13, this.lsActionType);
        button.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                for (Listener listener : RadioComposite.this.listeners) {
                    listener.handleEvent(arg0);
                }
            }
        });
    }

    public int getSelection() {
        Control[] children = this.getChildren();
        for (int j = 0; j < children.length; ++j) {
            Button bc;
            Control child = children[j];
            if (!(child instanceof Button) || !(bc = (Button)child).getSelection()) continue;
            return j;
        }
        return 0;
    }

    public void setSelection(int index) {
        Control[] children = this.getChildren();
        for (int j = 0; j < children.length; ++j) {
            Control child = children[j];
            if (!(child instanceof Button)) continue;
            Button bc = (Button)child;
            if (j == index) {
                bc.setSelection(true);
                continue;
            }
            bc.setSelection(false);
        }
        Event event = new Event();
        this.notifyListeners(2, event);
        for (Listener listener : this.listeners) {
            listener.handleEvent(event);
        }
    }

    public void setCallback(final Runnable callback) {
        this.addListener(new Listener(){

            public void handleEvent(Event event) {
                callback.run();
            }
        });
    }
}

