/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.teradatabulkloader;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.pentaho.di.core.Const;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.trans.steps.teradatabulkloader.RadioComposite;
import org.pentaho.di.ui.trans.steps.teradatabulkloader.TeraDataBulkLoaderDialog;
import org.pentaho.di.ui.trans.steps.teradatabulkloader.TextVarMenuItem;

class CompositeMenuItem {
    private final PropsUI props;
    private final ModifyListener lsMod;
    private final Listener lsModSelect;
    private final BaseStepMeta baseStepMeta;
    private Label label;
    private Composite composite;
    private List<Control> items = new ArrayList<Control>();
    int margin = 4;
    final int middle;

    CompositeMenuItem(PropsUI props, ModifyListener lsMod, Listener lsModSelect, BaseStepMeta baseStepMeta, Composite parent, TextVarMenuItem top, String labelProp, int type) {
        this(props, lsMod, lsModSelect, baseStepMeta, parent, top.getButton(), labelProp, type);
    }

    CompositeMenuItem(PropsUI props, ModifyListener lsMod, Listener lsModSelect, BaseStepMeta baseStepMeta, Composite parent, Control top, String labelProp, int type) {
        this.props = props;
        this.middle = props.getMiddlePct();
        this.lsMod = lsMod;
        this.lsModSelect = lsModSelect;
        this.baseStepMeta = baseStepMeta;
        this.label = new Label(parent, 131072);
        this.label.setText(BaseMessages.getString(TeraDataBulkLoaderDialog.PKG, (String)labelProp, (String[])new String[0]));
        FormData fdl = new FormData();
        fdl.left = new FormAttachment(0, this.margin);
        fdl.top = top == null ? new FormAttachment(0, this.margin) : new FormAttachment(top, this.margin);
        fdl.right = new FormAttachment(this.middle, -this.margin);
        props.setLook((Control)this.label);
        this.label.setLayoutData((Object)fdl);
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new FormLayout());
        FormData fdc = new FormData();
        fdc.left = new FormAttachment((Control)this.label, 0);
        fdc.top = top == null ? new FormAttachment(0, 0) : new FormAttachment(top, 0);
        fdc.right = new FormAttachment(100, 0);
        this.composite.setLayoutData((Object)fdc);
        props.setLook((Control)this.composite);
    }

    public Composite getComposite() {
        return this.composite;
    }

    public void add(Control item) {
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, this.margin);
        fd.left = this.items.size() > 0 ? new FormAttachment(this.items.get(this.items.size() - 1), this.margin) : new FormAttachment(0, this.margin);
        item.setLayoutData((Object)fd);
        this.props.setLook(item);
        this.items.add(item);
    }

    public CCombo addCCombo() {
        CCombo combo = new CCombo(this.composite, 2056);
        combo.setEditable(true);
        this.props.setLook((Control)combo);
        combo.addModifyListener(this.lsMod);
        this.add((Control)combo);
        return combo;
    }

    public Button addButton(String label, int radio) {
        Button button = new Button(this.composite, radio | 0x20000);
        if (!Const.isEmpty((String)label)) {
            button.setText(BaseMessages.getString(TeraDataBulkLoaderDialog.PKG, (String)label, (String[])new String[0]));
        }
        button.addListener(32, this.lsModSelect);
        this.props.setLook((Control)button);
        this.add((Control)button);
        return button;
    }

    public RadioComposite addRadioComposite(String[] labels, int opts, Object p, final Runnable callback) {
        RadioComposite rc = new RadioComposite(this.props, this.baseStepMeta, this.composite, opts);
        RowLayout layout = new RowLayout();
        rc.setLayout((Layout)layout);
        layout.spacing = 10;
        if (callback != null) {
            rc.addListener(new Listener(){

                public void handleEvent(Event event) {
                    callback.run();
                }
            });
        }
        rc.addButtons(labels);
        this.add((Control)rc);
        return rc;
    }

    public Label addLabel(String label) {
        Label lbl = new Label(this.composite, 16384);
        lbl.setText(BaseMessages.getString(TeraDataBulkLoaderDialog.PKG, (String)label, (String[])new String[0]));
        this.props.setLook((Control)lbl);
        this.add((Control)lbl);
        return lbl;
    }

    public void setVisible(boolean b) {
        this.label.setVisible(b);
        this.composite.setVisible(b);
    }
}

