/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v231.group.VXR_V03_OBXNTE;
import ca.uhn.hl7v2.model.v231.segment.ORC;
import ca.uhn.hl7v2.model.v231.segment.RXA;
import ca.uhn.hl7v2.model.v231.segment.RXR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class VXR_V03_ORCRXARXROBXNTE
extends AbstractGroup {
    public VXR_V03_ORCRXARXROBXNTE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, false, false);
            this.add(RXA.class, true, false);
            this.add(RXR.class, false, false);
            this.add(VXR_V03_OBXNTE.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating VXR_V03_ORCRXARXROBXNTE - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3.1";
    }

    public ORC getORC() {
        ORC ret = null;
        try {
            ret = (ORC)this.get("ORC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RXA getRXA() {
        RXA ret = null;
        try {
            ret = (RXA)this.get("RXA");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RXR getRXR() {
        RXR ret = null;
        try {
            ret = (RXR)this.get("RXR");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public VXR_V03_OBXNTE getOBXNTE() {
        VXR_V03_OBXNTE ret = null;
        try {
            ret = (VXR_V03_OBXNTE)this.get("OBXNTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public VXR_V03_OBXNTE getOBXNTE(int rep) {
        VXR_V03_OBXNTE ret = null;
        try {
            ret = (VXR_V03_OBXNTE)this.get("OBXNTE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getOBXNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("OBXNTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertOBXNTE(VXR_V03_OBXNTE structure, int rep) throws HL7Exception {
        super.insertRepetition("OBXNTE", (Structure)structure, rep);
    }

    public VXR_V03_OBXNTE insertOBXNTE(int rep) throws HL7Exception {
        return (VXR_V03_OBXNTE)super.insertRepetition("OBXNTE", rep);
    }

    public VXR_V03_OBXNTE removeOBXNTE(int rep) throws HL7Exception {
        return (VXR_V03_OBXNTE)super.removeRepetition("OBXNTE", rep);
    }
}

