/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.text;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.TextType;

public class URLBuilderFunction
implements Function {
    private static final long serialVersionUID = -3929896303552652226L;

    @Override
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int parameterCount = parameters.getParameterCount();
        if (parameterCount < 2 || parameterCount > 3) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        Type textType = parameters.getType(0);
        Object textValue = parameters.getValue(0);
        String textResult = context.getTypeRegistry().convertToText(textType, textValue);
        if (textResult == null) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        Type pathType = parameters.getType(1);
        Object pathValue = parameters.getValue(1);
        String pathResult = context.getTypeRegistry().convertToText(pathType, pathValue);
        if (pathResult == null) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        String paramResult = null;
        if (parameterCount == 3) {
            Type paramType = parameters.getType(1);
            Object paramValue = parameters.getValue(1);
            paramResult = context.getTypeRegistry().convertToText(paramType, paramValue);
            if (paramResult == null) {
                throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
            }
        }
        try {
            URI uri = new URI(textResult).resolve(pathResult).normalize();
            String query = null;
            query = !StringUtils.isEmpty(paramResult) ? (uri.getQuery() == null ? paramResult : query.concat("&").concat(paramResult)) : uri.getQuery();
            uri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), query, uri.getFragment());
            return new TypeValuePair(TextType.TYPE, uri.toURL().toString());
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
    }

    @Override
    public String getCanonicalName() {
        return "URLBUILDER";
    }
}

