/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.mondrianinput;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.annotations.PluginDialog;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransPreviewFactory;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mondrianinput.MondrianInputMeta;
import org.pentaho.di.ui.core.dialog.EnterNumberDialog;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.dialog.PreviewRowsDialog;
import org.pentaho.di.ui.core.widget.StyledTextComp;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.dialog.TransPreviewProgressDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.steps.mondrianinput.MDXValuesHighlight;

@PluginDialog(id="MondrianInput", image="MON.svg", pluginType=PluginDialog.PluginType.STEP, documentationUrl="Products/Mondrian_Input")
public class MondrianInputDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = MondrianInputMeta.class;
    private CCombo wConnection;
    private Label wlSQL;
    private StyledTextComp wSQL;
    private FormData fdlSQL;
    private FormData fdSQL;
    private Label wlCatalog;
    private TextVar wCatalog;
    private Button wbbFilename;
    private FormData fdlCatalog;
    private FormData fdCatalog;
    private MondrianInputMeta input;
    private Label wlPosition;
    private FormData fdlPosition;
    private Label wlVariables;
    private Button wVariables;
    private FormData fdlVariables;
    private FormData fdVariables;
    private TextVar wRole;

    public MondrianInputDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (MondrianInputMeta)in;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MondrianInputDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"MondrianInputDialog.MondrianInput", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"MondrianInputDialog.StepName", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wStepname, middle, margin);
        if (this.input.getDatabaseMeta() == null && this.transMeta.nrDatabases() == 1) {
            this.wConnection.select(0);
        }
        this.wConnection.addModifyListener(lsMod);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"System.Button.Preview", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wPreview, this.wCancel}, margin, null);
        Label wlRole = new Label((Composite)this.shell, 131072);
        wlRole.setText(BaseMessages.getString(PKG, (String)"MondrianInputDialog.Role", (String[])new String[0]));
        this.props.setLook((Control)wlRole);
        FormData fdlRole = new FormData();
        fdlRole.left = new FormAttachment(0, 0);
        fdlRole.right = new FormAttachment(middle, -margin);
        fdlRole.bottom = new FormAttachment((Control)this.wOK, -2 * margin);
        wlRole.setLayoutData((Object)fdlRole);
        this.wRole = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wRole);
        this.wRole.addModifyListener(lsMod);
        this.wRole.setToolTipText(BaseMessages.getString(PKG, (String)"MondrianInputDialog.Role.Tooltip", (String[])new String[0]));
        FormData fdRole = new FormData();
        fdRole.left = new FormAttachment(middle, 0);
        fdRole.right = new FormAttachment(100, -margin);
        fdRole.bottom = new FormAttachment((Control)this.wOK, -2 * margin);
        this.wRole.setLayoutData((Object)fdRole);
        this.wbbFilename = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbbFilename);
        this.wbbFilename.setText(BaseMessages.getString((String)"System.Button.Browse"));
        this.wbbFilename.setToolTipText(BaseMessages.getString((String)"System.Tooltip.BrowseForFileOrDirAndAdd"));
        FormData fdbFilename = new FormData();
        fdbFilename.right = new FormAttachment(100, 0);
        fdbFilename.bottom = new FormAttachment((Control)this.wRole, -2 * margin);
        this.wbbFilename.setLayoutData((Object)fdbFilename);
        this.wlCatalog = new Label((Composite)this.shell, 131072);
        this.wlCatalog.setText(BaseMessages.getString(PKG, (String)"MondrianInputDialog.Catalog", (String[])new String[0]));
        this.props.setLook((Control)this.wlCatalog);
        this.fdlCatalog = new FormData();
        this.fdlCatalog.left = new FormAttachment(0, 0);
        this.fdlCatalog.right = new FormAttachment(middle, -margin);
        this.fdlCatalog.bottom = new FormAttachment((Control)this.wRole, -2 * margin);
        this.wlCatalog.setLayoutData((Object)this.fdlCatalog);
        this.wCatalog = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wCatalog);
        this.wCatalog.addModifyListener(lsMod);
        this.fdCatalog = new FormData();
        this.fdCatalog.left = new FormAttachment(middle, 0);
        this.fdCatalog.right = new FormAttachment((Control)this.wbbFilename, -margin);
        this.fdCatalog.bottom = new FormAttachment((Control)this.wRole, -2 * margin);
        this.wCatalog.setLayoutData((Object)this.fdCatalog);
        this.wlVariables = new Label((Composite)this.shell, 131072);
        this.wlVariables.setText(BaseMessages.getString(PKG, (String)"MondrianInputDialog.ReplaceVariables", (String[])new String[0]));
        this.props.setLook((Control)this.wlVariables);
        this.fdlVariables = new FormData();
        this.fdlVariables.left = new FormAttachment(0, 0);
        this.fdlVariables.right = new FormAttachment(middle, -margin);
        this.fdlVariables.bottom = new FormAttachment((Control)this.wCatalog, -margin);
        this.wlVariables.setLayoutData((Object)this.fdlVariables);
        this.wVariables = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wVariables);
        this.wVariables.setToolTipText(BaseMessages.getString(PKG, (String)"MondrianInputDialog.ReplaceVariables.Tooltip", (String[])new String[0]));
        this.fdVariables = new FormData();
        this.fdVariables.left = new FormAttachment(middle, 0);
        this.fdVariables.right = new FormAttachment(100, 0);
        this.fdVariables.bottom = new FormAttachment((Control)this.wCatalog, -margin);
        this.wVariables.setLayoutData((Object)this.fdVariables);
        this.wVariables.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MondrianInputDialog.this.setSQLToolTip();
                MondrianInputDialog.this.input.setChanged();
            }
        });
        this.wlPosition = new Label((Composite)this.shell, 0);
        this.props.setLook((Control)this.wlPosition);
        this.fdlPosition = new FormData();
        this.fdlPosition.left = new FormAttachment(0, 0);
        this.fdlPosition.right = new FormAttachment(100, 0);
        this.fdlPosition.bottom = new FormAttachment((Control)this.wVariables, -margin);
        this.wlPosition.setLayoutData((Object)this.fdlPosition);
        this.wlSQL = new Label((Composite)this.shell, 0);
        this.wlSQL.setText(BaseMessages.getString(PKG, (String)"MondrianInputDialog.SQL", (String[])new String[0]));
        this.props.setLook((Control)this.wlSQL);
        this.fdlSQL = new FormData();
        this.fdlSQL.left = new FormAttachment(0, 0);
        this.fdlSQL.top = new FormAttachment((Control)this.wConnection, margin * 2);
        this.wlSQL.setLayoutData((Object)this.fdlSQL);
        this.wSQL = new StyledTextComp((VariableSpace)this.transMeta, (Composite)this.shell, 19202, "");
        this.props.setLook((Control)this.wSQL, 1);
        this.wSQL.addModifyListener(lsMod);
        this.fdSQL = new FormData();
        this.fdSQL.left = new FormAttachment(0, 0);
        this.fdSQL.top = new FormAttachment((Control)this.wlSQL, margin);
        this.fdSQL.right = new FormAttachment(100, -2 * margin);
        this.fdSQL.bottom = new FormAttachment((Control)this.wlPosition, -margin);
        this.wSQL.setLayoutData((Object)this.fdSQL);
        this.wSQL.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                MondrianInputDialog.this.setSQLToolTip();
                MondrianInputDialog.this.setPosition();
            }
        });
        this.wSQL.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                MondrianInputDialog.this.setPosition();
            }

            public void keyReleased(KeyEvent e) {
                MondrianInputDialog.this.setPosition();
            }
        });
        this.wSQL.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                MondrianInputDialog.this.setPosition();
            }

            public void focusLost(FocusEvent e) {
                MondrianInputDialog.this.setPosition();
            }
        });
        this.wSQL.addMouseListener(new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                MondrianInputDialog.this.setPosition();
            }

            public void mouseDown(MouseEvent e) {
                MondrianInputDialog.this.setPosition();
            }

            public void mouseUp(MouseEvent e) {
                MondrianInputDialog.this.setPosition();
            }
        });
        this.wSQL.addLineStyleListener((LineStyleListener)new MDXValuesHighlight());
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                MondrianInputDialog.this.cancel();
            }
        };
        this.lsPreview = new Listener(){

            public void handleEvent(Event e) {
                MondrianInputDialog.this.preview();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                MondrianInputDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wPreview.addListener(13, this.lsPreview);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                MondrianInputDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wCatalog.addSelectionListener(this.lsDef);
        if (this.wbbFilename != null) {
            this.wbbFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FileDialog dialog = new FileDialog(MondrianInputDialog.this.shell, 4096);
                    dialog.setFilterExtensions(new String[]{"*.xml", "*"});
                    if (MondrianInputDialog.this.wCatalog.getText() != null) {
                        String fname = MondrianInputDialog.this.transMeta.environmentSubstitute(MondrianInputDialog.this.wCatalog.getText());
                        dialog.setFileName(fname);
                    }
                    dialog.setFilterNames(new String[]{BaseMessages.getString((String)"System.FileType.XMLFiles"), BaseMessages.getString((String)"System.FileType.AllFiles")});
                    if (dialog.open() != null) {
                        String str = dialog.getFilterPath() + System.getProperty("file.separator") + dialog.getFileName();
                        MondrianInputDialog.this.wCatalog.setText(str);
                    }
                }
            });
        }
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                MondrianInputDialog.this.cancel();
            }
        });
        this.getData();
        this.input.setChanged(this.changed);
        this.setSize();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    public void setPosition() {
        String scr = this.wSQL.getText();
        int linenr = this.wSQL.getLineAtOffset(this.wSQL.getCaretOffset()) + 1;
        int posnr = this.wSQL.getCaretOffset();
        int colnr = 0;
        while (posnr > 0 && scr.charAt(posnr - 1) != '\n' && scr.charAt(posnr - 1) != '\r') {
            --posnr;
            ++colnr;
        }
        this.wlPosition.setText(BaseMessages.getString(PKG, (String)"MondrianInputDialog.Position.Label", (String[])new String[]{"" + linenr, "" + colnr}));
    }

    protected void setSQLToolTip() {
        if (this.wVariables.getSelection()) {
            this.wSQL.setToolTipText(this.transMeta.environmentSubstitute(this.wSQL.getText()));
        }
    }

    public void getData() {
        if (this.input.getSQL() != null) {
            this.wSQL.setText(this.input.getSQL());
        }
        if (this.input.getDatabaseMeta() != null) {
            this.wConnection.setText(this.input.getDatabaseMeta().getName());
        }
        if (this.input.getCatalog() != null) {
            this.wCatalog.setText(this.input.getCatalog());
        }
        if (this.input.getRole() != null) {
            this.wRole.setText(this.input.getRole());
        }
        this.wVariables.setSelection(this.input.isVariableReplacementActive());
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void getInfo(MondrianInputMeta meta) {
        meta.setSQL(this.wSQL.getText());
        meta.setDatabaseMeta(this.transMeta.findDatabase(this.wConnection.getText()));
        meta.setCatalog(this.wCatalog.getText());
        meta.setVariableReplacementActive(this.wVariables.getSelection());
        meta.setRole(this.wRole.getText());
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        this.getInfo(this.input);
        if (this.input.getDatabaseMeta() == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"MondrianInputDialog.SelectValidConnection", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"MondrianInputDialog.DialogCaptionError", (String[])new String[0]));
            mb.open();
            return;
        }
        this.dispose();
    }

    private void preview() {
        MondrianInputMeta oneMeta = new MondrianInputMeta();
        this.getInfo(oneMeta);
        TransMeta previewMeta = TransPreviewFactory.generatePreviewTransformation((VariableSpace)this.transMeta, (StepMetaInterface)oneMeta, (String)this.wStepname.getText());
        EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"MondrianInputDialog.EnterPreviewSize", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MondrianInputDialog.NumberOfRowsToPreview", (String[])new String[0]));
        int previewSize = numberDialog.open();
        if (previewSize > 0) {
            TransPreviewProgressDialog progressDialog = new TransPreviewProgressDialog(this.shell, previewMeta, new String[]{this.wStepname.getText()}, new int[]{previewSize});
            progressDialog.open();
            Trans trans = progressDialog.getTrans();
            String loggingText = progressDialog.getLoggingText();
            if (!progressDialog.isCancelled() && trans.getResult() != null && trans.getResult().getNrErrors() > 0L) {
                EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                etd.setReadOnly();
                etd.open();
            }
            PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, (VariableSpace)this.transMeta, 0, this.wStepname.getText(), progressDialog.getPreviewRowsMeta(this.wStepname.getText()), progressDialog.getPreviewRows(this.wStepname.getText()), loggingText);
            prd.open();
        }
    }
}

