/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.group.MFN_M16_PACKAGING;
import ca.uhn.hl7v2.model.v26.segment.VND;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class MFN_M16_PURCHASING_VENDOR
extends AbstractGroup {
    public MFN_M16_PURCHASING_VENDOR(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(VND.class, true, false);
            this.add(MFN_M16_PACKAGING.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating MFN_M16_PURCHASING_VENDOR - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public VND getVND() {
        VND ret = null;
        try {
            ret = (VND)this.get("VND");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public MFN_M16_PACKAGING getPACKAGING() {
        MFN_M16_PACKAGING ret = null;
        try {
            ret = (MFN_M16_PACKAGING)this.get("PACKAGING");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public MFN_M16_PACKAGING getPACKAGING(int rep) {
        MFN_M16_PACKAGING ret = null;
        try {
            ret = (MFN_M16_PACKAGING)this.get("PACKAGING", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPACKAGINGReps() {
        int reps = -1;
        try {
            reps = this.getAll("PACKAGING").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertPACKAGING(MFN_M16_PACKAGING structure, int rep) throws HL7Exception {
        super.insertRepetition("PACKAGING", (Structure)structure, rep);
    }

    public MFN_M16_PACKAGING insertPACKAGING(int rep) throws HL7Exception {
        return (MFN_M16_PACKAGING)super.insertRepetition("PACKAGING", rep);
    }

    public MFN_M16_PACKAGING removePACKAGING(int rep) throws HL7Exception {
        return (MFN_M16_PACKAGING)super.removeRepetition("PACKAGING", rep);
    }
}

