/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.group.EHC_E01_INVOICE_PROCESSING;
import ca.uhn.hl7v2.model.v26.group.EHC_E01_PATIENT_INFO;
import ca.uhn.hl7v2.model.v26.group.EHC_E01_PROCEDURE;
import ca.uhn.hl7v2.model.v26.group.EHC_E01_PRODUCT_SERVICE_LINE_ITEM;
import ca.uhn.hl7v2.model.v26.segment.LOC;
import ca.uhn.hl7v2.model.v26.segment.PSG;
import ca.uhn.hl7v2.model.v26.segment.ROL;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class EHC_E01_PRODUCT_SERVICE_GROUP
extends AbstractGroup {
    public EHC_E01_PRODUCT_SERVICE_GROUP(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PSG.class, true, false);
            this.add(LOC.class, false, true);
            this.add(ROL.class, false, true);
            this.add(EHC_E01_PATIENT_INFO.class, false, true);
            this.add(EHC_E01_PRODUCT_SERVICE_LINE_ITEM.class, true, true);
            this.add(EHC_E01_PROCEDURE.class, false, true);
            this.add(EHC_E01_INVOICE_PROCESSING.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating EHC_E01_PRODUCT_SERVICE_GROUP - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public PSG getPSG() {
        PSG ret = null;
        try {
            ret = (PSG)this.get("PSG");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public LOC getLOC() {
        LOC ret = null;
        try {
            ret = (LOC)this.get("LOC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public LOC getLOC(int rep) {
        LOC ret = null;
        try {
            ret = (LOC)this.get("LOC", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getLOCReps() {
        int reps = -1;
        try {
            reps = this.getAll("LOC").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertLOC(LOC structure, int rep) throws HL7Exception {
        super.insertRepetition("LOC", (Structure)structure, rep);
    }

    public LOC insertLOC(int rep) throws HL7Exception {
        return (LOC)super.insertRepetition("LOC", rep);
    }

    public LOC removeLOC(int rep) throws HL7Exception {
        return (LOC)super.removeRepetition("LOC", rep);
    }

    public ROL getROL() {
        ROL ret = null;
        try {
            ret = (ROL)this.get("ROL");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ROL getROL(int rep) {
        ROL ret = null;
        try {
            ret = (ROL)this.get("ROL", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getROLReps() {
        int reps = -1;
        try {
            reps = this.getAll("ROL").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertROL(ROL structure, int rep) throws HL7Exception {
        super.insertRepetition("ROL", (Structure)structure, rep);
    }

    public ROL insertROL(int rep) throws HL7Exception {
        return (ROL)super.insertRepetition("ROL", rep);
    }

    public ROL removeROL(int rep) throws HL7Exception {
        return (ROL)super.removeRepetition("ROL", rep);
    }

    public EHC_E01_PATIENT_INFO getPATIENT_INFO() {
        EHC_E01_PATIENT_INFO ret = null;
        try {
            ret = (EHC_E01_PATIENT_INFO)this.get("PATIENT_INFO");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public EHC_E01_PATIENT_INFO getPATIENT_INFO(int rep) {
        EHC_E01_PATIENT_INFO ret = null;
        try {
            ret = (EHC_E01_PATIENT_INFO)this.get("PATIENT_INFO", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPATIENT_INFOReps() {
        int reps = -1;
        try {
            reps = this.getAll("PATIENT_INFO").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertPATIENT_INFO(EHC_E01_PATIENT_INFO structure, int rep) throws HL7Exception {
        super.insertRepetition("PATIENT_INFO", (Structure)structure, rep);
    }

    public EHC_E01_PATIENT_INFO insertPATIENT_INFO(int rep) throws HL7Exception {
        return (EHC_E01_PATIENT_INFO)super.insertRepetition("PATIENT_INFO", rep);
    }

    public EHC_E01_PATIENT_INFO removePATIENT_INFO(int rep) throws HL7Exception {
        return (EHC_E01_PATIENT_INFO)super.removeRepetition("PATIENT_INFO", rep);
    }

    public EHC_E01_PRODUCT_SERVICE_LINE_ITEM getPRODUCT_SERVICE_LINE_ITEM() {
        EHC_E01_PRODUCT_SERVICE_LINE_ITEM ret = null;
        try {
            ret = (EHC_E01_PRODUCT_SERVICE_LINE_ITEM)this.get("PRODUCT_SERVICE_LINE_ITEM");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public EHC_E01_PRODUCT_SERVICE_LINE_ITEM getPRODUCT_SERVICE_LINE_ITEM(int rep) {
        EHC_E01_PRODUCT_SERVICE_LINE_ITEM ret = null;
        try {
            ret = (EHC_E01_PRODUCT_SERVICE_LINE_ITEM)this.get("PRODUCT_SERVICE_LINE_ITEM", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPRODUCT_SERVICE_LINE_ITEMReps() {
        int reps = -1;
        try {
            reps = this.getAll("PRODUCT_SERVICE_LINE_ITEM").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertPRODUCT_SERVICE_LINE_ITEM(EHC_E01_PRODUCT_SERVICE_LINE_ITEM structure, int rep) throws HL7Exception {
        super.insertRepetition("PRODUCT_SERVICE_LINE_ITEM", (Structure)structure, rep);
    }

    public EHC_E01_PRODUCT_SERVICE_LINE_ITEM insertPRODUCT_SERVICE_LINE_ITEM(int rep) throws HL7Exception {
        return (EHC_E01_PRODUCT_SERVICE_LINE_ITEM)super.insertRepetition("PRODUCT_SERVICE_LINE_ITEM", rep);
    }

    public EHC_E01_PRODUCT_SERVICE_LINE_ITEM removePRODUCT_SERVICE_LINE_ITEM(int rep) throws HL7Exception {
        return (EHC_E01_PRODUCT_SERVICE_LINE_ITEM)super.removeRepetition("PRODUCT_SERVICE_LINE_ITEM", rep);
    }

    public EHC_E01_PROCEDURE getPROCEDURE() {
        EHC_E01_PROCEDURE ret = null;
        try {
            ret = (EHC_E01_PROCEDURE)this.get("PROCEDURE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public EHC_E01_PROCEDURE getPROCEDURE(int rep) {
        EHC_E01_PROCEDURE ret = null;
        try {
            ret = (EHC_E01_PROCEDURE)this.get("PROCEDURE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPROCEDUREReps() {
        int reps = -1;
        try {
            reps = this.getAll("PROCEDURE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertPROCEDURE(EHC_E01_PROCEDURE structure, int rep) throws HL7Exception {
        super.insertRepetition("PROCEDURE", (Structure)structure, rep);
    }

    public EHC_E01_PROCEDURE insertPROCEDURE(int rep) throws HL7Exception {
        return (EHC_E01_PROCEDURE)super.insertRepetition("PROCEDURE", rep);
    }

    public EHC_E01_PROCEDURE removePROCEDURE(int rep) throws HL7Exception {
        return (EHC_E01_PROCEDURE)super.removeRepetition("PROCEDURE", rep);
    }

    public EHC_E01_INVOICE_PROCESSING getINVOICE_PROCESSING() {
        EHC_E01_INVOICE_PROCESSING ret = null;
        try {
            ret = (EHC_E01_INVOICE_PROCESSING)this.get("INVOICE_PROCESSING");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public EHC_E01_INVOICE_PROCESSING getINVOICE_PROCESSING(int rep) {
        EHC_E01_INVOICE_PROCESSING ret = null;
        try {
            ret = (EHC_E01_INVOICE_PROCESSING)this.get("INVOICE_PROCESSING", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getINVOICE_PROCESSINGReps() {
        int reps = -1;
        try {
            reps = this.getAll("INVOICE_PROCESSING").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertINVOICE_PROCESSING(EHC_E01_INVOICE_PROCESSING structure, int rep) throws HL7Exception {
        super.insertRepetition("INVOICE_PROCESSING", (Structure)structure, rep);
    }

    public EHC_E01_INVOICE_PROCESSING insertINVOICE_PROCESSING(int rep) throws HL7Exception {
        return (EHC_E01_INVOICE_PROCESSING)super.insertRepetition("INVOICE_PROCESSING", rep);
    }

    public EHC_E01_INVOICE_PROCESSING removeINVOICE_PROCESSING(int rep) throws HL7Exception {
        return (EHC_E01_INVOICE_PROCESSING)super.removeRepetition("INVOICE_PROCESSING", rep);
    }
}

