/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.libsparklines;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.pentaho.reporting.libraries.libsparklines.util.GraphUtils;

public class BarGraphDrawable {
    private static final int DEFAULT_SPACING = 2;
    private static final Color DEFAULT_COLOR = Color.gray;
    private static final Color DEFAULT_HIGH_COLOR = Color.black;
    private static final Color DEFAULT_LAST_COLOR = Color.red;
    private static final Number[] EMPTY = new Number[0];
    private Number[] data;
    private Color color;
    private Color highColor = DEFAULT_HIGH_COLOR;
    private Color lastColor = DEFAULT_LAST_COLOR;
    private Color background;
    private int spacing = 2;

    public BarGraphDrawable() {
        this.color = DEFAULT_COLOR;
        this.data = EMPTY;
    }

    public Number[] getData() {
        return (Number[])this.data.clone();
    }

    public void setData(Number[] data) {
        this.data = (Number[])data.clone();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new NullPointerException();
        }
        this.color = color;
    }

    public Color getHighColor() {
        return this.highColor;
    }

    public void setHighColor(Color highColor) {
        this.highColor = highColor;
    }

    public Color getLastColor() {
        return this.lastColor;
    }

    public void setLastColor(Color lastColor) {
        this.lastColor = lastColor;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    public void draw(Graphics2D g2, Rectangle2D drawArea) {
        if (g2 == null) {
            throw new NullPointerException();
        }
        if (drawArea == null) {
            throw new NullPointerException();
        }
        int height = (int)drawArea.getHeight();
        if (height <= 0) {
            return;
        }
        Graphics2D g = (Graphics2D)g2.create();
        g.translate(drawArea.getX(), drawArea.getY());
        if (this.background != null) {
            g.setBackground(this.background);
            g.clearRect(0, 0, (int)drawArea.getWidth(), height);
        }
        if (this.data == null || this.data.length == 0) {
            g.dispose();
            return;
        }
        float scale = GraphUtils.getDivisor(this.data, height);
        float axe = GraphUtils.getAxe(this.data) / scale;
        float avg = BarGraphDrawable.computeAverage(this.data);
        float spacing1 = this.getSpacing();
        float barWidth = (float)((drawArea.getWidth() - (double)(spacing1 * (float)this.data.length)) / (double)this.data.length);
        float x = 0.0f;
        double canvasHeight = drawArea.getHeight();
        Rectangle2D.Double bar = new Rectangle2D.Double();
        for (int index = 0; index < this.data.length; ++index) {
            Number value = this.data[index];
            if (value == null) {
                x += barWidth + spacing1;
                continue;
            }
            float h = (int)(value.doubleValue() / (double)scale);
            float intVal = value.floatValue();
            if (index == this.data.length - 1 && this.lastColor != null) {
                g.setPaint(this.lastColor);
            } else if (intVal < avg || this.highColor == null) {
                g.setPaint(this.color);
            } else {
                g.setPaint(this.highColor);
            }
            if (axe == 0.0f) {
                bar.setRect(x, canvasHeight - (double)h, barWidth, h);
            } else if (axe < 0.0f) {
                bar.setRect(x, 0.0, barWidth, h < 0.0f ? (double)(-h) : (double)h);
            } else {
                bar.setRect(x, h < 0.0f ? (double)axe : (double)(axe - h), barWidth, h < 0.0f ? (double)(-h) : (double)h);
            }
            g.fill(bar);
            x += barWidth + spacing1;
        }
        g.dispose();
    }

    private static float computeAverage(Number[] data) {
        int total = 0;
        int length = 0;
        for (int index = 0; index < data.length; ++index) {
            Number i = data[index];
            if (i == null) continue;
            total = (int)((float)total + i.floatValue());
            ++length;
        }
        return total / length;
    }
}

