/*
 * Decompiled with CFR 0.152.
 */
package com.totvscrm.pentaho.step.upsertdelete;

import com.totvscrm.pentaho.step.upsertdelete.UpsertDeleteData;
import com.totvscrm.pentaho.step.upsertdelete.UpsertDeleteMeta;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseBatchException;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;

public class UpsertDelete
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = UpsertDeleteMeta.class;
    private UpsertDeleteMeta meta;
    private UpsertDeleteData data;
    private int countNew;
    private int countChanged;
    private int countDelete;
    private int countInativa;
    private int countIdentical;
    private ArrayList<Object[]> inativaObject;
    private ArrayList<Object[]> updateObject;
    private boolean logOperations;

    public UpsertDelete(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.logOperations = false;
        for (int i = 0; i < this.listVariables().length; ++i) {
            if (!this.listVariables()[i].equalsIgnoreCase("LOG_OPERATIONS") || !this.getVariable("LOG_OPERATIONS").equalsIgnoreCase("1")) continue;
            this.logOperations = true;
        }
        this.meta = (UpsertDeleteMeta)smi;
        this.data = (UpsertDeleteData)sdi;
        this.inativaObject = new ArrayList();
        this.updateObject = new ArrayList();
        if (super.init(smi, sdi)) {
            Hashtable hashtable;
            this.data.realSchemaName = this.environmentSubstitute(this.meta.getSchemaName());
            this.data.realSequenceName = this.environmentSubstitute(this.meta.getSequenceName());
            Database db = new Database((LoggingObjectInterface)this, this.meta.getDatabaseMeta());
            db.shareVariablesWith((VariableSpace)this);
            this.data.setDb(db);
            try {
                if (this.getTransMeta().isUsingUniqueConnections()) {
                    Trans trans = this.getTrans();
                    synchronized (trans) {
                        this.data.getDb().connect(this.getTrans().getTransactionId(), this.getPartitionID());
                    }
                } else {
                    this.data.getDb().connect(this.getPartitionID());
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"UpsertDelete.Log.ConnectedDB", (String[])new String[0]));
                }
            }
            catch (KettleDatabaseException dbe) {
                this.logError(BaseMessages.getString(PKG, (String)"UpsertDelete.Log.CouldNotConnectToDB", (String[])new String[0]) + dbe.getMessage());
            }
            if (this.meta.isNumber()) {
                boolean doAbort = false;
                try {
                    this.data.start = Long.parseLong(this.environmentSubstitute(this.meta.getStartAt()));
                }
                catch (NumberFormatException ex) {
                    this.logError(BaseMessages.getString(PKG, (String)"UpsertDelete.Log.CouldNotParseCounterValue", (String[])new String[]{"start", this.meta.getStartAt(), this.environmentSubstitute(this.meta.getStartAt()), ex.getMessage()}));
                    doAbort = true;
                }
                try {
                    this.data.increment = Long.parseLong(this.meta.getIncrementBy());
                }
                catch (NumberFormatException ex) {
                    this.logError(BaseMessages.getString(PKG, (String)"UpsertDelete.Log.CouldNotParseCounterValue", (String[])new String[]{"increment", this.meta.getIncrementBy(), this.environmentSubstitute(this.meta.getIncrementBy()), ex.getMessage()}));
                    doAbort = true;
                }
                try {
                    this.data.maximum = Long.parseLong(this.meta.getMaxValue());
                }
                catch (NumberFormatException ex) {
                    this.logError(BaseMessages.getString(PKG, (String)"UpsertDelete.Log.CouldNotParseCounterValue", (String[])new String[]{"increment", this.meta.getMaxValue(), this.environmentSubstitute(this.meta.getMaxValue()), ex.getMessage()}));
                    doAbort = true;
                }
                if (doAbort) {
                    return false;
                }
                this.data.setLookup("@@sequence:" + this.meta.getValuename());
                if (this.getTrans().getCounters() != null) {
                    hashtable = this.getTrans().getCounters();
                    synchronized (hashtable) {
                        this.data.counter = (Counter)this.getTrans().getCounters().get(this.data.getLookup());
                        if (this.data.counter == null) {
                            this.data.counter = new Counter(this.data.start, this.data.increment, this.data.maximum);
                            this.getTrans().getCounters().put(this.data.getLookup(), this.data.counter);
                        } else if (this.data.counter.getStart() != this.data.start || this.data.counter.getIncrement() != this.data.increment || this.data.counter.getMaximum() != this.data.maximum) {
                            this.logError(BaseMessages.getString(PKG, (String)"UpsertDelete.Log.CountersWithDifferentCharacteristics", (String[])new String[]{this.data.getLookup()}));
                            return false;
                        }
                    }
                } else {
                    this.logError(BaseMessages.getString(PKG, (String)"UpsertDelete.Log.TransformationCountersHashtableNotAllocated", (String[])new String[0]));
                }
            }
            try {
                this.data.commitSize = Integer.parseInt(this.environmentSubstitute(this.meta.getCommitSize()));
                if (this.meta.useBatchUpdateUp()) {
                    this.data.commitSizeUp = Integer.parseInt(this.environmentSubstitute(this.meta.getCommitSizeVar()));
                }
                this.data.databaseMeta = this.meta.getDatabaseMeta();
                DatabaseInterface dbInterface = this.data.databaseMeta.getDatabaseInterface();
                this.data.useSafePoints = this.data.databaseMeta.getDatabaseInterface().useSafePoints() && this.getStepMeta().isDoingErrorHandling();
                this.data.releaseSavepoint = dbInterface.releaseSavepoint();
                boolean bl = this.data.batchMode = this.meta.useBatchUpdate() && this.data.commitSize > 0 && !this.getTransMeta().isUsingUniqueConnections() && !this.data.useSafePoints;
                if (this.getStepMeta().isDoingErrorHandling() && !dbInterface.supportsErrorHandlingOnBatchUpdates()) {
                    this.log.logMinimal(BaseMessages.getString(PKG, (String)"UpsertDelete.Warning.ErrorHandlingIsNotFullySupportedWithBatchProcessing", (String[])new String[0]));
                }
                if (this.meta.getDatabaseMeta() == null) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"UpsertDelete.Exception.DatabaseNeedsToBeSelected", (String[])new String[0]));
                }
                if (this.meta.getDatabaseMeta() == null) {
                    this.logError(BaseMessages.getString(PKG, (String)"UpsertDelete.Init.ConnectionMissing", (String[])new String[]{this.getStepname()}));
                    return false;
                }
                if (this.log.isBasic()) {
                    this.logBasic("Connected to database [" + String.valueOf(this.meta.getDatabaseMeta()) + "] INSERT = (commit=" + this.data.commitSize + ")  UPDATE = (commit=" + this.data.commitSizeUp + ")  DELETE = (commit=" + this.environmentSubstitute(this.meta.getCommitSizeVarDel()) + ")");
                }
                if (this.data.commitSize == 0) {
                    this.data.commitSize = Integer.MAX_VALUE;
                }
                this.data.db.setCommit(this.data.commitSize);
                this.data.tableName = this.environmentSubstitute(this.meta.getTableName());
                this.data.dbUp = new Database((LoggingObjectInterface)this, this.meta.getDatabaseMeta());
                this.data.dbUp.shareVariablesWith((VariableSpace)this);
                if (this.getTransMeta().isUsingUniqueConnections()) {
                    hashtable = this.getTrans();
                    synchronized (hashtable) {
                        this.data.dbUp.connect(this.getTrans().getTransactionId(), this.getPartitionID());
                    }
                } else {
                    this.data.dbUp.connect(this.getPartitionID());
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"UpsertDelete.Log.ConnectedToDB", (String[])new String[0]));
                }
                this.data.dbUp.setCommit(this.meta.getCommitSizeUp((VariableSpace)this));
                this.data.dbDel = new Database((LoggingObjectInterface)this, this.meta.getDatabaseMeta());
                this.data.dbDel.shareVariablesWith((VariableSpace)this);
                if (this.getTransMeta().isUsingUniqueConnections()) {
                    hashtable = this.getTrans();
                    synchronized (hashtable) {
                        this.data.dbDel.connect(this.getTrans().getTransactionId(), this.getPartitionID());
                    }
                } else {
                    this.data.dbDel.connect(this.getPartitionID());
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"UpsertDelete.Log.ConnectedToDB", (String[])new String[0]));
                }
                this.data.dbDel.setCommit(this.meta.getCommitSizeDel((VariableSpace)this));
                this.data.dbIna = new Database((LoggingObjectInterface)this, this.meta.getDatabaseMeta());
                this.data.dbIna.shareVariablesWith((VariableSpace)this);
                if (this.getTransMeta().isUsingUniqueConnections()) {
                    hashtable = this.getTrans();
                    synchronized (hashtable) {
                        this.data.dbIna.connect(this.getTrans().getTransactionId(), this.getPartitionID());
                    }
                } else {
                    this.data.dbIna.connect(this.getPartitionID());
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"UpsertDelete.Log.ConnectedToDB", (String[])new String[0]));
                }
                this.data.dbIna.setCommit(this.meta.getCommitSizeDel((VariableSpace)this));
                return true;
            }
            catch (KettleException ke) {
                this.logError(BaseMessages.getString(PKG, (String)"UpsertDelete.Log.ErrorOccurred", (String[])new String[0]) + ke.getMessage());
                this.setErrors(1L);
                this.stopAll();
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized Object[] lookupValues(RowMetaInterface rowMeta, Object[] row, int nrRow) throws KettleException {
        int size = this.meta.getUpdateLookup().length;
        String[] arrayFieldName = new String[this.getInputRowMeta().size()];
        String[] arrayOldValue = new String[size];
        String[] arrayNewValue = new String[size];
        Object[] outputRow = row;
        Object[] lookupRow = new Object[this.data.lookupParameterRowMeta.size()];
        int lookupIndex = 0;
        for (int i = 0; i < this.data.keynrs.length; ++i) {
            if (this.data.keynrs[i] >= 0) {
                lookupRow[lookupIndex] = row[this.data.keynrs[i]];
                ++lookupIndex;
            }
            if (this.data.keynrs2[i] < 0) continue;
            lookupRow[lookupIndex] = row[this.data.keynrs2[i]];
            ++lookupIndex;
        }
        RowMetaInterface returnRowMeta = null;
        this.data.dbUp.setValues(this.data.lookupParameterRowMeta, lookupRow, this.data.prepStatementLookup);
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"UpsertDelete.Log.ValuesSetForLookup", (String[])new String[]{this.data.lookupParameterRowMeta.getString(lookupRow), rowMeta.getString(row)}));
        }
        Object[] add = this.data.dbUp.getLookup(this.data.prepStatementLookup);
        returnRowMeta = this.data.dbUp.getReturnRowMeta();
        this.incrementLinesInput();
        if (add == null) {
            if (!this.getStepMeta().isDoingErrorHandling()) throw new KettleDatabaseException(BaseMessages.getString(PKG, (String)"UpsertDelete.Exception.KeyCouldNotFound", (String[])new String[0]) + this.data.lookupParameterRowMeta.getString(lookupRow));
            outputRow = null;
            if (this.data.stringErrorKeyNotFound == null) {
                this.data.stringErrorKeyNotFound = BaseMessages.getString(PKG, (String)"UpsertDelete.Exception.KeyCouldNotFound", (String[])new String[0]) + this.data.lookupParameterRowMeta.getString(lookupRow);
                this.data.stringFieldnames = "";
                for (int i = 0; i < this.data.lookupParameterRowMeta.size(); ++i) {
                    if (i > 0) {
                        this.data.stringFieldnames = this.data.stringFieldnames + ", ";
                    }
                    this.data.stringFieldnames = this.data.stringFieldnames + this.data.lookupParameterRowMeta.getValueMeta(i).getName();
                }
            }
            this.putError(rowMeta, row, 1L, this.data.stringErrorKeyNotFound, this.data.stringFieldnames, "UPD001");
            return outputRow;
        } else {
            if (this.log.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"UpsertDelete.Log.FoundRow", (String[])new String[0]) + this.data.lookupReturnRowMeta.getString(add));
            }
            boolean update = false;
            for (int i = 0; i < returnRowMeta.size(); ++i) {
                Object retvalue;
                ValueMetaInterface valueMeta = rowMeta.getValueMeta(this.data.valuenrsUp[i]);
                Object rowvalue = row[this.data.valuenrsUp[i]];
                ValueMetaInterface returnValueMeta = returnRowMeta.getValueMeta(i);
                if (returnValueMeta.compare(retvalue = add[i], valueMeta, rowvalue) == 0) continue;
                update = true;
                if (!this.meta.isLogDB() && !this.logOperations) continue;
                arrayFieldName[i] = rowMeta.getValueMeta(i).getName();
                arrayOldValue[i] = retvalue != null ? retvalue.toString() : "null";
                arrayNewValue[i] = rowvalue != null ? rowvalue.toString() : "null";
            }
            if (update) {
                int i;
                Object[] updateRow = new Object[this.data.updateParameterRowMeta.size()];
                for (i = 0; i < returnRowMeta.size(); ++i) {
                    updateRow[i] = row[this.data.valuenrsUp[i]];
                }
                for (i = 0; i < lookupRow.length; ++i) {
                    updateRow[returnRowMeta.size() + i] = lookupRow[i];
                }
                if (this.meta.isLogDB() || this.logOperations) {
                    this.logBasic("----------LOG UPDATE---------- lineNr: " + nrRow + "\n");
                    for (i = 0; i < this.getInputRowMeta().size() - 1; ++i) {
                        if (arrayFieldName[i] == rowMeta.getValueMeta(i).getName()) {
                            if (arrayNewValue[i].equals(arrayOldValue[i])) {
                                this.logBasic(rowMeta.getValueMeta(i).getName() + " = " + String.valueOf(row[i]) + "\n");
                                continue;
                            }
                            this.logBasic(rowMeta.getValueMeta(i).getName() + " = " + arrayOldValue[i] + " -->> " + arrayNewValue[i] + "\n");
                            continue;
                        }
                        this.logBasic(rowMeta.getValueMeta(i).getName() + " = " + String.valueOf(row[i]) + "\n");
                    }
                    this.logBasic("\n");
                }
                if (this.log.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"Update.Log.UpdateRow", (String[])new String[0]) + this.data.lookupParameterRowMeta.getString(lookupRow));
                }
                this.data.dbUp.setValues(this.data.updateParameterRowMeta, updateRow, this.data.prepStatementUpdate);
                this.data.dbUp.insertRow(this.data.prepStatementUpdate, this.meta.useBatchUpdateUp(), true);
                this.incrementLinesUpdated();
                return outputRow;
            } else {
                this.incrementLinesSkipped();
            }
        }
        return outputRow;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        int i;
        this.meta = (UpsertDeleteMeta)smi;
        this.data = (UpsertDeleteData)sdi;
        String flag = "";
        boolean sendToErrorRow = false;
        String errorMessage = null;
        Object[] r = this.getRow();
        if (r == null) {
            Object[] outputRow;
            int i2;
            if (this.updateObject != null && this.updateObject.size() > 0) {
                for (i2 = 0; i2 < this.updateObject.size(); ++i2) {
                    try {
                        outputRow = this.lookupValues(this.getInputRowMeta(), this.updateObject.get(i2), i2 + 1);
                        if (outputRow != null) {
                            this.putRow(this.data.outputRowMeta, outputRow);
                        }
                        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
                            this.logBasic(BaseMessages.getString(PKG, (String)"UpsertDelete.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
                        }
                        ++this.countChanged;
                        continue;
                    }
                    catch (KettleException e) {
                        if (!this.getStepMeta().isDoingErrorHandling()) {
                            this.logError(BaseMessages.getString(PKG, (String)"UpsertDelete.Log.ErrorInStep", (String[])new String[0]), e);
                            this.setErrors(1L);
                            this.stopAll();
                            this.setOutputDone();
                            return false;
                        }
                        sendToErrorRow = true;
                        errorMessage = e.toString();
                        if (!sendToErrorRow) continue;
                        this.putError(this.getInputRowMeta(), this.updateObject.get(i2), 1L, errorMessage, null, "UPD001");
                    }
                }
            }
            if (this.inativaObject != null && this.inativaObject.size() > 0) {
                for (i2 = 0; i2 < this.inativaObject.size(); ++i2) {
                    try {
                        outputRow = this.inativa(this.getInputRowMeta(), this.inativaObject.get(i2), i2 + 1);
                        if (outputRow != null) {
                            this.putRow(this.data.outputRowMeta, outputRow);
                        }
                        if (!this.checkFeedback(this.getLinesRead()) || !this.log.isBasic()) continue;
                        this.logBasic(BaseMessages.getString(PKG, (String)"UpsertDelete.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
                        continue;
                    }
                    catch (KettleException e) {
                        if (!this.getStepMeta().isDoingErrorHandling()) {
                            this.logError(BaseMessages.getString(PKG, (String)"UpsertDelete.Log.ErrorInStep", (String[])new String[0]), e);
                            this.setErrors(1L);
                            this.stopAll();
                            this.setOutputDone();
                            return false;
                        }
                        sendToErrorRow = true;
                        errorMessage = e.toString();
                        if (!sendToErrorRow) continue;
                        this.putError(this.getInputRowMeta(), this.inativaObject.get(i2), 1L, errorMessage, null, "UPD001");
                    }
                }
            }
            this.logBasic(this.getTrans().getName() + " - INSERT: " + this.countNew);
            this.logBasic(this.getTrans().getName() + " - UPDATE: " + this.countChanged);
            if (this.meta.isDelete()) {
                this.logBasic(this.getTrans().getName() + " - DELETE: " + this.countDelete);
            } else if (this.meta.isInativa()) {
                this.logBasic(this.getTrans().getName() + " - INATIVA: " + this.countInativa);
            }
            this.logBasic(this.getTrans().getName() + " - IDENTICAL: " + this.countIdentical);
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, (VariableSpace)this, this.repository, this.metaStore);
            this.data.insertRowMeta = new RowMeta();
            this.data.schemaTable = this.meta.getDatabaseMeta().getQuotedSchemaTableCombination(this.environmentSubstitute(this.meta.getSchemaName()), this.environmentSubstitute(this.meta.getTableName()));
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"UpsertDelete.Log.CheckingRow", (String[])new String[0]) + this.getInputRowMeta().getString(r));
            }
            ArrayList<Integer> keynrs = new ArrayList<Integer>(this.meta.getKeyStream().length);
            ArrayList<Integer> keynrs2 = new ArrayList<Integer>(this.meta.getKeyStream2().length);
            for (i = 0; i < this.meta.getKeyStream().length; ++i) {
                int keynr2;
                int keynr = this.getInputRowMeta().indexOfValue(this.meta.getKeyStream()[i]);
                if (keynr < 0 && !"IS NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i]) && !"IS NOT NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"UpsertDelete.Exception.FieldRequired", (String[])new String[]{this.meta.getKeyStream()[i]}));
                }
                keynrs.add(keynr);
                if ("= ~NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                    keynrs.add(keynr);
                    keynrs2.add(-1);
                }
                if ((keynr2 = this.getInputRowMeta().indexOfValue(this.meta.getKeyStream2()[i])) < 0 && "BETWEEN".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"UpsertDelete.Exception.FieldRequired", (String[])new String[]{this.meta.getKeyStream2()[i]}));
                }
                keynrs2.add(keynr2);
                if (!this.log.isDebug()) continue;
                this.logDebug(BaseMessages.getString(PKG, (String)"UpsertDelete.Log.FieldHasDataNumbers", (String[])new String[]{this.meta.getKeyStream()[i]}) + String.valueOf(keynrs.get(keynrs.size() - 1)));
            }
            this.data.keynrs = ArrayUtils.toPrimitive((Integer[])keynrs.toArray(new Integer[0]));
            this.data.keynrs2 = ArrayUtils.toPrimitive((Integer[])keynrs2.toArray(new Integer[0]));
            this.data.valuenrsUp = new int[this.meta.getUpdateStream().length];
            for (i = 0; i < this.meta.getUpdateLookup().length; ++i) {
                this.data.valuenrsUp[i] = this.getInputRowMeta().indexOfValue(this.meta.getUpdateStream()[i]);
                if (this.data.valuenrsUp[i] < 0) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"UpsertDelete.Exception.FieldRequired", (String[])new String[]{this.meta.getUpdateStream()[i]}));
                }
                if (!this.log.isDebug()) continue;
                this.logDebug(BaseMessages.getString(PKG, (String)"UpsertDelete.Log.FieldHasDataNumbers", (String[])new String[]{this.meta.getUpdateStream()[i]}) + this.data.valuenrsUp[i]);
            }
            this.setLookup(this.getInputRowMeta());
            this.prepareUpdate(this.getInputRowMeta());
            if (this.meta.getComboInativa().equalsIgnoreCase("Selecione...") && this.meta.isInativa()) {
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"UpsertDelete.Exception.FieldInativaRequired", (String[])new String[0]));
            }
            this.data.keynrsDel = new int[this.meta.getKeyStreamDel().length];
            this.data.keynrsDel2 = new int[this.meta.getKeyStreamDel().length];
            for (i = 0; i < this.meta.getKeyStreamDel().length; ++i) {
                this.data.keynrsDel[i] = this.getInputRowMeta().indexOfValue(this.meta.getKeyStreamDel()[i]);
                if (this.data.keynrsDel[i] < 0 && !"IS NULL".equalsIgnoreCase(this.meta.getKeyConditionDel()[i]) && !"IS NOT NULL".equalsIgnoreCase(this.meta.getKeyConditionDel()[i])) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"UpsertDelete.Exception.FieldRequired", (String[])new String[]{this.meta.getKeyStreamDel()[i]}));
                }
                this.data.keynrsDel2[i] = this.getInputRowMeta().indexOfValue(this.meta.getKeyStreamDel2()[i]);
                if (this.data.keynrsDel2[i] < 0 && "BETWEEN".equalsIgnoreCase(this.meta.getKeyConditionDel()[i])) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"UpsertDelete.Exception.FieldRequired", (String[])new String[]{this.meta.getKeyStreamDel2()[i]}));
                }
                if (!this.log.isDebug()) continue;
                this.logDebug(BaseMessages.getString(PKG, (String)"UpsertDelete.Log.FieldInfo", (String[])new String[]{this.meta.getKeyStreamDel()[i]}) + this.data.keynrsDel[i]);
            }
            this.prepareDelete(this.getInputRowMeta());
            this.data.valuenrsIns = new int[this.meta.getFieldDatabase().length];
            for (i = 0; i < this.meta.getFieldDatabase().length; ++i) {
                this.data.valuenrsIns[i] = this.data.outputRowMeta.indexOfValue(this.meta.getFieldStream()[i]);
                if (this.data.valuenrsIns[i] >= 0) continue;
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"UpsertDelete.Exception.FieldRequired", (String[])new String[]{this.meta.getFieldStream()[i]}));
            }
            for (i = 0; i < this.meta.getFieldDatabase().length; ++i) {
                ValueMetaInterface insValue = this.data.outputRowMeta.searchValueMeta(this.meta.getFieldStream()[i]);
                if (insValue == null) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"UpsertDelete.Exception.FailedToFindField", (String[])new String[]{this.meta.getFieldStream()[i]}));
                }
                ValueMetaInterface insertValue = insValue.clone();
                insertValue.setName(this.meta.getFieldDatabase()[i]);
                this.data.insertRowMeta.addValueMeta(insertValue);
            }
        }
        for (int i3 = 0; i3 < this.getInputRowMeta().size(); ++i3) {
            if (!this.getInputRowMeta().getFieldNames()[i3].equals(this.meta.getFlag())) continue;
            flag = this.getInputRowMeta().getValueMeta(i3).getString(r[i3]);
        }
        switch (flag) {
            case "new": {
                if (this.meta.useSequence()) {
                    this.addSequence(this.data.outputRowMeta, r);
                    if (!this.data.batchMode || this.data.batchBuffer == null) break;
                    for (i = 0; i < this.data.batchBuffer.size(); ++i) {
                        Object[] row = this.data.batchBuffer.get(i);
                        this.putRow(this.data.outputRowMeta, row);
                        this.incrementLinesOutput();
                    }
                    this.data.batchBuffer.clear();
                    break;
                }
                try {
                    Object[] outputRowData = this.writeToTable(this.getInputRowMeta(), r);
                    if (outputRowData != null) {
                        this.putRow(this.data.outputRowMeta, outputRowData);
                        this.incrementLinesOutput();
                    }
                    if (!this.checkFeedback(this.getLinesRead()) || !this.log.isBasic()) break;
                    this.logBasic("linenr " + this.getLinesRead());
                    break;
                }
                catch (KettleException e) {
                    this.logError("Because of an error, this step can't continue: ", e);
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
            }
            case "changed": {
                this.updateObject.add(r);
                break;
            }
            case "deleted": {
                if (this.meta.isDelete() && this.meta.isInativa()) {
                    this.logError("APENAS UM CHECKBOX DEVE SER SELECIONADO. DELETE OU INATIVA!");
                    break;
                }
                if (this.meta.isDelete()) {
                    try {
                        this.deleteValues(this.getInputRowMeta(), r);
                        this.putRow(this.data.outputRowMeta, r);
                        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
                            this.logBasic(BaseMessages.getString(PKG, (String)"UpsertDelete.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
                        }
                        ++this.countDelete;
                    }
                    catch (KettleException e) {
                        if (!this.getStepMeta().isDoingErrorHandling()) {
                            this.logError(BaseMessages.getString(PKG, (String)"UpsertDelete.Log.ErrorInStepDel", (String[])new String[0]) + e.getMessage());
                            this.setErrors(1L);
                            this.stopAll();
                            this.setOutputDone();
                            return false;
                        }
                        sendToErrorRow = true;
                        errorMessage = e.toString();
                        if (!sendToErrorRow) break;
                        this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "DEL001");
                    }
                    break;
                }
                if (!this.meta.isInativa()) break;
                this.inativaObject.add(r);
                break;
            }
            case "identical": {
                try {
                    this.putRow(this.getInputRowMeta(), r);
                    ++this.countIdentical;
                }
                catch (Exception e) {
                    this.logError("ERRO NA SAIDA DA LINHA");
                }
                break;
            }
        }
        return true;
    }

    protected Object[] writeToTable(RowMetaInterface rowMeta, Object[] r) throws KettleException {
        if (r == null) {
            if (this.log.isDetailed()) {
                this.logDetailed("Last line inserted: stop");
            }
            return null;
        }
        PreparedStatement insertStatement = null;
        Object[] outputRowData = r;
        String tableName = null;
        boolean sendToErrorRow = false;
        String errorMessage = null;
        boolean rowIsSafe = false;
        int[] updateCounts = null;
        List exceptionsList = null;
        boolean batchProblem = false;
        tableName = this.data.tableName;
        Object[] insertRowData = r;
        insertRowData = new Object[this.data.valuenrsIns.length];
        for (int idx = 0; idx < this.data.valuenrsIns.length; ++idx) {
            insertRowData[idx] = r[this.data.valuenrsIns[idx]];
        }
        if (tableName == null || tableName.equals("")) {
            throw new KettleStepException("The tablename is not defined (empty)");
        }
        insertStatement = this.data.preparedStatements.get(tableName);
        if (insertStatement == null) {
            String sql = this.data.db.getInsertStatement(this.environmentSubstitute(this.meta.getSchemaName()), tableName, this.data.insertRowMeta);
            if (this.log.isDetailed()) {
                this.logDetailed("Prepared statement : " + sql);
            }
            insertStatement = this.data.db.prepareSQL(sql, false);
            this.data.preparedStatements.put(tableName, insertStatement);
        }
        try {
            Integer commitCounter;
            if (this.data.useSafePoints) {
                this.data.savepoint = this.data.db.setSavepoint();
            }
            if (this.meta.isLogDB() || this.logOperations) {
                this.logBasic("----------LOG INSERT---------- lineNr: " + (this.countNew + 1) + "\n");
                for (int i = 0; i < this.data.insertRowMeta.size(); ++i) {
                    this.logBasic(this.data.insertRowMeta.getValueMeta(i).getName() + " = " + String.valueOf(insertRowData[i]) + "\n");
                }
                this.logBasic("\n");
            }
            this.data.db.setValues(this.data.insertRowMeta, insertRowData, insertStatement);
            this.data.db.insertRow(insertStatement, this.data.batchMode, false);
            if (this.isRowLevel()) {
                this.logRowlevel("Written row: " + this.data.insertRowMeta.getString(insertRowData));
            }
            if ((commitCounter = this.data.commitCounterMap.get(tableName)) == null) {
                commitCounter = 1;
            } else {
                Integer n = commitCounter;
                Integer n2 = commitCounter = Integer.valueOf(commitCounter + 1);
            }
            this.data.commitCounterMap.put(tableName, (int)commitCounter);
            if (this.data.useSafePoints && this.data.releaseSavepoint) {
                this.data.db.releaseSavepoint(this.data.savepoint);
            }
            if (this.data.commitSize > 0 && commitCounter % this.data.commitSize == 0) {
                if (this.data.db.getUseBatchInsert(this.data.batchMode)) {
                    try {
                        insertStatement.executeBatch();
                        this.data.db.commit();
                        insertStatement.clearBatch();
                    }
                    catch (SQLException ex) {
                        throw Database.createKettleDatabaseBatchException((String)"Error updating batch", (SQLException)ex);
                    }
                    catch (Exception ex) {
                        throw new KettleDatabaseException("Unexpected error inserting row", (Throwable)ex);
                    }
                } else {
                    this.data.db.commit();
                }
                this.data.commitCounterMap.put(tableName, 0);
                rowIsSafe = true;
            } else {
                rowIsSafe = false;
            }
        }
        catch (KettleDatabaseBatchException be) {
            errorMessage = be.toString();
            batchProblem = true;
            sendToErrorRow = true;
            updateCounts = be.getUpdateCounts();
            exceptionsList = be.getExceptionsList();
            if (this.getStepMeta().isDoingErrorHandling()) {
                this.data.db.clearBatch(insertStatement);
                this.data.db.commit(true);
            }
            this.data.db.clearBatch(insertStatement);
            this.data.db.rollback();
            StringBuilder msg = new StringBuilder("Error batch inserting rows into table [" + tableName + "].");
            msg.append(Const.CR);
            msg.append("Errors encountered (first 10):").append(Const.CR);
            for (int x = 0; x < be.getExceptionsList().size() && x < 10; ++x) {
                Exception exception = (Exception)be.getExceptionsList().get(x);
                if (exception.getMessage() == null) continue;
                msg.append(exception.getMessage()).append(Const.CR);
            }
            throw new KettleException(msg.toString(), (Throwable)be);
        }
        catch (KettleDatabaseException dbe) {
            if (this.getStepMeta().isDoingErrorHandling()) {
                if (this.isRowLevel()) {
                    this.logRowlevel("Written row to error handling : " + this.getInputRowMeta().getString(r));
                }
                if (this.data.useSafePoints) {
                    this.data.db.rollback(this.data.savepoint);
                    if (this.data.releaseSavepoint) {
                        this.data.db.releaseSavepoint(this.data.savepoint);
                    }
                }
                sendToErrorRow = true;
                errorMessage = dbe.toString();
            }
            this.setErrors(this.getErrors() + 1L);
            this.data.db.rollback();
            throw new KettleException("Error inserting row into table [" + tableName + "] with values: " + rowMeta.getString(r), (Throwable)dbe);
        }
        if (this.data.batchMode) {
            if (sendToErrorRow) {
                if (batchProblem) {
                    this.data.batchBuffer.add(outputRowData);
                    outputRowData = null;
                    this.processBatchException(errorMessage, updateCounts, exceptionsList);
                } else {
                    this.putError(rowMeta, r, 1L, errorMessage, null, "TOP001");
                    outputRowData = null;
                }
            } else {
                this.data.batchBuffer.add(outputRowData);
                outputRowData = null;
                if (rowIsSafe) {
                    for (int i = 0; i < this.data.batchBuffer.size(); ++i) {
                        Object[] row = this.data.batchBuffer.get(i);
                        this.putRow(this.data.outputRowMeta, row);
                        this.incrementLinesOutput();
                    }
                    this.data.batchBuffer.clear();
                }
            }
        } else if (sendToErrorRow) {
            this.putError(rowMeta, r, 1L, errorMessage, null, "TOP001");
            outputRowData = null;
        }
        ++this.countNew;
        return outputRowData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSequence(RowMetaInterface inputRowMeta, Object[] r) throws KettleException {
        Object[] outputRowData;
        Long next = null;
        if (this.meta.isNumber()) {
            Counter counter = this.data.counter;
            synchronized (counter) {
                long prev = this.data.counter.getCounter();
                long nval = prev + this.data.increment;
                if (this.data.increment > 0L && this.data.maximum > this.data.start && nval > this.data.maximum) {
                    nval = this.data.start;
                }
                if (this.data.increment < 0L && this.data.maximum < this.data.start && nval < this.data.maximum) {
                    nval = this.data.start;
                }
                this.data.counter.setCounter(nval);
                next = prev;
            }
        } else if (!this.meta.isNumber()) {
            try {
                next = this.data.getDb().getNextSequenceValue(this.data.realSchemaName, this.data.realSequenceName, this.meta.getValuename());
            }
            catch (KettleDatabaseException dbe) {
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"UpsertDelete.Exception.ErrorReadingSequence", (String[])new String[]{this.data.realSequenceName}), (Throwable)dbe);
            }
        } else {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"UpsertDelete.Exception.NoSpecifiedMethod", (String[])new String[0]));
        }
        if (next != null) {
            outputRowData = r;
            if (r.length < inputRowMeta.size() + 1) {
                outputRowData = RowDataUtil.resizeArray((Object[])r, (int)(inputRowMeta.size() + 1));
            }
        } else {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"UpsertDelete.Exception.CouldNotFindNextValueForSequence", (String[])new String[0]) + this.meta.getValuename());
        }
        outputRowData[inputRowMeta.size() - 1] = next;
        try {
            Object[] outputRowData2 = this.writeToTable(inputRowMeta, outputRowData);
            if (outputRowData2 != null) {
                this.putRow(inputRowMeta, outputRowData2);
                this.incrementLinesOutput();
            }
            if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
                this.logBasic("linenr " + this.getLinesRead());
            }
        }
        catch (KettleException e) {
            this.logError("Because of an error, this step can't continue: ", e);
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
        }
    }

    public boolean isRowLevel() {
        return this.log.isRowLevel();
    }

    private void processBatchException(String errorMessage, int[] updateCounts, List<Exception> exceptionsList) throws KettleException {
        if (updateCounts != null) {
            int errNr = 0;
            for (int i = 0; i < updateCounts.length; ++i) {
                Object[] row = this.data.batchBuffer.get(i);
                if (updateCounts[i] > 0) {
                    this.putRow(this.data.outputRowMeta, row);
                    this.incrementLinesOutput();
                    continue;
                }
                String exMessage = errorMessage;
                if (errNr < exceptionsList.size()) {
                    SQLException se = (SQLException)exceptionsList.get(errNr);
                    ++errNr;
                    exMessage = se.toString();
                }
                this.putError(this.data.outputRowMeta, row, 1L, exMessage, null, "TOP0002");
            }
        } else {
            for (int i = 0; i < this.data.batchBuffer.size(); ++i) {
                Object[] row = this.data.batchBuffer.get(i);
                this.putError(this.data.outputRowMeta, row, 1L, errorMessage, null, "TOP0003");
            }
        }
        this.data.batchBuffer.clear();
    }

    protected UpsertDeleteMeta getMeta() {
        return this.meta;
    }

    protected UpsertDeleteData getData() {
        return this.data;
    }

    protected void setMeta(UpsertDeleteMeta meta) {
        this.meta = meta;
    }

    protected void setData(UpsertDeleteData data) {
        this.data = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (UpsertDeleteMeta)smi;
        this.data = (UpsertDeleteData)sdi;
        if (this.meta.isNumber()) {
            if (this.data.getLookup() != null) {
                this.getTrans().getCounters().remove(this.data.getLookup());
            }
            this.data.counter = null;
        }
        if (this.data.db != null) {
            try {
                for (String schemaTable : this.data.preparedStatements.keySet()) {
                    Integer batchCounter = this.data.commitCounterMap.get(schemaTable);
                    if (batchCounter == null) {
                        batchCounter = 0;
                    }
                    PreparedStatement insertStatement = this.data.preparedStatements.get(schemaTable);
                    this.data.db.emptyAndCommit(insertStatement, this.data.batchMode, batchCounter.intValue());
                }
                for (int i = 0; i < this.data.batchBuffer.size(); ++i) {
                    Object[] row = this.data.batchBuffer.get(i);
                    this.putRow(this.data.outputRowMeta, row);
                    this.incrementLinesOutput();
                }
                this.data.batchBuffer.clear();
            }
            catch (KettleDatabaseBatchException be) {
                if (this.getStepMeta().isDoingErrorHandling()) {
                    try {
                        this.processBatchException(be.toString(), be.getUpdateCounts(), be.getExceptionsList());
                    }
                    catch (KettleException e) {
                        this.logError("Unexpected error processing batch error", e);
                        this.setErrors(1L);
                        this.stopAll();
                    }
                } else {
                    this.logError("Unexpected batch update error committing the database connection.", be);
                    this.setErrors(1L);
                    this.stopAll();
                }
            }
            catch (Exception dbe) {
                this.logError("Unexpected error committing the database connection.", dbe);
                this.logError(Const.getStackTracker((Throwable)dbe));
                this.setErrors(1L);
                this.stopAll();
            }
            finally {
                this.setOutputDone();
                if (this.getErrors() > 0L) {
                    try {
                        this.data.db.rollback();
                    }
                    catch (KettleDatabaseException e) {
                        this.logError("Unexpected error rolling back the database connection.", e);
                    }
                }
                this.data.db.disconnect();
            }
        }
        if (this.data.dbUp != null) {
            try {
                if (!this.data.dbUp.isAutoCommit()) {
                    if (this.getErrors() == 0L) {
                        this.data.dbUp.emptyAndCommit(this.data.prepStatementUpdate, this.meta.useBatchUpdateUp());
                    } else {
                        this.data.dbUp.rollback();
                    }
                }
                this.data.dbUp.closePreparedStatement(this.data.prepStatementUpdate);
                this.data.dbUp.closePreparedStatement(this.data.prepStatementLookup);
            }
            catch (KettleDatabaseException e) {
                this.logError(BaseMessages.getString(PKG, (String)"Upsertdelete.Log.UnableToCommitUpdateConnection", (String[])new String[0]) + String.valueOf(this.data.dbUp) + "] :" + e.toString());
                this.setErrors(1L);
            }
            finally {
                this.data.dbUp.disconnect();
            }
        }
        if (this.data.dbIna != null) {
            try {
                if (!this.data.dbIna.isAutoCommit()) {
                    if (this.getErrors() == 0L) {
                        this.data.dbIna.emptyAndCommit(this.data.prepStatementInativa, this.meta.useBatchUpdateUp());
                    } else {
                        this.data.dbIna.rollback();
                    }
                }
                this.data.dbIna.closePreparedStatement(this.data.prepStatementInativa);
                this.data.dbIna.closePreparedStatement(this.data.prepStatementLookupIna);
            }
            catch (KettleDatabaseException e) {
                this.logError(BaseMessages.getString(PKG, (String)"Upsertdelete.Log.UnableToCommitUpdateConnection", (String[])new String[0]) + String.valueOf(this.data.dbIna) + "] :" + e.toString());
                this.setErrors(1L);
            }
            finally {
                this.data.dbIna.disconnect();
            }
        }
        if (this.data.dbDel != null) {
            try {
                if (!this.data.dbDel.isAutoCommit()) {
                    if (this.getErrors() == 0L) {
                        this.data.dbDel.commit();
                    } else {
                        this.data.dbDel.rollback();
                    }
                }
                this.data.dbDel.closeUpdate();
            }
            catch (KettleDatabaseException e) {
                this.logError(BaseMessages.getString(PKG, (String)"UpsertDelete.Log.UnableToCommitUpdateConnection", (String[])new String[0]) + String.valueOf(this.data.dbDel) + "] :" + e.toString());
                this.setErrors(1L);
            }
            finally {
                this.data.dbDel.disconnect();
            }
        }
        super.dispose(smi, sdi);
    }

    public void setLookup(RowMetaInterface rowMeta) throws KettleDatabaseException {
        int i;
        this.data.lookupParameterRowMeta = new RowMeta();
        this.data.inativaParameterRowMeta = new RowMeta();
        this.data.lookupReturnRowMeta = new RowMeta();
        this.data.lookupReturnRowMetaIna = new RowMeta();
        DatabaseMeta databaseMeta = this.meta.getDatabaseMeta();
        Object sql = "SELECT ";
        Object sqlInativa = "SELECT ";
        for (i = 0; i < this.meta.getUpdateLookup().length; ++i) {
            if (i != 0) {
                sql = (String)sql + ", ";
            }
            sql = (String)sql + databaseMeta.quoteField(this.meta.getUpdateLookup()[i]);
            this.data.lookupReturnRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getUpdateStream()[i]));
        }
        if (this.meta.getKeyLookupDel().length > 0) {
            sqlInativa = (String)sqlInativa + " 0 AS " + this.meta.getComboInativa();
            this.data.lookupReturnRowMetaIna.addValueMeta(rowMeta.searchValueMeta(this.meta.getComboInativa()));
        }
        sql = (String)sql + " FROM " + this.data.schemaTable + " WHERE ";
        sqlInativa = (String)sqlInativa + " FROM " + this.data.schemaTable + " WHERE ";
        for (i = 0; i < this.meta.getKeyLookup().length; ++i) {
            if (i != 0) {
                sql = (String)sql + " AND ";
            }
            sql = (String)sql + " ( ( ";
            sql = (String)sql + databaseMeta.quoteField(this.meta.getKeyLookup()[i]);
            if ("BETWEEN".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                sql = (String)sql + " BETWEEN ? AND ? ";
                this.data.lookupParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream()[i]));
                this.data.lookupParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream2()[i]));
            } else if ("IS NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i]) || "IS NOT NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                sql = (String)sql + " " + this.meta.getKeyCondition()[i] + " ";
            } else if ("= ~NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                sql = (String)sql + " IS NULL AND ";
                sql = databaseMeta.requiresCastToVariousForIsNull() ? (String)sql + "CAST(? AS VARCHAR(256)) IS NULL" : (String)sql + "? IS NULL";
                this.data.lookupParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream()[i]));
                sql = (String)sql + " ) OR ( " + databaseMeta.quoteField(this.meta.getKeyLookup()[i]) + " = ?";
                this.data.lookupParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream()[i]).clone());
            } else {
                sql = (String)sql + " " + this.meta.getKeyCondition()[i] + " ? ";
                this.data.lookupParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream()[i]));
            }
            sql = (String)sql + " ) ) ";
        }
        for (i = 0; i < this.meta.getKeyLookupDel().length; ++i) {
            if (i != 0) {
                sqlInativa = (String)sqlInativa + " AND ";
            }
            sqlInativa = (String)sqlInativa + " ( ( ";
            sqlInativa = (String)sqlInativa + databaseMeta.quoteField(this.meta.getKeyLookupDel()[i]);
            if ("BETWEEN".equalsIgnoreCase(this.meta.getKeyConditionDel()[i])) {
                sqlInativa = (String)sqlInativa + " BETWEEN ? AND ? ";
                this.data.inativaParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStreamDel()[i]));
                this.data.inativaParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStreamDel2()[i]));
            } else if ("IS NULL".equalsIgnoreCase(this.meta.getKeyConditionDel()[i]) || "IS NOT NULL".equalsIgnoreCase(this.meta.getKeyConditionDel()[i])) {
                sqlInativa = (String)sqlInativa + " " + this.meta.getKeyConditionDel()[i] + " ";
            } else if ("= ~NULL".equalsIgnoreCase(this.meta.getKeyConditionDel()[i])) {
                sqlInativa = (String)sqlInativa + " IS NULL AND ";
                sqlInativa = databaseMeta.requiresCastToVariousForIsNull() ? (String)sqlInativa + "CAST(? AS VARCHAR(256)) IS NULL" : (String)sqlInativa + "? IS NULL";
                this.data.inativaParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStreamDel()[i]));
                sqlInativa = (String)sqlInativa + " ) OR ( " + databaseMeta.quoteField(this.meta.getKeyLookupDel()[i]) + " = ?";
                this.data.inativaParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStreamDel()[i]).clone());
            } else {
                sqlInativa = (String)sqlInativa + " " + this.meta.getKeyConditionDel()[i] + " ? ";
                this.data.inativaParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStreamDel()[i]));
            }
            sqlInativa = (String)sqlInativa + " ) ) ";
        }
        try {
            if (this.log.isDetailed()) {
                this.logDetailed("Setting preparedStatement to [" + (String)sql + "]");
                this.logDetailed("Setting preparedStatement to [" + (String)sqlInativa + "]");
            }
            this.data.prepStatementLookup = this.data.dbUp.getConnection().prepareStatement(databaseMeta.stripCR((String)sql));
            this.data.prepStatementLookupIna = this.data.dbIna.getConnection().prepareStatement(databaseMeta.stripCR((String)sqlInativa));
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Unable to prepare statement for SQL statement [" + (String)sql + "]       OR      [" + (String)sqlInativa + "]", (Throwable)ex);
        }
    }

    public void prepareUpdate(RowMetaInterface rowMeta) throws KettleDatabaseException {
        int i;
        DatabaseMeta databaseMeta = this.meta.getDatabaseMeta();
        DatabaseMeta databaseMetaIna = this.meta.getDatabaseMeta();
        this.data.updateParameterRowMeta = new RowMeta();
        this.data.inativaParameterRowMeta = new RowMeta();
        String sql = "UPDATE " + this.data.schemaTable + Const.CR;
        String sqlInativa = "UPDATE " + this.data.schemaTable + Const.CR;
        sql = sql + " SET ";
        sqlInativa = this.meta.isCheckBool() ? sqlInativa + " SET " + this.meta.getComboInativa() + " = false " : sqlInativa + " SET " + this.meta.getComboInativa() + " = 0 ";
        for (i = 0; i < this.meta.getUpdateLookup().length; ++i) {
            if (i != 0) {
                sql = sql + ",   ";
            }
            sql = sql + databaseMeta.quoteField(this.meta.getUpdateLookup()[i]);
            sql = sql + " = ?" + Const.CR;
            this.data.updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getUpdateStream()[i]));
        }
        sql = sql + " WHERE ";
        sqlInativa = sqlInativa + " WHERE ";
        for (i = 0; i < this.meta.getKeyLookupDel().length; ++i) {
            if (i != 0) {
                sqlInativa = sqlInativa + " AND   ";
            }
            sqlInativa = sqlInativa + " ( ( ";
            sqlInativa = sqlInativa + databaseMetaIna.quoteField(this.meta.getKeyLookupDel()[i]);
            if ("BETWEEN".equalsIgnoreCase(this.meta.getKeyConditionDel()[i])) {
                sqlInativa = sqlInativa + " BETWEEN ? AND ? ";
                this.data.inativaParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStreamDel()[i]));
                this.data.inativaParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStreamDel2()[i]));
            } else if ("IS NULL".equalsIgnoreCase(this.meta.getKeyConditionDel()[i]) || "IS NOT NULL".equalsIgnoreCase(this.meta.getKeyConditionDel()[i])) {
                sqlInativa = sqlInativa + " " + this.meta.getKeyConditionDel()[i] + " ";
            } else if ("= ~NULL".equalsIgnoreCase(this.meta.getKeyConditionDel()[i])) {
                sqlInativa = sqlInativa + " IS NULL AND ";
                sqlInativa = databaseMetaIna.requiresCastToVariousForIsNull() ? sqlInativa + "CAST(? AS VARCHAR(256)) IS NULL" : sqlInativa + "? IS NULL";
                this.data.inativaParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStreamDel()[i]));
                sqlInativa = sqlInativa + " ) OR ( " + databaseMetaIna.quoteField(this.meta.getKeyLookupDel()[i]) + " = ?";
                this.data.inativaParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStreamDel()[i]).clone());
            } else {
                sqlInativa = sqlInativa + " " + this.meta.getKeyConditionDel()[i] + " ? ";
                this.data.inativaParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStreamDel()[i]));
            }
            sqlInativa = sqlInativa + " ) ) ";
        }
        for (i = 0; i < this.meta.getKeyLookup().length; ++i) {
            if (i != 0) {
                sql = sql + "AND   ";
            }
            sql = sql + " ( ( ";
            sql = sql + databaseMeta.quoteField(this.meta.getKeyLookup()[i]);
            if ("BETWEEN".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                sql = sql + " BETWEEN ? AND ? ";
                this.data.updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream()[i]));
                this.data.updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream2()[i]));
            } else if ("IS NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i]) || "IS NOT NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                sql = sql + " " + this.meta.getKeyCondition()[i] + " ";
            } else if ("= ~NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                sql = sql + " IS NULL AND ";
                sql = databaseMeta.requiresCastToVariousForIsNull() ? sql + "CAST(? AS VARCHAR(256)) IS NULL" : sql + "? IS NULL";
                this.data.updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream()[i]));
                sql = sql + " ) OR ( " + databaseMeta.quoteField(this.meta.getKeyLookup()[i]) + " = ?";
                this.data.updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream()[i]).clone());
            } else {
                sql = sql + " " + this.meta.getKeyCondition()[i] + " ? ";
                this.data.updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream()[i]));
            }
            sql = sql + " ) ) ";
        }
        try {
            if (this.log.isDetailed()) {
                this.logDetailed("Setting update preparedStatement to [" + sql + "]");
                this.logDetailed("Setting inativa preparedStatement to [" + sqlInativa + "]");
            }
            this.data.prepStatementUpdate = this.data.dbUp.getConnection().prepareStatement(databaseMeta.stripCR(sql));
            this.data.prepStatementInativa = this.data.dbIna.getConnection().prepareStatement(databaseMetaIna.stripCR(sqlInativa));
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Unable to prepare statement for SQL statement [" + sql + "]    OR     [" + sqlInativa + "]", (Throwable)ex);
        }
    }

    private synchronized void deleteValues(RowMetaInterface rowMeta, Object[] row) throws KettleException {
        int i;
        Object[] deleteRow = new Object[this.data.deleteParameterRowMeta.size()];
        int deleteIndex = 0;
        for (i = 0; i < this.meta.getKeyStreamDel().length; ++i) {
            if (this.data.keynrsDel[i] >= 0) {
                deleteRow[deleteIndex] = row[this.data.keynrsDel[i]];
                ++deleteIndex;
            }
            if (this.data.keynrsDel2[i] < 0) continue;
            deleteRow[deleteIndex] = row[this.data.keynrsDel2[i]];
            ++deleteIndex;
        }
        if (this.meta.isLogDB() || this.logOperations) {
            this.logBasic("----------LOG DELETE---------- lineNr: " + (this.countDelete + 1) + "\n");
            for (i = 0; i < this.getInputRowMeta().size() - 1; ++i) {
                this.logBasic(rowMeta.getValueMeta(i).getName() + " = " + String.valueOf(row[i]) + "\n");
            }
            this.logBasic("\n");
        }
        this.data.dbDel.setValues(this.data.deleteParameterRowMeta, deleteRow, this.data.prepStatementDelete);
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"UpsertDelete.Log.SetValuesForDelete", (String[])new String[]{this.data.deleteParameterRowMeta.getString(deleteRow), rowMeta.getString(row)}));
        }
        this.data.dbDel.insertRow(this.data.prepStatementDelete);
        this.incrementLinesUpdated();
    }

    public void prepareDelete(RowMetaInterface rowMeta) throws KettleDatabaseException {
        DatabaseMeta databaseMeta = this.meta.getDatabaseMeta();
        this.data.deleteParameterRowMeta = new RowMeta();
        String sql = "DELETE FROM " + this.data.schemaTable + Const.CR;
        sql = sql + "WHERE ";
        for (int i = 0; i < this.meta.getKeyLookupDel().length; ++i) {
            if (i != 0) {
                sql = sql + "AND   ";
            }
            sql = sql + databaseMeta.quoteField(this.meta.getKeyLookupDel()[i]);
            if ("BETWEEN".equalsIgnoreCase(this.meta.getKeyConditionDel()[i])) {
                sql = sql + " BETWEEN ? AND ? ";
                this.data.deleteParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStreamDel()[i]));
                this.data.deleteParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStreamDel2()[i]));
                continue;
            }
            if ("IS NULL".equalsIgnoreCase(this.meta.getKeyConditionDel()[i]) || "IS NOT NULL".equalsIgnoreCase(this.meta.getKeyConditionDel()[i])) {
                sql = sql + " " + this.meta.getKeyConditionDel()[i] + " ";
                continue;
            }
            sql = sql + " " + this.meta.getKeyConditionDel()[i] + " ? ";
            this.data.deleteParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStreamDel()[i]));
        }
        try {
            if (this.log.isDetailed()) {
                this.logDetailed("Setting delete preparedStatement to [" + sql + "]");
            }
            this.data.prepStatementDelete = this.data.dbDel.getConnection().prepareStatement(databaseMeta.stripCR(sql));
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Unable to prepare statement for SQL statement [" + sql + "]", (Throwable)ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized Object[] inativa(RowMetaInterface rowMeta, Object[] row, int nrRow) throws KettleException {
        Object[] outputRow = row;
        Object[] lookupRow = new Object[this.data.keynrsDel.length];
        int lookupIndex = 0;
        for (int i = 0; i < this.data.keynrsDel.length; ++i) {
            if (this.data.keynrsDel[i] >= 0) {
                lookupRow[lookupIndex] = row[this.data.keynrsDel[i]];
                ++lookupIndex;
            }
            if (this.data.keynrsDel2[i] < 0) continue;
            lookupRow[lookupIndex] = row[this.data.keynrsDel2[i]];
            ++lookupIndex;
        }
        RowMetaInterface returnRowMeta = null;
        this.data.dbIna.setValues(this.data.inativaParameterRowMeta, lookupRow, this.data.prepStatementLookupIna);
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"UpsertDelete.Log.ValuesSetForLookup", (String[])new String[]{this.data.inativaParameterRowMeta.getString(lookupRow), rowMeta.getString(row)}));
        }
        Object[] add = this.data.dbIna.getLookup(this.data.prepStatementLookupIna);
        returnRowMeta = this.data.dbIna.getReturnRowMeta();
        this.incrementLinesInput();
        if (add == null) {
            if (!this.getStepMeta().isDoingErrorHandling()) throw new KettleDatabaseException(BaseMessages.getString(PKG, (String)"UpsertDelete.Exception.KeyCouldNotFound", (String[])new String[0]) + this.data.inativaParameterRowMeta.getString(lookupRow));
            outputRow = null;
            if (this.data.stringErrorKeyNotFound == null) {
                this.data.stringErrorKeyNotFound = BaseMessages.getString(PKG, (String)"UpsertDelete.Exception.KeyCouldNotFound", (String[])new String[0]) + this.data.inativaParameterRowMeta.getString(lookupRow);
                this.data.stringFieldnames = "";
                for (int i = 0; i < this.data.inativaParameterRowMeta.size(); ++i) {
                    if (i > 0) {
                        this.data.stringFieldnames = this.data.stringFieldnames + ", ";
                    }
                    this.data.stringFieldnames = this.data.stringFieldnames + this.data.inativaParameterRowMeta.getValueMeta(i).getName();
                }
            }
            this.putError(rowMeta, row, 1L, this.data.stringErrorKeyNotFound, this.data.stringFieldnames, "UPD001");
            return outputRow;
        } else {
            if (this.log.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"UpsertDelete.Log.FoundRow", (String[])new String[0]) + "0");
            }
            boolean update = false;
            for (int i = 0; i < returnRowMeta.size(); ++i) {
                Object retvalue;
                ValueMetaInterface valueMeta = rowMeta.searchValueMeta(this.meta.getComboInativa());
                int idx = rowMeta.indexOfValue(rowMeta.searchValueMeta(this.meta.getComboInativa()).getName());
                Object rowvalue = row[idx];
                ValueMetaInterface returnValueMeta = returnRowMeta.getValueMeta(i);
                if (returnValueMeta.compare(retvalue = add[i], valueMeta, rowvalue) == 0) continue;
                update = true;
            }
            if (update) {
                int indexInativaField;
                int i;
                Object[] updateRow = new Object[this.data.inativaParameterRowMeta.size()];
                for (i = 0; i < returnRowMeta.size(); ++i) {
                    updateRow[i] = row[this.data.valuenrsIns[i]];
                }
                for (i = 0; i < lookupRow.length; ++i) {
                    updateRow[0] = lookupRow[i];
                }
                if (this.log.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"Upsertdelete.Log.UpdateRow", (String[])new String[0]) + this.data.inativaParameterRowMeta.getString(lookupRow));
                }
                if (row[indexInativaField = rowMeta.indexOfValue(this.meta.getComboInativa())].toString().equalsIgnoreCase("1") || row[indexInativaField].toString().equalsIgnoreCase("true")) {
                    if (this.meta.isLogDB() || this.logOperations) {
                        this.logBasic("----------LOG INATIVA---------- lineNr: " + nrRow + "\n");
                        for (int i2 = 0; i2 < this.getInputRowMeta().size() - 1; ++i2) {
                            if (this.meta.getComboInativa().equalsIgnoreCase(rowMeta.getValueMeta(i2).getName())) {
                                this.logBasic("idnAtivo = 0\n");
                                continue;
                            }
                            this.logBasic(rowMeta.getValueMeta(i2).getName() + " = " + String.valueOf(row[i2]) + "\n");
                        }
                        this.logBasic("\n");
                    }
                    this.data.dbIna.setValues(this.data.inativaParameterRowMeta, updateRow, this.data.prepStatementInativa);
                    this.data.dbIna.insertRow(this.data.prepStatementInativa, false, true);
                    this.incrementLinesUpdated();
                    ++this.countInativa;
                    return outputRow;
                } else {
                    ++this.countIdentical;
                }
                return outputRow;
            } else {
                this.incrementLinesSkipped();
            }
        }
        return outputRow;
    }
}

