/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.monospace;

import org.pentaho.reporting.libraries.fonts.monospace.MonospaceFontRecord;
import org.pentaho.reporting.libraries.fonts.registry.FontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontRecord;

public class MonospaceFontFamily
implements FontFamily {
    private String familyName;
    private FontRecord[] fonts;
    private float lpi;
    private float cpi;

    public MonospaceFontFamily(String familyName, float lpi, float cpi) {
        if (familyName == null) {
            throw new NullPointerException();
        }
        this.familyName = familyName;
        this.fonts = new FontRecord[4];
        this.lpi = lpi;
        this.cpi = cpi;
    }

    @Override
    public String getFamilyName() {
        return this.familyName;
    }

    @Override
    public String[] getAllNames() {
        return new String[]{this.familyName};
    }

    @Override
    public FontRecord getFontRecord(boolean bold, boolean italics) {
        int index = 0;
        if (bold) {
            ++index;
        }
        if (italics) {
            index += 2;
        }
        if (this.fonts[index] != null) {
            return this.fonts[index];
        }
        this.fonts[index] = new MonospaceFontRecord(this, bold, italics);
        return this.fonts[index];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MonospaceFontFamily that = (MonospaceFontFamily)o;
        if (this.lpi != that.lpi) {
            return false;
        }
        if (this.cpi != that.cpi) {
            return false;
        }
        return this.familyName.equals(that.familyName);
    }

    public int hashCode() {
        int result = this.familyName.hashCode();
        result = 31 * result + (this.lpi != 0.0f ? Float.floatToIntBits(this.lpi) : 0);
        result = 31 * result + (this.cpi != 0.0f ? Float.floatToIntBits(this.cpi) : 0);
        return result;
    }
}

