/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.PageTimeStamp;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.data.DataFactory;

public final class ReclaimSpace
implements Serviceable {
    private boolean serviceASAP;
    private ContainerKey containerId;
    private PageKey pageId;
    private RecordHandle headRowHandle;
    private int columnId;
    private long columnPageId;
    private int columnRecordId;
    private PageTimeStamp timeStamp;
    private int attempts;
    private DataFactory processor;
    private int reclaim;
    public static final int CONTAINER = 1;
    public static final int PAGE = 2;
    public static final int ROW_RESERVE = 3;
    public static final int COLUMN_CHAIN = 4;

    private void initContainerInfo(ContainerKey containerKey, int n, DataFactory dataFactory, boolean bl) {
        this.containerId = containerKey;
        this.reclaim = n;
        this.attempts = 0;
        this.processor = dataFactory;
        this.serviceASAP = bl;
    }

    public ReclaimSpace(int n, ContainerKey containerKey, DataFactory dataFactory, boolean bl) {
        this.initContainerInfo(containerKey, n, dataFactory, bl);
    }

    public ReclaimSpace(int n, PageKey pageKey, DataFactory dataFactory, boolean bl) {
        this.initContainerInfo(pageKey.getContainerId(), n, dataFactory, bl);
        this.pageId = pageKey;
    }

    public ReclaimSpace(int n, RecordHandle recordHandle, DataFactory dataFactory, boolean bl) {
        this.initContainerInfo(recordHandle.getContainerId(), n, dataFactory, bl);
        this.headRowHandle = recordHandle;
    }

    public ReclaimSpace(int n, RecordHandle recordHandle, int n2, long l, int n3, PageTimeStamp pageTimeStamp, DataFactory dataFactory, boolean bl) {
        this.initContainerInfo(recordHandle.getContainerId(), n, dataFactory, bl);
        this.headRowHandle = recordHandle;
        this.columnId = n2;
        this.columnPageId = l;
        this.columnRecordId = n3;
        this.timeStamp = pageTimeStamp;
    }

    @Override
    public boolean serviceASAP() {
        return this.serviceASAP;
    }

    @Override
    public int performWork(ContextManager contextManager) throws StandardException {
        return this.processor.reclaimSpace(this, contextManager);
    }

    @Override
    public boolean serviceImmediately() {
        return true;
    }

    public final ContainerKey getContainerId() {
        return this.containerId;
    }

    public final PageKey getPageId() {
        return this.pageId;
    }

    public final RecordHandle getHeadRowHandle() {
        return this.headRowHandle;
    }

    public final int getColumnId() {
        return this.columnId;
    }

    public final long getColumnPageId() {
        return this.columnPageId;
    }

    public final int getColumnRecordId() {
        return this.columnRecordId;
    }

    public final PageTimeStamp getPageTimeStamp() {
        return this.timeStamp;
    }

    public final int reclaimWhat() {
        return this.reclaim;
    }

    public final int incrAttempts() {
        return ++this.attempts;
    }

    public String toString() {
        return null;
    }
}

