/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.kettle.repository.locator.api.impl;

import java.util.Collection;
import java.util.Objects;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.service.PluginServiceLoader;
import org.pentaho.di.core.service.ServiceProvider;
import org.pentaho.di.core.service.ServiceProviderInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.kettle.repository.locator.api.KettleRepositoryLocator;
import org.pentaho.kettle.repository.locator.api.KettleRepositoryProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceProvider(id="KettleRepositoryLocator", description="Provides access to the repository", provides=KettleRepositoryLocator.class)
public class KettleRepositoryLocatorImpl
implements KettleRepositoryLocator,
ServiceProviderInterface<KettleRepositoryLocator> {
    Logger logger = LoggerFactory.getLogger(KettleRepositoryLocator.class);

    public Repository getRepository() {
        try {
            Collection repositoryProviders = PluginServiceLoader.loadServices(KettleRepositoryProvider.class);
            return repositoryProviders.stream().map(KettleRepositoryProvider::getRepository).filter(Objects::nonNull).findFirst().orElse(null);
        }
        catch (KettlePluginException e) {
            this.logger.error("Error getting repository", (Throwable)e);
            return null;
        }
    }
}

