/*
 * Decompiled with CFR 0.152.
 */
package org.ftp4che.util.ftpfile;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.ftp4che.util.ftpfile.EPLFFileParser;
import org.ftp4che.util.ftpfile.FTPFile;
import org.ftp4che.util.ftpfile.FileParser;
import org.ftp4che.util.ftpfile.LastChanceFileParser;
import org.ftp4che.util.ftpfile.NetwareFileParser;
import org.ftp4che.util.ftpfile.UnixFileParser;
import org.ftp4che.util.ftpfile.VMSFileParser;
import org.ftp4che.util.ftpfile.WindowsFileParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FTPFileFactory {
    private static Logger log = Logger.getLogger(FTPFileFactory.class);
    public static final String UNIX_IDENTIFICATION = "UNIX";
    public static final String WINDOWS_IDENTIFICATION = "WINDOWS";
    public static final String VMS_IDENTIFICATION = "VMS";
    private String system;
    private FileParser parser = null;
    public Locale locale;

    public FTPFileFactory(String system) {
        this.system = system.toUpperCase();
        this.locale = Locale.getDefault();
        this.parser = this.getParserInstance();
    }

    public FTPFileFactory(String system, Locale locale) {
        this.system = system.toUpperCase();
        this.locale = locale;
        this.parser = this.getParserInstance();
    }

    public String getSystem() {
        return this.system;
    }

    public FileParser getParserInstance() {
        if (this.system.indexOf(UNIX_IDENTIFICATION) >= 0) {
            log.debug((Object)"Found UNIX identification, try to use UNIX file parser");
            return new UnixFileParser(this.locale);
        }
        if (this.system.indexOf(WINDOWS_IDENTIFICATION) >= 0) {
            log.debug((Object)"Found WINDOWS identification, try to use WINDOWS file parser");
            return new WindowsFileParser(this.locale);
        }
        if (this.system.indexOf(VMS_IDENTIFICATION) >= 0) {
            log.debug((Object)"Found VMS identification, try to use VMS file parser");
            return new VMSFileParser(this.locale);
        }
        log.warn((Object)("Unknown SYST '" + this.system + "', trying UnixFileParsers"));
        return null;
    }

    public List<FTPFile> parse(List<String> serverLines, String parentPath) {
        ArrayList<FTPFile> files = new ArrayList<FTPFile>(serverLines.size());
        for (String line : serverLines) {
            FTPFile file = null;
            try {
                log.debug((Object)("Trying to parse line: " + line));
                file = this.parser.parse(line, parentPath);
            }
            catch (ParseException pe) {
                try {
                    log.warn((Object)"Previous file parser couldn't parse listing. Trying a UNIX file parser");
                    this.parser = new UnixFileParser(this.locale);
                    file = this.parser.parse(line, parentPath);
                }
                catch (ParseException pe2) {
                    try {
                        log.warn((Object)"Previous file parser couldn't parse listing. Trying a EPLF file parser");
                        this.parser = new EPLFFileParser();
                        file = this.parser.parse(line, parentPath);
                    }
                    catch (ParseException pe5) {
                        try {
                            log.warn((Object)"Previous file parser couldn't parse listing. Trying a netware file parser");
                            this.parser = new NetwareFileParser(this.locale);
                            file = this.parser.parse(line, parentPath);
                        }
                        catch (ParseException pe3) {
                            log.warn((Object)"Last chance!!! calling LastChanceFileParser");
                            this.parser = new LastChanceFileParser(this.locale);
                            try {
                                file = this.parser.parse(line, parentPath);
                            }
                            catch (ParseException pe4) {
                                log.fatal((Object)"Couldn't parse the LIST reply");
                            }
                        }
                    }
                }
            }
            if (file == null) continue;
            files.add(file);
        }
        return files;
    }

    public static void main(String[] args) {
        FTPFileFactory factory = new FTPFileFactory(VMS_IDENTIFICATION);
        ArrayList<String> list = new ArrayList<String>();
        list.add("00README.TXT;1      2 30-DEC-1996 17:44 [SYSTEM] (RWED,RWED,RE,RE)");
        list.add("CORE.DIR;1          1  8-SEP-1996 16:09 [SYSTEM] (RWE,RWE,RE,RE)");
        list.add("CII-MANUAL.TEX;1  213/216  29-JAN-1996 03:33:12  [ANONYMOUS,ANONYMOUS]   (RWED,RWED,,)");
        List<Object> files = new ArrayList();
        files = factory.parse(list, "/tmp");
        for (FTPFile fTPFile : files) {
            log.debug((Object)("Name: " + fTPFile.getName()));
            log.debug((Object)("Size: " + fTPFile.getSize()));
            log.debug((Object)("Group: " + fTPFile.getGroup()));
            log.debug((Object)("isLink: " + fTPFile.isLink));
            log.debug((Object)("isDir: " + fTPFile.isDirectory()));
            log.debug((Object)("Modes:  " + fTPFile.getMode()));
            log.debug((Object)("points to:" + fTPFile.getLinkedname()));
            log.debug((Object)"------------------------------");
        }
    }
}

