/*
 * Decompiled with CFR 0.152.
 */
package org.ftp4che.commands;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.ftp4che.commands.DataConnectionCommand;
import org.ftp4che.io.ReplyWorker;
import org.ftp4che.reply.Reply;
import org.ftp4che.util.ftpfile.FTPFile;

public class StoreCommand
extends DataConnectionCommand {
    FTPFile toFile;
    FTPFile fromFile;
    InputStream stream;
    private long resumePosition = -1L;

    public StoreCommand(String command, FTPFile toFile) {
        super(command, toFile.toString());
        this.setToFile(toFile);
    }

    public StoreCommand(String command, FTPFile fromFile, FTPFile toFile) {
        this(command, toFile);
        this.setFromFile(fromFile);
    }

    public StoreCommand(String command, InputStream upStream, FTPFile toFile) {
        this(command, toFile);
        this.setStream(upStream);
    }

    public StoreCommand(String command, Object upSrc, FTPFile toFile) throws IllegalArgumentException {
        this(command, toFile);
        if (upSrc instanceof FTPFile) {
            this.setFromFile((FTPFile)upSrc);
        } else if (upSrc instanceof InputStream) {
            this.setStream((InputStream)upSrc);
        } else {
            throw new IllegalArgumentException("The upSrc either must be a FTPFile or an InputStream!");
        }
    }

    public Reply fetchDataConnectionReply() throws FileNotFoundException, IOException {
        ReplyWorker worker = new ReplyWorker(this.getDataSocket(), this);
        worker.start();
        while (worker.getStatus() == -1) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (worker.getStatus() == 1) {
            return worker.getReply();
        }
        if (worker.getCaughtException() instanceof FileNotFoundException) {
            throw (FileNotFoundException)worker.getCaughtException();
        }
        throw (IOException)worker.getCaughtException();
    }

    public FTPFile getToFile() {
        return this.toFile;
    }

    public void setToFile(FTPFile file) {
        this.toFile = file;
    }

    public FTPFile getFromFile() {
        return this.fromFile;
    }

    public void setFromFile(FTPFile fromFile) {
        this.fromFile = fromFile;
    }

    public long getResumePosition() {
        return this.resumePosition;
    }

    public void setResumePosition(long resumePosition) {
        this.resumePosition = resumePosition;
    }

    public InputStream getStream() throws FileNotFoundException {
        if (this.stream != null) {
            return this.stream;
        }
        if (this.fromFile != null && this.fromFile.getName().length() > 0) {
            return new FileInputStream(this.fromFile.getFile());
        }
        throw new FileNotFoundException();
    }

    public void setStream(InputStream upStream) {
        this.stream = upStream;
    }
}

