/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swt.tags.treeutil;

import java.lang.reflect.Method;
import java.util.Comparator;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Item;
import org.pentaho.ui.xul.swt.tags.SwtTreeItem;
import org.pentaho.ui.xul.swt.tags.treeutil.XulSortProperties;
import org.pentaho.ui.xul.util.SortDirection;

public abstract class XulColumnSorter
extends ViewerComparator {
    SortDirection direction = SortDirection.NATURAL;
    Item column = null;
    int columnIndex = 0;
    int compareIndex = 0;
    Comparator comparable = null;
    XulSortProperties properties;
    protected final SelectionListener selectionHandler = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Item selectedColumn = (Item)e.widget;
            XulColumnSorter.this.setColumn(selectedColumn);
        }
    };

    public XulColumnSorter(Viewer viewer, XulSortProperties properties) {
        this.properties = properties;
        try {
            this.initializeViewer(viewer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (properties.getSortColumn() != null) {
            this.setColumn(properties.getSortColumn());
        }
    }

    public abstract void initializeViewer(Viewer var1) throws Exception;

    public void setColumn(Item selectedColumn) {
        if (this.column == selectedColumn) {
            switch (this.direction) {
                case ASCENDING: {
                    this.direction = SortDirection.DESCENDING;
                    break;
                }
                case DESCENDING: {
                    this.direction = SortDirection.ASCENDING;
                    break;
                }
                default: {
                    this.direction = SortDirection.ASCENDING;
                    break;
                }
            }
        } else {
            this.column = selectedColumn;
            this.direction = this.properties.getSortDirection();
            this.comparable = null;
        }
        this.setViewerColumns();
        switch (this.direction) {
            case ASCENDING: {
                this.compareIndex = 1;
                break;
            }
            case DESCENDING: {
                this.compareIndex = -1;
                break;
            }
            default: {
                this.compareIndex = 0;
            }
        }
        Item[] columns = this.getViewerColumns();
        for (int i = 0; i < columns.length; ++i) {
            Item theColumn = columns[i];
            if (theColumn != this.column) continue;
            this.columnIndex = i;
        }
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        SwtTreeItem item = (SwtTreeItem)((Object)e1);
        Object o1 = item.getBoundObject();
        item = (SwtTreeItem)((Object)e2);
        Object o2 = item.getBoundObject();
        if (this.properties.getSortMethod(this.column) != null && this.comparable == null) {
            try {
                Method method = o1.getClass().getMethod(this.properties.getSortMethod(this.column), new Class[0]);
                this.comparable = (Comparator)method.invoke(o1, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.comparable != null) {
            return this.compareIndex * this.comparable.compare(o1, o2);
        }
        return this.compareIndex * this.doCompare(viewer, e1, e2);
    }

    public abstract void setViewerColumns();

    public abstract Item[] getViewerColumns();

    protected abstract int doCompare(Viewer var1, Object var2, Object var3);
}

