/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swt.tags;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulEventSource;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.DefaultBinding;
import org.pentaho.ui.xul.binding.InlineBindingExpression;
import org.pentaho.ui.xul.components.XulTreeCell;
import org.pentaho.ui.xul.components.XulTreeCol;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.containers.XulTreeChildren;
import org.pentaho.ui.xul.containers.XulTreeCols;
import org.pentaho.ui.xul.containers.XulTreeItem;
import org.pentaho.ui.xul.containers.XulTreeRow;
import org.pentaho.ui.xul.dnd.DropEffectType;
import org.pentaho.ui.xul.dnd.DropEvent;
import org.pentaho.ui.xul.dnd.DropPosition;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.swt.AbstractSwtXulContainer;
import org.pentaho.ui.xul.swt.TableSelection;
import org.pentaho.ui.xul.swt.tags.SwtTreeCell;
import org.pentaho.ui.xul.swt.tags.SwtTreeItem;
import org.pentaho.ui.xul.swt.tags.SwtTreeRow;
import org.pentaho.ui.xul.swt.tags.treeutil.TableColumnSorter;
import org.pentaho.ui.xul.swt.tags.treeutil.TreeColumnSorter;
import org.pentaho.ui.xul.swt.tags.treeutil.XulSortProperties;
import org.pentaho.ui.xul.swt.tags.treeutil.XulTableColumnLabelProvider;
import org.pentaho.ui.xul.swt.tags.treeutil.XulTableColumnModifier;
import org.pentaho.ui.xul.swt.tags.treeutil.XulTableContentProvider;
import org.pentaho.ui.xul.swt.tags.treeutil.XulTreeCellLabelProvider;
import org.pentaho.ui.xul.swt.tags.treeutil.XulTreeColumnModifier;
import org.pentaho.ui.xul.swt.tags.treeutil.XulTreeContentProvider;
import org.pentaho.ui.xul.swt.tags.treeutil.XulTreeTextCellEditor;
import org.pentaho.ui.xul.util.ColumnType;
import org.pentaho.ui.xul.util.SortDirection;
import org.pentaho.ui.xul.util.SwtDragManager;
import org.pentaho.ui.xul.util.SwtXulUtil;
import org.pentaho.ui.xul.util.TreeCellEditor;
import org.pentaho.ui.xul.util.TreeCellRenderer;

public class SwtTree
extends AbstractSwtXulContainer
implements XulTree {
    private static final Log logger = LogFactory.getLog(SwtTree.class);
    protected XulTreeCols columns = null;
    protected XulTreeChildren rootChildren = null;
    protected XulComponent parentComponent = null;
    private Object data = null;
    private boolean disabled = false;
    private boolean enableColumnDrag = false;
    private boolean editable = false;
    private String onedit;
    private String onSelect = null;
    private int rowsToDisplay = 0;
    private TableSelection selType = TableSelection.SINGLE;
    private boolean isHierarchical = false;
    private ColumnType[] currentColumnTypes = null;
    private int activeRow = -1;
    private int activeColumn = -1;
    private XulDomContainer domContainer;
    private TableViewer table;
    private TreeViewer tree;
    private int selectedIndex = -1;
    protected boolean controlDown;
    private int[] selectedRows;
    private boolean hiddenRoot = true;
    private String command;
    private String toggle;
    private boolean preserveExpandedState;
    private boolean linesVisible = true;
    private XulSortProperties sortProperties = new XulSortProperties();
    private List<Binding> elementBindings = new ArrayList<Binding>();
    private String newItemBinding;
    private boolean autoCreateNewRows;
    private boolean preserveSelection;
    private Collection currentSelectedItems = null;
    private Method dropVetoerMethod;
    private Object dropVetoerController;
    private PropertyChangeListener cellChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent arg0) {
            SwtTree.this.update();
        }
    };
    private Collection elements;
    private boolean suppressEvents = false;
    private final AtomicBoolean settingElements = new AtomicBoolean(false);
    private String childrenBinding;
    int[] expandCache;
    private List<Binding> expandBindings = new ArrayList<Binding>();
    private TreeLabelBindingConvertor treeLabelConvertor = new TreeLabelBindingConvertor(this);
    protected List<Object> cachedDndItems;
    private DropPosition curPos;

    public SwtTree(Element self, XulComponent parent, XulDomContainer container, String tagName) {
        super(tagName);
        this.parentComponent = parent;
        this.domContainer = container;
    }

    @Override
    public void layout() {
        XulComponent primaryColumn = this.getElementByXPath("treecols/treecol[@primary='true']");
        XulComponent isaContainer = this.getElementByXPath("treechildren/treeitem[@container='true']");
        boolean bl = this.isHierarchical = primaryColumn != null || isaContainer != null;
        if (this.isHierarchical) {
            int style = this.selType == TableSelection.MULTIPLE ? 2 : 0;
            this.tree = SwtXulUtil.isRunningOnWebspoonMode() ? new TreeViewer((Composite)this.parentComponent.getManagedObject(), style) : new PentahoTreeViewer((Composite)this.parentComponent.getManagedObject(), style |= 0x800);
            this.setManagedObject(this.tree);
        } else {
            this.table = new TableViewer((Composite)this.parentComponent.getManagedObject(), 68354);
            this.setManagedObject(this.table);
        }
        if (this.isHierarchical) {
            this.setupTree();
        } else {
            this.setupTable();
        }
        if (this.getOndrag() != null) {
            DropEffectType effect = DropEffectType.COPY;
            if (this.getDrageffect() != null) {
                effect = DropEffectType.valueOfIgnoreCase((String)this.getDrageffect());
            }
            super.enableDrag(effect);
        }
        if (this.getOndrop() != null) {
            super.enableDrop();
        }
        this.initialized = true;
    }

    private void resizeTreeColumn() {
        Composite parentComposite = (Composite)this.parentComponent.getManagedObject();
        Rectangle area = parentComposite.getClientArea();
        Point preferredSize = this.tree.getTree().computeSize(-1, -1);
        int width = area.width - 2 * this.tree.getTree().getBorderWidth();
        if (preferredSize.y > area.height + this.tree.getTree().getHeaderHeight()) {
            Point vBarSize = this.tree.getTree().getVerticalBar().getSize();
            width -= vBarSize.x;
        }
        this.tree.getTree().getColumn(0).setWidth(width -= 20);
    }

    private void setupTree() {
        Composite parentComposite = (Composite)this.parentComponent.getManagedObject();
        parentComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                SwtTree.this.resizeTreeColumn();
            }
        });
        TreeViewerColumn treeCol = new TreeViewerColumn(this.tree, 16384);
        treeCol.getColumn().setMoveable(true);
        treeCol.getColumn().setText("Column 3");
        treeCol.setLabelProvider((CellLabelProvider)new XulTreeCellLabelProvider(this, this.domContainer));
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tree);
        this.tree.setCellEditors(new CellEditor[]{new XulTreeTextCellEditor(this.tree.getTree())});
        this.tree.setCellModifier((ICellModifier)new XulTreeColumnModifier(this));
        this.tree.setContentProvider((IContentProvider)new XulTreeContentProvider(this));
        this.tree.setInput((Object)this);
        this.tree.getTree().setLayoutData((Object)new GridData(1808));
        this.tree.setColumnProperties(new String[]{"0"});
        TreeViewerEditor.create((TreeViewer)this.tree, (ColumnViewerEditorActivationStrategy)new ColumnViewerEditorActivationStrategy((ColumnViewer)this.tree){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return super.isEditorActivationEvent(event);
            }
        }, (int)1);
        this.tree.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                switch (event.keyCode) {
                    case 262144: {
                        SwtTree.this.controlDown = true;
                        break;
                    }
                    case 27: {
                        SwtTree.this.tree.getTree().deselectAll();
                        SwtTree.this.setSelectedRows(new int[0]);
                    }
                }
            }

            public void keyReleased(KeyEvent event) {
                switch (event.keyCode) {
                    case 262144: {
                        SwtTree.this.controlDown = false;
                    }
                }
            }
        });
        this.tree.getTree().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent arg0) {
            }

            public void focusLost(FocusEvent arg0) {
                if (!SwtTree.this.tree.getCellEditors()[0].isActivated()) {
                    SwtTree.this.controlDown = false;
                }
            }
        });
        this.tree.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent arg0) {
                if (arg0.getElement() instanceof XulTreeItem) {
                    XulTreeItem t = (XulTreeItem)arg0.getElement();
                    t.setExpanded(false);
                    if (SwtTree.this.toggle != null) {
                        SearchBundle b = SwtTree.this.findSelectedIndex(new SearchBundle(), SwtTree.this.getRootChildren(), t);
                        Object[] toggled = new Object[]{b.selectedItem};
                        SwtTree.this.invoke(SwtTree.this.toggle, new Object[]{toggled, false});
                    }
                }
            }

            public void treeExpanded(TreeExpansionEvent arg0) {
                if (arg0.getElement() instanceof XulTreeItem) {
                    XulTreeItem t = (XulTreeItem)arg0.getElement();
                    t.setExpanded(true);
                    if (SwtTree.this.toggle != null) {
                        SearchBundle b = SwtTree.this.findSelectedIndex(new SearchBundle(), SwtTree.this.getRootChildren(), t);
                        Object[] toggled = new Object[]{b.selectedItem};
                        SwtTree.this.invoke(SwtTree.this.toggle, new Object[]{toggled, true});
                    }
                }
            }
        });
        this.tree.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent arg0) {
                if (SwtTree.this.command != null) {
                    if (SwtTree.this.elements != null) {
                        SwtTree.this.invoke(SwtTree.this.command, new Object[]{SwtTree.this.getSelectedItems().toArray()});
                    } else {
                        SwtTree.this.invoke(SwtTree.this.command, new Object[]{SwtTree.this.getSelectedRows()});
                    }
                }
            }
        });
        this.tree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    SwtTree.this.setSelectedIndex(-1);
                    return;
                }
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    int[] selected = new int[selection.size()];
                    ArrayList<Object> selectedItems = new ArrayList<Object>();
                    int i = 0;
                    for (Object o : selection.toArray()) {
                        XulTreeItem selectedItem = (XulTreeItem)o;
                        SearchBundle b = SwtTree.this.findSelectedIndex(new SearchBundle(), SwtTree.this.getRootChildren(), selectedItem);
                        selected[i++] = b.curPos;
                        selectedItems.add(b.selectedItem);
                    }
                    if (selected.length == 0) {
                        SwtTree.this.setSelectedIndex(-1);
                    } else {
                        SwtTree.this.setSelectedIndex(selected[0]);
                    }
                    int[] selectedRows = null;
                    if (SwtTree.this.controlDown && Arrays.equals(selected, selectedRows) && !SwtTree.this.tree.getCellEditors()[0].isActivated()) {
                        SwtTree.this.tree.getTree().deselectAll();
                        selectedRows = new int[]{};
                    } else {
                        selectedRows = selected;
                    }
                    SwtTree.this.changeSupport.firePropertyChange("selectedRows", null, selectedRows);
                    SwtTree.this.changeSupport.firePropertyChange("absoluteSelectedRows", null, selectedRows);
                    SwtTree.this.changeSupport.firePropertyChange("selectedItems", null, selectedItems);
                    SwtTree.this.currentSelectedItems = selectedItems;
                    Object selectedItem = selectedItems.size() > 0 ? selectedItems.get(0) : null;
                    SwtTree.this.changeSupport.firePropertyChange("selectedItem", null, selectedItem);
                }
            }
        });
        this.sortProperties.setSortColumn(null);
        this.sortProperties.setSortable(false);
        for (XulComponent col : this.columns.getChildNodes()) {
            XulTreeCol xulCol = (XulTreeCol)col;
            if (xulCol.isSortActive() && this.sortProperties.getSortColumn() == null) {
                this.sortProperties.setSortColumn((Item)treeCol.getColumn());
                this.sortProperties.setSortDirection(SortDirection.valueOf((String)xulCol.getSortDirection()));
            }
            this.sortProperties.setSortMethod((Item)treeCol.getColumn(), SwtTree.toGetter(xulCol.getComparatorbinding()));
        }
        TreeColumnSorter sorter = new TreeColumnSorter(this.tree, this.sortProperties);
    }

    private SearchBundle findSelectedIndex(SearchBundle bundle, XulTreeChildren children, XulTreeItem selectedItem) {
        for (XulComponent c : children.getChildNodes()) {
            if (c == selectedItem) {
                bundle.found = true;
                if (this.elements != null) {
                    bundle.selectedItem = this.findBoundTreeItem(bundle.curPos);
                }
                return bundle;
            }
            ++bundle.curPos;
            if (c.getChildNodes().size() <= 1) continue;
            SearchBundle b = this.findSelectedIndex(bundle, (XulTreeChildren)c.getChildNodes().get(1), selectedItem);
            if (!b.found) continue;
            return b;
        }
        return bundle;
    }

    private Object findBoundTreeItem(int pos) {
        if (this.isHierarchical && this.elements != null) {
            if (this.elements == null || this.hiddenRoot && this.elements.size() == 0) {
                return null;
            }
            String method = SwtTree.toGetter(((XulTreeCol)this.getColumns().getChildNodes().get(0)).getChildrenbinding());
            if (pos == -1) {
                return null;
            }
            FindSelectedItemTuple tuple = this.findSelectedItem((Object)this.elements, method, new FindSelectedItemTuple(pos, this.isHiddenrootnode()));
            return tuple != null ? tuple.selectedItem : null;
        }
        return null;
    }

    private void setupTable() {
        this.table.setContentProvider((IContentProvider)new XulTableContentProvider(this));
        this.table.setLabelProvider((IBaseLabelProvider)new XulTableColumnLabelProvider(this, this.domContainer));
        this.table.setCellModifier((ICellModifier)new XulTableColumnModifier(this));
        Table baseTable = this.table.getTable();
        baseTable.setLayoutData((Object)new GridData(1808));
        this.setupColumns();
        this.table.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                SwtTree.this.setSelectedIndex(SwtTree.this.getRootChildren().getChildNodes().indexOf(selection.getFirstElement()));
                int[] selectedRows = new int[selection.size()];
                int i = 0;
                for (Object sel : selection) {
                    selectedRows[i] = SwtTree.this.getRootChildren().getChildNodes().indexOf(sel);
                    ++i;
                }
                SwtTree.this.changeSupport.firePropertyChange("selectedRows", null, selectedRows);
                SwtTree.this.changeSupport.firePropertyChange("absoluteSelectedRows", null, selectedRows);
                Collection selectedItems = SwtTree.this.findSelectedTableRows(selectedRows);
                SwtTree.this.changeSupport.firePropertyChange("selectedItems", null, selectedItems);
                Object selectedItem = selectedItems.size() > 0 ? selectedItems.toArray()[0] : null;
                SwtTree.this.changeSupport.firePropertyChange("selectedItem", null, selectedItem);
            }
        });
        MouseAdapter lsMouseT = new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                if (event.button == 1) {
                    boolean control;
                    boolean shift = (event.stateMask & 0x20000) != 0;
                    boolean bl = control = (event.stateMask & 0x40000) != 0;
                    if (!shift && !control) {
                        Rectangle clientArea = SwtTree.this.table.getTable().getClientArea();
                        Point pt = new Point(event.x, event.y);
                        for (int index = SwtTree.this.table.getTable().getTopIndex(); index < SwtTree.this.table.getTable().getItemCount(); ++index) {
                            boolean visible = false;
                            TableItem item = SwtTree.this.table.getTable().getItem(index);
                            for (int i = 0; i < SwtTree.this.table.getTable().getColumnCount(); ++i) {
                                Rectangle rect = item.getBounds(i);
                                if (!rect.contains(pt)) {
                                    if (i == SwtTree.this.table.getTable().getColumnCount() - 1 && pt.x > rect.x + rect.width && pt.y >= rect.y && pt.y <= rect.y + rect.height) {
                                        return;
                                    }
                                } else {
                                    return;
                                }
                                if (visible || !rect.intersects(clientArea)) continue;
                                visible = true;
                            }
                            if (visible) continue;
                            return;
                        }
                        SwtTree.this.insertRowAtLast();
                    }
                }
            }
        };
        this.table.getTable().addMouseListener((MouseListener)lsMouseT);
        this.table.getTable().addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent arg0) {
                int[] rows;
                if (arg0.keyCode == 0x1000002 && (rows = SwtTree.this.getSelectedRows()) != null && rows.length > 0 && rows[0] == SwtTree.this.table.getTable().getItemCount() - 1) {
                    SwtTree.this.insertRowAtLast();
                }
            }
        });
        this.table.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent arg0) {
                if (SwtTree.this.command != null) {
                    if (SwtTree.this.elements != null) {
                        SwtTree.this.invoke(SwtTree.this.command, new Object[]{SwtTree.this.getSelectedItems().toArray()});
                    } else {
                        SwtTree.this.invoke(SwtTree.this.command, new Object[]{SwtTree.this.getSelectedRows()});
                    }
                }
            }
        });
        baseTable.setHeaderVisible(true);
        baseTable.setLinesVisible(this.isTreeLines());
        this.table.setInput((Object)this);
        Composite parentComposite = (Composite)this.parentComponent.getManagedObject();
        parentComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                SwtTree.this.resizeColumns();
            }
        });
        TableColumnSorter sorter = new TableColumnSorter((Viewer)this.table, this.sortProperties);
        this.table.getTable().setEnabled(!this.disabled);
        this.table.refresh();
    }

    private void insertRowAtLast() {
        if (this.elements != null && this.newItemBinding != null) {
            this.invoke(this.newItemBinding);
        } else if (this.autoCreateNewRows) {
            this.getRootChildren().addNewRow();
            this.update();
        }
    }

    private Collection findSelectedTableRows(int[] selectedRows) {
        if (this.elements == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> selectedItems = new ArrayList<Object>();
        for (int i = 0; i < selectedRows.length; ++i) {
            if (selectedRows[i] < 0 || selectedRows[i] >= this.elements.size()) continue;
            selectedItems.add(this.elements.toArray()[selectedRows[i]]);
        }
        return selectedItems;
    }

    private void resizeColumns() {
        Composite parentComposite = (Composite)this.parentComponent.getManagedObject();
        Rectangle area = parentComposite.getClientArea();
        Point preferredSize = this.table.getTable().computeSize(-1, -1);
        int width = area.width - 2 * this.table.getTable().getBorderWidth();
        if (preferredSize.y > area.height + this.table.getTable().getHeaderHeight()) {
            Point vBarSize = this.table.getTable().getVerticalBar().getSize();
            width -= vBarSize.x;
        }
        width -= 20;
        double totalFlex = 0.0;
        for (XulComponent col : this.getColumns().getChildNodes()) {
            totalFlex += (double)((XulTreeCol)col).getFlex();
        }
        int colIdx = 0;
        for (XulComponent col : this.getColumns().getChildNodes()) {
            if (colIdx >= this.table.getTable().getColumnCount()) break;
            TableColumn c = this.table.getTable().getColumn(colIdx);
            int colFlex = ((XulTreeCol)col).getFlex();
            int colWidth = ((XulTreeCol)col).getWidth();
            if (totalFlex == 0.0) {
                if (colWidth > 0) {
                    c.setWidth(colWidth);
                } else {
                    c.setWidth(Math.round(width / this.getColumns().getColumnCount()));
                }
            } else if (colFlex > 0) {
                if (colWidth > 0) {
                    c.setWidth(colWidth);
                } else {
                    c.setWidth(Integer.parseInt("" + Math.round((double)width * ((double)colFlex / totalFlex))));
                }
            }
            ++colIdx;
        }
    }

    private void setSelectedIndex(int idx) {
        this.selectedIndex = idx;
        this.changeSupport.firePropertyChange("selectedRows", null, new int[]{idx});
        this.changeSupport.firePropertyChange("absoluteSelectedRows", null, new int[]{idx});
        if (this.onSelect != null) {
            this.invoke(this.onSelect, new Object[]{new Integer(idx)});
        }
    }

    private void createColumnTypesSnapshot() {
        if (this.columns.getChildNodes().size() > 0) {
            Object[] xulTreeColArray = this.columns.getChildNodes().toArray();
            this.currentColumnTypes = new ColumnType[xulTreeColArray.length];
            for (int i = 0; i < xulTreeColArray.length; ++i) {
                this.currentColumnTypes[i] = ColumnType.valueOf((String)((XulTreeCol)xulTreeColArray[i]).getType());
            }
        } else {
            this.currentColumnTypes = new ColumnType[0];
        }
    }

    private boolean columnsNeedUpdate() {
        if (this.table.getTable().getColumnCount() != this.columns.getColumnCount()) {
            return true;
        }
        if (this.currentColumnTypes == null) {
            return true;
        }
        Object[] xulTreeColArray = this.columns.getChildNodes().toArray();
        for (int i = 0; i < xulTreeColArray.length; ++i) {
            XulTreeCol xulTreeCol = (XulTreeCol)xulTreeColArray[i];
            if (!this.currentColumnTypes[i].toString().equalsIgnoreCase(((XulTreeCol)xulTreeColArray[i]).getType())) {
                return true;
            }
            if ((this.table.getTable().getColumn(i).getWidth() <= 0 || xulTreeCol.isVisible()) && (this.table.getTable().getColumn(i).getWidth() != 0 || !xulTreeCol.isVisible())) continue;
            return true;
        }
        return false;
    }

    private void setupColumns() {
        int i;
        if (this.columnsNeedUpdate()) {
            this.sortProperties.setSortColumn(null);
            while (this.table.getTable().getColumnCount() > 0) {
                this.table.getTable().getColumn(0).dispose();
            }
            for (XulComponent col : this.columns.getChildNodes()) {
                TableColumn tc = new TableColumn(this.table.getTable(), 16384);
                XulTreeCol column = (XulTreeCol)col;
                String lbl = column.getLabel();
                tc.setText(lbl != null ? lbl : "");
                if (column.isSortActive() && this.sortProperties.getSortColumn() == null) {
                    this.sortProperties.setSortColumn((Item)tc);
                    this.sortProperties.setSortDirection(SortDirection.valueOf((String)column.getSortDirection()));
                }
                this.sortProperties.setSortMethod((Item)tc, SwtTree.toGetter(column.getComparatorbinding()));
            }
            for (i = 0; i < this.table.getTable().getColumnCount(); ++i) {
                if (!this.columns.getColumn(i).isVisible()) continue;
                this.table.getTable().getColumn(i).pack();
            }
        }
        if (this.table.getCellEditors() != null) {
            for (i = 0; i < this.table.getCellEditors().length; ++i) {
                this.table.getCellEditors()[i].dispose();
            }
        }
        CellEditor[] editors = new CellEditor[this.columns.getChildNodes().size()];
        String[] names = new String[this.getColumns().getColumnCount()];
        int i2 = 0;
        for (XulComponent c : this.columns.getChildNodes()) {
            CCombo editableControl;
            CheckboxCellEditor editor;
            XulTreeCol col = (XulTreeCol)c;
            final int colIdx = i2;
            ColumnType type = col.getColumnType();
            switch (type) {
                case CHECKBOX: {
                    editor = new CheckboxCellEditor((Composite)this.table.getTable());
                    break;
                }
                case COMBOBOX: {
                    editor = new ComboBoxCellEditor((Composite)this.table.getTable(), new String[0], 8);
                    break;
                }
                case EDITABLECOMBOBOX: {
                    editor = new ComboBoxCellEditor((Composite)this.table.getTable(), new String[0]);
                    editableControl = (CCombo)((ComboBoxCellEditor)editor).getControl();
                    editableControl.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent modifyEvent) {
                            SwtTree.this.domContainer.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    XulTreeCell cell = SwtTree.this.getCell(colIdx);
                                    cell.setLabel(editableControl.getText());
                                }
                            });
                        }
                    });
                    break;
                }
                case PASSWORD: {
                    editor = new TextCellEditor((Composite)this.table.getTable());
                    ((Text)editor.getControl()).setEchoChar('*');
                    break;
                }
                default: {
                    editor = new TextCellEditor((Composite)this.table.getTable());
                    final Text textControl = (Text)((TextCellEditor)editor).getControl();
                    textControl.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent modifyEvent) {
                            XulTreeCell cell = SwtTree.this.getCell(colIdx);
                            cell.setLabel(textControl.getText());
                        }
                    });
                }
            }
            if (type == ColumnType.EDITABLECOMBOBOX || type == ColumnType.COMBOBOX) {
                editableControl = (CCombo)((ComboBoxCellEditor)editor).getControl();
                editableControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetDefaultSelected(SelectionEvent arg0) {
                        super.widgetDefaultSelected(arg0);
                    }

                    public void widgetSelected(SelectionEvent arg0) {
                        super.widgetSelected(arg0);
                        XulTreeCell cell = SwtTree.this.getCell(colIdx);
                        cell.setSelectedIndex(editableControl.getSelectionIndex());
                    }
                });
            }
            editors[i2] = editor;
            names[i2] = "" + i2;
            ++i2;
        }
        this.table.setCellEditors(editors);
        this.table.setColumnProperties(names);
        this.resizeColumns();
        this.createColumnTypesSnapshot();
    }

    private XulTreeCell getCell(int colIdx) {
        return ((XulTreeItem)this.table.getTable().getSelection()[0].getData()).getRow().getCell(colIdx);
    }

    public boolean isHierarchical() {
        return this.isHierarchical;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
        if (!this.isHierarchical() && this.table != null) {
            this.table.getTable().setEnabled(!disabled);
        }
    }

    public int getRows() {
        return this.rowsToDisplay;
    }

    public void setRows(int rowsToDisplay) {
        this.rowsToDisplay = rowsToDisplay;
        if (this.table != null && !this.table.getTable().isDisposed() && rowsToDisplay > 0) {
            int ht = rowsToDisplay * this.table.getTable().getItemHeight();
            if (this.table.getTable().getLayoutData() != null) {
                ((GridData)this.table.getTable().getLayoutData()).heightHint = ht;
                ((GridData)this.table.getTable().getLayoutData()).minimumHeight = ht;
                this.table.getTable().getParent().layout(true);
            }
        }
    }

    public String getSeltype() {
        return this.selType.toString();
    }

    public void setSeltype(String selType) {
        if (selType.equalsIgnoreCase(this.getSeltype())) {
            return;
        }
        this.selType = TableSelection.valueOf(selType.toUpperCase());
    }

    public TableSelection getTableSelection() {
        return this.selType;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isEnableColumnDrag() {
        return this.enableColumnDrag;
    }

    public void setEditable(boolean edit) {
        this.editable = edit;
    }

    public void setEnableColumnDrag(boolean drag) {
        this.enableColumnDrag = drag;
    }

    public String getOnselect() {
        return this.onSelect;
    }

    public void setOnselect(String method) {
        if (method == null) {
            return;
        }
        this.onSelect = method;
    }

    public void setColumns(XulTreeCols columns) {
        this.columns = columns;
    }

    public XulTreeCols getColumns() {
        return this.columns;
    }

    public XulTreeChildren getRootChildren() {
        if (this.rootChildren == null) {
            this.rootChildren = (XulTreeChildren)this.getChildNodes().get(1);
        }
        return this.rootChildren;
    }

    public void setRootChildren(XulTreeChildren rootChildren) {
        this.rootChildren = rootChildren;
    }

    public int[] getActiveCellCoordinates() {
        return new int[]{this.activeRow, this.activeColumn};
    }

    public void setActiveCellCoordinates(int row, int column) {
        this.activeRow = row;
        this.activeColumn = column;
    }

    public Object[][] getValues() {
        Object[][] data = new Object[this.getRootChildren().getChildNodes().size()][this.getColumns().getColumnCount()];
        int y = 0;
        for (XulComponent item : this.getRootChildren().getChildNodes()) {
            int x = 0;
            for (XulComponent tempCell : ((XulTreeItem)item).getRow().getChildNodes()) {
                XulTreeCell cell = (XulTreeCell)tempCell;
                switch (this.columns.getColumn(x).getColumnType()) {
                    case CHECKBOX: {
                        Boolean flag = (Boolean)cell.getValue();
                        if (flag == null) {
                            flag = Boolean.FALSE;
                        }
                        data[y][x] = flag;
                        break;
                    }
                    case COMBOBOX: {
                        Vector values = (Vector)cell.getValue();
                        int idx = cell.getSelectedIndex();
                        data[y][x] = values.get(idx);
                        break;
                    }
                    default: {
                        data[y][x] = cell.getLabel();
                    }
                }
                ++x;
            }
            ++y;
        }
        return data;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public int[] getSelectedRows() {
        if (this.selectedIndex > -1) {
            return new int[]{this.selectedIndex};
        }
        return new int[0];
    }

    public int[] getAbsoluteSelectedRows() {
        return this.getSelectedRows();
    }

    public Collection getSelectedItems() {
        if (this.elements == null) {
            return null;
        }
        if (this.isHierarchical()) {
            ArrayList<Object> selectedItems = new ArrayList<Object>();
            IStructuredSelection selection = (IStructuredSelection)this.tree.getSelection();
            boolean i = false;
            for (Object o : selection.toArray()) {
                XulTreeItem selectedItem = (XulTreeItem)o;
                SearchBundle b = this.findSelectedIndex(new SearchBundle(), this.getRootChildren(), selectedItem);
                selectedItems.add(b.selectedItem);
            }
            return selectedItems;
        }
        IStructuredSelection selection = (IStructuredSelection)this.table.getSelection();
        this.setSelectedIndex(this.getRootChildren().getChildNodes().indexOf(selection.getFirstElement()));
        int[] selectedRows = new int[selection.size()];
        int i = 0;
        for (Object sel : selection) {
            selectedRows[i] = this.getRootChildren().getChildNodes().indexOf(sel);
            ++i;
        }
        return this.findSelectedTableRows(selectedRows);
    }

    public void addTreeRow(XulTreeRow row) {
        this.addChild((Element)row);
        SwtTreeItem item = new SwtTreeItem(this.getRootChildren());
        row.setParentTreeItem((XulTreeItem)item);
        ((SwtTreeRow)row).layout();
    }

    public void removeTreeRows(int[] rows) {
    }

    public void update() {
        if (this.settingElements.get()) {
            return;
        }
        if (this.isHierarchical) {
            this.tree.refresh();
            if ("true".equals(this.getAttributeValue("expanded"))) {
                this.tree.expandAll();
            } else if (this.expandBindings.size() > 0 && !this.suppressEvents) {
                for (Binding expBind : this.expandBindings) {
                    try {
                        expBind.fireSourceChanged();
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                }
                this.expandBindings.clear();
            }
            this.resizeTreeColumn();
        } else {
            this.setupColumns();
            this.table.setInput((Object)this);
            this.table.refresh();
        }
        this.selectedIndex = -1;
    }

    public void clearSelection() {
    }

    public void setSelectedRows(int[] rows) {
        if (this.isHierarchical) {
            Object selected = this.getSelectedTreeItem(rows);
            int prevSelected = -1;
            if (this.selectedRows != null && this.selectedRows.length > 0) {
                prevSelected = this.selectedRows[0];
            }
            this.changeSupport.firePropertyChange("selectedItem", (Object)prevSelected, selected);
        } else {
            this.table.getTable().setSelection(rows);
        }
        if (rows.length > 0) {
            this.selectedIndex = rows[0];
        }
        this.changeSupport.firePropertyChange("selectedRows", this.selectedRows, rows);
        this.changeSupport.firePropertyChange("absoluteSelectedRows", this.selectedRows, rows);
        this.selectedRows = rows;
    }

    public String getOnedit() {
        return this.onedit;
    }

    public void setOnedit(String onedit) {
        this.onedit = onedit;
    }

    private String getChildrenBinding() {
        if (this.childrenBinding == null) {
            this.childrenBinding = ((XulTreeCol)this.getColumns().getChildNodes().get(0)).getChildrenbinding();
        }
        return this.childrenBinding;
    }

    private void cacheExpandedState() {
        Object[] expandedTreeItems = this.tree.getExpandedElements();
        this.expandCache = new int[expandedTreeItems.length];
        for (int i = 0; i < expandedTreeItems.length; ++i) {
            XulTreeItem item = (XulTreeItem)expandedTreeItems[i];
            SearchBundle b = this.findSelectedIndex(new SearchBundle(), this.getRootChildren(), item);
            this.expandCache[i] = b.curPos;
        }
    }

    private void restoreExpandedState() {
        for (int i = 0; i < this.expandCache.length; ++i) {
            XulTreeItem item = this.findTreeItemForPos(this.expandCache[i]);
            if (item == null) continue;
            this.tree.setExpandedState((Object)item, true);
        }
    }

    private XulTreeItem findTreeItemForPos(int pos) {
        if (!this.isHierarchical()) {
            return (XulTreeItem)this.getTreeChildren((XulComponent)this).getChildNodes().get(pos);
        }
        FindTreeItemForPosTuple tuple = new FindTreeItemForPosTuple(pos, (XulComponent)this);
        this.findTreeItemAtPosFunc(tuple);
        return tuple.treeItem;
    }

    private void findTreeItemAtPosFunc(FindTreeItemForPosTuple bundle) {
        if (bundle.curPos == bundle.pos) {
            bundle.found = true;
            bundle.treeItem = (XulTreeItem)bundle.curComponent;
            return;
        }
        XulTreeChildren children = this.getTreeChildren(bundle.curComponent);
        if (children == null) {
            return;
        }
        for (XulComponent c : this.getTreeChildren(bundle.curComponent).getChildNodes()) {
            ++bundle.curPos;
            bundle.curComponent = c;
            this.findTreeItemAtPosFunc(bundle);
            if (!bundle.found) continue;
            return;
        }
    }

    private void destroyPreviousBindings() {
        for (Binding bind : this.elementBindings) {
            bind.destroyBindings();
        }
        this.elementBindings.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void setElements(Collection<T> elements) {
        block32: {
            this.settingElements.set(true);
            try {
                int scrollPos = -1;
                if (this.isHierarchical) {
                    if (this.isPreserveexpandedstate()) {
                        this.cacheExpandedState();
                    }
                    scrollPos = this.tree.getTree().getVerticalBar().getSelection();
                }
                this.destroyPreviousBindings();
                this.elements = elements;
                this.getRootChildren().removeAll();
                if (elements == null) {
                    this.update();
                    this.changeSupport.firePropertyChange("selectedRows", null, this.getSelectedRows());
                    this.changeSupport.firePropertyChange("absoluteSelectedRows", null, this.getAbsoluteSelectedRows());
                    return;
                }
                try {
                    if (!this.isHierarchical) {
                        for (T o : elements) {
                            XulTreeRow row = this.getRootChildren().addNewRow();
                            ((XulTreeItem)row.getParent()).setBoundObject(o);
                            for (int x = 0; x < this.getColumns().getChildNodes().size(); ++x) {
                                XulTreeCol col = this.getColumns().getColumn(x);
                                final XulTreeCell cell = (XulTreeCell)this.getDocument().createElement("treecell");
                                XulTreeCol column = col;
                                for (InlineBindingExpression exp : col.getBindingExpressions()) {
                                    Binding binding;
                                    String colType;
                                    if (logger.isDebugEnabled()) {
                                        logger.debug((Object)("applying binding expression [" + exp + "] to xul tree cell [" + cell + "] and model [" + o + "]"));
                                    }
                                    if (!StringUtils.isEmpty((String)(colType = column.getType())) && colType.equals("dynamic")) {
                                        colType = this.extractDynamicColType(o, x);
                                    }
                                    if ((colType.equalsIgnoreCase("combobox") || colType.equalsIgnoreCase("editablecombobox")) && column.getCombobinding() != null) {
                                        binding = this.createBinding((XulEventSource)o, column.getCombobinding(), (XulEventSource)cell, "value");
                                        this.elementBindings.add(binding);
                                        binding.setBindingType(Binding.Type.ONE_WAY);
                                        this.domContainer.addBinding(binding);
                                        binding.fireSourceChanged();
                                        binding = this.createBinding((XulEventSource)o, col.getBinding(), (XulEventSource)cell, "selectedIndex");
                                        this.elementBindings.add(binding);
                                        binding.setConversion((BindingConvertor)new BindingConvertor<Object, Integer>(){

                                            public Integer sourceToTarget(Object value) {
                                                int index = ((Vector)cell.getValue()).indexOf(value);
                                                return index > -1 ? index : 0;
                                            }

                                            public Object targetToSource(Integer value) {
                                                return ((Vector)cell.getValue()).get(value);
                                            }
                                        });
                                        this.domContainer.addBinding(binding);
                                        binding.fireSourceChanged();
                                        if (!colType.equalsIgnoreCase("editablecombobox")) continue;
                                        binding = this.createBinding((XulEventSource)o, exp.getModelAttr(), (XulEventSource)cell, exp.getXulCompAttr());
                                        this.elementBindings.add(binding);
                                        if (!this.editable) {
                                            binding.setBindingType(Binding.Type.ONE_WAY);
                                        } else {
                                            binding.setBindingType(Binding.Type.BI_DIRECTIONAL);
                                        }
                                        this.domContainer.addBinding(binding);
                                        continue;
                                    }
                                    if (colType.equalsIgnoreCase("checkbox")) {
                                        if (!StringUtils.isNotEmpty((String)exp.getModelAttr())) continue;
                                        binding = this.createBinding((XulEventSource)o, exp.getModelAttr(), (XulEventSource)cell, "value");
                                        this.elementBindings.add(binding);
                                        if (!column.isEditable()) {
                                            binding.setBindingType(Binding.Type.ONE_WAY);
                                        }
                                        this.domContainer.addBinding(binding);
                                        binding.fireSourceChanged();
                                        continue;
                                    }
                                    if (StringUtils.isNotEmpty((String)exp.getModelAttr())) {
                                        binding = this.createBinding((XulEventSource)o, exp.getModelAttr(), (XulEventSource)cell, exp.getXulCompAttr());
                                        this.elementBindings.add(binding);
                                        if (!column.isEditable()) {
                                            binding.setBindingType(Binding.Type.ONE_WAY);
                                        }
                                        this.domContainer.addBinding(binding);
                                        binding.fireSourceChanged();
                                        continue;
                                    }
                                    cell.setLabel(o.toString());
                                }
                                if (column.getDisabledbinding() != null) {
                                    String prop = column.getDisabledbinding();
                                    Binding bind = this.createBinding((XulEventSource)o, column.getDisabledbinding(), (XulEventSource)cell, "disabled");
                                    this.elementBindings.add(bind);
                                    bind.setBindingType(Binding.Type.ONE_WAY);
                                    this.domContainer.addBinding(bind);
                                    bind.fireSourceChanged();
                                }
                                String imageSrc = null;
                                String method = SwtTree.toGetter(((XulTreeCol)this.getColumns().getChildNodes().get(x)).getImagebinding());
                                if (method != null) {
                                    Method imageMethod = o.getClass().getMethod(method, new Class[0]);
                                    imageSrc = (String)imageMethod.invoke(o, new Object[0]);
                                    SwtTreeItem item = (SwtTreeItem)row.getParent();
                                    item.setXulDomContainer(this.domContainer);
                                    ((XulTreeItem)row.getParent()).setImage(imageSrc);
                                }
                                row.addCell(cell);
                            }
                        }
                    } else {
                        this.suppressEvents = true;
                        if (!this.isHiddenrootnode()) {
                            SwtTreeItem item = new SwtTreeItem(this.getRootChildren());
                            item.setXulDomContainer(this.domContainer);
                            item.setBoundObject(elements);
                            SwtTreeRow newRow = new SwtTreeRow((XulComponent)item);
                            item.setRow(newRow);
                            this.getRootChildren().addChild((Element)item);
                            this.addTreeChild(elements, newRow);
                        } else {
                            for (T o : elements) {
                                SwtTreeItem item = new SwtTreeItem(this.getRootChildren());
                                item.setXulDomContainer(this.domContainer);
                                item.setBoundObject(o);
                                SwtTreeRow newRow = new SwtTreeRow((XulComponent)item);
                                item.setRow(newRow);
                                this.getRootChildren().addChild((Element)item);
                                this.addTreeChild(o, newRow);
                            }
                        }
                        this.suppressEvents = false;
                    }
                    this.update();
                    if (this.isHierarchical) {
                        if (this.isPreserveexpandedstate()) {
                            this.restoreExpandedState();
                        }
                        int item = scrollPos;
                    }
                    if (this.isPreserveselection() && this.currentSelectedItems != null && this.currentSelectedItems.size() > 0) {
                        this.setSelectedItems(this.currentSelectedItems);
                        this.suppressEvents = false;
                        break block32;
                    }
                    this.suppressEvents = false;
                    this.changeSupport.firePropertyChange("selectedRows", null, this.getSelectedRows());
                    this.changeSupport.firePropertyChange("absoluteSelectedRows", null, this.getAbsoluteSelectedRows());
                    this.changeSupport.firePropertyChange("selectedItems", null, Collections.EMPTY_LIST);
                    this.changeSupport.firePropertyChange("selectedItem", "", null);
                }
                catch (XulException e) {
                    logger.error((Object)"error adding elements", (Throwable)e);
                }
                catch (Exception e) {
                    logger.error((Object)"error adding elements", (Throwable)e);
                }
            }
            finally {
                this.settingElements.set(false);
                this.update();
            }
        }
    }

    private <T> void addTreeChild(T element, XulTreeRow row) {
        try {
            Binding bind;
            String prop;
            Binding binding;
            SwtTreeCell cell = (SwtTreeCell)this.getDocument().createElement("treecell");
            for (InlineBindingExpression exp : ((XulTreeCol)this.getColumns().getChildNodes().get(0)).getBindingExpressions()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("applying binding expression [" + exp + "] to xul tree cell [" + (Object)((Object)cell) + "] and model [" + element + "]"));
                }
                binding = this.createBinding((XulEventSource)element, exp.getModelAttr(), (XulEventSource)cell, exp.getXulCompAttr());
                this.elementBindings.add(binding);
                binding.setConversion((BindingConvertor)this.treeLabelConvertor);
                if (this.isEditable()) {
                    binding.setBindingType(Binding.Type.BI_DIRECTIONAL);
                } else {
                    binding.setBindingType(Binding.Type.ONE_WAY);
                }
                this.domContainer.addBinding(binding);
                binding.fireSourceChanged();
            }
            cell.addPropertyChangeListener("label", this.cellChangeListener);
            XulTreeCol column = (XulTreeCol)this.getColumns().getChildNodes().get(0);
            String expBind = column.getExpandedbinding();
            if (expBind != null) {
                binding = this.createBinding((XulEventSource)element, expBind, (XulEventSource)row.getParent(), "expanded");
                this.elementBindings.add(binding);
                binding.setBindingType(Binding.Type.BI_DIRECTIONAL);
                this.domContainer.addBinding(binding);
                this.expandBindings.add(binding);
            }
            if (column.getDisabledbinding() != null) {
                prop = column.getDisabledbinding();
                bind = this.createBinding((XulEventSource)element, column.getDisabledbinding(), (XulEventSource)row.getParent(), "disabled");
                this.elementBindings.add(bind);
                bind.setBindingType(Binding.Type.ONE_WAY);
                this.domContainer.addBinding(bind);
                bind.fireSourceChanged();
            }
            if (column.getTooltipbinding() != null) {
                prop = column.getTooltipbinding();
                bind = this.createBinding((XulEventSource)element, column.getTooltipbinding(), (XulEventSource)row.getParent(), "tooltiptext");
                this.elementBindings.add(bind);
                bind.setBindingType(Binding.Type.ONE_WAY);
                this.domContainer.addBinding(bind);
                bind.fireSourceChanged();
            }
            row.addCell((XulTreeCell)cell);
            String method = SwtTree.toGetter(((XulTreeCol)this.getColumns().getChildNodes().get(0)).getChildrenbinding());
            Method childrenMethod = null;
            try {
                childrenMethod = element.getClass().getMethod(method, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                logger.debug((Object)("Could not find children binding method for object: " + element.getClass().getSimpleName()));
            }
            method = ((XulTreeCol)this.getColumns().getChildNodes().get(0)).getImagebinding();
            if (method != null) {
                Binding binding2 = this.createBinding((XulEventSource)element, method, (XulEventSource)row.getParent(), "image");
                this.elementBindings.add(binding2);
                binding2.setBindingType(Binding.Type.ONE_WAY);
                this.domContainer.addBinding(binding2);
                binding2.fireSourceChanged();
            }
            Collection children = null;
            if (childrenMethod != null) {
                children = (Collection)childrenMethod.invoke(element, new Object[0]);
            } else if (element instanceof Collection) {
                children = (Collection)element;
            }
            XulTreeChildren treeChildren = null;
            if (children != null && children.size() > 0) {
                treeChildren = (XulTreeChildren)this.getDocument().createElement("treechildren");
                row.getParent().addChild((Element)treeChildren);
            }
            if (children == null) {
                return;
            }
            for (Object child : children) {
                SwtTreeItem item = new SwtTreeItem(treeChildren);
                item.setXulDomContainer(this.domContainer);
                SwtTreeRow newRow = new SwtTreeRow((XulComponent)item);
                item.setRow(newRow);
                item.setBoundObject(child);
                treeChildren.addChild((Element)item);
                this.addTreeChild(child, newRow);
            }
        }
        catch (Exception e) {
            logger.error((Object)"error adding elements", (Throwable)e);
        }
    }

    public <T> Collection<T> getElements() {
        return null;
    }

    private String extractDynamicColType(Object row, int columnPos) {
        try {
            Method method = row.getClass().getMethod(this.columns.getColumn(columnPos).getColumntypebinding(), new Class[0]);
            return (String)method.invoke(row, new Object[0]);
        }
        catch (Exception e) {
            logger.debug((Object)"Could not extract column type from binding");
            return "text";
        }
    }

    private static String toGetter(String property) {
        if (property == null) {
            return null;
        }
        return "get" + property.substring(0, 1).toUpperCase() + property.substring(1);
    }

    public Object getSelectedItem() {
        Collection c = this.getSelectedItems();
        if (c != null && c.size() > 0) {
            return c.toArray()[0];
        }
        return null;
    }

    private Object getSelectedTreeItem(int[] currentSelection) {
        if (this.isHierarchical && this.elements != null) {
            int[] vals = currentSelection;
            if (vals == null || vals.length == 0 || this.elements == null || this.elements.size() == 0) {
                return null;
            }
            String property = SwtTree.toGetter(((XulTreeCol)this.getColumns().getChildNodes().get(0)).getChildrenbinding());
            int selectedIdx = vals[0];
            if (selectedIdx == -1) {
                return null;
            }
            FindSelectedItemTuple tuple = this.findSelectedItem((Object)this.elements, property, new FindSelectedItemTuple(selectedIdx, this.isHiddenrootnode()));
            return tuple != null ? tuple.selectedItem : null;
        }
        return null;
    }

    private void fireSelectedItem() {
        this.changeSupport.firePropertyChange("selectedItem", null, this.getSelectedItem());
    }

    private void removeItemFromElements(Object item, DropEvent event) {
        String method = SwtTree.toGetter(((XulTreeCol)this.getColumns().getChildNodes().get(0)).getChildrenbinding());
        this.removeItem(this.elements, method, item, event);
    }

    private void removeItem(Object parent, String childrenMethodProperty, Object toRemove, DropEvent event) {
        Collection children = SwtTree.getChildCollection(parent, childrenMethodProperty);
        if (children == null) {
            return;
        }
        Iterator iter = children.iterator();
        int pos = 0;
        while (iter.hasNext()) {
            Object next = iter.next();
            if (next == toRemove) {
                if (event.getDropParent() == children && event.getDropIndex() > pos) {
                    event.setDropIndex(event.getDropIndex() - 1);
                }
                children.remove(toRemove);
                return;
            }
            this.removeItem(next, childrenMethodProperty, toRemove, event);
            ++pos;
        }
    }

    private FindSelectedItemTuple findSelectedItem(Object parent, String childrenMethodProperty, FindSelectedItemTuple tuple) {
        if (tuple.curpos == tuple.selectedIndex) {
            tuple.selectedItem = parent;
            return tuple;
        }
        Collection children = SwtTree.getChildCollection(parent, childrenMethodProperty);
        if (children == null || children.size() == 0) {
            return null;
        }
        for (Object child : children) {
            ++tuple.curpos;
            this.findSelectedItem(child, childrenMethodProperty, tuple);
            if (tuple.selectedItem == null) continue;
            return tuple;
        }
        return null;
    }

    public void registerCellEditor(String key, TreeCellEditor editor) {
    }

    public void registerCellRenderer(String key, TreeCellRenderer renderer) {
    }

    public void collapseAll() {
        if (this.isHierarchical) {
            this.tree.collapseAll();
        }
    }

    public void expandAll() {
        if (this.isHierarchical) {
            this.tree.expandAll();
        }
    }

    private static Collection getChildCollection(Object obj, String childrenMethodProperty) {
        Method childrenMethod;
        Collection children;
        block5: {
            children = null;
            childrenMethod = null;
            try {
                childrenMethod = obj.getClass().getMethod(childrenMethodProperty, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                if (!(obj instanceof Collection)) break block5;
                children = (Collection)obj;
            }
        }
        try {
            if (childrenMethod != null) {
                children = (Collection)childrenMethod.invoke(obj, new Object[0]);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
        return children;
    }

    private XulTreeChildren getTreeChildren(XulComponent parent) {
        if (parent == this && !this.isHiddenrootnode()) {
            List childNodes = this.getRootChildren().getChildNodes();
            if (childNodes.size() > 0) {
                parent = (XulComponent)childNodes.get(0);
            } else {
                return null;
            }
        }
        for (XulComponent c : parent.getChildNodes()) {
            if (!(c instanceof XulTreeChildren)) continue;
            return (XulTreeChildren)c;
        }
        return null;
    }

    private FindBoundItemTuple findBoundItem(Object obj, XulComponent parent, String childrenMethodProperty, FindBoundItemTuple tuple) {
        if (obj.equals(tuple.item)) {
            tuple.treeItem = parent;
            return tuple;
        }
        Collection children = SwtTree.getChildCollection(obj, childrenMethodProperty);
        if (children == null || children.size() == 0) {
            return null;
        }
        XulTreeChildren xulChildren = this.getTreeChildren(parent);
        Object[] childrenArry = children.toArray();
        for (int i = 0; i < children.size(); ++i) {
            this.findBoundItem(childrenArry[i], (XulComponent)xulChildren.getChildNodes().get(i), childrenMethodProperty, tuple);
            if (tuple.treeItem == null) continue;
            return tuple;
        }
        return null;
    }

    public void setBoundObjectExpanded(Object o, boolean expanded) {
        FindBoundItemTuple tuple = new FindBoundItemTuple(o);
        String property = SwtTree.toGetter(((XulTreeCol)this.getColumns().getChildNodes().get(0)).getChildrenbinding());
        this.findBoundItem(this.elements, (XulComponent)this, property, tuple);
        if (tuple.treeItem != null) {
            this.setTreeItemExpanded((XulTreeItem)tuple.treeItem, expanded);
        }
    }

    public void setTreeItemExpanded(XulTreeItem item, boolean expanded) {
        if (this.isHierarchical) {
            this.tree.setExpandedState((Object)item, expanded);
        }
    }

    @Override
    public void setPopup(IMenuManager menuMgr) {
        final Control control = this.isHierarchical() ? this.tree.getControl() : this.table.getControl();
        Menu menu = ((MenuManager)menuMgr).createContextMenu(control);
        control.setMenu(menu);
        control.addListener(35, new Listener(){

            public void handleEvent(Event evt) {
                Point pt = control.getDisplay().map(control, null, new Point(evt.x, evt.y));
                Menu menu = control.getMenu();
                menu.setLocation(evt.x, evt.y);
                menu.setVisible(true);
            }
        });
    }

    @Override
    protected Control getDndObject() {
        Control control = this.isHierarchical() ? this.tree.getControl() : this.table.getControl();
        return control;
    }

    @Override
    protected List<Object> getSwtDragData() {
        if (this.elements != null) {
            this.cachedDndItems = (List)this.getSelectedItems();
        } else {
            IStructuredSelection selection = !this.isHierarchical ? (IStructuredSelection)this.tree.getSelection() : (IStructuredSelection)this.table.getSelection();
            ArrayList<Object> list = new ArrayList<Object>();
            boolean i = false;
            for (Object o : selection.toArray()) {
                list.add(((XulTreeItem)o).getRow().getCell(0).getLabel());
            }
            this.cachedDndItems = list;
        }
        return this.cachedDndItems;
    }

    @Override
    protected void resolveDndParentAndIndex(DropEvent xulEvent) {
        Object parentObj = null;
        int index = -1;
        if (!this.isHierarchical) {
            DropTargetEvent event = (DropTargetEvent)xulEvent.getNativeEvent();
            if (event.item != null) {
                TableItem item = (TableItem)event.item;
                if (item != null) {
                    if (this.elements != null) {
                        if (item.getData() instanceof SwtTreeItem) {
                            SwtTreeItem treeItem = (SwtTreeItem)((Object)item.getData());
                            parentObj = treeItem.getBoundObject();
                        }
                    } else {
                        parentObj = item.getText();
                    }
                }
                index = 0;
            }
        } else {
            TreeItem parent = null;
            DropTargetEvent event = (DropTargetEvent)xulEvent.getNativeEvent();
            if (event.item != null) {
                TreeItem item = (TreeItem)event.item;
                Point pt = this.tree.getControl().getDisplay().map(null, this.tree.getControl(), event.x, event.y);
                Rectangle bounds = item.getBounds();
                parent = item.getParentItem();
                if (parent != null) {
                    TreeItem[] items = parent.getItems();
                    index = 0;
                    for (int i = 0; i < items.length; ++i) {
                        if (items[i] != item) continue;
                        index = i;
                        break;
                    }
                    if (pt.y > bounds.y + 2 * bounds.height / 3) {
                        ++index;
                    } else {
                        parent = item;
                        index = 0;
                    }
                } else {
                    TreeItem[] items = this.tree.getTree().getItems();
                    index = 0;
                    for (int i = 0; i < items.length; ++i) {
                        if (items[i] != item) continue;
                        index = i;
                        break;
                    }
                    if (pt.y > bounds.y + 2 * bounds.height / 3) {
                        ++index;
                    } else {
                        parent = item;
                        index = 0;
                    }
                }
            }
            if (parent != null) {
                if (this.elements != null) {
                    SearchBundle b = this.findSelectedIndex(new SearchBundle(), this.getRootChildren(), (XulTreeItem)parent.getData());
                    parentObj = b.selectedItem;
                } else {
                    parentObj = parent.getText();
                }
            }
        }
        xulEvent.setDropParent(parentObj);
        xulEvent.setDropIndex(index);
    }

    @Override
    protected void onSwtDragDropAccepted(DropEvent xulEvent) {
        List results = xulEvent.getDataTransfer().getData();
        if (this.elements != null) {
            Collection insertInto = this.elements;
            if (xulEvent.getDropParent() != null) {
                String method = SwtTree.toGetter(((XulTreeCol)this.getColumns().getChildNodes().get(0)).getChildrenbinding());
                insertInto = SwtTree.getChildCollection(xulEvent.getDropParent(), method);
            }
            if (insertInto instanceof List) {
                List list = (List)insertInto;
                if (xulEvent.getDropIndex() == -1) {
                    for (Object o : results) {
                        list.add(o);
                    }
                } else {
                    for (int i = results.size() - 1; i >= 0; --i) {
                        list.add(xulEvent.getDropIndex(), results.get(i));
                    }
                }
            }
            this.setElements(this.elements);
        }
    }

    @Override
    protected void onSwtDragFinished(DropEffectType effect, DropEvent event) {
        if (effect == DropEffectType.MOVE) {
            if (this.elements != null) {
                for (Object item : this.cachedDndItems) {
                    this.removeItemFromElements(item, event);
                }
                this.cachedDndItems = null;
                this.setElements(this.elements);
            } else if (this.isHierarchical()) {
                this.tree.remove((Object)this.tree.getSelection());
            } else {
                this.table.remove((Object)this.table.getSelection());
            }
        }
    }

    public void setDropvetoer(String dropVetoMethod) {
        if (StringUtils.isEmpty((String)dropVetoMethod)) {
            return;
        }
        super.setDropvetoer(dropVetoMethod);
    }

    private void resolveDropVetoerMethod() {
        if (this.dropVetoerMethod == null && this.getDropvetoer() != null) {
            String id = this.getDropvetoer().substring(0, this.getDropvetoer().indexOf("."));
            try {
                XulEventHandler controller = this.domContainer.getEventHandler(id);
                this.dropVetoerMethod = controller.getClass().getMethod(this.getDropvetoer().substring(this.getDropvetoer().indexOf(".") + 1, this.getDropvetoer().indexOf("(")), DropEvent.class);
                this.dropVetoerController = controller;
            }
            catch (XulException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void onSwtDragOver(DropTargetEvent dropEvent) {
        dropEvent.feedback = 24;
        if (dropEvent.item != null) {
            TreeItem item;
            Rectangle bounds = null;
            Point pt = null;
            if (this.isHierarchical()) {
                item = (TreeItem)dropEvent.item;
                pt = this.tree.getControl().getDisplay().map(null, this.tree.getControl(), dropEvent.x, dropEvent.y);
                bounds = item.getBounds();
            } else {
                item = (TableItem)dropEvent.item;
                pt = this.table.getControl().getDisplay().map(null, this.table.getControl(), dropEvent.x, dropEvent.y);
                bounds = item.getBounds();
            }
            this.curPos = pt.y < bounds.y + bounds.height / 3 ? DropPosition.ABOVE : (pt.y > bounds.y + 2 * (bounds.height / 3) ? DropPosition.BELOW : DropPosition.MIDDLE);
            this.resolveDropVetoerMethod();
            DropEvent event = SwtDragManager.getInstance().getCurrentDropEvent();
            if (this.dropVetoerMethod != null) {
                XulTreeItem xulItem = (XulTreeItem)dropEvent.item.getData();
                if (this.curPos == DropPosition.MIDDLE) {
                    event.setDropParent(xulItem.getBoundObject());
                } else {
                    XulComponent parent = xulItem.getParent().getParent();
                    Object parentObj = parent instanceof SwtTree ? this.elements : ((XulTreeItem)parent).getBoundObject();
                    event.setDropParent(parentObj);
                }
                event.setNativeEvent((Object)dropEvent);
                event.setAccepted(true);
                this.resolveDndParentAndIndex(event);
                event.setDropPosition(this.curPos);
                try {
                    this.dropVetoerMethod.invoke(this.dropVetoerController, event);
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            dropEvent.feedback = !event.isAccepted() ? 0 : (pt.y < bounds.y + bounds.height / 3 ? (dropEvent.feedback |= 2) : (pt.y > bounds.y + 2 * (bounds.height / 3) ? (dropEvent.feedback |= 4) : (dropEvent.feedback |= 1)));
        }
    }

    public <T> void setSelectedItems(Collection<T> items) {
        int[] selIndexes = new int[items.size()];
        if (this.isHierarchical && this.elements != null) {
            ArrayList<XulComponent> selection = new ArrayList<XulComponent>();
            String property = SwtTree.toGetter(((XulTreeCol)this.getColumns().getChildNodes().get(0)).getChildrenbinding());
            for (T t : items) {
                FindBoundItemTuple tuple = new FindBoundItemTuple(t);
                this.findBoundItem(this.elements, (XulComponent)this, property, tuple);
                XulComponent bItem = tuple.treeItem;
                if (tuple.treeItem == this) {
                    bItem = (XulComponent)this.getRootChildren().getChildNodes().get(0);
                }
                if (bItem == null) continue;
                selection.add(bItem);
            }
            this.tree.setSelection((ISelection)new StructuredSelection(selection));
        } else {
            int pos = 0;
            for (T t : items) {
                selIndexes[pos++] = this.findIndexOfItem(t);
            }
            this.setSelectedRows(selIndexes);
        }
    }

    public int findIndexOfItem(Object o) {
        String property = ((XulTreeCol)this.getColumns().getChildNodes().get(0)).getChildrenbinding();
        property = "get" + property.substring(0, 1).toUpperCase() + property.substring(1);
        Method childrenMethod = null;
        try {
            childrenMethod = this.elements.getClass().getMethod(property, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            logger.debug((Object)e);
        }
        FindSelectedIndexTuple tuple = this.findSelectedItem((Object)this.elements, childrenMethod, new FindSelectedIndexTuple(o));
        return tuple.selectedIndex;
    }

    private FindSelectedIndexTuple findSelectedItem(Object parent, Method childrenMethod, FindSelectedIndexTuple tuple) {
        if (tuple.selectedItem == parent) {
            tuple.selectedIndex = tuple.curpos;
            return tuple;
        }
        Collection children = null;
        if (childrenMethod != null) {
            try {
                children = (Collection)childrenMethod.invoke(parent, new Object[0]);
            }
            catch (Exception e) {
                logger.error((Object)e);
                return tuple;
            }
        } else if (parent instanceof List) {
            children = (List)parent;
        }
        if (children == null || children.size() == 0) {
            return null;
        }
        for (Object child : children) {
            ++tuple.curpos;
            this.findSelectedItem(child, childrenMethod, tuple);
            if (tuple.selectedIndex <= -1) continue;
            return tuple;
        }
        return tuple;
    }

    public boolean isHiddenrootnode() {
        return this.hiddenRoot;
    }

    public void setHiddenrootnode(boolean hidden) {
        this.hiddenRoot = hidden;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getToggle() {
        return this.toggle;
    }

    public void setToggle(String toggle) {
        this.toggle = toggle;
    }

    public boolean isPreserveexpandedstate() {
        return this.preserveExpandedState;
    }

    public void setPreserveexpandedstate(boolean preserve) {
        this.preserveExpandedState = preserve;
    }

    public boolean isSortable() {
        return this.sortProperties.isSortable();
    }

    public void setSortable(boolean sortable) {
        this.sortProperties.setSortable(sortable);
    }

    public boolean isTreeLines() {
        return this.linesVisible;
    }

    public void setTreeLines(boolean visible) {
        this.linesVisible = visible;
    }

    public void setNewitembinding(String binding) {
        this.newItemBinding = binding;
    }

    public String getNewitembinding() {
        return this.newItemBinding;
    }

    public void setAutocreatenewrows(boolean auto) {
        this.autoCreateNewRows = auto;
    }

    public boolean getAutocreatenewrows() {
        return this.autoCreateNewRows;
    }

    public boolean isPreserveselection() {
        return this.preserveSelection;
    }

    public void setPreserveselection(boolean preserve) {
        this.preserveSelection = preserve;
    }

    private Binding createBinding(XulEventSource source, String prop1, XulEventSource target, String prop2) {
        if (this.bindingProvider != null) {
            return this.bindingProvider.getBinding(source, prop1, target, prop2);
        }
        return new DefaultBinding((Object)source, prop1, (Object)target, prop2);
    }

    private class PentahoTreeViewer
    extends TreeViewer {
        private ListenerList<ITreeViewerListener> duplicateTreeListenerList;

        public PentahoTreeViewer(Composite parent, int style) {
            super(parent, style);
            this.duplicateTreeListenerList = new ListenerList();
        }

        public void addTreeListener(ITreeViewerListener listener) {
            this.duplicateTreeListenerList.add((Object)listener);
            super.addTreeListener(listener);
        }

        public void removeTreeListener(ITreeViewerListener listener) {
            this.duplicateTreeListenerList.remove((Object)listener);
            super.removeTreeListener(listener);
        }

        protected void fireTreeExpanded(final TreeExpansionEvent event) {
            for (final ITreeViewerListener l : this.duplicateTreeListenerList) {
                SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        l.treeExpanded(event);
                    }
                });
            }
        }

        protected void fireTreeCollapsed(final TreeExpansionEvent event) {
            for (final ITreeViewerListener l : this.duplicateTreeListenerList) {
                SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        l.treeCollapsed(event);
                    }
                });
            }
        }
    }

    private static class TreeLabelBindingConvertor
    extends BindingConvertor<String, String> {
        private SwtTree tree;

        public TreeLabelBindingConvertor(SwtTree tree) {
            this.tree = tree;
        }

        public String sourceToTarget(String value) {
            return value;
        }

        public String targetToSource(String value) {
            this.tree.update();
            return value;
        }
    }

    private static class FindSelectedIndexTuple {
        Object selectedItem = null;
        Object currentItem = null;
        int curpos = -1;
        int selectedIndex = -1;

        public FindSelectedIndexTuple(Object selectedItem) {
            this.selectedItem = selectedItem;
        }
    }

    private static class FindBoundItemTuple {
        Object item = null;
        XulComponent treeItem;

        public FindBoundItemTuple(Object item) {
            this.item = item;
        }
    }

    private static class FindSelectedItemTuple {
        Object selectedItem = null;
        int curpos = -1;
        int selectedIndex;

        public FindSelectedItemTuple(int selectedIndex, boolean rootHidden) {
            this.selectedIndex = selectedIndex;
            if (!rootHidden) {
                this.curpos = 0;
            }
        }
    }

    private static class FindTreeItemForPosTuple {
        int pos;
        int curPos = -1;
        XulComponent curComponent;
        XulTreeItem treeItem;
        boolean found;

        public FindTreeItemForPosTuple(int pos, XulComponent curComponent) {
            this.pos = pos;
            this.curComponent = curComponent;
        }
    }

    public static enum SELECTION_MODE {
        SINGLE,
        CELL,
        MULTIPLE;

    }

    private class SearchBundle {
        int curPos;
        boolean found;
        Object selectedItem;

        private SearchBundle() {
        }
    }
}

