/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swt.tags;

import java.beans.Expression;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.components.XulMenuList;
import org.pentaho.ui.xul.components.XulMenuitem;
import org.pentaho.ui.xul.containers.XulMenupopup;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swt.AbstractSwtXulContainer;
import org.pentaho.ui.xul.swt.tags.SwtMenuitem;
import org.pentaho.ui.xul.swt.tags.SwtMenupopup;

public class SwtMenuList<T>
extends AbstractSwtXulContainer
implements XulMenuList<T> {
    private Combo combobox;
    private XulDomContainer xulDomContainer;
    private static final Log logger = LogFactory.getLog(SwtMenuList.class);
    private boolean loaded = false;
    private String binding;
    private Object previousSelectedItem = null;
    private SwtMenupopup popup;
    private SwtMenuitem selectedItem = null;
    private boolean editable = false;
    private String command;
    private XulComponent parent;
    private Collection<T> elements;

    public SwtMenuList(Element self, XulComponent parent, XulDomContainer domContainer, String tagName) {
        super("menulist");
        this.xulDomContainer = domContainer;
        this.parent = parent;
        this.setupCombobox();
    }

    private void setupCombobox() {
        this.combobox = this.editable ? new Combo((Composite)this.parent.getManagedObject(), 4) : new Combo((Composite)this.parent.getManagedObject(), 12);
        this.setManagedObject(this.combobox);
        this.combobox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SwtMenuList.this.fireSelectedEvents();
            }
        });
    }

    @Override
    public void addChild(Element ele) {
        super.addChild(ele);
        if (ele instanceof XulMenupopup) {
            this.popup = (SwtMenupopup)ele;
        }
    }

    @Override
    public void layout() {
        this.combobox.removeAll();
        this.selectedItem = null;
        for (XulComponent item : this.popup.getChildNodes()) {
            SwtMenuitem mItem = (SwtMenuitem)item;
            if (mItem.isSelected()) {
                this.selectedItem = mItem;
            }
            this.combobox.add(mItem.getLabel());
        }
        int idx = -1;
        if (this.selectedItem != null) {
            idx = this.combobox.indexOf(this.selectedItem.toString());
        } else if (this.popup.getChildNodes().size() > 0) {
            idx = 0;
        }
        this.setSelectedIndex(idx);
        this.loaded = true;
    }

    @Deprecated
    public void replaceAllItems(Collection<T> tees) {
        this.setElements(tees);
    }

    public String getSelectedItem() {
        int idx = this.combobox.getSelectionIndex();
        return idx > -1 && idx < this.combobox.getItemCount() ? this.combobox.getItem(idx) : null;
    }

    public void setSelectedItem(T t) {
        if (t == null) {
            this.combobox.deselectAll();
            return;
        }
        if (this.elements != null) {
            this.combobox.select(new ArrayList<T>(this.elements).indexOf(t));
        } else {
            this.combobox.select(this.combobox.indexOf(t.toString()));
        }
        this.previousSelectedItem = null;
    }

    public void setOncommand(String command) {
        this.command = command;
    }

    public Collection<T> getElements() {
        return this.popup.getChildNodes();
    }

    public String getBinding() {
        return this.binding;
    }

    public void setBinding(String binding) {
        this.binding = binding;
    }

    private String extractLabel(T t) {
        String attribute = this.getBinding();
        if (StringUtils.isEmpty((String)attribute)) {
            return t.toString();
        }
        String getter = "get" + String.valueOf(attribute.charAt(0)).toUpperCase() + attribute.substring(1);
        try {
            return new Expression(t, getter, null).getValue().toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setElements(Collection<T> tees) {
        this.elements = tees;
        for (XulComponent menuItem : this.popup.getChildNodes()) {
            this.popup.removeChild((Element)menuItem);
        }
        if (tees == null) {
            return;
        }
        for (Object t : tees) {
            try {
                XulMenuitem item = (XulMenuitem)this.xulDomContainer.getDocumentRoot().createElement("menuitem");
                String attribute = this.getBinding();
                item.setLabel(this.extractLabel(t));
                this.popup.addChild((Element)item);
            }
            catch (XulException e) {
                logger.error((Object)"Unable to create new menulist menuitem: ", (Throwable)e);
            }
        }
        this.layout();
    }

    public int getSelectedIndex() {
        return this.combobox.getSelectionIndex();
    }

    public void setSelectedIndex(int idx) {
        if (idx == -1) {
            this.combobox.clearSelection();
        } else {
            this.combobox.select(idx);
        }
        this.fireSelectedEvents();
    }

    private void fireSelectedEvents() {
        int idx = this.getSelectedIndex();
        if (idx >= 0) {
            String newSelectedItem = idx >= 0 ? (this.elements != null ? this.elements.toArray()[idx] : this.getSelectedItem()) : this.getSelectedItem();
            this.changeSupport.firePropertyChange("selectedItem", this.previousSelectedItem, newSelectedItem);
            this.previousSelectedItem = newSelectedItem;
        }
        this.changeSupport.firePropertyChange("selectedIndex", null, (Object)this.combobox.getSelectionIndex());
        if (this.command != null && this.getDocument() != null) {
            this.invoke(this.command, new Object[0]);
        }
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean getEditable() {
        return this.editable;
    }

    public String getValue() {
        return this.getSelectedItem();
    }

    public void setValue(String value) {
        this.combobox.setText(value);
    }

    @Override
    public void setDisabled(boolean disabled) {
        super.setDisabled(disabled);
        this.combobox.setEnabled(!disabled);
    }
}

