/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swt.tags;

import java.awt.Color;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.containers.XulBox;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swt.AbstractSwtXulContainer;
import org.pentaho.ui.xul.swt.tags.Style;
import org.pentaho.ui.xul.util.Orient;
import org.pentaho.ui.xul.util.SwtXulUtil;

public class SwtBox
extends AbstractSwtXulContainer
implements XulBox {
    private static final long serialVersionUID = 582736100041411600L;
    protected Composite box;
    protected String background;
    protected String bgcolor;
    protected String style;
    protected XulDomContainer container;
    private static Log logger = LogFactory.getLog(SwtBox.class);

    public SwtBox(Element self, XulComponent parent, XulDomContainer container, String tagName) {
        this(self, parent, tagName, container, Orient.HORIZONTAL);
    }

    public SwtBox(Element self, XulComponent parent, String tagName, XulDomContainer container, Orient orient) {
        super(tagName);
        this.style = self != null ? self.getAttributeValue("style") : "";
        this.box = this.createNewComposite((Composite)parent.getManagedObject());
        this.box.setBackgroundMode(1);
        this.setOrient(orient.toString());
        this.container = container;
        this.setManagedObject(this.box);
    }

    protected Composite createNewComposite(Composite parent) {
        int overflowProperty;
        int n = overflowProperty = this.style != null ? Style.getOverflowProperty(this.style) : 0;
        if (overflowProperty == 0) {
            return new Composite(parent, 0);
        }
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, overflowProperty);
        scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite = new Composite((Composite)scrolledComposite, 0);
        composite.setLayout((Layout)new GridLayout());
        scrolledComposite.setContent((Control)composite);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        return composite;
    }

    public String getBackground() {
        return this.background;
    }

    public void setBackground(String background) {
        this.background = background;
        Image backgroundImg = SwtXulUtil.getCachedImage(background, this.container, this.box.getDisplay());
        if (backgroundImg != null) {
            this.box.setBackgroundMode(1);
            this.box.setBackgroundImage(backgroundImg);
        }
    }

    public String getBgcolor() {
        return this.bgcolor;
    }

    @Override
    public void layout() {
        super.layout();
        Composite composite = (Composite)this.getManagedObject();
        if (composite.getParent() instanceof ScrolledComposite) {
            ((ScrolledComposite)composite.getParent()).setMinSize(composite.computeSize(-1, -1));
        }
    }

    public void setBgcolor(String bgcolor) {
        this.bgcolor = bgcolor;
        Color c = Color.decode(bgcolor);
        this.box.setBackground(new org.eclipse.swt.graphics.Color((Device)this.box.getDisplay(), c.getRed(), c.getGreen(), c.getBlue()));
        this.box.setBackgroundMode(1);
    }
}

