/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.luciddbstreamingloader;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.SourceToTargetMapping;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.luciddbstreamingloader.LucidDBStreamingLoaderMeta;
import org.pentaho.di.ui.core.database.dialog.DatabaseExplorerDialog;
import org.pentaho.di.ui.core.database.dialog.SQLEditor;
import org.pentaho.di.ui.core.dialog.EnterMappingDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.StyledTextComp;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.steps.tableinput.SQLValuesHighlight;

public class LucidDBStreamingLoaderDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = LucidDBStreamingLoaderMeta.class;
    private CCombo wConnection;
    private Label wlSchema;
    private TextVar wSchema;
    private FormData fdlSchema;
    private FormData fdSchema;
    private Label wlTable;
    private Button wbTable;
    private TextVar wTable;
    private FormData fdlTable;
    private FormData fdbTable;
    private FormData fdTable;
    private Label wlHost;
    private TextVar wHost;
    private FormData fdlHost;
    private FormData fdHost;
    private Label wlPort;
    private TextVar wPort;
    private FormData fdlPort;
    private FormData fdPort;
    private Label wlOperation;
    private CCombo wOperation;
    private FormData fdlOperation;
    private FormData fdOperation;
    private CTabFolder wTabFolder;
    private FormData fdTabFolder;
    private CTabItem wKeysTab;
    private CTabItem wFieldsTab;
    private CTabItem wCustomTab;
    private Composite wKeysComp;
    private Composite wFieldsComp;
    private Composite wCustomComp;
    private FormData fdKeysComp;
    private FormData fdFieldsComp;
    private FormData fdCustomComp;
    private Label wlKeysTb;
    private TableView wKeysTb;
    private FormData fdlKeysTb;
    private FormData fdKeysTb;
    private Label wlFieldsTb;
    private TableView wFieldsTb;
    private FormData fdlFieldsTb;
    private FormData fdFieldsTb;
    private Label wlCustomTb;
    private StyledTextComp wCustomTb;
    private FormData fdlCustomTb;
    private FormData fdCustomTb;
    private Button wGetFieldsForKeys;
    private FormData fdGetFieldsForKeys;
    private Button wDoMappingForKeys;
    private FormData fdDoMappingForKeys;
    private Button wGetFieldsForFields;
    private FormData fdGetFieldsForFields;
    private Button wDoMappingForFields;
    private FormData fdDoMappingForFields;
    public LucidDBStreamingLoaderMeta input;
    private Label lAutoCreateTable;
    private FormData fdlAutoCreateTable;
    private FormData fdbAutoCreateTable;

    public LucidDBStreamingLoaderDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (LucidDBStreamingLoaderMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LucidDBStreamingLoaderDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wStepname, middle, margin);
        if (this.input.getDatabaseMeta() == null && this.transMeta.nrDatabases() == 1) {
            this.wConnection.select(0);
        }
        this.wConnection.addModifyListener(lsMod);
        this.wlSchema = new Label((Composite)this.shell, 131072);
        this.wlSchema.setText(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.TargetSchema.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSchema);
        this.fdlSchema = new FormData();
        this.fdlSchema.left = new FormAttachment(0, 0);
        this.fdlSchema.right = new FormAttachment(middle, -margin);
        this.fdlSchema.top = new FormAttachment((Control)this.wConnection, margin * 2);
        this.wlSchema.setLayoutData((Object)this.fdlSchema);
        this.wSchema = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wSchema);
        this.wSchema.addModifyListener(lsMod);
        this.fdSchema = new FormData();
        this.fdSchema.left = new FormAttachment(middle, 0);
        this.fdSchema.top = new FormAttachment((Control)this.wConnection, margin * 2);
        this.fdSchema.right = new FormAttachment(100, 0);
        this.wSchema.setLayoutData((Object)this.fdSchema);
        this.wlTable = new Label((Composite)this.shell, 131072);
        this.wlTable.setText(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.TargetTable.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTable);
        this.fdlTable = new FormData();
        this.fdlTable.left = new FormAttachment(0, 0);
        this.fdlTable.right = new FormAttachment(middle, -margin);
        this.fdlTable.top = new FormAttachment((Control)this.wSchema, margin);
        this.wlTable.setLayoutData((Object)this.fdlTable);
        this.wbTable = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbTable);
        this.wbTable.setText(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.Browse.Button", (String[])new String[0]));
        this.fdbTable = new FormData();
        this.fdbTable.right = new FormAttachment(100, 0);
        this.fdbTable.top = new FormAttachment((Control)this.wSchema, margin);
        this.wbTable.setLayoutData((Object)this.fdbTable);
        this.wTable = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wTable);
        this.wTable.addModifyListener(lsMod);
        this.fdTable = new FormData();
        this.fdTable.left = new FormAttachment(middle, 0);
        this.fdTable.top = new FormAttachment((Control)this.wSchema, margin);
        this.fdTable.right = new FormAttachment((Control)this.wbTable, -margin);
        this.wTable.setLayoutData((Object)this.fdTable);
        this.lAutoCreateTable = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)this.lAutoCreateTable);
        this.fdlAutoCreateTable = new FormData();
        this.fdlAutoCreateTable.left = new FormAttachment(0, 0);
        this.fdlAutoCreateTable.top = new FormAttachment((Control)this.wTable, margin);
        this.fdlAutoCreateTable.right = new FormAttachment(middle, -margin);
        this.lAutoCreateTable.setLayoutData((Object)this.fdlAutoCreateTable);
        this.fdbAutoCreateTable = new FormData();
        this.fdbAutoCreateTable.left = new FormAttachment((Control)this.lAutoCreateTable, 10);
        this.fdbAutoCreateTable.top = new FormAttachment((Control)this.wTable, margin);
        this.wlHost = new Label((Composite)this.shell, 131072);
        this.wlHost.setText(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.Host.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlHost);
        this.fdlHost = new FormData();
        this.fdlHost.left = new FormAttachment(0, 0);
        this.fdlHost.top = new FormAttachment((Control)this.lAutoCreateTable, margin);
        this.fdlHost.right = new FormAttachment(middle, -margin);
        this.wlHost.setLayoutData((Object)this.fdlHost);
        this.wHost = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wHost);
        this.wHost.addModifyListener(lsMod);
        this.fdHost = new FormData();
        this.fdHost.left = new FormAttachment(middle, 0);
        this.fdHost.top = new FormAttachment((Control)this.lAutoCreateTable, margin);
        this.fdHost.right = new FormAttachment(100, 0);
        this.wHost.setLayoutData((Object)this.fdHost);
        this.wlPort = new Label((Composite)this.shell, 131072);
        this.wlPort.setText(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.Port.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlPort);
        this.fdlPort = new FormData();
        this.fdlPort.left = new FormAttachment(0, 0);
        this.fdlPort.top = new FormAttachment((Control)this.wHost, margin);
        this.fdlPort.right = new FormAttachment(middle, -margin);
        this.wlPort.setLayoutData((Object)this.fdlPort);
        this.wPort = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wPort);
        this.wPort.addModifyListener(lsMod);
        this.fdPort = new FormData();
        this.fdPort.left = new FormAttachment(middle, 0);
        this.fdPort.top = new FormAttachment((Control)this.wHost, margin);
        this.fdPort.right = new FormAttachment(100, 0);
        this.wPort.setLayoutData((Object)this.fdPort);
        this.wlOperation = new Label((Composite)this.shell, 131072);
        this.wlOperation.setText(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.Operation.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlOperation);
        this.fdlOperation = new FormData();
        this.fdlOperation.left = new FormAttachment(0, 0);
        this.fdlOperation.top = new FormAttachment((Control)this.wPort, margin);
        this.fdlOperation.right = new FormAttachment(middle, -margin);
        this.wlOperation.setLayoutData((Object)this.fdlOperation);
        this.wOperation = new CCombo((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wOperation);
        this.wOperation.addModifyListener(lsMod);
        this.fdOperation = new FormData();
        this.fdOperation.top = new FormAttachment((Control)this.wPort, margin);
        this.fdOperation.left = new FormAttachment(middle, 0);
        this.fdOperation.right = new FormAttachment(100, 0);
        this.wOperation.setLayoutData((Object)this.fdOperation);
        final String[] operations = new String[]{BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.Operation.CCombo.Item1", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.Operation.CCombo.Item2", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.Operation.CCombo.Item3", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.Operation.CCombo.Item4", (String[])new String[0])};
        this.wOperation.setItems(operations);
        this.wOperation.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }

            public void widgetSelected(SelectionEvent event) {
                CCombo mycc = (CCombo)event.widget;
                if (operations[0].equals(mycc.getItem(mycc.getSelectionIndex()))) {
                    ((LucidDBStreamingLoaderDialog)LucidDBStreamingLoaderDialog.this).wKeysTb.table.removeAll();
                    ((LucidDBStreamingLoaderDialog)LucidDBStreamingLoaderDialog.this).wKeysTb.table.setItemCount(1);
                    LucidDBStreamingLoaderDialog.this.wKeysTb.setRowNums();
                    ((LucidDBStreamingLoaderDialog)LucidDBStreamingLoaderDialog.this).wFieldsTb.table.removeAll();
                    ((LucidDBStreamingLoaderDialog)LucidDBStreamingLoaderDialog.this).wFieldsTb.table.setItemCount(1);
                    LucidDBStreamingLoaderDialog.this.wFieldsTb.setRowNums();
                    LucidDBStreamingLoaderDialog.this.wCustomTb.setText("");
                    LucidDBStreamingLoaderDialog.this.wTabFolder.setSelection(LucidDBStreamingLoaderDialog.this.wKeysTab);
                    LucidDBStreamingLoaderDialog.this.wKeysTab.getControl().setEnabled(true);
                    LucidDBStreamingLoaderDialog.this.wFieldsTab.getControl().setEnabled(true);
                    LucidDBStreamingLoaderDialog.this.wCustomTab.getControl().setEnabled(false);
                    ((LucidDBStreamingLoaderDialog)LucidDBStreamingLoaderDialog.this).wFieldsTb.table.getColumn(3).setWidth(80);
                } else if (operations[1].equals(mycc.getItem(mycc.getSelectionIndex()))) {
                    ((LucidDBStreamingLoaderDialog)LucidDBStreamingLoaderDialog.this).wKeysTb.table.removeAll();
                    ((LucidDBStreamingLoaderDialog)LucidDBStreamingLoaderDialog.this).wKeysTb.table.setItemCount(1);
                    LucidDBStreamingLoaderDialog.this.wKeysTb.setRowNums();
                    ((LucidDBStreamingLoaderDialog)LucidDBStreamingLoaderDialog.this).wFieldsTb.table.removeAll();
                    ((LucidDBStreamingLoaderDialog)LucidDBStreamingLoaderDialog.this).wFieldsTb.table.setItemCount(1);
                    LucidDBStreamingLoaderDialog.this.wFieldsTb.setRowNums();
                    LucidDBStreamingLoaderDialog.this.wCustomTb.setText("");
                    LucidDBStreamingLoaderDialog.this.wTabFolder.setSelection(LucidDBStreamingLoaderDialog.this.wFieldsTab);
                    LucidDBStreamingLoaderDialog.this.wKeysTab.getControl().setEnabled(false);
                    LucidDBStreamingLoaderDialog.this.wFieldsTab.getControl().setEnabled(true);
                    LucidDBStreamingLoaderDialog.this.wCustomTab.getControl().setEnabled(false);
                    ((LucidDBStreamingLoaderDialog)LucidDBStreamingLoaderDialog.this).wFieldsTb.table.getColumn(3).setWidth(0);
                } else if (operations[2].equals(mycc.getItem(mycc.getSelectionIndex()))) {
                    ((LucidDBStreamingLoaderDialog)LucidDBStreamingLoaderDialog.this).wKeysTb.table.removeAll();
                    ((LucidDBStreamingLoaderDialog)LucidDBStreamingLoaderDialog.this).wKeysTb.table.setItemCount(1);
                    LucidDBStreamingLoaderDialog.this.wKeysTb.setRowNums();
                    ((LucidDBStreamingLoaderDialog)LucidDBStreamingLoaderDialog.this).wFieldsTb.table.removeAll();
                    ((LucidDBStreamingLoaderDialog)LucidDBStreamingLoaderDialog.this).wFieldsTb.table.setItemCount(1);
                    LucidDBStreamingLoaderDialog.this.wFieldsTb.setRowNums();
                    LucidDBStreamingLoaderDialog.this.wCustomTb.setText("");
                    LucidDBStreamingLoaderDialog.this.wTabFolder.setSelection(LucidDBStreamingLoaderDialog.this.wKeysTab);
                    LucidDBStreamingLoaderDialog.this.wKeysTab.getControl().setEnabled(true);
                    LucidDBStreamingLoaderDialog.this.wFieldsTab.getControl().setEnabled(true);
                    LucidDBStreamingLoaderDialog.this.wCustomTab.getControl().setEnabled(false);
                    ((LucidDBStreamingLoaderDialog)LucidDBStreamingLoaderDialog.this).wFieldsTb.table.getColumn(3).setWidth(80);
                } else if (operations[3].equals(mycc.getItem(mycc.getSelectionIndex()))) {
                    ((LucidDBStreamingLoaderDialog)LucidDBStreamingLoaderDialog.this).wKeysTb.table.removeAll();
                    ((LucidDBStreamingLoaderDialog)LucidDBStreamingLoaderDialog.this).wKeysTb.table.setItemCount(1);
                    LucidDBStreamingLoaderDialog.this.wKeysTb.setRowNums();
                    ((LucidDBStreamingLoaderDialog)LucidDBStreamingLoaderDialog.this).wFieldsTb.table.removeAll();
                    ((LucidDBStreamingLoaderDialog)LucidDBStreamingLoaderDialog.this).wFieldsTb.table.setItemCount(1);
                    LucidDBStreamingLoaderDialog.this.wFieldsTb.setRowNums();
                    LucidDBStreamingLoaderDialog.this.wCustomTb.setText("");
                    LucidDBStreamingLoaderDialog.this.wTabFolder.setSelection(LucidDBStreamingLoaderDialog.this.wKeysTab);
                    LucidDBStreamingLoaderDialog.this.wKeysTab.getControl().setEnabled(true);
                    LucidDBStreamingLoaderDialog.this.wFieldsTab.getControl().setEnabled(true);
                    LucidDBStreamingLoaderDialog.this.wCustomTab.getControl().setEnabled(true);
                    ((LucidDBStreamingLoaderDialog)LucidDBStreamingLoaderDialog.this).wFieldsTb.table.getColumn(3).setWidth(80);
                }
            }
        });
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.wTabFolder.setSimple(false);
        this.fdTabFolder = new FormData();
        this.fdTabFolder.left = new FormAttachment(0, 0);
        this.fdTabFolder.top = new FormAttachment((Control)this.wlOperation, margin);
        this.fdTabFolder.right = new FormAttachment(100, 0);
        this.fdTabFolder.bottom = new FormAttachment(100, -50);
        this.wTabFolder.setLayoutData((Object)this.fdTabFolder);
        this.wKeysTab = new CTabItem(this.wTabFolder, 0);
        this.wKeysTab.setText(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.KeyTab.TabTitle", (String[])new String[0]));
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginWidth = 5;
        fieldsLayout.marginHeight = 5;
        this.wKeysComp = new Composite((Composite)this.wTabFolder, 0);
        this.wKeysComp.setLayout((Layout)fieldsLayout);
        this.props.setLook((Control)this.wKeysComp);
        this.wlKeysTb = new Label(this.wKeysComp, 16384);
        this.wlKeysTb.setText(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.KeyTab.Label", (String[])new String[0]));
        this.fdlKeysTb = new FormData();
        this.fdlKeysTb.left = new FormAttachment(0, 0);
        this.fdlKeysTb.top = new FormAttachment(0, 0);
        this.fdlKeysTb.right = new FormAttachment(100, 0);
        this.wlKeysTb.setLayoutData((Object)this.fdlKeysTb);
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.Key.Column1", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.Key.Column2", (String[])new String[0]), 1, false)};
        this.wKeysTb = new TableView((VariableSpace)this.transMeta, this.wKeysComp, 65538, colinf, 0, lsMod, this.props);
        this.fdKeysTb = new FormData();
        this.fdKeysTb.left = new FormAttachment(0, 0);
        this.fdKeysTb.top = new FormAttachment((Control)this.wlKeysTb, margin);
        this.fdKeysTb.right = new FormAttachment(100, 0);
        this.fdKeysTb.bottom = new FormAttachment(95, -margin);
        this.wKeysTb.setLayoutData((Object)this.fdKeysTb);
        this.fdKeysComp = new FormData();
        this.fdKeysComp.left = new FormAttachment(0, 0);
        this.fdKeysComp.top = new FormAttachment(0, 0);
        this.fdKeysComp.right = new FormAttachment(100, 0);
        this.fdKeysComp.bottom = new FormAttachment(100, 0);
        this.wKeysComp.setLayoutData((Object)this.fdKeysComp);
        this.wGetFieldsForKeys = new Button(this.wKeysComp, 8);
        this.wGetFieldsForKeys.setText(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.GetFields.Label", (String[])new String[0]));
        this.fdGetFieldsForKeys = new FormData();
        this.fdGetFieldsForKeys.top = new FormAttachment((Control)this.wKeysTb, margin);
        this.fdGetFieldsForKeys.left = new FormAttachment(0, margin);
        this.wGetFieldsForKeys.setLayoutData((Object)this.fdGetFieldsForKeys);
        this.wGetFieldsForKeys.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                LucidDBStreamingLoaderDialog.this.getFields(LucidDBStreamingLoaderDialog.this.wKeysTab.getText());
            }
        });
        this.wDoMappingForKeys = new Button(this.wKeysComp, 8);
        this.wDoMappingForKeys.setText(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.EditMapping.Label", (String[])new String[0]));
        this.fdDoMappingForKeys = new FormData();
        this.fdDoMappingForKeys.top = new FormAttachment((Control)this.wKeysTb, margin);
        this.fdDoMappingForKeys.left = new FormAttachment((Control)this.wGetFieldsForKeys, margin);
        this.wDoMappingForKeys.setLayoutData((Object)this.fdDoMappingForKeys);
        this.wDoMappingForKeys.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                LucidDBStreamingLoaderDialog.this.generateMappings(LucidDBStreamingLoaderDialog.this.wKeysTab.getText());
            }
        });
        this.wKeysComp.layout();
        this.wKeysTab.setControl((Control)this.wKeysComp);
        this.wFieldsTab = new CTabItem(this.wTabFolder, 0);
        this.wFieldsTab.setText(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.FieldsTab.TabTitle", (String[])new String[0]));
        this.wFieldsComp = new Composite((Composite)this.wTabFolder, 0);
        this.wFieldsComp.setLayout((Layout)fieldsLayout);
        this.props.setLook((Control)this.wFieldsComp);
        this.wlFieldsTb = new Label(this.wFieldsComp, 16384);
        this.wlFieldsTb.setText(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.FieldTab.Label", (String[])new String[0]));
        this.fdlFieldsTb = new FormData();
        this.fdlFieldsTb.left = new FormAttachment(0, 0);
        this.fdlFieldsTb.top = new FormAttachment(0, 0);
        this.fdlFieldsTb.right = new FormAttachment(100, 0);
        this.wlFieldsTb.setLayoutData((Object)this.fdlFieldsTb);
        ColumnInfo[] colinf1 = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.Field.Column1", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.Field.Column2", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.Field.Column3", (String[])new String[0]), 2, new String[]{"Y", "N"}, true)};
        this.wFieldsTb = new TableView((VariableSpace)this.transMeta, this.wFieldsComp, 65538, colinf1, 0, lsMod, this.props);
        this.fdFieldsTb = new FormData();
        this.fdFieldsTb.left = new FormAttachment(0, 0);
        this.fdFieldsTb.top = new FormAttachment((Control)this.wlFieldsTb, margin);
        this.fdFieldsTb.right = new FormAttachment(100, 0);
        this.fdFieldsTb.bottom = new FormAttachment(95, -margin);
        this.wFieldsTb.setLayoutData((Object)this.fdFieldsTb);
        this.fdFieldsComp = new FormData();
        this.fdFieldsComp.left = new FormAttachment(0, 0);
        this.fdFieldsComp.top = new FormAttachment(0, 0);
        this.fdFieldsComp.right = new FormAttachment(100, 0);
        this.fdFieldsComp.bottom = new FormAttachment(100, 0);
        this.wFieldsComp.setLayoutData((Object)this.fdFieldsComp);
        this.wGetFieldsForFields = new Button(this.wFieldsComp, 8);
        this.wGetFieldsForFields.setText(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.GetFields.Label", (String[])new String[0]));
        this.fdGetFieldsForFields = new FormData();
        this.fdGetFieldsForFields.top = new FormAttachment((Control)this.wFieldsTb, margin);
        this.fdGetFieldsForFields.left = new FormAttachment(0, margin);
        this.wGetFieldsForFields.setLayoutData((Object)this.fdGetFieldsForFields);
        this.wGetFieldsForFields.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                LucidDBStreamingLoaderDialog.this.getFields(LucidDBStreamingLoaderDialog.this.wFieldsTab.getText());
            }
        });
        this.wDoMappingForFields = new Button(this.wFieldsComp, 8);
        this.wDoMappingForFields.setText(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.EditMapping.Label", (String[])new String[0]));
        this.fdDoMappingForFields = new FormData();
        this.fdDoMappingForFields.top = new FormAttachment((Control)this.wFieldsTb, margin);
        this.fdDoMappingForFields.left = new FormAttachment((Control)this.wGetFieldsForFields, margin);
        this.wDoMappingForFields.setLayoutData((Object)this.fdDoMappingForFields);
        this.wDoMappingForFields.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                LucidDBStreamingLoaderDialog.this.generateMappings(LucidDBStreamingLoaderDialog.this.wFieldsTab.getText());
            }
        });
        this.wFieldsComp.layout();
        this.wFieldsTab.setControl((Control)this.wFieldsComp);
        this.wCustomTab = new CTabItem(this.wTabFolder, 0);
        this.wCustomTab.setText(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.CustomTab.TabTitle", (String[])new String[0]));
        this.wCustomComp = new Composite((Composite)this.wTabFolder, 0);
        this.wCustomComp.setLayout((Layout)fieldsLayout);
        this.props.setLook((Control)this.wCustomComp);
        this.wlCustomTb = new Label(this.wCustomComp, 16384);
        this.wlCustomTb.setText(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.CustomTab.Label", (String[])new String[0]));
        this.fdlCustomTb = new FormData();
        this.fdlCustomTb.left = new FormAttachment(0, 0);
        this.fdlCustomTb.top = new FormAttachment(0, 0);
        this.fdlCustomTb.right = new FormAttachment(100, 0);
        this.wlCustomTb.setLayoutData((Object)this.fdlCustomTb);
        this.wCustomTb = new StyledTextComp((VariableSpace)this.transMeta, this.wCustomComp, 19202, "");
        this.props.setLook((Control)this.wCustomTb, 1);
        this.wCustomTb.addModifyListener(lsMod);
        this.fdCustomTb = new FormData();
        this.fdCustomTb.left = new FormAttachment(0, 0);
        this.fdCustomTb.top = new FormAttachment((Control)this.wlCustomTb, margin);
        this.fdCustomTb.right = new FormAttachment(100, -2 * margin);
        this.fdCustomTb.bottom = new FormAttachment(100, -margin);
        this.wCustomTb.setLayoutData((Object)this.fdCustomTb);
        SQLValuesHighlight lineStyler = new SQLValuesHighlight();
        this.wCustomTb.addLineStyleListener((LineStyleListener)lineStyler);
        this.fdCustomComp = new FormData();
        this.fdCustomComp.left = new FormAttachment(0, 0);
        this.fdCustomComp.top = new FormAttachment(0, 0);
        this.fdCustomComp.right = new FormAttachment(100, 0);
        this.fdCustomComp.bottom = new FormAttachment(100, 0);
        this.wCustomComp.setLayoutData((Object)this.fdCustomComp);
        this.wCustomComp.layout();
        this.wCustomTab.setControl((Control)this.wCustomComp);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString((String)"System.Button.OK"));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString((String)"System.Button.Cancel"));
        this.wSQL = new Button((Composite)this.shell, 8);
        this.wSQL.setText(BaseMessages.getString((String)"System.Button.SQL"));
        this.setButtonPositions(new Button[]{this.wOK, this.wSQL, this.wCancel}, margin, null);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                LucidDBStreamingLoaderDialog.this.ok();
            }
        };
        this.lsSQL = new Listener(){

            public void handleEvent(Event e) {
                LucidDBStreamingLoaderDialog.this.create();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                LucidDBStreamingLoaderDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wSQL.addListener(13, this.lsSQL);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                LucidDBStreamingLoaderDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wSchema.addSelectionListener(this.lsDef);
        this.wTable.addSelectionListener(this.lsDef);
        this.wPort.addSelectionListener(this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                LucidDBStreamingLoaderDialog.this.cancel();
            }
        });
        this.wbTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LucidDBStreamingLoaderDialog.this.getTableName();
            }
        });
        this.setSize();
        this.getData();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    public void getData() {
        TableItem item;
        int i;
        this.logDebug(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.Log.GettingKeyInfo", (String[])new String[0]));
        if (this.input.getDatabaseMeta() != null) {
            this.wConnection.setText(this.input.getDatabaseMeta().getName());
        } else if (this.transMeta.nrDatabases() == 1) {
            this.wConnection.setText(this.transMeta.getDatabase(0).getName());
        }
        if (this.input.getSchemaName() != null) {
            this.wSchema.setText(this.input.getSchemaName());
        }
        if (this.input.getTableName() != null) {
            this.wTable.setText(this.input.getTableName());
        }
        if (this.input.getHost() != null) {
            this.wHost.setText("" + this.input.getHost());
        }
        if (this.input.getPort() != null) {
            this.wPort.setText("" + this.input.getPort());
        }
        if (this.input.getOperation() != null) {
            this.wOperation.select(this.wOperation.indexOf(this.input.getOperation()));
            if (BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.Operation.CCombo.Item2", (String[])new String[0]).equals(this.input.getOperation())) {
                this.wTabFolder.setSelection(1);
            } else {
                this.wTabFolder.setSelection(0);
            }
        }
        if (this.input.getCustom_sql() != null) {
            this.wCustomTb.setText(this.input.getCustom_sql());
        }
        if (this.input.getFieldTableForKeys() != null) {
            int nrKeyMapping = this.input.getFieldTableForKeys().length;
            this.wKeysTb.table.setItemCount(nrKeyMapping);
            for (i = 0; i < nrKeyMapping; ++i) {
                item = this.wKeysTb.table.getItem(i);
                if (this.input.getFieldTableForKeys()[i] != null) {
                    item.setText(1, this.input.getFieldTableForKeys()[i]);
                }
                if (this.input.getFieldStreamForKeys()[i] == null) continue;
                item.setText(2, this.input.getFieldStreamForKeys()[i]);
            }
        }
        this.wKeysTb.setRowNums();
        this.wKeysTb.optWidth(true);
        if (this.input.getFieldTableForFields() != null) {
            int nrFieldMapping = this.input.getFieldTableForFields().length;
            this.wFieldsTb.table.setItemCount(nrFieldMapping);
            for (i = 0; i < nrFieldMapping; ++i) {
                item = this.wFieldsTb.table.getItem(i);
                if (this.input.getFieldTableForFields()[i] != null) {
                    item.setText(1, this.input.getFieldTableForFields()[i]);
                }
                if (this.input.getFieldStreamForFields()[i] != null) {
                    item.setText(2, this.input.getFieldStreamForFields()[i]);
                }
                if (this.input.getInsOrUptFlag() != null) {
                    item.setText(3, this.input.getInsOrUptFlag()[i] ? "Y" : "N");
                    continue;
                }
                item.setText(3, "N");
            }
        }
        this.wFieldsTb.setRowNums();
        this.wFieldsTb.optWidth(true);
        if (this.input.getTabIsEnable().length != 0) {
            this.wKeysTab.getControl().setEnabled(this.input.getTabIsEnable()[0]);
            this.wFieldsTab.getControl().setEnabled(this.input.getTabIsEnable()[1]);
            this.wCustomTab.getControl().setEnabled(this.input.getTabIsEnable()[2]);
        }
        int fieldWidth = this.wFieldsTb.table.getColumn(3).getWidth();
        if (this.input.getOperation() != null && "INSERT".equalsIgnoreCase(this.wOperation.getItem(this.wOperation.getSelectionIndex()))) {
            this.wFieldsTb.table.getColumn(3).setWidth(0);
        } else {
            this.wFieldsTb.table.getColumn(3).setWidth(fieldWidth);
        }
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void generateMappings(String tabName) {
        EnterMappingDialog d;
        RowMetaInterface targetFields;
        RowMetaInterface sourceFields;
        TableView myTb;
        boolean flag = false;
        if (tabName.equals(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.KeyTab.TabTitle", (String[])new String[0]))) {
            myTb = this.wKeysTb;
        } else if (tabName.equals(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.FieldsTab.TabTitle", (String[])new String[0]))) {
            myTb = this.wFieldsTb;
            if (BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.Operation.CCombo.Item2", (String[])new String[0]).equalsIgnoreCase(this.wOperation.getItem(this.wOperation.getSelectionIndex()))) {
                flag = true;
            }
        } else {
            return;
        }
        try {
            sourceFields = this.transMeta.getPrevStepFields(this.stepMeta);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.DoMapping.UnableToFindSourceFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.DoMapping.UnableToFindSourceFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        this.input.setDatabaseMeta(this.transMeta.findDatabase(this.wConnection.getText()));
        this.input.setTableName(this.transMeta.environmentSubstitute(this.wTable.getText()));
        StepMetaInterface stepMetaInterface = this.stepMeta.getStepMetaInterface();
        try {
            targetFields = stepMetaInterface.getRequiredFields((VariableSpace)this.transMeta);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.DoMapping.UnableToFindTargetFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.DoMapping.UnableToFindTargetFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        String[] inputNames = new String[sourceFields.size()];
        for (int i = 0; i < sourceFields.size(); ++i) {
            ValueMetaInterface value = sourceFields.getValueMeta(i);
            inputNames[i] = value.getName() + "            (" + value.getOrigin() + ")";
        }
        List mappings = new ArrayList();
        StringBuffer missingSourceFields = new StringBuffer();
        StringBuffer missingTargetFields = new StringBuffer();
        if (missingSourceFields.length() > 0 || missingTargetFields.length() > 0) {
            String message = "";
            if (missingSourceFields.length() > 0) {
                message = message + BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.DoMapping.SomeSourceFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            if (missingTargetFields.length() > 0) {
                message = message + BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.DoMapping.SomeTargetFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            message = message + Const.CR;
            message = message + BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.DoMapping.SomeFieldsNotFoundContinue", (String[])new String[0]) + Const.CR;
            MessageDialog.setDefaultImage((Image)GUIResource.getInstance().getImageSpoon());
            boolean goOn = MessageDialog.openConfirm((Shell)this.shell, (String)BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.DoMapping.SomeFieldsNotFoundTitle", (String[])new String[0]), (String)message);
            if (!goOn) {
                return;
            }
        }
        if ((mappings = (d = new EnterMappingDialog(this.shell, sourceFields.getFieldNames(), targetFields.getFieldNames(), mappings)).open()) != null) {
            myTb.table.removeAll();
            myTb.table.setItemCount(mappings.size());
            for (int i = 0; i < mappings.size(); ++i) {
                SourceToTargetMapping mapping = (SourceToTargetMapping)mappings.get(i);
                TableItem item = myTb.table.getItem(i);
                item.setText(2, sourceFields.getValueMeta(mapping.getSourcePosition()).getName());
                item.setText(1, targetFields.getValueMeta(mapping.getTargetPosition()).getName());
            }
            myTb.setRowNums();
            myTb.optWidth(true);
            int width = myTb.table.getColumn(3).getWidth();
            if (flag) {
                myTb.table.getColumn(3).setWidth(0);
            } else {
                myTb.table.getColumn(3).setWidth(width);
            }
        }
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void getInfo(LucidDBStreamingLoaderMeta inf) {
        TableItem item;
        int i;
        inf.setDatabaseMeta(this.transMeta.findDatabase(this.wConnection.getText()));
        inf.setSchemaName(this.wSchema.getText());
        inf.setTableName(this.wTable.getText());
        inf.setHost(this.wHost.getText());
        inf.setPort(this.wPort.getText());
        inf.setOperation(this.wOperation.getItem(this.wOperation.getSelectionIndex()));
        int nrKeyMapping = this.wKeysTb.nrNonEmpty();
        int nrFieldMappping = this.wFieldsTb.nrNonEmpty();
        inf.allocate(nrKeyMapping, nrFieldMappping, 3);
        for (i = 0; i < nrKeyMapping; ++i) {
            item = this.wKeysTb.getNonEmpty(i);
            inf.getFieldTableForKeys()[i] = item.getText(1);
            inf.getFieldStreamForKeys()[i] = item.getText(2);
        }
        for (i = 0; i < nrFieldMappping; ++i) {
            item = this.wFieldsTb.getNonEmpty(i);
            inf.getFieldTableForFields()[i] = item.getText(1);
            inf.getFieldStreamForFields()[i] = item.getText(2);
            inf.getInsOrUptFlag()[i] = "Y".equalsIgnoreCase(item.getText(3));
        }
        inf.getTabIsEnable()[0] = this.wKeysTab.getControl().getEnabled();
        inf.getTabIsEnable()[1] = this.wFieldsTab.getControl().getEnabled();
        inf.getTabIsEnable()[2] = this.wCustomTab.getControl().getEnabled();
        if (BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.Operation.CCombo.Item4", (String[])new String[0]).equals(inf.getOperation())) {
            inf.setCustom_sql(this.wCustomTb.getText());
        }
        this.stepname = this.wStepname.getText();
    }

    private void getFields(String tabName) {
        TableView myTb;
        boolean flag = false;
        if (tabName.equals(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.KeyTab.TabTitle", (String[])new String[0]))) {
            myTb = this.wKeysTb;
        } else if (tabName.equals(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.FieldsTab.TabTitle", (String[])new String[0]))) {
            myTb = this.wFieldsTb;
            if (BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.Operation.CCombo.Item2", (String[])new String[0]).equalsIgnoreCase(this.wOperation.getItem(this.wOperation.getSelectionIndex()))) {
                flag = true;
            }
        } else {
            return;
        }
        try {
            RowMetaInterface streamMeta = this.transMeta.getPrevStepFields(this.stepMeta);
            String[] fieldNamesOfStream = streamMeta.getFieldNames();
            this.input.setSchemaName(this.wSchema.getText());
            this.input.setTableName(this.wTable.getText());
            this.input.setDatabaseMeta(this.transMeta.findDatabase(this.wConnection.getText()));
            StepMetaInterface stepMetaInterface = this.stepMeta.getStepMetaInterface();
            RowMetaInterface tblMeta = null;
            String[] fieldsNamesOfTbl = null;
            try {
                tblMeta = stepMetaInterface.getRequiredFields((VariableSpace)this.transMeta);
                fieldsNamesOfTbl = tblMeta.getFieldNames();
            }
            catch (KettleException kettleException) {
                // empty catch block
            }
            int count = 0;
            if (fieldsNamesOfTbl == null) {
                count = fieldNamesOfStream.length;
                myTb.table.setItemCount(count);
                for (int i = 0; i < count; ++i) {
                    TableItem item = myTb.table.getItem(i);
                    item.setText(1, fieldNamesOfStream[i]);
                    item.setText(2, fieldNamesOfStream[i]);
                }
            } else {
                count = fieldNamesOfStream.length >= fieldsNamesOfTbl.length ? fieldNamesOfStream.length : fieldsNamesOfTbl.length;
                myTb.table.setItemCount(count);
                for (int i = 0; i < count; ++i) {
                    TableItem item = myTb.table.getItem(i);
                    if (i < fieldsNamesOfTbl.length && fieldsNamesOfTbl[i] != null) {
                        item.setText(1, fieldsNamesOfTbl[i]);
                    }
                    if (i >= fieldNamesOfStream.length || fieldNamesOfStream[i] == null) continue;
                    item.setText(2, fieldNamesOfStream[i]);
                }
            }
            myTb.setRowNums();
            myTb.optWidth(true);
            if (flag) {
                myTb.table.getColumn(3).setWidth(0);
                System.out.println(myTb.table.getColumn(3).getWidth());
            }
        }
        catch (KettleStepException kettleStepException) {
            // empty catch block
        }
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        this.getInfo(this.input);
        if (this.input.getDatabaseMeta() == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
        this.dispose();
    }

    private void getTableName() {
        DatabaseMeta inf = null;
        int connr = this.wConnection.getSelectionIndex();
        if (connr >= 0) {
            inf = this.transMeta.getDatabase(connr);
        }
        if (inf != null) {
            this.logDebug(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.Log.LookingAtConnection", (String[])new String[0]) + inf.toString());
            DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, inf, this.transMeta.getDatabases());
            std.setSelectedSchemaAndTable(this.wSchema.getText(), this.wTable.getText());
            if (std.open()) {
                this.wSchema.setText(Const.NVL((String)std.getSchemaName(), (String)""));
                this.wTable.setText(Const.NVL((String)std.getTableName(), (String)""));
            }
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
    }

    private void create() {
        try {
            LucidDBStreamingLoaderMeta info = new LucidDBStreamingLoaderMeta();
            this.getInfo(info);
            String name = this.stepname;
            StepMeta stepMeta = new StepMeta(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.StepMeta.Title", (String[])new String[0]), name, (StepMetaInterface)info);
            RowMetaInterface prev = this.transMeta.getPrevStepFields(this.stepname);
            SQLStatement sql = info.getSQLStatements(this.transMeta, stepMeta, prev, this.repository, this.metaStore);
            if (!sql.hasError()) {
                if (sql.hasSQL()) {
                    SQLEditor sqledit = new SQLEditor((VariableSpace)this.transMeta, this.shell, 0, info.getDatabaseMeta(), this.transMeta.getDbCache(), sql.getSQL());
                    sqledit.open();
                } else {
                    MessageBox mb = new MessageBox(this.shell, 34);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.NoSQLNeeds.DialogMessage", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.NoSQLNeeds.DialogTitle", (String[])new String[0]));
                    mb.open();
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(sql.getError());
                mb.setText(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.SQLError.DialogTitle", (String[])new String[0]));
                mb.open();
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.CouldNotBuildSQL.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.CouldNotBuildSQL.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }
}

