/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.teradatabulkloader;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.core.database.dialog.DatabaseExplorerDialog;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.steps.teradatabulkloader.TeraDataBulkLoaderDialog;
import org.pentaho.di.ui.trans.steps.teradatabulkloader.TextVarMenuItem;

class TableSelectionButtonListener
extends SelectionAdapter {
    private final TransMeta transMeta;
    private final Shell shell;
    private final TextVarMenuItem wSchema;
    private final TextVarMenuItem wTable;
    private final CCombo wConnection;
    private final Runnable setTableFieldCombo;
    private final LogChannelInterface logChannelInterface;
    private final TextVar textWidget;

    TableSelectionButtonListener(TransMeta transMeta, TextVar textWidget, CCombo wConnection, Shell shell, TextVarMenuItem wSchema, TextVarMenuItem wTable, Runnable setTableFieldCombo, LogChannelInterface logChannelInterface) {
        this.transMeta = transMeta;
        this.textWidget = textWidget;
        this.shell = shell;
        this.wSchema = wSchema;
        this.wTable = wTable;
        this.setTableFieldCombo = setTableFieldCombo;
        this.wConnection = wConnection;
        this.logChannelInterface = logChannelInterface;
    }

    public void widgetSelected(SelectionEvent e) {
        DatabaseMeta inf = null;
        int connr = this.wConnection.getSelectionIndex();
        if (connr >= 0) {
            inf = this.transMeta.getDatabase(connr);
        }
        if (inf != null) {
            if (this.logChannelInterface.isDebug()) {
                this.logChannelInterface.logDebug(BaseMessages.getString(TeraDataBulkLoaderDialog.PKG, (String)"TeraDataBulkLoaderDialog.Log.LookingAtConnection", (String[])new String[0]) + inf.toString());
            }
            DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, inf, this.transMeta.getDatabases());
            std.setSelectedSchemaAndTable(this.wSchema.getText(), this.wTable.getText());
            if (std.open()) {
                this.wSchema.setText(Const.NVL((String)std.getSchemaName(), (String)""));
                this.textWidget.setText(Const.NVL((String)std.getTableName(), (String)""));
                this.setTableFieldCombo.run();
            }
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(TeraDataBulkLoaderDialog.PKG, (String)"TeraDataBulkLoaderDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(TeraDataBulkLoaderDialog.PKG, (String)"TeraDataBulkLoaderDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
    }
}

