/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.avro.input;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.trans.steps.avro.AvroSpec;
import org.pentaho.di.trans.steps.avro.input.IAvroInputField;
import org.pentaho.di.trans.steps.avro.input.IPentahoInputFormat;
import org.pentaho.di.trans.steps.avro.input.PentahoAvroInputFormat;

public class PentahoAvroRecordReader
implements IPentahoInputFormat.IPentahoRecordReader {
    private final DataFileStream<GenericRecord> nativeAvroRecordReader;
    private final Schema avroSchema;
    private final List<? extends IAvroInputField> fields;
    private boolean legacySchema;

    public PentahoAvroRecordReader(DataFileStream<GenericRecord> nativeAvroRecordReader, Schema avroSchema, List<? extends IAvroInputField> fields) {
        this.nativeAvroRecordReader = nativeAvroRecordReader;
        this.avroSchema = avroSchema;
        this.legacySchema = this.isLegacySchema(avroSchema);
        this.fields = fields;
    }

    @Override
    public void close() throws IOException {
        this.nativeAvroRecordReader.close();
    }

    @Override
    public Iterator<RowMetaAndData> iterator() {
        return new Iterator<RowMetaAndData>(){

            @Override
            public boolean hasNext() {
                return PentahoAvroRecordReader.this.nativeAvroRecordReader.hasNext();
            }

            @Override
            public RowMetaAndData next() {
                return PentahoAvroRecordReader.this.getRowMetaAndData((GenericRecord)PentahoAvroRecordReader.this.nativeAvroRecordReader.next());
            }
        };
    }

    @VisibleForTesting
    public RowMetaAndData getRowMetaAndData(GenericRecord avroRecord) {
        RowMetaAndData rowMetaAndData = new RowMetaAndData();
        Schema.Field avroField = null;
        String avroFieldName = null;
        String metaFieldName = null;
        for (IAvroInputField iAvroInputField : this.fields) {
            if (this.legacySchema) {
                metaFieldName = iAvroInputField.getAvroFieldName();
                if (!metaFieldName.contains("_delimiter_")) {
                    PentahoAvroInputFormat.FieldName fieldName = new PentahoAvroInputFormat.FieldName(metaFieldName, iAvroInputField.getPentahoType(), false);
                    avroFieldName = fieldName.getLegacyFieldName();
                    avroField = this.avroSchema.getField(avroFieldName);
                    if (avroField == null) {
                        fieldName = new PentahoAvroInputFormat.FieldName(metaFieldName, iAvroInputField.getPentahoType(), true);
                        avroFieldName = fieldName.getLegacyFieldName();
                        avroField = this.avroSchema.getField(avroFieldName);
                    }
                } else {
                    avroFieldName = iAvroInputField.getAvroFieldName();
                    avroField = this.avroSchema.getField(avroFieldName);
                }
            } else {
                avroFieldName = iAvroInputField.getAvroFieldName();
                avroField = this.avroSchema.getField(avroFieldName);
            }
            if (avroField == null || iAvroInputField == null) continue;
            AvroSpec.DataType avroDataType = null;
            LogicalType logicalType = null;
            Schema.Type primitiveAvroType = null;
            if (avroField.schema().getType().equals((Object)Schema.Type.UNION)) {
                for (Schema typeSchema : avroField.schema().getTypes()) {
                    if (typeSchema.getType().equals((Object)Schema.Type.NULL)) continue;
                    logicalType = typeSchema.getLogicalType();
                    primitiveAvroType = typeSchema.getType();
                    break;
                }
            } else {
                logicalType = avroField.schema().getLogicalType();
                primitiveAvroType = avroField.schema().getType();
            }
            if (logicalType != null) {
                for (AvroSpec.DataType tmpType : AvroSpec.DataType.values()) {
                    if (tmpType.isPrimitiveType() || !tmpType.getType().equals(logicalType.getName())) continue;
                    avroDataType = tmpType;
                    break;
                }
            } else {
                switch (primitiveAvroType) {
                    case INT: {
                        avroDataType = AvroSpec.DataType.INTEGER;
                        break;
                    }
                    case LONG: {
                        avroDataType = AvroSpec.DataType.LONG;
                        break;
                    }
                    case BYTES: {
                        avroDataType = AvroSpec.DataType.BYTES;
                        break;
                    }
                    case FLOAT: {
                        avroDataType = AvroSpec.DataType.FLOAT;
                        break;
                    }
                    case DOUBLE: {
                        avroDataType = AvroSpec.DataType.DOUBLE;
                        break;
                    }
                    case STRING: {
                        avroDataType = AvroSpec.DataType.STRING;
                        break;
                    }
                    case BOOLEAN: {
                        avroDataType = AvroSpec.DataType.BOOLEAN;
                    }
                }
            }
            Object avroData = avroRecord.get(avroFieldName);
            Object pentahoData = null;
            if (avroData != null) {
                if (avroData instanceof Utf8) {
                    avroData = avroData.toString();
                }
                int pentahoType = iAvroInputField.getPentahoType();
                switch (avroDataType) {
                    case BOOLEAN: {
                        pentahoData = this.convertToPentahoType(pentahoType, (Boolean)avroData);
                        break;
                    }
                    case DATE: {
                        pentahoData = this.convertToPentahoType(pentahoType, (Integer)avroData);
                        break;
                    }
                    case FLOAT: {
                        pentahoData = this.convertToPentahoType(pentahoType, (Float)avroData);
                        break;
                    }
                    case DOUBLE: {
                        pentahoData = this.convertToPentahoType(pentahoType, (Double)avroData);
                        break;
                    }
                    case LONG: {
                        pentahoData = this.convertToPentahoType(pentahoType, (Long)avroData);
                        break;
                    }
                    case DECIMAL: {
                        pentahoData = this.convertToPentahoType(pentahoType, (ByteBuffer)avroData, avroField);
                        break;
                    }
                    case INTEGER: {
                        pentahoData = this.convertToPentahoType(pentahoType, (Integer)avroData);
                        break;
                    }
                    case STRING: {
                        pentahoData = this.convertToPentahoType(pentahoType, (String)avroData, iAvroInputField);
                        break;
                    }
                    case BYTES: {
                        pentahoData = this.convertToPentahoType(pentahoType, (ByteBuffer)avroData, avroField);
                        break;
                    }
                    case TIMESTAMP_MILLIS: {
                        pentahoData = this.convertToPentahoType(pentahoType, (Long)avroData);
                    }
                }
            }
            rowMetaAndData.addValue(iAvroInputField.getPentahoFieldName(), iAvroInputField.getPentahoType(), pentahoData);
            String stringFormat = iAvroInputField.getStringFormat();
            if (stringFormat == null || stringFormat.trim().length() <= 0) continue;
            rowMetaAndData.getValueMeta(rowMetaAndData.size() - 1).setConversionMask(stringFormat);
        }
        return rowMetaAndData;
    }

    private Object convertToPentahoType(int pentahoType, Float avroData) {
        Object pentahoData = null;
        if (avroData != null) {
            try {
                switch (pentahoType) {
                    case 2: {
                        pentahoData = avroData.toString();
                        break;
                    }
                    case 5: {
                        pentahoData = new Long(avroData.longValue());
                        break;
                    }
                    case 1: {
                        pentahoData = Double.parseDouble(avroData.toString());
                        break;
                    }
                    case 6: {
                        new BigDecimal(avroData.toString());
                        break;
                    }
                    case 9: {
                        pentahoData = new Timestamp(avroData.longValue());
                        break;
                    }
                    case 3: {
                        pentahoData = new Date(avroData.longValue());
                        break;
                    }
                    case 4: {
                        pentahoData = avroData.floatValue() == 0.0f ? Boolean.FALSE : Boolean.TRUE;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return pentahoData;
    }

    private Object convertToPentahoType(int pentahoType, ByteBuffer avroData, Schema.Field field) {
        Object pentahoData = null;
        if (avroData != null) {
            try {
                switch (pentahoType) {
                    case 6: {
                        Conversions.DecimalConversion converter = new Conversions.DecimalConversion();
                        Schema schema = field.schema();
                        if (schema.getType().equals((Object)Schema.Type.UNION)) {
                            List schemas = field.schema().getTypes();
                            for (Schema s : schemas) {
                                if (s.getName().equalsIgnoreCase("null")) continue;
                                schema = s;
                                break;
                            }
                        }
                        Object precision = schema.getObjectProp("precision");
                        Object scale = schema.getObjectProp("scale");
                        LogicalTypes.Decimal decimalType = LogicalTypes.decimal((int)Integer.parseInt(precision.toString()), (int)Integer.parseInt(scale.toString()));
                        pentahoData = converter.fromBytes(avroData, this.avroSchema, (LogicalType)decimalType);
                        break;
                    }
                    case 8: {
                        pentahoData = new byte[avroData.remaining()];
                        avroData.get((byte[])pentahoData);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return pentahoData;
    }

    private Object convertToPentahoType(int pentahoType, Long avroData) {
        Object pentahoData = null;
        if (avroData != null) {
            try {
                switch (pentahoType) {
                    case 2: {
                        pentahoData = avroData.toString();
                        break;
                    }
                    case 5: {
                        pentahoData = (long)avroData;
                        break;
                    }
                    case 1: {
                        pentahoData = new Double(avroData.doubleValue());
                        break;
                    }
                    case 6: {
                        pentahoData = BigDecimal.valueOf(avroData);
                        break;
                    }
                    case 9: {
                        pentahoData = new Timestamp(avroData);
                        break;
                    }
                    case 3: {
                        pentahoData = new Date(avroData);
                        break;
                    }
                    case 4: {
                        pentahoData = avroData == 0L ? Boolean.FALSE : Boolean.TRUE;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return pentahoData;
    }

    private Object convertToPentahoType(int pentahoType, Integer avroData) {
        Object pentahoData = null;
        if (avroData != null) {
            try {
                switch (pentahoType) {
                    case 2: {
                        pentahoData = avroData.toString();
                        break;
                    }
                    case 5: {
                        pentahoData = new Long(avroData.longValue());
                        break;
                    }
                    case 1: {
                        pentahoData = new Double(avroData.doubleValue());
                        break;
                    }
                    case 6: {
                        pentahoData = BigDecimal.valueOf(avroData.intValue());
                        break;
                    }
                    case 9: {
                        pentahoData = new Timestamp(avroData.intValue());
                        break;
                    }
                    case 3: {
                        LocalDate localDate = LocalDate.ofEpochDay(0L).plusDays(avroData.intValue());
                        pentahoData = Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
                        break;
                    }
                    case 4: {
                        pentahoData = avroData == 0 ? Boolean.FALSE : Boolean.TRUE;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return pentahoData;
    }

    private Object convertToPentahoType(int pentahoType, Double avroData) {
        Object pentahoData = null;
        if (avroData != null) {
            try {
                switch (pentahoType) {
                    case 2: {
                        pentahoData = avroData.toString();
                        break;
                    }
                    case 5: {
                        pentahoData = new Long(avroData.longValue());
                        break;
                    }
                    case 1: {
                        pentahoData = avroData;
                        break;
                    }
                    case 6: {
                        pentahoData = BigDecimal.valueOf(avroData);
                        break;
                    }
                    case 9: {
                        pentahoData = new Timestamp(avroData.longValue());
                        break;
                    }
                    case 3: {
                        pentahoData = new Date(avroData.longValue());
                        break;
                    }
                    case 4: {
                        pentahoData = avroData == 0.0 ? Boolean.FALSE : Boolean.TRUE;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return pentahoData;
    }

    private Object convertToPentahoType(int pentahoType, Boolean avroData) {
        Object pentahoData = null;
        if (avroData != null) {
            try {
                switch (pentahoType) {
                    case 2: {
                        pentahoData = avroData.toString();
                        break;
                    }
                    case 4: {
                        pentahoData = avroData;
                        break;
                    }
                    case 5: {
                        pentahoData = avroData != false ? new Long(1L) : new Long(0L);
                        break;
                    }
                    case 1: {
                        pentahoData = avroData != false ? new Double(1.0) : new Double(0.0);
                        break;
                    }
                    case 6: {
                        pentahoData = avroData != false ? new BigDecimal(1) : new BigDecimal(0);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return pentahoData;
    }

    private Object convertToPentahoType(int pentahoType, String avroData, IAvroInputField avroInputField) {
        Object pentahoData = null;
        if (avroData != null) {
            try {
                switch (pentahoType) {
                    case 10: {
                        pentahoData = InetAddress.getByName(avroData.toString());
                        break;
                    }
                    case 2: {
                        pentahoData = avroData;
                        break;
                    }
                    case 5: {
                        pentahoData = Long.parseLong(avroData);
                        break;
                    }
                    case 1: {
                        pentahoData = Double.parseDouble(avroData);
                        break;
                    }
                    case 6: {
                        pentahoData = new BigDecimal(avroData);
                        break;
                    }
                    case 9: {
                        pentahoData = new Timestamp(Long.parseLong(avroData));
                        break;
                    }
                    case 3: {
                        String dateFormatStr = avroInputField.getStringFormat();
                        if (dateFormatStr == null || dateFormatStr.trim().length() == 0) {
                            dateFormatStr = ValueMetaBase.DEFAULT_DATE_FORMAT_MASK;
                        }
                        SimpleDateFormat datePattern = new SimpleDateFormat(dateFormatStr);
                        pentahoData = datePattern.parse(avroData);
                        break;
                    }
                    case 4: {
                        pentahoData = "Y".equalsIgnoreCase(avroData) || "TRUE".equalsIgnoreCase(avroData) || "YES".equalsIgnoreCase(avroData) || "1".equals(avroData);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return pentahoData;
    }

    private boolean isLegacySchema(Schema schema) {
        if (schema.getFields().size() > 0) {
            Schema.Field field = (Schema.Field)schema.getFields().get(0);
            return field != null && field.name() != null && field.name().contains("_delimiter_");
        }
        return false;
    }
}

