/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.avro.input;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DecoderFactory;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.steps.avro.input.AvroInputField;
import org.pentaho.di.trans.steps.avro.input.AvroNestedReader;
import org.pentaho.di.trans.steps.avro.input.IAvroInputField;
import org.pentaho.di.trans.steps.avro.input.IPentahoInputFormat;

public class AvroNestedRecordReader
implements IPentahoInputFormat.IPentahoRecordReader {
    private final DataFileStream<Object> nativeAvroRecordReader;
    private final Schema avroSchema;
    private final List<? extends IAvroInputField> fields;
    private final AvroNestedReader avroNestedReader;
    private final VariableSpace avroInputStep;
    private Object[] incomingFields;
    private RowMetaAndData nextRow;
    Object[][] expandedRows = null;
    private int nextExpandedRow = 0;
    private RowMetaInterface incomingRowMeta;
    private RowMetaInterface outputRowMeta;
    private boolean isDatum;
    private int nextCallCounter = 0;

    public AvroNestedRecordReader(DataFileStream<Object> nativeAvroRecordReader, Schema avroSchema, List<? extends IAvroInputField> fields, VariableSpace avroInputStep, RowMetaInterface incomingRowMeta, Object[] incomingFields, RowMetaInterface outputRowMeta, String fileName, boolean isDataBinaryEncoded, int fieldIndexForDataStream, boolean isDatum) {
        this.nativeAvroRecordReader = nativeAvroRecordReader;
        this.avroSchema = avroSchema;
        this.fields = fields;
        this.avroInputStep = avroInputStep;
        this.incomingRowMeta = incomingRowMeta;
        this.incomingFields = incomingFields;
        this.isDatum = isDatum;
        this.outputRowMeta = outputRowMeta;
        this.avroNestedReader = new AvroNestedReader();
        this.avroNestedReader.m_schemaToUse = avroSchema;
        this.avroNestedReader.m_incomingRowMeta = incomingRowMeta;
        this.avroNestedReader.m_outputRowMeta = outputRowMeta;
        this.avroNestedReader.m_jsonEncoded = !isDataBinaryEncoded;
        this.avroNestedReader.m_decodingFromField = fieldIndexForDataStream >= 0;
        this.avroNestedReader.m_fieldToDecodeIndex = fieldIndexForDataStream;
        try {
            if (nativeAvroRecordReader != null) {
                this.avroNestedReader.m_containerReader = nativeAvroRecordReader;
            } else if (avroSchema != null) {
                this.avroNestedReader.m_datumReader = new GenericDatumReader(avroSchema);
                if (fileName != null) {
                    FileObject fileObject = KettleVFS.getFileObject((String)fileName);
                    this.avroNestedReader.m_decoder = this.avroNestedReader.m_jsonEncoded ? DecoderFactory.get().jsonDecoder(avroSchema, KettleVFS.getInputStream((FileObject)fileObject)) : DecoderFactory.get().binaryDecoder(KettleVFS.getInputStream((FileObject)fileObject), null);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<AvroInputField> castedList = new ArrayList<AvroInputField>();
        for (IAvroInputField iAvroInputField : fields) {
            AvroInputField newField = new AvroInputField();
            newField.setAvroFieldName(iAvroInputField.getAvroFieldName());
            newField.setAvroType(iAvroInputField.getAvroType());
            newField.setIndexedValues(iAvroInputField.getIndexedValues());
            newField.setFormatType(iAvroInputField.getFormatType());
            newField.setPentahoFieldName(iAvroInputField.getPentahoFieldName());
            newField.setPentahoType(iAvroInputField.getPentahoType());
            newField.setPrecision(iAvroInputField.getPrecision());
            newField.setScale(iAvroInputField.getScale());
            newField.setStringFormat(iAvroInputField.getStringFormat());
            List<String> indexes = iAvroInputField.getIndexedVals();
            String fieldName = iAvroInputField.getFormatFieldName();
            if (fieldName.endsWith("[0]") && !indexes.toString().equals("[]")) {
                String newValue = fieldName.substring(0, fieldName.lastIndexOf("[")) + indexes.toString();
                newField.setFormatFieldName(newValue);
            } else {
                newField.setFormatFieldName(iAvroInputField.getFormatFieldName());
            }
            castedList.add(newField);
        }
        this.avroNestedReader.m_normalFields = castedList;
        try {
            this.avroNestedReader.init();
        }
        catch (KettleException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.nativeAvroRecordReader != null) {
            this.nativeAvroRecordReader.close();
        }
    }

    private boolean hasExpandedRows() {
        if (this.expandedRows != null) {
            if (this.nextExpandedRow < this.expandedRows.length) {
                return true;
            }
            this.incomingFields = null;
        }
        return false;
    }

    @Override
    public Iterator<RowMetaAndData> iterator() {
        return new Iterator<RowMetaAndData>(){

            @Override
            public boolean hasNext() {
                if (AvroNestedRecordReader.this.hasExpandedRows()) {
                    return true;
                }
                if (AvroNestedRecordReader.this.nativeAvroRecordReader != null && AvroNestedRecordReader.this.nativeAvroRecordReader.hasNext()) {
                    return true;
                }
                if (AvroNestedRecordReader.this.incomingFields != null) {
                    return true;
                }
                return AvroNestedRecordReader.this.isDatum && AvroNestedRecordReader.this.nextCallCounter == 0;
            }

            @Override
            public RowMetaAndData next() {
                AvroNestedRecordReader.this.nextCallCounter++;
                return AvroNestedRecordReader.this.getNextRowMetaAndData();
            }
        };
    }

    private RowMetaAndData getNextRowMetaAndData() {
        if (!this.hasExpandedRows()) {
            try {
                this.nextExpandedRow = 0;
                this.expandedRows = null;
                this.expandedRows = this.avroNestedReader.avroObjectToKettle(this.incomingFields, this.avroInputStep);
                if (this.expandedRows == null) {
                    return null;
                }
                this.nextRow = this.objectToRowMetaAndData(this.expandedRows[this.nextExpandedRow]);
            }
            catch (KettleException e) {
                e.printStackTrace();
            }
        }
        this.nextRow = this.objectToRowMetaAndData(this.expandedRows[this.nextExpandedRow]);
        ++this.nextExpandedRow;
        return this.nextRow;
    }

    private RowMetaAndData objectToRowMetaAndData(Object[] row) {
        RowMetaAndData rowMetaAndData = new RowMetaAndData();
        int index = 0;
        int incomingFieldsCount = this.outputRowMeta.size() - this.fields.size();
        if (this.outputRowMeta != null && this.incomingFields != null) {
            for (index = 0; index < incomingFieldsCount; ++index) {
                rowMetaAndData.addValue(this.outputRowMeta.getValueMeta(index), this.incomingFields[index]);
            }
        }
        for (IAvroInputField iAvroInputField : this.fields) {
            rowMetaAndData.addValue(iAvroInputField.getPentahoFieldName(), iAvroInputField.getPentahoType(), row[index]);
            String stringFormat = iAvroInputField.getStringFormat();
            if (stringFormat != null && stringFormat.trim().length() > 0) {
                rowMetaAndData.getValueMeta(rowMetaAndData.size() - 1).setConversionMask(stringFormat);
            }
            ++index;
        }
        return rowMetaAndData;
    }
}

