/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.avro.input;

import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.trans.steps.avro.AvroSpec;
import org.pentaho.di.trans.steps.avro.input.AvroInputField;
import org.pentaho.di.trans.steps.avro.input.IAvroInputField;

public class AvroNestedFieldGetter {
    private static final String KEY = "[*key*]";

    private AvroNestedFieldGetter() {
    }

    public static List<? extends IAvroInputField> getLeafFields(Schema s) throws KettleException {
        if (s == null) {
            return null;
        }
        ArrayList<AvroInputField> fields = new ArrayList<AvroInputField>();
        String root = "";
        if (s.getType() == Schema.Type.ARRAY || s.getType() == Schema.Type.MAP) {
            while (s.getType() == Schema.Type.ARRAY || s.getType() == Schema.Type.MAP) {
                if (s.getType() == Schema.Type.ARRAY) {
                    root = root + "[0]";
                    s = s.getElementType();
                    continue;
                }
                root = root + KEY;
                s = s.getValueType();
            }
        }
        if (s.getType() == Schema.Type.RECORD) {
            AvroNestedFieldGetter.processRecord(root, s, fields);
        } else if (s.getType() == Schema.Type.UNION) {
            AvroNestedFieldGetter.processUnion(root, s, fields);
        } else {
            AvroInputField newField = AvroNestedFieldGetter.createAvroField(root, s);
            if (newField != null) {
                fields.add(newField);
            }
        }
        for (int i = 0; i < fields.size() - 1; ++i) {
            String fieldName;
            boolean duplicateName;
            AvroInputField field = (AvroInputField)fields.get(i);
            int suffix = 0;
            do {
                fieldName = field.getPentahoFieldName();
                if (suffix > 0) {
                    fieldName = fieldName + "-" + Integer.toString(suffix);
                }
                duplicateName = false;
                for (int j = i + 1; j < fields.size() && !duplicateName; ++j) {
                    duplicateName = fieldName.equals(((AvroInputField)fields.get(j)).getPentahoFieldName());
                }
                ++suffix;
            } while (duplicateName);
            field.setPentahoFieldName(fieldName);
        }
        return fields;
    }

    protected static void processRecord(String path, Schema s, List<AvroInputField> fields) throws KettleException {
        if (path.length() > 0) {
            path = path + ".";
        }
        List recordFields = s.getFields();
        for (Schema.Field rField : recordFields) {
            Schema rSchema = rField.schema();
            if (rSchema.getType() == Schema.Type.UNION) {
                AvroNestedFieldGetter.processUnion(path + rField.name(), rSchema, fields);
                continue;
            }
            if (rSchema.getType() == Schema.Type.RECORD) {
                AvroNestedFieldGetter.processRecord(path + rField.name(), rSchema, fields);
                continue;
            }
            if (rSchema.getType() == Schema.Type.ARRAY) {
                AvroNestedFieldGetter.processArray(path + rField.name() + "[0]", rSchema, fields);
                continue;
            }
            if (rSchema.getType() == Schema.Type.MAP) {
                AvroNestedFieldGetter.processMap(path + rField.name() + KEY, rSchema, fields);
                continue;
            }
            AvroInputField newField = AvroNestedFieldGetter.createAvroField(path + rField.name(), rSchema);
            if (newField == null) continue;
            fields.add(newField);
        }
    }

    protected static void processUnion(String path, Schema s, List<AvroInputField> fields) throws KettleException {
        List<Schema> primitives = AvroNestedFieldGetter.checkUnionForLeafTypes(s);
        if (!primitives.isEmpty()) {
            AvroInputField newField;
            if (primitives.size() == 1) {
                Schema single = primitives.get(0);
                newField = AvroNestedFieldGetter.createAvroField(path, single);
                if (newField != null) {
                    fields.add(newField);
                }
            } else {
                Schema stringS = Schema.create((Schema.Type)Schema.Type.STRING);
                newField = AvroNestedFieldGetter.createAvroField(path, stringS);
                if (newField != null) {
                    fields.add(newField);
                }
            }
        }
        for (Schema toCheck : s.getTypes()) {
            if (toCheck.getType() == Schema.Type.RECORD) {
                AvroNestedFieldGetter.processRecord(path, toCheck, fields);
                continue;
            }
            if (toCheck.getType() == Schema.Type.MAP) {
                AvroNestedFieldGetter.processMap(path + KEY, toCheck, fields);
                continue;
            }
            if (toCheck.getType() != Schema.Type.ARRAY) continue;
            AvroNestedFieldGetter.processArray(path + "[0]", toCheck, fields);
        }
    }

    protected static void processMap(String path, Schema s, List<AvroInputField> fields) throws KettleException {
        AvroNestedFieldGetter.handleType(path, s.getValueType(), fields);
    }

    protected static void processArray(String path, Schema s, List<AvroInputField> fields) throws KettleException {
        AvroNestedFieldGetter.handleType(path, s.getElementType(), fields);
    }

    private static void handleType(String path, Schema s, List<AvroInputField> fields) throws KettleException {
        if (s.getType() == Schema.Type.UNION) {
            AvroNestedFieldGetter.processUnion(path, s, fields);
        } else if (s.getType() == Schema.Type.ARRAY) {
            AvroNestedFieldGetter.processArray(path + "[0]", s, fields);
        } else if (s.getType() == Schema.Type.RECORD) {
            AvroNestedFieldGetter.processRecord(path, s, fields);
        } else if (s.getType() == Schema.Type.MAP) {
            AvroNestedFieldGetter.processMap(path + KEY, s, fields);
        } else {
            AvroInputField newField = AvroNestedFieldGetter.createAvroField(path, s);
            if (newField != null) {
                fields.add(newField);
            }
        }
    }

    protected static AvroInputField createAvroField(String path, Schema s) {
        String[] splits;
        int index;
        AvroInputField newField = new AvroInputField();
        String fieldName = "data";
        if (path.trim().length() > 0) {
            fieldName = path.substring(path.lastIndexOf(46) + 1);
        }
        if ((index = fieldName.indexOf(91)) == 0) {
            fieldName = "data";
        } else if (index > 0) {
            fieldName = fieldName.substring(0, index);
        }
        newField.setAvroFieldName(path);
        newField.setPentahoFieldName(fieldName);
        newField = AvroNestedFieldGetter.setFieldType(s, newField);
        if (fieldName.contains("_delimiter_") && newField != null && (splits = fieldName.split("_delimiter_")).length > 0 && splits.length <= 3) {
            newField.setPentahoFieldName(splits[0]);
            newField.setPentahoType(Integer.valueOf(splits[1]));
        }
        return newField;
    }

    private static AvroInputField setFieldType(Schema s, AvroInputField newField) {
        switch (s.getType()) {
            case BOOLEAN: {
                newField.setAvroType(AvroSpec.DataType.BOOLEAN);
                newField.setPentahoType(4);
                break;
            }
            case ENUM: 
            case STRING: {
                newField.setPentahoType(2);
                newField.setAvroType(AvroSpec.DataType.STRING);
                break;
            }
            case FLOAT: {
                newField.setAvroType(AvroSpec.DataType.FLOAT);
                newField.setPentahoType(1);
                break;
            }
            case DOUBLE: {
                newField.setAvroType(AvroSpec.DataType.DOUBLE);
                newField.setPentahoType(1);
                break;
            }
            case INT: {
                if (s.getLogicalType() != null) {
                    if (s.getLogicalType().getName().equalsIgnoreCase("Date")) {
                        newField.setAvroType(AvroSpec.DataType.DATE);
                        newField.setPentahoType(3);
                        break;
                    }
                    newField.setAvroType(AvroSpec.DataType.INTEGER);
                    newField.setPentahoType(5);
                    break;
                }
                newField.setAvroType(AvroSpec.DataType.INTEGER);
                newField.setPentahoType(5);
                break;
            }
            case LONG: {
                if (s.getLogicalType() != null) {
                    if (s.getLogicalType().getName().equalsIgnoreCase("timestamp-millis")) {
                        newField.setAvroType(AvroSpec.DataType.TIMESTAMP_MILLIS);
                        newField.setPentahoType(9);
                        break;
                    }
                    newField.setAvroType(AvroSpec.DataType.LONG);
                    newField.setPentahoType(5);
                    break;
                }
                newField.setAvroType(AvroSpec.DataType.LONG);
                newField.setPentahoType(5);
                break;
            }
            case BYTES: {
                if (s.getLogicalType() != null) {
                    if (s.getLogicalType().getName().equalsIgnoreCase("Decimal")) {
                        newField.setAvroType(AvroSpec.DataType.DECIMAL);
                        newField.setPentahoType(6);
                        break;
                    }
                    newField.setAvroType(AvroSpec.DataType.BYTES);
                    newField.setPentahoType(8);
                    break;
                }
                newField.setAvroType(AvroSpec.DataType.BYTES);
                newField.setPentahoType(8);
                break;
            }
            case FIXED: {
                newField.setAvroType(AvroSpec.DataType.FIXED);
                newField.setPentahoType(8);
                break;
            }
            default: {
                newField = null;
            }
        }
        return newField;
    }

    protected static List<Schema> checkUnionForLeafTypes(Schema s) {
        List types = s.getTypes();
        ArrayList<Schema> primitives = new ArrayList<Schema>();
        for (Schema toCheck : types) {
            switch (toCheck.getType()) {
                case BOOLEAN: 
                case ENUM: 
                case STRING: 
                case FLOAT: 
                case DOUBLE: 
                case INT: 
                case LONG: 
                case BYTES: 
                case FIXED: {
                    primitives.add(toCheck);
                }
            }
        }
        return primitives;
    }
}

